/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3CollectService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3CollectServiceV2;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@DubboService
@Component
public class CompanyGradeV3RefreshServiceImpl
implements ICompanyGradeV3RefreshService {
    @Lazy
    @Autowired
    private CompanyGradeV3CollectService collectCompanyGrade;
    @Lazy
    @Autowired
    private CompanyGradeV3CollectServiceV2 collectCompanyGradeV2;
    Logger logger = LoggerFactory.getLogger(CompanyGradeV3RefreshServiceImpl.class);

    public void refreshCompanyGradeByCid(Long cid, CompanyGradeEventSource eventSource) {
        if (cid != null) {
            this.refreshCompanyGradeByCids(Arrays.asList(cid), eventSource);
        }
    }

    public void refreshCompanyGradeByCids(List<Long> cid, CompanyGradeEventSource eventSource) {
        DebugUtils.error((String)"refreshCompanyGradeByCids:{}, cid:{}\u5237\u65b0\u5206\u7c7b\u76d1\u7ba1\u6570\u636estart-->", (Object[])new Object[]{DateUtils.formatDateTime((Date)new Date()), ListUtil.partition(cid, (int)100)});
        try {
            this.collectCompanyGradeV2.refreshGrade(cid, eventSource);
        }
        catch (Exception e) {
            this.logger.error("\u5237\u65b0cid:{}\u7684\u5206\u7c7b\u76d1\u7ba1\u6570\u636e\u51fa\u9519:{}", cid, (Object)e);
        }
        DebugUtils.error((String)"refreshCompanyGradeByCids:{}, cid:{}\u5237\u65b0\u5206\u7c7b\u76d1\u7ba1\u6570\u636eend-->", (Object[])new Object[]{DateUtils.formatDateTime((Date)new Date()), ListUtil.partition(cid, (int)100)});
    }

    public String encrypt(String plaintext) {
        String s = SpringEncryptUtils.encrypt((String)plaintext);
        return s;
    }

    public String decrypt(String encryptext) {
        String s = SpringEncryptUtils.decrypt((String)encryptext);
        return s;
    }
}

