/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyHarmNumVo;
import cn.smarthse.modules.health.entity.work.statistics.CompanyClassCCount;
import cn.smarthse.modules.health.supervise.dao.company.grade.CompanyGradeV3RecMapper;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectModel;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyGradeV3RecServiceImpl
extends BaseServiceImpl<CompanyGradeV3RecMapper, CompanyGradeV3Rec>
implements ICompanyGradeV3RecService {
    public List<CompanyGradeV3Rec> listAllCompanyGradeRec(List<Long> cids) {
        List<CompanyGradeV3Rec> companyGradeV3Recs = ((CompanyGradeV3RecMapper)this.dao).listAllCompanyGradeRec(cids);
        return companyGradeV3Recs;
    }

    public CompanyGradeV3Rec getGradeRecByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Example e = new Example(CompanyGradeV3Rec.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List listByExample = this.getListByExample(e);
        if (CollectionUtils.isNotEmpty(listByExample)) {
            CompanyGradeV3Rec gradeV3Rec = (CompanyGradeV3Rec)listByExample.get(0);
            if (!Objects.equals(gradeV3Rec.getCheckState(), 1)) {
                gradeV3Rec.setJudgeLevel(Integer.valueOf(0));
                gradeV3Rec.setRiskLevel(Integer.valueOf(0));
            }
            return gradeV3Rec;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public int batchSaveCompanyGradeV3Rec(List<CompanyGradeV3Rec> gradeV3RecList) {
        if (CollectionUtils.isEmpty(gradeV3RecList)) {
            return 0;
        }
        int pointsDataLimit = 1000;
        int listSize = gradeV3RecList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<CompanyGradeV3Rec> newList = new ArrayList<CompanyGradeV3Rec>();
        for (int i = 0; i < gradeV3RecList.size(); ++i) {
            CompanyGradeV3Rec gradeV3Rec = gradeV3RecList.get(i);
            gradeV3Rec.setId(Long.valueOf(this.idworker.nextId()));
            newList.add(gradeV3Rec);
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = ((CompanyGradeV3RecMapper)this.dao).insertGrades(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    @Transactional(readOnly=false)
    public int batchupdateCompanyGradeV3Rec(List<CompanyGradeV3Rec> gradeV3RecList) {
        if (CollectionUtils.isEmpty(gradeV3RecList)) {
            return 0;
        }
        int pointsDataLimit = 1000;
        int listSize = gradeV3RecList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<CompanyGradeV3Rec> newList = new ArrayList<CompanyGradeV3Rec>();
        for (int i = 0; i < gradeV3RecList.size(); ++i) {
            newList.add(gradeV3RecList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = ((CompanyGradeV3RecMapper)this.dao).updateGrades(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    public List<GradeV3CollectModel> collectGradeRec(GradeV3CollectModel collectModel) {
        List<GradeV3CollectModel> gradeV3CollectModels = ((CompanyGradeV3RecMapper)this.dao).collectGradeRec(collectModel);
        return gradeV3CollectModels;
    }

    public List<Map<String, Object>> collectGradeRec2(GradeV3CollectModel collectModel) {
        return ((CompanyGradeV3RecMapper)this.dao).collectGradeRec2(collectModel);
    }

    public List<CompanyClassCCount> getAllComClassCCountData() {
        return ((CompanyGradeV3RecMapper)this.dao).getAllComClassCCountData();
    }

    public List<CompanyHarmNumVo> listAllCompanyReportInfo(List<Long> cids) {
        return ((CompanyGradeV3RecMapper)this.dao).listAllCompanyReportInfo(cids);
    }

    public List<CompanyHarmNumVo> listAllCompanyDeclareInfo(List<Long> cids) {
        return ((CompanyGradeV3RecMapper)this.dao).listAllCompanyDeclareInfo(cids);
    }

    @Transactional(readOnly=false)
    public Integer batchUpdateLastYearPickupCount(List<CompanySuperviseModel> result) {
        if (CollectionUtils.isNotEmpty(result)) {
            Integer i = ((CompanyGradeV3RecMapper)this.dao).batchUpdateLastYearPickupCount(result);
            return result.size();
        }
        return 0;
    }

    public List<CompanyGradeV3Rec> getGradeByCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return null;
        }
        Example e = new Example(CompanyGradeV3Rec.class);
        e.createCriteria().andIn("cid", cids).andEqualTo("isValid", (Object)true);
        e.selectProperties(new String[]{"grade", "occType", "cid"});
        List<CompanyGradeV3Rec> resultList = this.getListByExample(e);
        return resultList;
    }
}

