/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeHisV3;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.supervise.dao.company.grade.CompanyGradeV3TempMapper;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.util.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyGradeV3HisDataHandleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyGradeV3HisDataHandleService.class);
    @Autowired
    ICompanyGradeV3Service companyGradeV3Service;
    @Autowired
    ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference
    IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    @Autowired
    CompanyGradeV3TempMapper gradeV3TempMapper;
    @DubboReference
    ISelfInspectionRiskAssessmentReportInfoService reportInfoService;

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public synchronized void handGradeHisData() {
        log.info("\u5206\u7ea7\u5206\u7c7b\u5386\u53f2\u6570\u636e\u5904\u7406....");
        try {
            List allHistoryReportInfo = this.reportInfoService.getAllHistoryReportInfo();
            if (CollectionUtils.isEmpty((Collection)allHistoryReportInfo)) {
                return;
            }
            List<WorkOperateLog> ooperatorLogList = this.gradeV3TempMapper.listWorkOperatorLog();
            if (CollectionUtils.isNotEmpty(ooperatorLogList)) {
                ArrayList<CompanyGradeHisV3> gradeHisList = new ArrayList<CompanyGradeHisV3>();
                Map<Long, Date> operatorLogMap = ooperatorLogList.stream().collect(Collectors.toMap(WorkOperateLog::getWorkId, WorkOperateLog::getUpdateDate, (v1, v2) -> v1));
                HashMap<Long, List> effcReportMap = new HashMap<Long, List>();
                for (SelfInspectionRiskAssessmentReportV314Vo reportInfo : allHistoryReportInfo) {
                    if (!Objects.equals(reportInfo.getReportFromYear(), (byte)2) || reportInfo.getRiskClassify() == null) continue;
                    if (operatorLogMap.containsKey(reportInfo.getId())) {
                        reportInfo.setUpdateDate(operatorLogMap.get(reportInfo.getId()));
                    }
                    if (reportInfo.getUpdateDate() == null) continue;
                    effcReportMap.computeIfAbsent(reportInfo.getCid(), v -> new ArrayList()).add(reportInfo);
                }
                if (MapUtils.isEmpty(effcReportMap)) {
                    return;
                }
                Set cidSet = effcReportMap.keySet();
                for (Long cid : cidSet) {
                    List reportV314VoList = (List)effcReportMap.get(cid);
                    List reportSortList = reportV314VoList.stream().sorted(Comparator.comparing(SelfInspectionRiskAssessmentReportV314Vo::getUpdateDate)).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(reportSortList)) continue;
                    for (int i = 0; i < reportSortList.size(); ++i) {
                        SelfInspectionRiskAssessmentReportV314Vo lastResult;
                        SelfInspectionRiskAssessmentReportV314Vo reportInfo = (SelfInspectionRiskAssessmentReportV314Vo)reportSortList.get(i);
                        if (i > 0 && Objects.equals((lastResult = (SelfInspectionRiskAssessmentReportV314Vo)reportSortList.get(i - 1)).getRiskClassify(), reportInfo.getRiskClassify())) continue;
                        CompanyGradeHisV3 hisV3 = new CompanyGradeHisV3();
                        hisV3.setGrade(reportInfo.getRiskClassify());
                        hisV3.setUpdateDate(DateUtil.getFromDate((Date)reportInfo.getUpdateDate()));
                        hisV3.setGradeTime(DateUtil.getFromDate((Date)reportInfo.getUpdateDate()));
                        hisV3.setCid(reportInfo.getCid());
                        String changeReason = reportInfo.getChangeReason();
                        String reason = "";
                        if (StringUtils.isNotBlank((CharSequence)changeReason)) {
                            if (changeReason.indexOf("1") > -1) {
                                reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d8\u66f4\u8bc4\u4f30\uff08\u804c\u4e1a\u75c5\u5371\u5bb3\u63a5\u89e6\u60c5\u51b5\u53d1\u751f\u91cd\u5927\u53d8\u5316\uff09", (String)",");
                            }
                            if (changeReason.indexOf("2") > -1) {
                                reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d8\u66f4\u8bc4\u4f30\uff08\u7ba1\u7406\u72b6\u51b5\u53d1\u751f\u91cd\u5927\u53d8\u5316\uff09", (String)",");
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)reason)) continue;
                        hisV3.setReason(reason);
                        gradeHisList.add(hisV3);
                    }
                }
                this.saveCompanyGradeHisBatch(gradeHisList);
            }
        }
        catch (Exception e) {
            log.error("\u5206\u7ea7\u5206\u7c7b\u5386\u53f2\u6570\u636e\u5904\u7406\u51fa\u9519...", (Throwable)e);
        }
    }

    private int saveCompanyGradeHisBatch(List<CompanyGradeHisV3> gradeHisList) {
        int pointsDataLimit = 1000;
        int listSize = gradeHisList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<CompanyGradeHisV3> newList = new ArrayList<CompanyGradeHisV3>();
        for (int i = 0; i < gradeHisList.size(); ++i) {
            newList.add(gradeHisList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = this.companyGradeV3Service.insertGradeHiss(newList);
            n += count;
            newList.clear();
        }
        return n;
    }
}

