/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyCreditSuperviseSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModelV3;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeHisV3;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3RecHis;
import cn.smarthse.modules.health.entity.sys.SysSuperviseObjectLog;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeTagEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.enums.company.grade.OccTypeChangeEvent;
import cn.smarthse.modules.health.supervise.model.grade.CompanyGradeChangeClassc;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3BatchCid;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecHisService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.GradeUtils;
import cn.smarthse.modules.health.supervise.service.sys.ISysLogThirdService;
import cn.smarthse.modules.health.vo.base.company.gradev3.SelfReportCollectVo;
import cn.smarthse.services.hfi.api.model.grade.CompanyOccTypeVo;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.fastjson.JSON;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RDeque;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service(value="companyGradeV3CollectServiceV2")
public class CompanyGradeV3CollectServiceV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyGradeV3CollectServiceV2.class);
    @Autowired
    private ICompanyGradeV3Service companyGradeV3Service;
    @Autowired
    private ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService provideByHSEService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService selfInsRiskAsseService;
    @Autowired
    private ISysLogThirdService sysLogThirdService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private CompanyGradeV3CollectServiceV2 collectService;
    @Autowired
    private ICompanyGradeV3RecHisService recHisService;
    @DubboReference
    private ICompanyRiskCompletionService riskCompletionService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    protected IDcCompanyService dcCompanyService;
    @Resource(name="gradeThreadPoolExecutor")
    private ExecutorService executorService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    private final Integer handBatchSize = 5000;
    private static final String CACHE_NAME = "CompanyGradeV3CollectServiceV2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshAllGrade(List<Long> cids, CompanyGradeEventSource eventSource) {
        RLock gradeRefreshLock = this.redissonClient.getLock("third-service:collectCompanyGradev2:lock");
        RDeque gradeDeque = this.redissonClient.getDeque("third-service:collectCompanyGradev2:deque");
        if (!gradeRefreshLock.tryLock()) {
            log.error("refreshAllGrade\u6b63\u5728\u6267\u884c\u5168\u91cf\u5b9a\u65f6\u4efb\u52a1\uff0c\u7b49\u5f85\u8d85\u65f6\u653e\u5f03\u4efb\u52a1.. ");
            return;
        }
        try {
            this.doCollectCompanyGrade(cids, eventSource);
            while (true) {
                GradeV3BatchCid gbc;
                if ((gbc = (GradeV3BatchCid)gradeDeque.poll()) == null) {
                    return;
                }
                this.doCollectCompanyGrade(gbc.getCids(), gbc.getEventSource());
                continue;
                break;
            }
        }
        catch (Exception e) {
            log.error("refreshAllGrade\u6279\u91cf\u66f4\u65b0\u4efb\u52a1\u4e2d\u65ad\uff0c", (Throwable)e);
            return;
        }
        finally {
            gradeRefreshLock.unlock();
        }
    }

    public void refreshGrade(List<Long> cids, CompanyGradeEventSource eventSource) {
        RLock gradeRefreshLock = this.redissonClient.getLock("third-service:collectCompanyGradev2:lock");
        RDeque gradeDeque = this.redissonClient.getDeque("third-service:collectCompanyGradev2:deque");
        if (CollectionUtils.isEmpty(cids)) {
            return;
        }
        this.doCollectCompanyGrade(cids, eventSource);
        if (gradeRefreshLock.isLocked()) {
            gradeDeque.offer((Object)new GradeV3BatchCid(cids, eventSource));
            log.error("\u6b63\u5728\u6267\u884c\u5168\u91cf\u5b9a\u65f6\u4efb\u52a1\uff0c \u5f53\u524d\u6570\u636e\u52a0\u5165\u4e4b\u540e\u6267\u884c, cid:{}", cids);
        }
    }

    private void handleGradeAndGradeSource(CompanyGradeV3 companyGradeV3, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap, Map<Long, CompanyGradeChangeClassc> changeClasscMap, Set<Long> suspendCidSet) {
        CompanyGradeChangeClassc companyGradeChangeClassc = changeClasscMap.get(companyGradeV3.getCid());
        CompanyGradeV3Rec dbRec = dbgradeV3RecMap.get(companyGradeV3.getCid());
        if (Objects.equals(companyGradeV3.getCompanyType(), 2)) {
            companyGradeV3.setGrade(Integer.valueOf(1));
            companyGradeV3.setGradeSource(GradeSourceEnum.LABOR_DISPATCH.getCode());
            companyGradeV3.addTag(GradeTagEnum.LABOR_DISPATCH.getCode());
        } else if (this.isZjCompany(companyGradeV3) && suspendCidSet.contains(companyGradeV3.getCid())) {
            companyGradeV3.setGrade(Integer.valueOf(3));
            companyGradeV3.setGradeSource(GradeSourceEnum.SUPENDREFORM.getCode());
            companyGradeV3.addTag(GradeTagEnum.SUPENDREFORM.getCode());
        } else if (this.isZjCompany(companyGradeV3) && Objects.equals(companyGradeV3.getCreditSupervise(), 1)) {
            companyGradeV3.setGrade(Integer.valueOf(1));
            companyGradeV3.setGradeSource(GradeSourceEnum.CREDITSUPERVISE.getCode());
            String creditSuperviseSource = companyGradeV3.getCreditSuperviseSource();
            List creditSuperviseSourceList = CommonUtil.str2IntegerList((String)creditSuperviseSource, (String)",");
            companyGradeV3.addTag(GradeTagEnum.CREDITSUPERVISE.getCode());
            if (creditSuperviseSourceList.contains(CompanyCreditSuperviseSourceEnum.ONLINE_DEVICE.getCode())) {
                companyGradeV3.addTag(GradeTagEnum.ONLINE_DEVICE.getCode());
            }
            if (creditSuperviseSourceList.contains(CompanyCreditSuperviseSourceEnum.TRAININGBASE.getCode())) {
                companyGradeV3.addTag(GradeTagEnum.TRAINING_BASE.getCode());
            }
            if (creditSuperviseSourceList.contains(CompanyCreditSuperviseSourceEnum.COMPLIANCECOMPANY.getCode())) {
                companyGradeV3.addTag(GradeTagEnum.COMPLIANCE.getCode());
            }
        } else if (companyGradeChangeClassc != null && dbRec != null && (dbRec.getCheckTime() == null || dbRec.getCheckTime() != null && DateUtils.compare_date((Date)companyGradeChangeClassc.getChangeTime(), (Date)dbRec.getCheckTime()) > 0)) {
            companyGradeV3.setGrade(Integer.valueOf(3));
            companyGradeV3.setGradeSource(GradeSourceEnum.SUPERVISE_IDENTIFY.getCode());
            companyGradeV3.addTag(GradeTagEnum.SUPERVISE_IDENTIFY.getCode());
        }
    }

    public Set<Long> getSuspendCidSet() {
        Date startDate = DateUtils.parseDate((Object)(DateUtils.getThisYear() - 1 + "-01-01 00:00:00"));
        Date endDate = DateUtils.parseDate((Object)(DateUtils.getThisYear() - 1 + "-12-31 23:59:59"));
        Set suspendCidList = (Set)this.redisClient.get(CACHE_NAME, "getSuspendCidSet" + startDate.hashCode() + endDate.hashCode(), 172800L, () -> {
            List suspendCidSet = this.riskCompletionService.getUnresolvedAssessCompanyIdsV2(null, startDate, endDate);
            if (suspendCidSet == null) {
                return new HashSet();
            }
            return new HashSet(suspendCidSet);
        });
        return suspendCidList;
    }

    private Map<Long, CompanyOccTypeVo> getCidOccTypeCacheByRisk(List<Long> cids) {
        Date start = DateUtils.addYear((Date)new Date(), (int)-3);
        Date end = DateUtils.addDay((Date)new Date(), (int)1);
        Map companyOccTypeMap = this.riskExposeEvaluateService.getCompanyOccTypeMap(cids, null, null, null);
        return companyOccTypeMap;
    }

    private void settingOccType(Map<Long, CompanyOccTypeVo> occTypeVoMap, CompanyGradeV3 companyGradeV3) {
        Long cid = companyGradeV3.getCid();
        CompanyOccTypeVo rickOccType = occTypeVoMap.get(cid);
        if (rickOccType != null && rickOccType.getOccType() != null) {
            companyGradeV3.setOccTypeSource(rickOccType.getCheckType());
            companyGradeV3.setOccType(Integer.valueOf(rickOccType.getOccType().intValue()));
        } else {
            companyGradeV3.setOccTypeSource(Integer.valueOf(9));
        }
    }

    public void doCollectCompanyGrade(List<Long> cids, CompanyGradeEventSource eventSource) {
        this.dcCompanyService.doCompanyOccTypeTask(cids, OccTypeChangeEvent.BY_CHECKINDU, Boolean.valueOf(false));
        log.info("\u5206\u7ea7\u5206\u7c7bV3\u5355\u4e2a\u4f01\u4e1a{}\u5b9e\u65f6\u7edf\u8ba1\u4efb\u52a1\u5f00\u59cb\u6267\u884c...", cids);
        Date end = new Date();
        Date start = DateUtils.addYear((Date)end, (int)-2);
        long jobId = XxlJobHelper.getJobId();
        List companyList = this.companyProvideService.listComapnyGradeInfoV3(cids);
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            return;
        }
        StopWatch sw = new StopWatch();
        sw.start("getSelfReportCollectMap");
        Map<Long, SelfReportCollectVo> selfReportMap = this.getSelfReportCollectMap(cids, start, end);
        sw.stop();
        if (jobId > 0L) {
            XxlJobHelper.log((String)"getSelfReportCollectMap \u6570\u636e\u52a0\u8f7d\u8017\u65f6:{}s", (Object[])new Object[]{sw.getTotalTimeSeconds()});
        }
        List companyGradeChangeClasscs = this.companyGradeV3Service.selectGradeChangeClassc(cids);
        HashMap<Long, CompanyGradeChangeClassc> changeClasscMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)companyGradeChangeClasscs)) {
            changeClasscMap = companyGradeChangeClasscs.stream().collect(Collectors.toMap(CompanyGradeChangeClassc::getCid, v -> v));
        }
        HashMap<Long, CompanyGradeV3Rec> dbgradeV3RecMap = new HashMap();
        List dbGradev3RecList = this.gradeV3RecService.listAllCompanyGradeRec(cids);
        if (CollectionUtils.isNotEmpty((Collection)dbGradev3RecList)) {
            dbgradeV3RecMap = dbGradev3RecList.stream().collect(Collectors.toMap(CompanyGradeV3Rec::getCid, a -> a, (k1, k2) -> k1));
        }
        Set<Long> suspendCidSet = this.getSuspendCidSet();
        if (jobId > 0L) {
            XxlJobHelper.log((String)"\u4e1a\u52a1\u6570\u636e\u52a0\u8f7d\u5b8c\u6210..", (Object[])new Object[0]);
        }
        List<CompanyGradeV3> newCompanyGradeV3List = this.convertCompanyGradeV3List(companyList);
        for (CompanyGradeV3 companyGradeV3 : newCompanyGradeV3List) {
            companyGradeV3.setIsGovern(Boolean.valueOf(false));
            this.handleGradeAndGradeSource(companyGradeV3, dbgradeV3RecMap, changeClasscMap, suspendCidSet);
            this.handSelfReportData(selfReportMap, companyGradeV3);
            if (companyGradeV3.getGrade() == 0) {
                this.setGradeByOccType(companyGradeV3);
            }
            this.calcRiskType(companyGradeV3);
            this.importantCheck(companyGradeV3);
            this.handPickupCount(companyGradeV3);
        }
        try {
            this.collectService.doSaveCollectCompanyGrade(cids, newCompanyGradeV3List, dbgradeV3RecMap, eventSource);
        }
        catch (Exception e) {
            log.error("\u5206\u7ea7\u5206\u7c7bV3\u5355\u4e2a\u4f01\u4e1a{}\u5b9e\u65f6\u7edf\u8ba1\u4efb\u52a1\u6267\u884c\u51fa\u9519...", cids, (Object)e);
        }
    }

    public void doSaveCollectCompanyGrade(List<Long> cids, List<CompanyGradeV3> newCompanyGradeV3List, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap, CompanyGradeEventSource eventSource) {
        long jobId = XxlJobHelper.getJobId();
        if (jobId > 0L) {
            XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406\u5206\u7c7brec\u6570\u636e..", (Object[])new Object[0]);
        }
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        ArrayList<Long> updateSuperviseCid = new ArrayList<Long>();
        List<CompanyGradeV3Rec> newUpdateRecList = this.handCompanyGradeRecData(newCompanyGradeV3List, dbgradeV3RecMap, updateSuperviseCid, eventSource);
        List<CompanyGradeHisV3> companyGradeHisV3s = this.handCompanyGradeRecHisData(newUpdateRecList, dbgradeV3RecMap, eventSource);
        List handSaveCids = newCompanyGradeV3List.stream().map(v -> v.getCid()).distinct().collect(Collectors.toList());
        HashMap gradeV3Map = CollectionUtils.isEmpty(newCompanyGradeV3List) ? new HashMap() : newCompanyGradeV3List.stream().collect(Collectors.toMap(CompanyGradeV3::getCid, v -> v, (k1, k2) -> k1));
        HashMap gradeV3RecMap = CollectionUtils.isEmpty(newUpdateRecList) ? new HashMap() : newUpdateRecList.stream().collect(Collectors.toMap(CompanyGradeV3Rec::getCid, v -> v, (k1, k2) -> k1));
        HashMap gradeHisV3Map = CollectionUtils.isEmpty(companyGradeHisV3s) ? new HashMap() : companyGradeHisV3s.stream().collect(Collectors.toMap(CompanyGradeHisV3::getCid, v -> v, (k1, k2) -> k1));
        List cidsPages = ListUtil.partition(handSaveCids, (int)this.handBatchSize);
        for (int i = 0; i < cidsPages.size(); ++i) {
            List currHandCids = (List)cidsPages.get(i);
            List<CompanyGradeV3> currgradeV3List = CompanyGradeV3CollectServiceV2.filterMapByKeys(gradeV3Map, currHandCids);
            List<CompanyGradeV3Rec> currgradeV3RecList = CompanyGradeV3CollectServiceV2.filterMapByKeys(gradeV3RecMap, currHandCids);
            List<CompanyGradeHisV3> currgradeHisV3List = CompanyGradeV3CollectServiceV2.filterMapByKeys(gradeHisV3Map, currHandCids);
            List<Long> cuurupdateSuperviseCid = updateSuperviseCid.stream().filter(currHandCids::contains).collect(Collectors.toList());
            try {
                StopWatch st = new StopWatch();
                st.start();
                this.collectService.saveCompanyGradeBatch(currgradeV3List, currgradeV3RecList, cuurupdateSuperviseCid, currgradeHisV3List);
                st.stop();
                if (jobId > 0L) {
                    XxlJobHelper.log((String)"saveCompanyGradeBatch\u5355\u9875{}\u5904\u7406\u8017\u65f6\uff1a{}s", (Object[])new Object[]{i, st.getTotalTimeSeconds()});
                }
                log.info("saveCompanyGradeBatch\u5355\u9875\u5904\u7406\u8017\u65f6\uff1a{}s", (Object)i, (Object)st.getTotalTimeSeconds());
                continue;
            }
            catch (Exception e) {
                log.error("\u5206\u7ea7\u5206\u7c7bV3\u7edf\u8ba1\u4efb\u52a1saveCompanyGradeBatch\u6267\u884c\u51fa\u9519...", (Throwable)e);
            }
        }
        log.info("\u5165\u5e93{}\u6761\u5206\u7ea7\u5206\u7c7bV3\u65b0\u6570\u636e", (Object)newCompanyGradeV3List.size());
    }

    public static <T> List<T> filterMapByKeys(Map<Long, T> maps, List<Long> cids) {
        if (MapUtils.isEmpty(maps)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Long cid : cids) {
            if (!maps.containsKey(cid)) continue;
            result.add(maps.get(cid));
        }
        return result;
    }

    private void handPickupCount(CompanyGradeV3 companyGradeV3) {
        companyGradeV3.setRealGrade(companyGradeV3.getGrade());
        companyGradeV3.setRealGradeSource(companyGradeV3.getGradeSource());
        if (companyGradeV3.getIsShowVictims() != null && companyGradeV3.getIsShowVictims() <= 2 && companyGradeV3.getGrade() != 0 && !Objects.equals(GradeSourceEnum.LABOR_DISPATCH.getCode(), companyGradeV3.getGradeSource())) {
            if (Objects.equals(companyGradeV3.getGradeSource(), GradeSourceEnum.BYINDU.getCode()) && companyGradeV3.getLastCheckedGradeLevel() != null && companyGradeV3.getLastCheckedGradeLevel() > 0) {
                companyGradeV3.setGrade(GradeUtils.downgrade(companyGradeV3.getLastCheckedGradeLevel()));
                companyGradeV3.addTag(GradeTagEnum.BYREPORT.getCode());
            } else {
                companyGradeV3.setGrade(GradeUtils.downgrade(companyGradeV3.getRealGrade()));
            }
            companyGradeV3.setGradeSource(GradeSourceEnum.LESS3.getCode());
            companyGradeV3.addTag(GradeTagEnum.LESS3.getCode());
        }
    }

    private Map<Long, SelfReportCollectVo> getSelfReportCollectMap(List<Long> cids, Date start, Date end) {
        List selfReportCollectVoList = this.selfInsRiskAsseService.getSelfReportInfoCollectVoListHasJudgeByRangTimeAndCid(start, DateUtils.addDay((Date)end, (int)1), cids);
        if (CollectionUtils.isNotEmpty((Collection)selfReportCollectVoList)) {
            Map<Long, SelfReportCollectVo> selfReportMap = selfReportCollectVoList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
            return selfReportMap;
        }
        return new HashMap<Long, SelfReportCollectVo>();
    }

    private void handSelfReportData(Map<Long, SelfReportCollectVo> selfReportMap, CompanyGradeV3 companyGradeV3) {
        SelfReportCollectVo selfReportModel;
        Long cid = companyGradeV3.getCid();
        if (selfReportMap.containsKey(cid) && (selfReportModel = selfReportMap.get(cid)) != null) {
            Integer gradeLevel = selfReportModel.getGradeLevel();
            if (companyGradeV3.getGrade() == 0 && gradeLevel != null && Objects.equals(1, selfReportModel.getEvaluateCheckState()) && Objects.equals(1, selfReportModel.getJudgeCheckState()) && Objects.equals(1, selfReportModel.getRiskCheckState())) {
                companyGradeV3.setGrade(gradeLevel);
                companyGradeV3.setGradeSource(GradeSourceEnum.BYREPORT.getCode());
                companyGradeV3.addTag(GradeTagEnum.BYREPORT.getCode());
            }
            companyGradeV3.setRiskClassify(Integer.valueOf(gradeLevel == null ? 0 : gradeLevel));
            companyGradeV3.setJudgeLevel(Integer.valueOf(selfReportModel.getJudgeLevel() == null ? 0 : selfReportModel.getJudgeLevel()));
            companyGradeV3.setRiskLevel(Integer.valueOf(selfReportModel.getRiskLevel() == null ? 0 : selfReportModel.getRiskLevel()));
            companyGradeV3.setSelfId(selfReportModel.getSelfId());
            companyGradeV3.setRiskId(selfReportModel.getRiskId());
            companyGradeV3.setEvaluateId(selfReportModel.getEvaluateId());
            companyGradeV3.setEvaluateUpdateDate(selfReportModel.getEvaluateUpdateDate());
            companyGradeV3.setRiskUpdateDate(selfReportModel.getRiskUpdateDate());
            companyGradeV3.setJugdeUpdateDate(selfReportModel.getJudgeUpdateDate());
            companyGradeV3.setEvaluateCheckState(Integer.valueOf(selfReportModel.getEvaluateCheckState() == null ? 3 : selfReportModel.getEvaluateCheckState()));
            companyGradeV3.setRiskCheckState(Integer.valueOf(selfReportModel.getRiskCheckState() == null ? 3 : selfReportModel.getRiskCheckState()));
            companyGradeV3.setJugdeCheckState(Integer.valueOf(selfReportModel.getJudgeCheckState() == null ? 3 : selfReportModel.getJudgeCheckState()));
            this.calcCheckState(companyGradeV3);
            companyGradeV3.setRiskHasUpdate(selfReportModel.getRiskHasUpdate());
            companyGradeV3.setEvaluateType(selfReportModel.getEvaluateType());
            companyGradeV3.setChangeReason(selfReportModel.getEvaluateChangeReason());
            companyGradeV3.setRealJudgeLevel(selfReportModel.getRealJudgelevel());
            companyGradeV3.setLastCheckedGradeLevel(selfReportModel.getLastCheckedGradeLevel());
        }
    }

    private void calcCheckState(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3 != null) {
            Integer evaluateCheckState = companyGradeV3.getEvaluateCheckState();
            Integer riskCheckState = companyGradeV3.getRiskCheckState();
            Integer jugdeCheckState = companyGradeV3.getJugdeCheckState();
            if (Objects.equals(evaluateCheckState, 0)) {
                companyGradeV3.setCheckState(Integer.valueOf(0));
            } else if (Objects.equals(evaluateCheckState, -1) || Objects.equals(riskCheckState, -1) || Objects.equals(jugdeCheckState, -1)) {
                companyGradeV3.setCheckState(Integer.valueOf(-1));
            } else if (Objects.equals(evaluateCheckState, 1) && Objects.equals(riskCheckState, 1) && Objects.equals(jugdeCheckState, 1)) {
                companyGradeV3.setCheckState(Integer.valueOf(1));
            } else if (evaluateCheckState != null || riskCheckState != null || jugdeCheckState != null) {
                companyGradeV3.setCheckState(Integer.valueOf(2));
            } else {
                companyGradeV3.setCheckState(Integer.valueOf(3));
            }
        }
    }

    private void calcRiskType(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3 != null) {
            Integer grade = companyGradeV3.getGrade();
            Integer riskLevel = companyGradeV3.getRiskLevel();
            Integer riskClassify = companyGradeV3.getRiskClassify();
            Integer judgeLevel = companyGradeV3.getJudgeLevel();
            Integer occType = companyGradeV3.getOccType();
            if (Integer.valueOf(CompanyGradeEnum.CLASSA.getValue().byteValue()).equals(grade) && HazardsExposureRiskLevelEnum.heightRisk.getCode().equals(riskLevel) && CompanyOccTypeEnum.SERIOUS.getCode().equals(occType)) {
                companyGradeV3.setRiskType(Integer.valueOf(1));
            } else if (HazardsExposureRiskLevelEnum.heightRisk.getCode().equals(riskLevel) && JudgeResultLevelEnum.A.getCode().equals(judgeLevel)) {
                companyGradeV3.setRiskType(Integer.valueOf(2));
            } else if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType) && (Integer.valueOf(CompanyGradeEnum.CLASSB.getValue().byteValue()).equals(grade) || Integer.valueOf(CompanyGradeEnum.CLASSC.getValue().byteValue()).equals(grade))) {
                companyGradeV3.setRiskType(Integer.valueOf(3));
            }
        }
    }

    private void importantCheck(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3 != null) {
            Integer riskLevel = companyGradeV3.getRiskLevel();
            Integer riskClassify = companyGradeV3.getRiskClassify();
            Integer judgeLevel = companyGradeV3.getJudgeLevel();
            Integer occType = companyGradeV3.getOccType();
            if (Integer.valueOf(CompanyGradeEnum.CLASSA.getValue().byteValue()).equals(judgeLevel) && HazardsExposureRiskLevelEnum.heightRisk.getCode().equals(riskLevel)) {
                companyGradeV3.setImportantCheck(Integer.valueOf(1));
            } else if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType) && Integer.valueOf(CompanyGradeEnum.CLASSA.getValue().byteValue()).equals(riskClassify)) {
                companyGradeV3.setImportantCheck(Integer.valueOf(2));
            }
        }
    }

    private void setGradeByOccType(CompanyGradeV3 companyGradeV3) {
        Integer occType = companyGradeV3.getOccType();
        if (occType != null) {
            if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType)) {
                companyGradeV3.setGrade(Integer.valueOf(3));
                companyGradeV3.setGradeSource(GradeSourceEnum.BYINDU.getCode());
                companyGradeV3.addTag(GradeTagEnum.BYINDU.getCode());
            } else if (CompanyOccTypeEnum.COMMON.getCode().equals(occType)) {
                companyGradeV3.setGrade(Integer.valueOf(2));
                companyGradeV3.setGradeSource(GradeSourceEnum.BYINDU.getCode());
                companyGradeV3.addTag(GradeTagEnum.BYINDU.getCode());
            }
        }
    }

    private List<CompanyGradeV3> convertCompanyGradeV3List(List<CompanyGradeModelV3> companyList) {
        if (CollectionUtils.isNotEmpty(companyList)) {
            List<CompanyGradeV3> collect = companyList.stream().map(v -> {
                CompanyGradeV3 v3 = new CompanyGradeV3();
                BeanUtils.copyProperties((Object)v, (Object)v3);
                v3.setGrade(Integer.valueOf(0));
                v3.setRiskLevel(Integer.valueOf(0));
                v3.setJudgeLevel(Integer.valueOf(0));
                v3.setRiskClassify(Integer.valueOf(0));
                v3.setIsBest(Byte.valueOf(v.getIsBest() == null ? (byte)0 : v.getIsBest()));
                v3.setIsDecCurrentYear(v.getIsDecCurrentYear());
                v3.setIsDecOld(v.getIsDecOld());
                v3.setIsShowVictims(v.getIsShowVictims());
                v3.setPickupCountSource(v.getPickupCountSource());
                v3.setOccType(v.getOccupationalRiskClassify());
                if (v3.getOccType() == null) {
                    v3.setOccType(CompanyOccTypeEnum.UNDIVIDED.getCode());
                }
                v3.setInduGrade(v3.getOccType());
                return v3;
            }).collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    private String compareGradeChangeReason2(CompanyGradeV3Rec companyGrade, CompanyGradeV3Rec companyGradeHis, CompanyGradeEventSource eventSource) {
        String reason = "";
        try {
            String changeReason = companyGrade.getChangeReason();
            if (CompanyGradeEventSource.BESTCHANGE.equals((Object)eventSource)) {
                if (companyGradeHis != null && !Objects.equals(companyGrade.getIsBest(), companyGradeHis.getIsBest())) {
                    if (Objects.equals(companyGrade.getIsBest(), (byte)0)) {
                        reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d6\u6d88\u5065\u5eb7\u4f01\u4e1a", (String)",");
                    } else if (Objects.equals(companyGrade.getIsBest(), (byte)1)) {
                        reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d8\u66f4\u4e3a\u5065\u5eb7\u4f01\u4e1a", (String)",");
                    }
                }
            } else {
                Integer newGradeSource = companyGrade.getGradeSource();
                if (Objects.equals(GradeSourceEnum.LABOR_DISPATCH.getCode(), newGradeSource)) {
                    reason = "\u53d8\u66f4\u4e3a\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d";
                } else if (Objects.equals(GradeSourceEnum.SUPERVISE_IDENTIFY.getCode(), newGradeSource)) {
                    reason = "\u76d1\u7ba1\u8ba4\u5b9a\u2014\u2014\u4e59\u7c7b\u53d8\u4e19\u7c7b";
                } else if (Objects.equals(GradeSourceEnum.CREDITSUPERVISE.getCode(), newGradeSource)) {
                    reason = "\u4fe1\u7528\u76d1\u7ba1\u63d0\u6863";
                } else if (Objects.equals(GradeSourceEnum.SUPENDREFORM.getCode(), newGradeSource)) {
                    reason = "\u672a\u53ca\u65f6\u5316\u89e3\u98ce\u9669\u4f01\u4e1a";
                } else if (Objects.equals(GradeSourceEnum.BYREPORT.getCode(), newGradeSource)) {
                    reason = "\u5206\u7c7b\u81ea\u67e5\u7ed3\u679c";
                } else if (Objects.equals(GradeSourceEnum.BYINDU.getCode(), newGradeSource)) {
                    reason = "\u6240\u5c5e\u884c\u4e1a\u98ce\u9669\u7c7b\u522b\u53d8\u66f4 ";
                } else if (Objects.equals(GradeSourceEnum.LESS3.getCode(), newGradeSource)) {
                    reason = "\u53d8\u66f4\u4e3a\u201c\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a";
                }
                if (StringUtils.isBlank((CharSequence)reason)) {
                    reason = GradeSourceEnum.getName((Integer)companyGrade.getGradeSource());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return reason;
    }

    private boolean isZjCompany(CompanyGradeV3 newCompanyGrade) {
        Long areaId = Optional.ofNullable(newCompanyGrade).map(g -> g.getAreaId()).orElse(null);
        if (areaId == null) {
            return false;
        }
        return areaId.toString().startsWith("33");
    }

    private List<CompanyGradeV3Rec> handCompanyGradeRecData(List<CompanyGradeV3> newGradeList, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap, List<Long> updateSuperviseCid, CompanyGradeEventSource eventSource) {
        ArrayList<CompanyGradeV3Rec> result;
        block15: {
            block14: {
                result = new ArrayList<CompanyGradeV3Rec>();
                if (!CollUtil.isNotEmpty(dbgradeV3RecMap)) break block14;
                if (CollectionUtils.isNotEmpty(newGradeList)) {
                    for (CompanyGradeV3 companyGradeV3 : newGradeList) {
                        CompanyGradeV3Rec dbRec;
                        if (!Objects.equals(companyGradeV3.getIsSupervise(), true) && (Objects.equals(companyGradeV3.getCheckState(), 1) || companyGradeV3.getIsShowVictims() != null && companyGradeV3.getIsShowVictims() < 3 && companyGradeV3.getIndustryCategory() != null && !Objects.equals(companyGradeV3.getOccType(), CompanyOccTypeEnum.NOTSUBDIVIDED.getCode()))) {
                            updateSuperviseCid.add(companyGradeV3.getCid());
                        }
                        if ((dbRec = dbgradeV3RecMap.get(companyGradeV3.getCid())) != null) {
                            CompanyGradeV3Rec dbRecCopy = new CompanyGradeV3Rec();
                            BeanUtils.copyProperties((Object)dbRec, (Object)dbRecCopy);
                            dbRecCopy.setIsValid(Integer.valueOf(1));
                            dbRecCopy.setAreaId(companyGradeV3.getAreaId());
                            if (Objects.equals(companyGradeV3.getCheckState(), 1)) {
                                BeanUtils.copyProperties((Object)companyGradeV3, (Object)dbRecCopy, (String[])new String[]{"id"});
                                dbRecCopy.setTags(StringUtils.join((Iterable)companyGradeV3.getTagSet(), (String)","));
                                if (CompanyGradeEventSource.AUDIT.equals((Object)eventSource)) {
                                    dbRecCopy.setCheckTime(new Date());
                                }
                                result.add(dbRecCopy);
                                this.saveRecHis(companyGradeV3, dbRecCopy, eventSource);
                                continue;
                            }
                            if (Objects.equals(dbRecCopy.getCheckState(), 0) || Objects.equals(dbRecCopy.getCheckState(), -1) || Objects.equals(dbRecCopy.getCheckState(), 2) || Objects.equals(dbRecCopy.getCheckState(), 3)) {
                                BeanUtils.copyProperties((Object)companyGradeV3, (Object)dbRecCopy, (String[])new String[]{"id"});
                                dbRecCopy.setTags(StringUtils.join((Iterable)companyGradeV3.getTagSet(), (String)","));
                                result.add(dbRecCopy);
                                this.saveRecHis(companyGradeV3, dbRecCopy, eventSource);
                                continue;
                            }
                            if (!Objects.equals(dbRecCopy.getCheckState(), 1)) continue;
                            CompanyGradeV3Rec rec2 = new CompanyGradeV3Rec();
                            rec2.setId(dbRecCopy.getId());
                            rec2.setCid(dbRecCopy.getCid());
                            rec2.setGrade(dbRecCopy.getGrade());
                            rec2.setGradeSource(dbRecCopy.getGradeSource());
                            rec2.setTags(StringUtils.join((Iterable)companyGradeV3.getTagSet(), (String)","));
                            rec2.setIsDecCurrentYear(dbRecCopy.getIsDecCurrentYear());
                            rec2.setInduGrade(companyGradeV3.getInduGrade());
                            rec2.setIsGovern(companyGradeV3.getIsGovern());
                            rec2.setOccType(companyGradeV3.getOccType());
                            rec2.setIsValid(Integer.valueOf(1));
                            rec2.setIsBest(companyGradeV3.getIsBest());
                            if (!Objects.equals(companyGradeV3.getIsBest(), dbRecCopy.getIsBest()) && !Objects.equals(companyGradeV3.getJudgeLevel(), companyGradeV3.getRealJudgeLevel())) {
                                rec2.setGrade(companyGradeV3.getGrade());
                            }
                            if (!(Objects.equals(companyGradeV3.getGradeSource(), dbRecCopy.getGradeSource()) && Objects.equals(companyGradeV3.getGrade(), dbRecCopy.getGrade()) || Objects.equals(companyGradeV3.getGrade(), 0) || Objects.equals(companyGradeV3.getRealGradeSource(), GradeSourceEnum.NOSOURCE.getCode()))) {
                                if (Objects.equals(companyGradeV3.getGradeSource(), GradeSourceEnum.BYINDU.getCode())) {
                                    rec2.setGrade(companyGradeV3.getLastCheckedGradeLevel());
                                    rec2.setGradeSource(GradeSourceEnum.BYREPORT.getCode());
                                    rec2.setTags(GradeSourceEnum.BYREPORT.getCode().toString());
                                } else {
                                    rec2.setGrade(companyGradeV3.getGrade());
                                    rec2.setGradeSource(companyGradeV3.getGradeSource());
                                }
                            }
                            result.add(rec2);
                            this.saveRecHis(companyGradeV3, rec2, eventSource);
                            continue;
                        }
                        CompanyGradeV3Rec gradeV3Rec = this.gradeV3ConvertRec(companyGradeV3);
                        gradeV3Rec.setGradeSource(companyGradeV3.getGradeSource());
                        result.add(gradeV3Rec);
                        this.saveRecHis(companyGradeV3, gradeV3Rec, eventSource);
                    }
                }
                Map<Long, CompanyGradeV3> newGradeMap = newGradeList.stream().collect(Collectors.toMap(CompanyGradeV3::getCid, a -> a, (k1, k2) -> k1));
                for (CompanyGradeV3Rec dbgradeV3Rec : dbgradeV3RecMap.values()) {
                    if (newGradeMap.containsKey(dbgradeV3Rec.getCid())) continue;
                    dbgradeV3Rec.setIsValid(Integer.valueOf(0));
                    dbgradeV3Rec.setUpdateDate(new Date());
                    result.add(dbgradeV3Rec);
                }
                break block15;
            }
            if (!CollectionUtils.isNotEmpty(newGradeList)) break block15;
            for (CompanyGradeV3 companyGradeV3 : newGradeList) {
                CompanyGradeV3Rec gradeV3Rec = this.gradeV3ConvertRec(companyGradeV3);
                if (gradeV3Rec.getGradeSource() == null) {
                    gradeV3Rec.setGradeSource(GradeSourceEnum.NOSOURCE.getCode());
                }
                result.add(gradeV3Rec);
            }
        }
        return result;
    }

    private void saveRecHis(CompanyGradeV3 gradeV3, CompanyGradeV3Rec rec, CompanyGradeEventSource eventSource) {
        if (CompanyGradeEventSource.AUDIT.equals((Object)eventSource)) {
            try {
                CompanyGradeV3RecHis recHis = new CompanyGradeV3RecHis();
                BeanUtils.copyProperties((Object)rec, (Object)recHis);
                recHis.setId(Long.valueOf(this.idworker.nextId()));
                recHis.setSelfId(gradeV3.getSelfId());
                recHis.setRiskId(gradeV3.getRiskId());
                recHis.setEvaluateId(gradeV3.getEvaluateId());
                this.recHisService.add((Object)recHis);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u5ba1\u6838\u8bb0\u5f55\u5386\u53f2\u8868\u51fa\u9519\u300b", (Throwable)e);
            }
        }
    }

    private CompanyGradeV3Rec gradeV3ConvertRec(CompanyGradeV3 gradeV3) {
        CompanyGradeV3Rec rec = new CompanyGradeV3Rec();
        BeanUtils.copyProperties((Object)gradeV3, (Object)rec);
        if (Objects.equals(gradeV3.getCheckState(), 1)) {
            rec.setCheckState(Integer.valueOf(1));
        } else {
            rec.setCheckState(Integer.valueOf(0));
        }
        if (gradeV3.getOccType() == null || Objects.equals(gradeV3.getOccType(), 1) || Objects.equals(gradeV3.getOccType(), 3)) {
            rec.setOccType(CompanyOccTypeEnum.UNDIVIDED.getCode());
        }
        rec.setCreateDate(new Date());
        rec.setChangeReason(gradeV3.getChangeReason());
        rec.setIsBest(gradeV3.getIsBest());
        return rec;
    }

    private List<CompanyGradeHisV3> handCompanyGradeRecHisData(List<CompanyGradeV3Rec> newGradeList, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap, CompanyGradeEventSource eventSource) {
        ArrayList<CompanyGradeHisV3> companyGradeHis = new ArrayList<CompanyGradeHisV3>();
        if (CollUtil.isNotEmpty(dbgradeV3RecMap) && CollectionUtils.isNotEmpty(newGradeList)) {
            for (CompanyGradeV3Rec newCompanyGrade : newGradeList) {
                if (!dbgradeV3RecMap.containsKey(newCompanyGrade.getCid())) continue;
                CompanyGradeV3Rec hisGrade = dbgradeV3RecMap.get(newCompanyGrade.getCid());
                Integer newGrade = Optional.ofNullable(newCompanyGrade).map(CompanyGradeV3Rec::getGrade).orElse(null);
                Integer oldGrade = Optional.ofNullable(hisGrade).map(CompanyGradeV3Rec::getGrade).orElse(null);
                Integer newGradeSource = Optional.ofNullable(newCompanyGrade).map(CompanyGradeV3Rec::getGradeSource).orElse(null);
                Integer oldGradeSource = Optional.ofNullable(hisGrade).map(CompanyGradeV3Rec::getGradeSource).orElse(null);
                if (oldGrade == null || Objects.equals(oldGrade, 0) || oldGradeSource == null || Objects.equals(oldGradeSource, 0) || newGrade == null || Objects.equals(newGrade, 0) || newGradeSource == null || Objects.equals(newGradeSource, 0)) continue;
                if (!Objects.equals(newGrade, oldGrade) || !Objects.equals(newGradeSource, oldGradeSource)) {
                    String reason = this.compareGradeChangeReason2(newCompanyGrade, hisGrade, eventSource);
                    if (newCompanyGrade.getGrade() == null || StringUtils.isBlank((CharSequence)reason)) {
                        log.error("\u4e0d\u5e94\u8be5\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5\u624d\u5bf9\uff1ahisGrade=\u3010{}\u3011\uff0cnewCompanyGrade=\u3010{}\u3011 ", (Object)JSON.toJSONString((Object)hisGrade), (Object)JSON.toJSONString((Object)newCompanyGrade));
                        continue;
                    }
                    newCompanyGrade.setGradeTime(LocalDateTime.now());
                    CompanyGradeHisV3 his = new CompanyGradeHisV3();
                    his.setCid(newCompanyGrade.getCid());
                    his.setGrade(newCompanyGrade.getGrade());
                    his.setReason(reason);
                    his.setGradeTime(LocalDateTime.now());
                    companyGradeHis.add(his);
                    continue;
                }
                if (!Objects.equals(newCompanyGrade.getEvaluateType(), hisGrade.getEvaluateType()) && Objects.equals(newCompanyGrade.getCheckState(), 1)) continue;
                newCompanyGrade.setGradeTime(hisGrade.getGradeTime());
            }
        }
        return companyGradeHis;
    }

    @Transactional(readOnly=false)
    public int saveCompanyGradeBatch(List<CompanyGradeV3> gradeList, List<CompanyGradeV3Rec> newUpdateRecList, List<Long> updateSuperviseCid, List<CompanyGradeHisV3> gradeHisList) {
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        if (CollectionUtils.isNotEmpty(gradeList)) {
            List gradeIdList = gradeList.stream().map(CompanyGradeV3::getCid).distinct().collect(Collectors.toList());
            this.companyGradeV3Service.delCompanyGradeV3ByCid(gradeIdList);
            for (CompanyGradeV3 l : gradeList) {
                l.setId(Long.valueOf(this.idworker.nextId()));
            }
            for (List companyGradeV3s : ListUtil.partition(gradeList, (int)1000)) {
                this.companyGradeV3Service.insertGrades(companyGradeV3s);
            }
        }
        if (CollectionUtils.isNotEmpty(gradeHisList)) {
            this.companyGradeV3Service.insertGradeHiss(gradeHisList);
        }
        if (CollectionUtils.isNotEmpty(newUpdateRecList)) {
            Map<Boolean, List<CompanyGradeV3Rec>> addUpdateRecMap = newUpdateRecList.stream().collect(Collectors.groupingBy(g -> g.getId() == null));
            List<CompanyGradeV3Rec> addCompanyGradeV3Recs = addUpdateRecMap.get(true);
            List<CompanyGradeV3Rec> updateCompanyGradeV3Recs = addUpdateRecMap.get(false);
            this.gradeV3RecService.batchSaveCompanyGradeV3Rec(addCompanyGradeV3Recs);
            this.gradeV3RecService.batchupdateCompanyGradeV3Rec(updateCompanyGradeV3Recs);
        }
        if (CollectionUtils.isNotEmpty(updateSuperviseCid)) {
            log.info("\u66f4\u65b0\u76d1\u7763\u5bf9\u8c61:" + updateSuperviseCid.size());
            this.provideByHSEService.batchUpdateSupervise(updateSuperviseCid);
            log.info("\u6dfb\u52a0\u76d1\u7763\u5bf9\u8c61\u65e5\u5fd7:" + updateSuperviseCid.size());
            List companySuperviseModels = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByCidExcludeDelete(updateSuperviseCid);
            List superviseObjectLogs = companySuperviseModels.stream().map(item -> {
                SysSuperviseObjectLog log = new SysSuperviseObjectLog();
                log.setCid(item.getId());
                log.setChangeType(Integer.valueOf(1));
                log.setSourceType(item.getDataSource());
                log.setChangeTime(new Date());
                return log;
            }).collect(Collectors.toList());
            this.sysLogThirdService.addSuperviseObjectLog(superviseObjectLogs);
        }
        return 1;
    }
}

