/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.util.BeanMapUtil;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.compare.CompareUtils;
import cn.smarthse.es.esservice.IGradeV3ChangeLogEsService;
import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanyBaseInfoChangeRecords;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModelV3;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyBaseInfoChangeRecordsProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeHisV3;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3FinishLog;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3RecHis;
import cn.smarthse.modules.health.entity.sys.SysSuperviseObjectLog;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.model.gradechangelog.GradeV3ChangeLog;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.model.grade.CompanyGradeChangeClassc;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3BatchCid;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecHisService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3CollectServiceV2;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.GradeUtils;
import cn.smarthse.modules.health.supervise.service.sys.ISysLogThirdService;
import cn.smarthse.modules.health.vo.base.company.gradev3.SelfReportCollectVo;
import cn.smarthse.services.hfi.api.model.grade.CompanyOccTypeVo;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;
import tk.mybatis.mapper.entity.Example;

@Service
public class CompanyGradeV3CollectService {
    @Autowired
    private ICompanyGradeV3Service companyGradeV3Service;
    @Resource(name="companyGradeV3CollectServiceV2")
    private CompanyGradeV3CollectServiceV2 collectServiceV2;
    @Autowired
    private ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService provideByHSEService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService selfInsRiskAsseService;
    @Autowired
    private ISysLogThirdService sysLogThirdService;
    @DubboReference
    private IGradeV3ChangeLogEsService changeLogEsService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private CompanyGradeV3CollectService collectService;
    @Autowired
    private ICompanyGradeV3RecHisService recHisService;
    @DubboReference
    private ICompanyRiskCompletionService riskCompletionService;
    @DubboReference
    private ICompanyBaseInfoChangeRecordsProviderService companyBaseInfoChangeRecordsProviderService;
    @Autowired
    private IComplianceCompanyInfoService companyInfoService;
    @Autowired
    protected IdWorker idworker;
    Cache<Long, IndustryModel> industryModelCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.DAYS).build();
    Cache<Long, Long> suspendReformDecCidCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();
    @Value(value="${enableChangeLog:1}")
    private String enableChangeLog;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="gradeThreadPoolExecutor")
    private ExecutorService executorService;
    private static final String COLLECTCOMPANYGRADE_LOCKNAME = "third-service:collectCompanyGrade:lock";
    private static final String COLLECTCOMPANYGRADE_DELAY_SET = "third-service:collectCompanyGrade:delayset";

    private void initSuspendReformDec() {
        this.suspendReformDecCidCache.invalidateAll();
        this.suspendReformDecCidCache.cleanUp();
        List suspendCidSet = this.riskCompletionService.getUnresolvedAssessCompanyIds(null);
        if (CollectionUtils.isNotEmpty((Collection)suspendCidSet)) {
            suspendCidSet = suspendCidSet.stream().distinct().collect(Collectors.toList());
            Map<Long, Long> suspenMap = suspendCidSet.stream().collect(Collectors.toMap(k -> k, v -> v));
            this.suspendReformDecCidCache.putAll(suspenMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collectCompanyGrade(List<Long> cids, CompanyGradeEventSource eventSource) {
        RSet delayCidSet = this.redissonClient.getSet(COLLECTCOMPANYGRADE_DELAY_SET);
        RLock lock = this.redissonClient.getLock(COLLECTCOMPANYGRADE_LOCKNAME);
        if (CollectionUtils.isEmpty(cids)) {
            try {
                if (lock.tryLock(1L, TimeUnit.MINUTES)) {
                    this.doCollectCompanyGrade(cids, eventSource);
                    if (!CollectionUtils.isNotEmpty((Collection)delayCidSet)) return;
                    Iterator iterator = delayCidSet.iterator();
                    while (iterator.hasNext()) {
                        GradeV3BatchCid v = (GradeV3BatchCid)iterator.next();
                        this.doCollectCompanyGrade(v.getCids(), v.getEventSource());
                        iterator.remove();
                    }
                    return;
                }
                this.logger.error("\u6b63\u5728\u6267\u884c\u5168\u91cf\u5b9a\u65f6\u4efb\u52a1\uff0c \u5f53\u524d\u66f4\u65b0\u4e22\u5931\uff0c \u6d89\u53ca\u4f01\u4e1a\u6570:{}, \u4f01\u4e1aid:{}", (Object)cids.size(), (Object)ListUtil.partition(cids, (int)100));
                return;
            }
            catch (InterruptedException e) {
                this.logger.error("\u6279\u91cf\u66f4\u65b0\u4efb\u52a1\u4e2d\u65ad\uff0c \u6d89\u53ca\u4f01\u4e1a\u6570:{}, \u4f01\u4e1aid:{}", (Object)cids.size(), (Object)ListUtil.partition(cids, (int)100));
                return;
            }
            finally {
                lock.unlock();
            }
        } else {
            if (lock.isLocked()) {
                delayCidSet.add((Object)new GradeV3BatchCid(cids, eventSource));
                this.logger.error("\u6b63\u5728\u6267\u884c\u5168\u91cf\u5b9a\u65f6\u4efb\u52a1\uff0c \u5f53\u524d\u6570\u636e\u52a0\u5165\u4e4b\u540e\u6267\u884c, cid:{}", cids);
            }
            this.doCollectCompanyGrade(cids, eventSource);
        }
    }

    public void doCollectCompanyGrade(List<Long> cids, CompanyGradeEventSource eventSource) {
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        this.logger.info("\u5206\u7ea7\u5206\u7c7bV3\u5355\u4e2a\u4f01\u4e1a{}\u5b9e\u65f6\u7edf\u8ba1\u4efb\u52a1\u5f00\u59cb\u6267\u884c...", cids);
        if (CollectionUtils.isEmpty(cids)) {
            this.industryModelCache.invalidateAll();
            this.industryModelCache.cleanUp();
            this.initSuspendReformDec();
        }
        Date end = new Date();
        Date start = DateUtils.addYear((Date)end, (int)-2);
        List companyList = this.companyProvideService.listComapnyGradeInfoV3(cids);
        Map<Long, SelfReportCollectVo> selfReportMap = this.getSelfReportCollectMap(cids, start, end);
        Object complianceCidSet = new ConcurrentHashSet();
        List complianceCompanyInfos = this.companyInfoService.listReformRemainDateInfo(cids);
        if (CollectionUtils.isNotEmpty((Collection)complianceCompanyInfos)) {
            complianceCidSet = complianceCompanyInfos.stream().filter(f -> {
                List labels = f.getLabelList();
                Integer status = f.getStatus();
                return !Objects.equals(status, 3) || !CollectionUtils.containsAny((Collection)labels, Arrays.asList(1, 2));
            }).map(ComplianceCompanyInfo::getCid).collect(Collectors.toSet());
        }
        ConcurrentHashMap<Long, CompanyGradeChangeClassc> changeClasscMap = new ConcurrentHashMap<Long, CompanyGradeChangeClassc>();
        List companyGradeChangeClasscs = this.companyGradeV3Service.selectGradeChangeClassc(cids);
        if (CollectionUtils.isNotEmpty((Collection)companyGradeChangeClasscs)) {
            Map<Long, CompanyGradeChangeClassc> changeClasscMapTemp = companyGradeChangeClasscs.stream().collect(Collectors.toMap(CompanyGradeChangeClassc::getCid, v -> v));
            changeClasscMap.putAll(changeClasscMapTemp);
        }
        ConcurrentHashMap<Long, CompanyGradeV3Rec> dbgradeV3RecMap = new ConcurrentHashMap<Long, CompanyGradeV3Rec>();
        List dbGradev3RecList = this.gradeV3RecService.listAllCompanyGradeRec(cids);
        if (CollectionUtils.isNotEmpty((Collection)dbGradev3RecList)) {
            Map<Long, CompanyGradeV3Rec> dbgradeV3RecMapTemp = dbGradev3RecList.stream().collect(Collectors.toMap(CompanyGradeV3Rec::getCid, a -> a, (k1, k2) -> k1));
            dbgradeV3RecMap.putAll(dbgradeV3RecMapTemp);
        }
        List<CompanyGradeV3> newCompanyGradeV3List = this.convertCompanyGradeV3List(companyList);
        Map<Long, CompanyOccTypeVo> occTypeVoMap = this.getCidOccTypeCacheByRisk(cids);
        for (CompanyGradeV3 companyGradeV3 : newCompanyGradeV3List) {
            Integer occType = this.getOccType(occTypeVoMap, companyGradeV3);
            companyGradeV3.setOccType(occType);
            companyGradeV3.setIsGovern(Boolean.valueOf(false));
            CompanyGradeChangeClassc companyGradeChangeClassc = (CompanyGradeChangeClassc)changeClasscMap.get(companyGradeV3.getCid());
            CompanyGradeV3Rec dbRec = (CompanyGradeV3Rec)dbgradeV3RecMap.get(companyGradeV3.getCid());
            if (complianceCidSet.contains(companyGradeV3.getCid())) {
                companyGradeV3.setIsCompliance(Boolean.valueOf(true));
            } else {
                companyGradeV3.setIsCompliance(Boolean.valueOf(false));
            }
            if (Objects.equals(companyGradeV3.getCompanyType(), 2)) {
                companyGradeV3.setGrade(Integer.valueOf(1));
            } else if (Objects.equals(companyGradeV3.getIsCompliance(), true)) {
                companyGradeV3.setGrade(Integer.valueOf(1));
            } else if (this.isZjCompany(companyGradeV3) && Objects.equals(companyGradeV3.getCreditSupervise(), 1)) {
                companyGradeV3.setGrade(Integer.valueOf(1));
            } else if (companyGradeChangeClassc != null && dbRec != null && (dbRec.getCheckTime() == null || dbRec.getCheckTime() != null && DateUtils.compare_date((Date)companyGradeChangeClassc.getChangeTime(), (Date)dbRec.getCheckTime()) > 0)) {
                companyGradeV3.setGrade(Integer.valueOf(3));
                companyGradeV3.setIdentifiedClassc(true);
            } else if (companyGradeV3.getPunishNum() != null && companyGradeV3.getPunishNum() > 0) {
                companyGradeV3.setGrade(Integer.valueOf(3));
            }
            this.handSelfReportData(selfReportMap, companyGradeV3);
            this.setInduGrade(companyGradeV3);
            if (companyGradeV3.getGrade() == 0) {
                this.setGradeByOccType(companyGradeV3);
            }
            this.calcRiskType(companyGradeV3);
            this.importantCheck(companyGradeV3);
            this.handPickupCount(companyGradeV3);
        }
        try {
            this.collectService.doSaveCollectCompanyGrade(newCompanyGradeV3List, dbgradeV3RecMap, cids, eventSource, changeClasscMap);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u7ea7\u5206\u7c7bV3\u5355\u4e2a\u4f01\u4e1a{}\u5b9e\u65f6\u7edf\u8ba1\u4efb\u52a1\u6267\u884c\u51fa\u9519...", cids, (Object)e);
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void doSaveCollectCompanyGrade(List<CompanyGradeV3> newCompanyGradeV3List, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap, List<Long> cids, CompanyGradeEventSource eventSource, Map<Long, CompanyGradeChangeClassc> changeClasscMap) {
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        List<CompanyGradeV3Rec> newUpdateRecList = this.handCompanyGradeRecData(newCompanyGradeV3List, dbgradeV3RecMap, eventSource, changeClasscMap);
        this.handOccTypeChangeRec(newCompanyGradeV3List, dbgradeV3RecMap);
        this.handCompanyGradeRecHisData(newUpdateRecList, dbgradeV3RecMap, eventSource);
        if ("1".equals(this.enableChangeLog)) {
            // empty if block
        }
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        if (CollectionUtils.isEmpty(cids)) {
            this.companyGradeV3Service.delCompanyGradeV3();
        } else {
            int delNum = this.companyGradeV3Service.delCompanyGradeV3ByCid(cids);
            this.logger.info("\u5220\u9664{}\u6761\u5206\u7ea7\u5206\u7c7bV3\u6570\u636e", (Object)delNum);
        }
        this.logger.info("\u5165\u5e93{}\u6761\u5206\u7ea7\u5206\u7c7bV3\u65b0\u6570\u636e", (Object)newCompanyGradeV3List.size());
        this.saveCompanyGradeBatch(newCompanyGradeV3List);
    }

    private void handPickupCount(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3.isIdentifiedClassc()) {
            return;
        }
        companyGradeV3.setRealGrade(companyGradeV3.getGrade());
        if (companyGradeV3.getIsShowVictims() != null && companyGradeV3.getIsShowVictims() <= 2) {
            companyGradeV3.setGrade(GradeUtils.downgrade(companyGradeV3.getRealGrade()));
        }
    }

    private void saveChangeLog(List<CompanyGradeV3Rec> newUpdateRecList, List<CompanyGradeV3Rec> dbGradev3RecList, List<CompanyGradeV3> newCompanyGradeV3List, List<Long> cids) {
        this.executorService.execute(() -> {
            GradeV3ChangeLog gradeV3ChangeLog;
            String compare;
            CompareUtils compareUtils;
            StopWatch watch = new StopWatch();
            watch.start("handlerChangeLog");
            List dbCompanyGradeV3List = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)newCompanyGradeV3List)) {
                if (CollectionUtils.isNotEmpty((Collection)cids)) {
                    Example example = new Example(CompanyGradeV3.class);
                    example.createCriteria().andIn("cid", (Iterable)cids);
                    dbCompanyGradeV3List = this.companyGradeV3Service.getListByExample(example);
                } else {
                    dbCompanyGradeV3List = this.companyGradeV3Service.getListByExample(null);
                }
            } else {
                return;
            }
            HashMap<Long, GradeV3ChangeLog> logMap = new HashMap<Long, GradeV3ChangeLog>();
            if (CollectionUtils.isNotEmpty((Collection)newUpdateRecList)) {
                Map<Object, Object> dbGradev3RecMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)dbGradev3RecList)) {
                    dbGradev3RecMap = dbGradev3RecList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
                }
                compareUtils = new CompareUtils();
                for (CompanyGradeV3Rec newRec : newUpdateRecList) {
                    CompanyGradeV3Rec dbRec = (CompanyGradeV3Rec)dbGradev3RecMap.get(newRec.getCid());
                    if (dbRec == null || Objects.equals(dbRec.getCheckState(), 1) && !Objects.equals(newRec.getCheckState(), 1) || StringUtils.isBlank((CharSequence)(compare = compareUtils.compareSpecific((Object)dbRec, (Object)newRec, StringUtils.parseToStringList((String)"grade,induGrade,evaluateType,judgeLevel,riskLevel,occType,checkState,isBest", (String)","))))) continue;
                    gradeV3ChangeLog = logMap.computeIfAbsent(newRec.getCid(), v -> new GradeV3ChangeLog(v));
                    gradeV3ChangeLog.setCreateDate(new Date());
                    gradeV3ChangeLog.setGradeRecChange(compare);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)newCompanyGradeV3List)) {
                Map<Object, Object> dbGradev3Map = new HashMap();
                if (CollectionUtils.isNotEmpty(dbCompanyGradeV3List)) {
                    dbGradev3Map = dbCompanyGradeV3List.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
                }
                compareUtils = new CompareUtils();
                for (CompanyGradeV3 newGrade : newCompanyGradeV3List) {
                    CompanyGradeV3 dbGrade = (CompanyGradeV3)dbGradev3Map.get(newGrade.getCid());
                    compare = compareUtils.compareSpecific((Object)dbGrade, (Object)newGrade, StringUtils.parseToStringList((String)"grade,induGrade,realGrade,selfId,riskId,evaluateId,judgeLevel,riskLevel,riskClassify,occType,evaluateType,evaluateCheckState,jugdeCheckState,riskCheckState,checkState", (String)","));
                    if (StringUtils.isBlank((CharSequence)compare)) continue;
                    gradeV3ChangeLog = logMap.computeIfAbsent(newGrade.getCid(), v -> new GradeV3ChangeLog(v));
                    gradeV3ChangeLog.setCreateDate(new Date());
                    gradeV3ChangeLog.setGradeChange(compare);
                }
            }
            List<GradeV3ChangeLog> gradeV3ChangeLogList = logMap.values().stream().collect(Collectors.toList());
            watch.stop();
            watch.start("saveChangeLog");
            this.saveCompanyGradeChangeLogBatch(gradeV3ChangeLogList);
            watch.stop();
            this.logger.info(watch.prettyPrint());
            this.logger.info("\u4fdd\u5b58{}\u6761\u5206\u7ea7\u5206\u7c7b\u53d8\u66f4\u65e5\u5fd7\u8bb0\u5f55, \u5904\u7406\u65f6\u957f\uff1a{}s", (Object)gradeV3ChangeLogList.size(), (Object)watch.getTotalTimeSeconds());
        });
    }

    @Transactional(readOnly=false)
    public void handCompanyGradeFinishLogData(List<CompanyGradeV3Rec> newUpdateRecList) {
        if (CollectionUtils.isNotEmpty(newUpdateRecList)) {
            Long cid = null;
            int gradeYear = DateUtils.getGradeYear();
            if (newUpdateRecList.size() == 1) {
                CompanyGradeV3Rec gradeV3Rec = newUpdateRecList.get(0);
                cid = gradeV3Rec.getCid();
            }
            List gradeFinishLogList = this.companyGradeV3Service.getGradeFinishLogList(cid, Integer.valueOf(gradeYear));
            Set finishLogCidSet = gradeFinishLogList.stream().map(CompanyGradeV3FinishLog::getCid).collect(Collectors.toSet());
            ArrayList<CompanyGradeV3FinishLog> gradeV3FinishLogList = new ArrayList<CompanyGradeV3FinishLog>();
            for (CompanyGradeV3Rec newGradeV3Rec : newUpdateRecList) {
                if (finishLogCidSet.contains(newGradeV3Rec.getCid()) || !Objects.equals(newGradeV3Rec.getIsDecCurrentYear(), true)) continue;
                CompanyGradeV3FinishLog finishLog = new CompanyGradeV3FinishLog();
                finishLog.setCid(newGradeV3Rec.getCid());
                finishLog.setYear(Integer.valueOf(gradeYear));
                gradeV3FinishLogList.add(finishLog);
            }
            this.saveGradeFinishLogBatch(gradeV3FinishLogList);
        }
    }

    private Map<Long, SelfReportCollectVo> getSelfReportCollectMap(List<Long> cids, Date start, Date end) {
        List selfReportCollectVoList = this.selfInsRiskAsseService.getSelfReportInfoCollectVoListHasJudgeByRangTimeAndCid(start, DateUtils.addDay((Date)end, (int)1), cids);
        if (CollectionUtils.isNotEmpty((Collection)selfReportCollectVoList)) {
            Map<Long, SelfReportCollectVo> selfReportMap = selfReportCollectVoList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
            return selfReportMap;
        }
        return new HashMap<Long, SelfReportCollectVo>();
    }

    private void handSelfReportData(Map<Long, SelfReportCollectVo> selfReportMap, CompanyGradeV3 companyGradeV3) {
        SelfReportCollectVo selfReportModel;
        Long cid = companyGradeV3.getCid();
        if (selfReportMap.containsKey(cid) && (selfReportModel = selfReportMap.get(cid)) != null) {
            Integer gradeLevel = selfReportModel.getGradeLevel();
            if (companyGradeV3.getGrade() == 0 && gradeLevel != null && Objects.equals(1, selfReportModel.getEvaluateCheckState()) && Objects.equals(1, selfReportModel.getJudgeCheckState()) && Objects.equals(1, selfReportModel.getRiskCheckState())) {
                companyGradeV3.setGrade(gradeLevel);
            }
            companyGradeV3.setRiskClassify(Integer.valueOf(gradeLevel == null ? 0 : gradeLevel));
            companyGradeV3.setJudgeLevel(Integer.valueOf(selfReportModel.getJudgeLevel() == null ? 0 : selfReportModel.getJudgeLevel()));
            companyGradeV3.setRiskLevel(Integer.valueOf(selfReportModel.getRiskLevel() == null ? 0 : selfReportModel.getRiskLevel()));
            companyGradeV3.setSelfId(selfReportModel.getSelfId());
            companyGradeV3.setRiskId(selfReportModel.getRiskId());
            companyGradeV3.setEvaluateId(selfReportModel.getEvaluateId());
            companyGradeV3.setEvaluateUpdateDate(selfReportModel.getEvaluateUpdateDate());
            companyGradeV3.setRiskUpdateDate(selfReportModel.getRiskUpdateDate());
            companyGradeV3.setJugdeUpdateDate(selfReportModel.getJudgeUpdateDate());
            if (CompanyGradeV3CollectService.isCurrentDate(selfReportModel.getEvaluateUpdateDate()) || CompanyGradeV3CollectService.isCurrentDate(selfReportModel.getRiskUpdateDate()) || CompanyGradeV3CollectService.isCurrentDate(selfReportModel.getJudgeUpdateDate())) {
                companyGradeV3.setIsDecCurrentYear(Boolean.valueOf(true));
            }
            companyGradeV3.setEvaluateCheckState(Integer.valueOf(selfReportModel.getEvaluateCheckState() == null ? 3 : selfReportModel.getEvaluateCheckState()));
            companyGradeV3.setRiskCheckState(Integer.valueOf(selfReportModel.getRiskCheckState() == null ? 3 : selfReportModel.getRiskCheckState()));
            companyGradeV3.setJugdeCheckState(Integer.valueOf(selfReportModel.getJudgeCheckState() == null ? 3 : selfReportModel.getJudgeCheckState()));
            this.calcCheckState(companyGradeV3);
            companyGradeV3.setRiskHasUpdate(selfReportModel.getRiskHasUpdate());
            companyGradeV3.setEvaluateType(selfReportModel.getEvaluateType());
            companyGradeV3.setChangeReason(selfReportModel.getEvaluateChangeReason());
            companyGradeV3.setRealJudgeLevel(selfReportModel.getRealJudgelevel());
        }
    }

    private static boolean isCurrentDate(Date date) {
        if (date == null) {
            return false;
        }
        LocalDateTime d1 = LocalDateTime.of(2022, 11, 25, 0, 0, 0);
        LocalDateTime fromDate = cn.smarthse.util.common.date.DateUtils.getFromDate((Date)date);
        return fromDate.isAfter(d1);
    }

    private void calcCheckState(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3 != null) {
            Integer evaluateCheckState = companyGradeV3.getEvaluateCheckState();
            Integer riskCheckState = companyGradeV3.getRiskCheckState();
            Integer jugdeCheckState = companyGradeV3.getJugdeCheckState();
            if (Objects.equals(evaluateCheckState, 0)) {
                companyGradeV3.setCheckState(Integer.valueOf(0));
            } else if (Objects.equals(evaluateCheckState, -1) || Objects.equals(riskCheckState, -1) || Objects.equals(jugdeCheckState, -1)) {
                companyGradeV3.setCheckState(Integer.valueOf(-1));
            } else if (Objects.equals(evaluateCheckState, 1) && Objects.equals(riskCheckState, 1) && Objects.equals(jugdeCheckState, 1)) {
                companyGradeV3.setCheckState(Integer.valueOf(1));
            } else if (evaluateCheckState != null || riskCheckState != null || jugdeCheckState != null) {
                companyGradeV3.setCheckState(Integer.valueOf(2));
            } else {
                companyGradeV3.setCheckState(Integer.valueOf(3));
            }
        }
    }

    private IndustryModel getIndustryModelCache(Long induId) {
        if (induId == null) {
            return null;
        }
        if (this.industryModelCache.estimatedSize() == 0L) {
            List industryList = this.industryProvideService.getIndustryList();
            Map<Object, Object> industryMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)industryList)) {
                industryMap = industryList.stream().collect(Collectors.toMap(IndustryModel::getId, m -> m, (v1, v2) -> v1));
                this.industryModelCache.putAll(industryMap);
            }
        }
        IndustryModel industryModel = (IndustryModel)this.industryModelCache.getIfPresent((Object)induId);
        return industryModel;
    }

    public boolean containsSuspendReformDec(Long cid) {
        if (cid == null) {
            return false;
        }
        Long contailsCid = (Long)this.suspendReformDecCidCache.getIfPresent((Object)cid);
        return contailsCid != null;
    }

    private Map<Long, CompanyOccTypeVo> getCidOccTypeCacheByRisk(List<Long> cids) {
        Date start = DateUtils.addYear((Date)new Date(), (int)-3);
        Date end = DateUtils.addDay((Date)new Date(), (int)1);
        Map companyOccTypeMap = this.riskExposeEvaluateService.getCompanyOccTypeMap(cids, null, null, null);
        return companyOccTypeMap;
    }

    private void calcRiskType(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3 != null) {
            Integer grade = companyGradeV3.getGrade();
            Integer riskLevel = companyGradeV3.getRiskLevel();
            Integer riskClassify = companyGradeV3.getRiskClassify();
            Integer judgeLevel = companyGradeV3.getJudgeLevel();
            Integer occType = companyGradeV3.getOccType();
            if (Integer.valueOf(CompanyGradeEnum.CLASSA.getValue().byteValue()).equals(grade) && HazardsExposureRiskLevelEnum.heightRisk.getCode().equals(riskLevel) && CompanyOccTypeEnum.SERIOUS.getCode().equals(occType)) {
                companyGradeV3.setRiskType(Integer.valueOf(1));
            } else if (HazardsExposureRiskLevelEnum.heightRisk.getCode().equals(riskLevel) && JudgeResultLevelEnum.A.getCode().equals(judgeLevel)) {
                companyGradeV3.setRiskType(Integer.valueOf(2));
            } else if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType) && (Integer.valueOf(CompanyGradeEnum.CLASSB.getValue().byteValue()).equals(grade) || Integer.valueOf(CompanyGradeEnum.CLASSC.getValue().byteValue()).equals(grade))) {
                companyGradeV3.setRiskType(Integer.valueOf(3));
            }
        }
    }

    private void importantCheck(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3 != null) {
            Integer riskLevel = companyGradeV3.getRiskLevel();
            Integer riskClassify = companyGradeV3.getRiskClassify();
            Integer judgeLevel = companyGradeV3.getJudgeLevel();
            Integer occType = companyGradeV3.getOccType();
            if (Integer.valueOf(CompanyGradeEnum.CLASSA.getValue().byteValue()).equals(judgeLevel) && HazardsExposureRiskLevelEnum.heightRisk.getCode().equals(riskLevel)) {
                companyGradeV3.setImportantCheck(Integer.valueOf(1));
            } else if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType) && Integer.valueOf(CompanyGradeEnum.CLASSA.getValue().byteValue()).equals(riskClassify)) {
                companyGradeV3.setImportantCheck(Integer.valueOf(2));
            }
        }
    }

    private static List<CompanyOccTypeVo> sortCompanyOccTypeVo(CompanyOccTypeVo ... list) {
        if (ArrayUtils.isNotEmpty((Object[])list)) {
            List<CompanyOccTypeVo> collect = Arrays.stream(list).filter(f -> f != null).sorted((v1, v2) -> {
                if (v1.getUpdateDate() == null && v2.getUpdateDate() == null) {
                    return 0;
                }
                if (v1.getUpdateDate() == null && v2.getUpdateDate() != null) {
                    return 1;
                }
                if (v1.getUpdateDate() != null && v2.getUpdateDate() == null) {
                    return -1;
                }
                if (v1.getUpdateDate().getTime() > v2.getUpdateDate().getTime()) {
                    return -1;
                }
                return 0;
            }).collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    private Integer getOccType(Map<Long, CompanyOccTypeVo> occTypeVoMap, CompanyGradeV3 companyGradeV3) {
        Object evaluateOccType;
        Long cid = companyGradeV3.getCid();
        Integer occType = CompanyOccTypeEnum.UNDIVIDED.getCode();
        CompanyOccTypeVo rickOccType = occTypeVoMap.get(cid);
        List<CompanyOccTypeVo> companyOccTypeVos = CompanyGradeV3CollectService.sortCompanyOccTypeVo(rickOccType, evaluateOccType = null);
        if (CollectionUtils.isNotEmpty(companyOccTypeVos) && companyOccTypeVos.get(0).getOccType() != null) {
            companyGradeV3.setOccTypeSource(companyOccTypeVos.get(0).getCheckType());
            return companyOccTypeVos.get(0).getOccType().intValue();
        }
        occType = this.getInduOccType(companyGradeV3);
        companyGradeV3.setOccTypeSource(Integer.valueOf(9));
        return occType;
    }

    private Integer getInduOccType(CompanyGradeV3 companyGradeV3) {
        Integer occType = CompanyOccTypeEnum.UNDIVIDED.getCode();
        IndustryModel industryModel = this.getIndustryModelCache(companyGradeV3.getIndustryCategory());
        if (industryModel != null && StringUtils.isNotBlank((CharSequence)industryModel.getHarmLevel())) {
            if ("WHCDC".equalsIgnoreCase(industryModel.getHarmLevel())) {
                occType = CompanyOccTypeEnum.COMMON.getCode();
            } else if ("WHCDH".equalsIgnoreCase(industryModel.getHarmLevel())) {
                occType = CompanyOccTypeEnum.HEAVIER.getCode();
            } else if ("WHCDS".equalsIgnoreCase(industryModel.getHarmLevel())) {
                occType = CompanyOccTypeEnum.SERIOUS.getCode();
            } else if ("WXF".equalsIgnoreCase(industryModel.getHarmLevel())) {
                occType = CompanyOccTypeEnum.NOTSUBDIVIDED.getCode();
            } else if ("WHF".equalsIgnoreCase(industryModel.getHarmLevel())) {
                occType = CompanyOccTypeEnum.UNDIVIDED.getCode();
            }
        }
        return occType;
    }

    private void setGradeByOccType(CompanyGradeV3 companyGradeV3) {
        Integer occType = companyGradeV3.getOccType();
        if (occType != null) {
            if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType)) {
                companyGradeV3.setGrade(Integer.valueOf(3));
            } else if (CompanyOccTypeEnum.COMMON.getCode().equals(occType)) {
                companyGradeV3.setGrade(Integer.valueOf(2));
            }
        }
    }

    public Integer getGradeByOccType(Integer occType) {
        if (occType != null) {
            if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType)) {
                return 3;
            }
            if (CompanyOccTypeEnum.COMMON.getCode().equals(occType)) {
                return 2;
            }
        }
        return null;
    }

    private void setInduGrade(CompanyGradeV3 companyGradeV3) {
        Integer occType = this.getInduOccType(companyGradeV3);
        companyGradeV3.setInduGrade(Integer.valueOf(0));
        if (occType != null) {
            if (CompanyOccTypeEnum.SERIOUS.getCode().equals(occType)) {
                companyGradeV3.setInduGrade(Integer.valueOf(3));
            } else if (CompanyOccTypeEnum.COMMON.getCode().equals(occType)) {
                companyGradeV3.setInduGrade(Integer.valueOf(2));
            }
        }
    }

    private List<CompanyGradeV3> convertCompanyGradeV3List(List<CompanyGradeModelV3> companyList) {
        if (CollectionUtils.isNotEmpty(companyList)) {
            List<CompanyGradeV3> collect = companyList.stream().map(v -> {
                CompanyGradeV3 v3 = new CompanyGradeV3();
                BeanUtils.copyProperties((Object)v, (Object)v3);
                v3.setGrade(Integer.valueOf(0));
                v3.setRiskLevel(Integer.valueOf(0));
                v3.setJudgeLevel(Integer.valueOf(0));
                v3.setRiskClassify(Integer.valueOf(0));
                v3.setGradeTime(LocalDateTime.now());
                v3.setIsBest(Byte.valueOf(v.getIsBest() == null ? (byte)0 : v.getIsBest()));
                v3.setIsDecCurrentYear(v.getIsDecCurrentYear());
                v3.setIsDecOld(v.getIsDecOld());
                v3.setIsShowVictims(v.getIsShowVictims());
                v3.setPickupCountSource(v.getPickupCountSource());
                v3.setIsValid(Integer.valueOf(1));
                return v3;
            }).collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    private LocalDateTime calcGradeTime(CompanyGradeV3Rec newRec, CompanyGradeV3Rec oldRec) {
        try {
            String[] fieds;
            Map newMap = BeanMapUtil.bean2Map((Object)newRec);
            Map oldMap = BeanMapUtil.bean2Map((Object)oldRec);
            for (String fied : fieds = new String[]{"grade", "gradeSource", "induGrade", "occType", "judgeLevel", "riskLevel", "checkTime"}) {
                String oldValue;
                String newValue;
                if (!newMap.containsKey(fied) || !oldMap.containsKey(fied) || Objects.equals(newValue = Convert.toStr(newMap.get(fied), (String)""), oldValue = Convert.toStr(oldMap.get(fied), (String)""))) continue;
                return LocalDateTime.now();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return oldRec.getGradeTime();
    }

    private String compareGradeChangeReason2(CompanyGradeV3Rec companyGrade, CompanyGradeV3Rec companyGradeHis, CompanyGradeEventSource eventSource) {
        String reason = "";
        try {
            String changeReason = companyGrade.getChangeReason();
            if (CompanyGradeEventSource.BESTCHANGE.equals((Object)eventSource)) {
                if (companyGradeHis != null && !Objects.equals(companyGrade.getIsBest(), companyGradeHis.getIsBest())) {
                    if (Objects.equals(companyGrade.getIsBest(), (byte)0)) {
                        reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d6\u6d88\u5065\u5eb7\u4f01\u4e1a", (String)",");
                    } else if (Objects.equals(companyGrade.getIsBest(), (byte)1)) {
                        reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d8\u66f4\u4e3a\u5065\u5eb7\u4f01\u4e1a", (String)",");
                    }
                }
            } else {
                Integer hisOccType;
                Integer newOccType;
                if (Objects.equals(companyGrade.getCheckState(), 1) && StringUtils.isNotEmpty((String)changeReason)) {
                    if (changeReason.indexOf("1") > -1) {
                        reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d8\u66f4\u8bc4\u4f30\uff08\u804c\u4e1a\u75c5\u5371\u5bb3\u63a5\u89e6\u60c5\u51b5\u53d1\u751f\u91cd\u5927\u53d8\u5316\uff09", (String)",");
                    }
                    if (changeReason.indexOf("2") > -1) {
                        reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u53d8\u66f4\u8bc4\u4f30\uff08\u7ba1\u7406\u72b6\u51b5\u53d1\u751f\u91cd\u5927\u53d8\u5316\uff09", (String)",");
                    }
                }
                if (!Objects.equals(companyGrade.getCheckState(), 1) && Objects.equals(companyGrade.getEvaluateType(), 1) && !Objects.equals(newOccType = companyGrade.getOccType(), hisOccType = companyGradeHis.getOccType())) {
                    reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u6240\u5c5e\u884c\u4e1a\u53d8\u66f4", (String)",");
                }
                if (StringUtils.isBlank((CharSequence)reason) && Objects.equals(companyGrade.getEvaluateType(), 1)) {
                    reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u5b9a\u671f\u8bc4\u4f30", (String)",");
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return reason;
    }

    private String compareGradeChangeNew(CompanyGradeV3Rec companyGrade) {
        boolean noChange = false;
        String reason = "";
        if (companyGrade == null || companyGrade.getGrade() == null || companyGrade.getGrade() == 0) {
            return "";
        }
        if (Objects.equals(companyGrade.getEvaluateType(), 2)) {
            reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u5b9a\u671f\u8bc4\u4f30", (String)",");
        }
        if (companyGrade.getAddOccNum() != null && companyGrade.getAddOccNum() > 0) {
            reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u4e24\u5e74\u5185\u65b0\u53d1\u804c\u4e1a\u75c5", (String)",");
        }
        if (companyGrade.getJudgeLevel() != null || companyGrade.getRiskLevel() != null) {
            reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u804c\u4e1a\u75c5\u5371\u5bb3\u98ce\u9669\u7c7b\u522b\u53d8\u66f4", (String)",");
        } else if (companyGrade.getOccType() != null) {
            reason = CommonUtil.distinctAppendStr((String)reason, (String)"\u884c\u4e1a\u804c\u4e1a\u75c5\u5371\u5bb3\u98ce\u9669\u7c7b\u522b\u53d8\u66f4", (String)",");
        }
        return reason;
    }

    private boolean isZjCompany(CompanyGradeV3 newCompanyGrade) {
        Long areaId = Optional.ofNullable(newCompanyGrade).map(g -> g.getAreaId()).orElse(null);
        if (areaId == null) {
            return false;
        }
        return areaId.toString().startsWith("33");
    }

    private boolean isZjCompany(CompanyGradeV3Rec dbrec) {
        Long areaId = Optional.ofNullable(dbrec).map(g -> g.getAreaId()).orElse(null);
        if (areaId == null) {
            return false;
        }
        return areaId.toString().startsWith("33");
    }

    private List<CompanyGradeV3Rec> handCompanyGradeRecData(List<CompanyGradeV3> newGradeList, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap, CompanyGradeEventSource eventSource, Map<Long, CompanyGradeChangeClassc> changeClasscMap) {
        ArrayList<CompanyGradeV3Rec> addGradeRecList = new ArrayList<CompanyGradeV3Rec>();
        ArrayList<CompanyGradeV3Rec> updateGradeRecList = new ArrayList<CompanyGradeV3Rec>();
        ArrayList<Long> updateSuperviseCid = new ArrayList<Long>();
        ArrayList<CompanyGradeV3Rec> result = new ArrayList<CompanyGradeV3Rec>();
        if (CollUtil.isNotEmpty(dbgradeV3RecMap)) {
            if (CollectionUtils.isNotEmpty(newGradeList)) {
                for (CompanyGradeV3 companyGradeV3 : newGradeList) {
                    if (!Objects.equals(companyGradeV3.getIsSupervise(), true) && (Objects.equals(companyGradeV3.getCheckState(), 1) || companyGradeV3.getIsShowVictims() != null && companyGradeV3.getIsShowVictims() < 3 && companyGradeV3.getIndustryCategory() != null && !Objects.equals(companyGradeV3.getOccType(), CompanyOccTypeEnum.NOTSUBDIVIDED.getCode()))) {
                        updateSuperviseCid.add(companyGradeV3.getCid());
                    }
                    GradeSourceEnum gs = GradeSourceEnum.NOSOURCE;
                    Integer gradeByOccType = this.getGradeByOccType(companyGradeV3.getOccType());
                    CompanyGradeChangeClassc companyGradeChangeClassc = changeClasscMap.get(companyGradeV3.getCid());
                    CompanyGradeV3Rec dbRec = dbgradeV3RecMap.get(companyGradeV3.getCid());
                    if (companyGradeV3.getGrade() != null && companyGradeV3.getGrade() != 0) {
                        if (Objects.equals(companyGradeV3.getCompanyType(), 2)) {
                            gs = GradeSourceEnum.LABOR_DISPATCH;
                        } else if (Objects.equals(companyGradeV3.getIsCompliance(), true)) {
                            gs = GradeSourceEnum.COMPLIANCE;
                        } else if (this.isZjCompany(companyGradeV3) && Objects.equals(companyGradeV3.getCreditSupervise(), 1)) {
                            gs = GradeSourceEnum.CREDITSUPERVISE;
                        } else if (companyGradeChangeClassc != null && dbRec != null && (dbRec.getCheckTime() == null || dbRec.getCheckTime() != null && DateUtils.compare_date((Date)companyGradeChangeClassc.getChangeTime(), (Date)dbRec.getCheckTime()) > 0)) {
                            gs = GradeSourceEnum.SUPERVISE_IDENTIFY;
                        } else if (this.isZjCompany(companyGradeV3) && this.containsSuspendReformDec(companyGradeV3.getCid())) {
                            gs = GradeSourceEnum.SUPENDREFORM;
                            if (companyGradeV3.getIsShowVictims() != null && companyGradeV3.getIsShowVictims() < 3) {
                                companyGradeV3.setGrade(Integer.valueOf(2));
                            } else {
                                companyGradeV3.setGrade(Integer.valueOf(3));
                            }
                        } else {
                            gs = companyGradeV3.getIsShowVictims() != null && companyGradeV3.getIsShowVictims() < 3 ? GradeSourceEnum.LESS3 : (Objects.equals(companyGradeV3.getCheckState(), 1) ? GradeSourceEnum.BYREPORT : GradeSourceEnum.BYINDU);
                        }
                    }
                    if (dbgradeV3RecMap.containsKey(companyGradeV3.getCid())) {
                        CompanyGradeV3Rec newRec = new CompanyGradeV3Rec();
                        BeanUtils.copyProperties((Object)dbgradeV3RecMap.get(companyGradeV3.getCid()), (Object)newRec);
                        newRec.setIsValid(Integer.valueOf(1));
                        newRec.setAreaId(companyGradeV3.getAreaId());
                        if (Objects.equals(companyGradeV3.getRiskClassify(), 0) && !Objects.equals(companyGradeV3.getGrade(), 0)) {
                            newRec.setByIndu(Integer.valueOf(1));
                        } else if (!Objects.equals(companyGradeV3.getCheckState(), 1) && !Objects.equals(companyGradeV3.getGrade(), 0)) {
                            newRec.setByIndu(Integer.valueOf(1));
                        } else {
                            newRec.setByIndu(Integer.valueOf(0));
                        }
                        if (Objects.equals(companyGradeV3.getCheckState(), 1)) {
                            BeanUtils.copyProperties((Object)companyGradeV3, (Object)newRec, (String[])new String[]{"id"});
                            newRec.setGradeSource(gs.getCode());
                            if (CompanyGradeEventSource.AUDIT.equals((Object)eventSource)) {
                                newRec.setCheckTime(new Date());
                            }
                            newRec.setGradeTime(this.calcGradeTime(newRec, dbRec));
                            updateGradeRecList.add(newRec);
                            this.saveRecHis(companyGradeV3, newRec, eventSource);
                            continue;
                        }
                        if (Objects.equals(newRec.getCheckState(), 0) || Objects.equals(newRec.getCheckState(), -1) || Objects.equals(newRec.getCheckState(), 2) || Objects.equals(newRec.getCheckState(), 3)) {
                            BeanUtils.copyProperties((Object)companyGradeV3, (Object)newRec, (String[])new String[]{"id"});
                            newRec.setGradeSource(gs.getCode());
                            newRec.setGradeTime(this.calcGradeTime(newRec, dbRec));
                            updateGradeRecList.add(newRec);
                            this.saveRecHis(companyGradeV3, newRec, eventSource);
                            continue;
                        }
                        if (!Objects.equals(newRec.getCheckState(), 1)) continue;
                        CompanyGradeV3Rec rec2 = new CompanyGradeV3Rec();
                        rec2.setId(newRec.getId());
                        rec2.setCid(newRec.getCid());
                        rec2.setIsDecCurrentYear(newRec.getIsDecCurrentYear());
                        rec2.setInduGrade(companyGradeV3.getInduGrade());
                        rec2.setIsGovern(companyGradeV3.getIsGovern());
                        rec2.setOccType(companyGradeV3.getOccType());
                        rec2.setIsValid(Integer.valueOf(1));
                        rec2.setIsBest(companyGradeV3.getIsBest());
                        if (!Objects.equals(companyGradeV3.getIsBest(), newRec.getIsBest()) && !Objects.equals(companyGradeV3.getJudgeLevel(), companyGradeV3.getRealJudgeLevel())) {
                            rec2.setGrade(companyGradeV3.getGrade());
                            rec2.setGradeTime(this.calcGradeTime(rec2, dbRec));
                        }
                        if (!Objects.equals(gs.getCode(), newRec.getGradeSource()) && (Objects.equals(gs, GradeSourceEnum.COMPLIANCE) || Objects.equals(gs, GradeSourceEnum.CREDITSUPERVISE) || Objects.equals(gs, GradeSourceEnum.SUPENDREFORM) || Objects.equals(gs, GradeSourceEnum.LESS3) || Objects.equals(gs, GradeSourceEnum.LABOR_DISPATCH) || Objects.equals(newRec.getGradeSource(), GradeSourceEnum.COMPLIANCE.getCode()) || Objects.equals(newRec.getGradeSource(), GradeSourceEnum.CREDITSUPERVISE.getCode()) || Objects.equals(newRec.getGradeSource(), GradeSourceEnum.SUPENDREFORM.getCode()) || Objects.equals(newRec.getGradeSource(), GradeSourceEnum.LESS3.getCode()) || Objects.equals(newRec.getGradeSource(), GradeSourceEnum.LABOR_DISPATCH.getCode()))) {
                            Integer dbRecGrade = this.getGradeByDbGradeRec(newRec, gs, gradeByOccType, companyGradeV3);
                            Integer dbRecGradeSource = this.getGradeSourceByDbGradeRec(newRec, gs, gradeByOccType, companyGradeV3.getCompanyType());
                            rec2.setGrade(dbRecGrade);
                            rec2.setGradeSource(dbRecGradeSource);
                            rec2.setGradeTime(this.calcGradeTime(rec2, dbRec));
                        }
                        updateGradeRecList.add(rec2);
                        this.saveRecHis(companyGradeV3, rec2, eventSource);
                        continue;
                    }
                    CompanyGradeV3Rec gradeV3Rec = this.gradeV3ConvertRec(companyGradeV3);
                    gradeV3Rec.setGradeSource(gs.getCode());
                    addGradeRecList.add(gradeV3Rec);
                    this.saveRecHis(companyGradeV3, gradeV3Rec, eventSource);
                }
            }
            Map<Long, CompanyGradeV3> newGradeMap = newGradeList.stream().collect(Collectors.toMap(CompanyGradeV3::getCid, a -> a, (k1, k2) -> k1));
            for (CompanyGradeV3Rec dbgradeV3Rec : dbgradeV3RecMap.values()) {
                if (newGradeMap.containsKey(dbgradeV3Rec.getCid())) continue;
                dbgradeV3Rec.setIsValid(Integer.valueOf(0));
                dbgradeV3Rec.setUpdateDate(new Date());
                updateGradeRecList.add(dbgradeV3Rec);
            }
        } else if (CollectionUtils.isNotEmpty(newGradeList)) {
            for (CompanyGradeV3 companyGradeV3 : newGradeList) {
                CompanyGradeV3Rec gradeV3Rec = this.gradeV3ConvertRec(companyGradeV3);
                if (gradeV3Rec.getGradeSource() == null) {
                    gradeV3Rec.setGradeSource(GradeSourceEnum.NOSOURCE.getCode());
                }
                addGradeRecList.add(gradeV3Rec);
            }
        }
        if (CollectionUtils.isNotEmpty(addGradeRecList)) {
            this.logger.info("\u5206\u7ea7\u76d1\u7763\u65b0\u589e\u5ba1\u6838\u8bb0\u5f55\u6761\u6570:" + addGradeRecList.size());
            this.gradeV3RecService.batchSaveCompanyGradeV3Rec(addGradeRecList);
        }
        if (CollectionUtils.isNotEmpty(updateGradeRecList)) {
            this.logger.info("\u5206\u7ea7\u76d1\u7763\u66f4\u65b0\u5ba1\u6838\u8bb0\u5f55\u6761\u6570:" + updateGradeRecList.size());
            this.gradeV3RecService.batchupdateCompanyGradeV3Rec(updateGradeRecList);
        }
        if (CollectionUtils.isNotEmpty(updateSuperviseCid)) {
            this.logger.info("\u66f4\u65b0\u76d1\u7763\u5bf9\u8c61:" + updateSuperviseCid.size());
            this.provideByHSEService.batchUpdateSupervise(updateSuperviseCid);
            this.logger.info("\u6dfb\u52a0\u76d1\u7763\u5bf9\u8c61\u65e5\u5fd7:" + updateSuperviseCid.size());
            List companySuperviseModels = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByCidExcludeDelete(updateSuperviseCid);
            List list = companySuperviseModels.stream().map(item -> {
                SysSuperviseObjectLog log = new SysSuperviseObjectLog();
                log.setCid(item.getId());
                log.setChangeType(Integer.valueOf(1));
                log.setSourceType(item.getDataSource());
                log.setChangeTime(new Date());
                return log;
            }).collect(Collectors.toList());
            this.sysLogThirdService.addSuperviseObjectLog(list);
        }
        result.addAll(addGradeRecList);
        result.addAll(updateGradeRecList);
        return result;
    }

    public Integer getGradeByDbGradeRec(CompanyGradeV3Rec dbrec, GradeSourceEnum gs, Integer gradeByOccType, CompanyGradeV3 newCompanyGrade) {
        HazardsExposureRiskLevelEnum riskLevelEnum;
        if (dbrec == null) {
            return 0;
        }
        if (Objects.equals(gs, GradeSourceEnum.CREDITSUPERVISE) || Objects.equals(gs, GradeSourceEnum.COMPLIANCE) || Objects.equals(gs, GradeSourceEnum.LABOR_DISPATCH)) {
            return 1;
        }
        Integer judgeLevel = dbrec.getJudgeLevel();
        Integer riskLevel = dbrec.getRiskLevel();
        JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)judgeLevel);
        HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)judgeResultLevelEnum, (HazardsExposureRiskLevelEnum)(riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)riskLevel)));
        if (riskClassifyEnum != null) {
            if (this.isZjCompany(dbrec) && this.containsSuspendReformDec(dbrec.getCid())) {
                if (newCompanyGrade.getIsShowVictims() != null && newCompanyGrade.getIsShowVictims() < 3) {
                    return 2;
                }
                return 3;
            }
            if (Objects.equals(gs, GradeSourceEnum.LESS3)) {
                return GradeUtils.downgrade(riskClassifyEnum.getCode());
            }
            return riskClassifyEnum.getCode();
        }
        if (gradeByOccType != null) {
            if (Objects.equals(gs, GradeSourceEnum.LESS3)) {
                return GradeUtils.downgrade(riskClassifyEnum.getCode());
            }
            return gradeByOccType;
        }
        return 0;
    }

    public Integer getGradeSourceByDbGradeRec(CompanyGradeV3Rec dbrec, GradeSourceEnum gs, Integer gradeByOccType, Integer companyType) {
        HazardsExposureRiskLevelEnum riskLevelEnum;
        if (dbrec == null) {
            return GradeSourceEnum.NOSOURCE.getCode();
        }
        if (Objects.equals(gs, GradeSourceEnum.COMPLIANCE) || Objects.equals(gs, GradeSourceEnum.CREDITSUPERVISE) || Objects.equals(gs, GradeSourceEnum.SUPENDREFORM) || Objects.equals(gs, GradeSourceEnum.LESS3) || Objects.equals(gs, GradeSourceEnum.LABOR_DISPATCH)) {
            return gs.getCode();
        }
        Integer judgeLevel = dbrec.getJudgeLevel();
        Integer riskLevel = dbrec.getRiskLevel();
        JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)judgeLevel);
        HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)judgeResultLevelEnum, (HazardsExposureRiskLevelEnum)(riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)riskLevel)));
        if (riskClassifyEnum != null) {
            if (this.isZjCompany(dbrec) && this.containsSuspendReformDec(dbrec.getCid())) {
                return GradeSourceEnum.SUPENDREFORM.getCode();
            }
            return GradeSourceEnum.BYREPORT.getCode();
        }
        Integer occType = dbrec.getOccType();
        return gradeByOccType == null ? GradeSourceEnum.NOSOURCE.getCode() : GradeSourceEnum.BYINDU.getCode();
    }

    private void handOccTypeChangeRec(List<CompanyGradeV3> newGradeList, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap) {
        ArrayList<CompanyBaseInfoChangeRecords> changeRecords = new ArrayList<CompanyBaseInfoChangeRecords>();
        if (CollUtil.isNotEmpty(dbgradeV3RecMap) && CollectionUtils.isNotEmpty(newGradeList)) {
            for (CompanyGradeV3 newCompanyGrade : newGradeList) {
                Integer newOccType = newCompanyGrade.getOccType();
                CompanyGradeV3Rec dbOccType = dbgradeV3RecMap.getOrDefault(newCompanyGrade.getCid(), null);
                if (dbOccType == null || Objects.equals(newOccType, dbOccType.getOccType())) continue;
                CompanyBaseInfoChangeRecords r = new CompanyBaseInfoChangeRecords();
                r.setCid(newCompanyGrade.getCid());
                r.setBeforeValue(CompanyOccTypeEnum.getName((Integer)dbOccType.getOccType()));
                r.setAfterValue(CompanyOccTypeEnum.getName((Integer)newOccType));
                r.setChangeType(CompanyBaseChangeTypeEnum.OCCTYPE_CHANGE.getValue());
                String reason = "";
                if (Objects.equals(newCompanyGrade.getOccTypeSource(), 2)) {
                    reason = "\u5b9a\u671f\u68c0\u6d4b";
                } else if (Objects.equals(newCompanyGrade.getOccTypeSource(), 4)) {
                    reason = "\u63a7\u5236\u8bc4\u4ef7\u68c0\u6d4b";
                } else if (Objects.equals(newCompanyGrade.getOccTypeSource(), 3)) {
                    reason = "\u73b0\u72b6\u8bc4\u4ef7";
                } else if (Objects.equals(newCompanyGrade.getOccTypeSource(), 9)) {
                    reason = "\u6309\u884c\u4e1a\u5206\u7c7b";
                }
                r.setReason(reason);
                r.setCreateDate(new Date());
                changeRecords.add(r);
            }
        }
        if (CollectionUtils.isNotEmpty(changeRecords)) {
            ListUtil.partition(changeRecords, (int)1000).forEach(list -> this.companyBaseInfoChangeRecordsProviderService.batchAddChangeRecInfo(list));
        }
    }

    private void handCompanyDecFalg(List<CompanyGradeV3> newGradeList, CompanyGradeEventSource eventSource) {
        CompanyGradeV3 companyGradeV3;
        ArrayList changeRecords = new ArrayList();
        if (CollectionUtils.isNotEmpty(newGradeList) && newGradeList.size() == 1 && Objects.equals(CompanyGradeEventSource.AUDIT, eventSource) && Objects.equals((companyGradeV3 = newGradeList.get(0)).getCheckState(), 1) && (Objects.equals(companyGradeV3.getIsDecOld(), false) || Objects.equals(companyGradeV3.getIsDecCurrentYear(), false))) {
            CompanySuperviseModel c = new CompanySuperviseModel();
            c.setId(companyGradeV3.getCid());
            c.setIsDecCurrentYear(Boolean.valueOf(true));
            c.setIsDecOld(Boolean.valueOf(true));
            this.companyProvideBySuperviseService.updateCompanyOnlyBaseInfo(c, Long.valueOf(7780L));
        }
    }

    private void saveRecHis(CompanyGradeV3 gradeV3, CompanyGradeV3Rec rec, CompanyGradeEventSource eventSource) {
        if (CompanyGradeEventSource.AUDIT.equals((Object)eventSource)) {
            try {
                CompanyGradeV3RecHis recHis = new CompanyGradeV3RecHis();
                BeanUtils.copyProperties((Object)rec, (Object)recHis);
                recHis.setId(Long.valueOf(this.idworker.nextId()));
                recHis.setSelfId(gradeV3.getSelfId());
                recHis.setRiskId(gradeV3.getRiskId());
                recHis.setEvaluateId(gradeV3.getEvaluateId());
                this.recHisService.add((Object)recHis);
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u5ba1\u6838\u8bb0\u5f55\u5386\u53f2\u8868\u51fa\u9519\u300b", (Throwable)e);
            }
        }
    }

    private CompanyGradeV3Rec gradeV3ConvertRec(CompanyGradeV3 gradeV3) {
        CompanyGradeV3Rec rec = new CompanyGradeV3Rec();
        BeanUtils.copyProperties((Object)gradeV3, (Object)rec);
        if (Objects.equals(gradeV3.getCheckState(), 1)) {
            rec.setCheckState(Integer.valueOf(1));
        } else {
            rec.setCheckState(Integer.valueOf(0));
        }
        if (Objects.equals(gradeV3.getOccType(), 1) || Objects.equals(gradeV3.getOccType(), 3)) {
            rec.setOccType(Integer.valueOf(4));
        }
        if (Objects.equals(gradeV3.getRiskClassify(), 0) && !Objects.equals(gradeV3.getGrade(), 0)) {
            rec.setByIndu(Integer.valueOf(1));
        } else if (!Objects.equals(gradeV3.getCheckState(), 1) && !Objects.equals(gradeV3.getGrade(), 0)) {
            rec.setByIndu(Integer.valueOf(1));
        } else {
            rec.setByIndu(Integer.valueOf(0));
        }
        rec.setCreateDate(new Date());
        rec.setChangeReason(gradeV3.getChangeReason());
        rec.setIsBest(gradeV3.getIsBest());
        return rec;
    }

    private void handCompanyGradeRecHisData(List<CompanyGradeV3Rec> newGradeList, Map<Long, CompanyGradeV3Rec> dbgradeV3RecMap, CompanyGradeEventSource eventSource) {
        this.executorService.execute(() -> {
            RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
            StopWatch watch = new StopWatch();
            watch.start("handCompanyGradeRecHisData");
            ArrayList<CompanyGradeHisV3> companyGradeHis = new ArrayList<CompanyGradeHisV3>();
            if (CollUtil.isNotEmpty((Map)dbgradeV3RecMap) && CollectionUtils.isNotEmpty((Collection)newGradeList)) {
                for (CompanyGradeV3Rec newCompanyGrade : newGradeList) {
                    if (!dbgradeV3RecMap.containsKey(newCompanyGrade.getCid())) continue;
                    CompanyGradeV3Rec hisGrade = (CompanyGradeV3Rec)dbgradeV3RecMap.get(newCompanyGrade.getCid());
                    Integer a = Optional.ofNullable(newCompanyGrade).map(CompanyGradeV3Rec::getGrade).orElse(null);
                    Integer b = Optional.ofNullable(hisGrade).map(CompanyGradeV3Rec::getGrade).orElse(null);
                    if (a == null || Objects.equals(a, 0)) continue;
                    if (!Objects.equals(a, b)) {
                        String reason = this.compareGradeChangeReason2(newCompanyGrade, hisGrade, eventSource);
                        if (newCompanyGrade.getGrade() == null || StringUtils.isBlank((CharSequence)reason)) continue;
                        CompanyGradeHisV3 his = new CompanyGradeHisV3();
                        his.setCid(newCompanyGrade.getCid());
                        his.setGrade(newCompanyGrade.getGrade());
                        his.setReason(reason);
                        his.setGradeTime(LocalDateTime.now());
                        companyGradeHis.add(his);
                        continue;
                    }
                    if (!Objects.equals(newCompanyGrade.getEvaluateType(), hisGrade.getEvaluateType()) && Objects.equals(newCompanyGrade.getCheckState(), 1)) continue;
                    newCompanyGrade.setGradeTime(hisGrade.getGradeTime());
                }
            }
            watch.stop();
            watch.start("saveCompanyGradeChangeLogBatch");
            if (CollectionUtils.isNotEmpty(companyGradeHis)) {
                this.saveCompanyGradeHisBatch(companyGradeHis);
            }
            watch.stop();
            this.logger.info(watch.prettyPrint());
            this.logger.info("\u4fdd\u5b58{}\u6761\u5206\u7ea7\u5206\u7c7b\u53d8\u66f4\u65e5\u5fd7\u8bb0\u5f55, \u5904\u7406\u65f6\u957f\uff1a{}s", (Object)companyGradeHis.size(), (Object)watch.getTotalTimeSeconds());
        });
    }

    @Transactional(readOnly=false)
    public int saveCompanyGradeChangeLogBatch(List<GradeV3ChangeLog> gradeList) {
        if (CollectionUtils.isEmpty(gradeList)) {
            return 0;
        }
        List partitionList = ListUtil.partition(gradeList, (int)100);
        for (List gradeV3ChangeLogs : partitionList) {
            this.changeLogEsService.batchAddChangeLog(gradeV3ChangeLogs);
        }
        return 1;
    }

    private int saveCompanyGradeBatch(List<CompanyGradeV3> gradeList) {
        if (CollectionUtils.isEmpty(gradeList)) {
            return 0;
        }
        int n = 0;
        for (List companyGradeV3s : ListUtil.partition(gradeList, (int)1000)) {
            int count = this.companyGradeV3Service.insertGrades(companyGradeV3s);
            n += count;
        }
        return n;
    }

    private int saveGradeFinishLogBatch(List<CompanyGradeV3FinishLog> gradeList) {
        if (CollectionUtils.isEmpty(gradeList)) {
            return 0;
        }
        int n = 0;
        for (List companyGradeV3s : ListUtil.partition(gradeList, (int)1000)) {
            int count = this.companyGradeV3Service.insertGradeFinishLog(companyGradeV3s);
            n += count;
        }
        return n;
    }

    private int saveCompanyGradeHisBatch(List<CompanyGradeHisV3> gradeHisList) {
        if (CollectionUtils.isEmpty(gradeHisList)) {
            return 0;
        }
        int n = 0;
        for (List companyGradeV3s : ListUtil.partition(gradeHisList, (int)1000)) {
            int count = this.companyGradeV3Service.insertGradeHiss(companyGradeV3s);
            n += count;
        }
        return n;
    }
}

