/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.govern;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.base.company.govern.CompanyGovern;
import cn.smarthse.modules.health.entity.base.company.govern.CompanyGovernRiskConf;
import cn.smarthse.modules.health.enums.company.govern.CompanyGovernReformStatusEnum;
import cn.smarthse.modules.health.enums.home.govern.CompanyGovernRiskTypeEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.supervise.dao.company.govern.CompanyGovernMapper;
import cn.smarthse.modules.health.supervise.model.AreaGradeNumModel;
import cn.smarthse.modules.health.supervise.model.govern.GovernCollectModel;
import cn.smarthse.modules.health.supervise.model.govern.GovernSearchForm;
import cn.smarthse.modules.health.supervise.service.company.govern.ICompanyGovernRiskConfService;
import cn.smarthse.modules.health.supervise.service.company.govern.ICompanyGovernService;
import cn.smarthse.modules.health.vo.base.company.govern.CompanyGovernQuery;
import cn.smarthse.modules.health.vo.base.company.govern.CompanyGovernVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class CompanyGovernServiceImpl
extends BaseServiceImpl<CompanyGovernMapper, CompanyGovern>
implements ICompanyGovernService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @Autowired
    private ICompanyGovernRiskConfService riskConfService;

    public int delCompanyGovern() {
        Example e = new Example(CompanyGovern.class);
        return ((CompanyGovernMapper)this.dao).deleteByExample(e);
    }

    @Transactional(readOnly=false)
    public void updateCompanyGovern(CompanyGovern companyGovern, Long loginStaffId) {
        Example e = new Example(CompanyGovern.class);
        this.update(companyGovern, loginStaffId);
    }

    public Integer getOverTimeComNumByArea(Long areaId, Byte areaLevel, Boolean isBelongType, Boolean onlyIsGovern) {
        return ((CompanyGovernMapper)this.dao).getOverTimeComNumByArea(areaId, areaLevel, isBelongType, onlyIsGovern);
    }

    public List<GovernCollectModel> collectCompanyGradeByCateGory(GovernCollectModel param, boolean fillCateGory) {
        Long areaId;
        AreaModel areaModel;
        if (param.getGroupType() == null) {
            return Collections.emptyList();
        }
        if (param.getAreaId() != null && param.getAreaLevel() == null && (areaModel = this.areaProvideService.getAreaById(areaId = param.getAreaId())) != null) {
            param.setAreaLevel(areaModel.getLevel());
        }
        List<GovernCollectModel> collectModelList = null;
        collectModelList = param.getGroupType().equals(1) ? ((CompanyGovernMapper)this.dao).collectCompanyGovernByGrade(param) : ((CompanyGovernMapper)this.dao).collectCompanyGovernByReformStatus(param);
        if (fillCateGory) {
            Integer groupType = param.getGroupType();
            this.fillCateGroy(collectModelList, groupType);
        }
        return collectModelList;
    }

    public List<GovernCollectModel> collectRiskCompanyByRiskType(GovernCollectModel param) {
        Long areaId;
        AreaModel areaModel;
        if (param.getGroupType() == null) {
            return Collections.emptyList();
        }
        if (param.getAreaId() != null && param.getAreaLevel() == null && (areaModel = this.areaProvideService.getAreaById(areaId = param.getAreaId())) != null) {
            param.setAreaLevel(areaModel.getLevel());
        }
        List<GovernCollectModel> collectModelList = ((CompanyGovernMapper)this.dao).collectRiskCompanyByRiskType(param);
        this.fillCateGroy(collectModelList, 3);
        return collectModelList;
    }

    public List<AreaGradeNumModel> listAreaGradeInfo(GovernSearchForm form) {
        if (form.getGradeLevel() == null) {
            return Collections.emptyList();
        }
        Integer gradeLevel = form.getGradeLevel();
        Integer reformStatus = form.getReformStatus();
        List<AreaGradeNumModel> areaGradeNumModels = null;
        if (gradeLevel != null && gradeLevel < 4) {
            areaGradeNumModels = ((CompanyGovernMapper)this.dao).listAreaGradeInfo(form);
        } else {
            if (gradeLevel == 4) {
                form.setReformStatus(Integer.valueOf(1));
            } else if (gradeLevel == 5) {
                form.setReformStatus(Integer.valueOf(0));
            }
            areaGradeNumModels = ((CompanyGovernMapper)this.dao).listAreaGovernReformStatusInfo(form);
        }
        return areaGradeNumModels;
    }

    public PageInfo<CompanyGovernVo> pageCaegoryListData(JqGridParam param, CompanyGovernQuery search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyGovernVo> list = this.listCaegoryListData(search);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<CompanyGovernVo> listCaegoryListData(CompanyGovernQuery search) {
        List<Object> resultList = new ArrayList();
        resultList = Integer.valueOf("2").equals(search.getType()) ? ((CompanyGovernMapper)this.dao).listReformListData(search) : ((CompanyGovernMapper)this.dao).listCaegoryListData(search);
        return resultList;
    }

    public CompanyGovernRiskConf getCompanyGovernRiskConf(Long areaId) {
        return this.riskConfService.getCompanyGovernRiskConf(areaId);
    }

    @Transactional(readOnly=false)
    public CompanyGovernRiskConf saveCompanyGovernRiskConf(CompanyGovernRiskConf riskConf, Long loginId) {
        return this.riskConfService.saveCompanyGovernRiskConf(riskConf, loginId);
    }

    private void fillCateGroy(List<GovernCollectModel> collectModelList, Integer groupType) {
        Set cateGroySet = collectModelList.stream().map(GovernCollectModel::getCateGory).collect(Collectors.toSet());
        switch (groupType) {
            case 1: {
                for (HazardsRiskClassifyEnum value : HazardsRiskClassifyEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GovernCollectModel(groupType, value.getCode(), Integer.valueOf(0)));
                }
                if (cateGroySet.contains(0)) break;
                collectModelList.add(new GovernCollectModel(groupType, Integer.valueOf(0), Integer.valueOf(0)));
                break;
            }
            case 2: {
                for (CompanyGovernReformStatusEnum value : CompanyGovernReformStatusEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GovernCollectModel(groupType, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
            case 3: {
                for (CompanyGovernRiskTypeEnum value : CompanyGovernRiskTypeEnum.values()) {
                    if (cateGroySet.contains(value.getValue())) continue;
                    collectModelList.add(new GovernCollectModel(groupType, value.getValue(), Integer.valueOf(0)));
                }
                break;
            }
        }
    }

    public Integer getContactHarmOverComNumByArea(Long areaId, Byte areaLevel, Boolean isBelongType) {
        return ((CompanyGovernMapper)this.dao).getContactHarmOverComNumByArea(areaId, areaLevel, isBelongType);
    }

    public Integer getToBeRectifiedComNumByArea(Long areaId, Byte areaLevel, Boolean isBelongType, Boolean onlyIsGovern) {
        return ((CompanyGovernMapper)this.dao).getToBeRectifiedComNumByArea(areaId, areaLevel, isBelongType, onlyIsGovern);
    }
}

