/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.govern;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.base.company.govern.CompanyGovernRiskConf;
import cn.smarthse.modules.health.supervise.dao.company.govern.CompanyGovernRiskConfMapper;
import cn.smarthse.modules.health.supervise.service.company.govern.ICompanyGovernRiskConfService;
import cn.smarthse.modules.platform.model.AreaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class CompanyGovernRiskConfServiceImpl
extends BaseServiceImpl<CompanyGovernRiskConfMapper, CompanyGovernRiskConf>
implements ICompanyGovernRiskConfService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;

    public Long getGovernRiskTypeAreaId(Long areaIdTemp) {
        ArrayList<Long> areaids = new ArrayList<Long>();
        areaids.add(0L);
        AreaModel areaModel = this.areaProvideService.getAreaById(areaIdTemp);
        if (areaModel != null) {
            if (areaModel.getLevel().intValue() == 1) {
                areaids.add(areaModel.getProvinceId());
            } else if (areaModel.getLevel().intValue() == 2) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
            } else if (areaModel.getLevel().intValue() == 3) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
                areaids.add(areaModel.getAreaId());
            } else if (areaModel.getLevel().intValue() == 4) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
                areaids.add(areaModel.getAreaId());
                areaids.add(areaModel.getStreetId());
            }
        }
        Collections.reverse(areaids);
        List<Long> allGradeSetAreaId = ((CompanyGovernRiskConfMapper)this.dao).getAllRiskConfAreaId();
        HashSet<Long> allGradeSetAreaIdSet = new HashSet<Long>(allGradeSetAreaId);
        if (CollectionUtils.isNotEmpty(allGradeSetAreaIdSet)) {
            for (Long areaid : areaids) {
                if (!allGradeSetAreaIdSet.contains(areaid)) continue;
                return areaid;
            }
        }
        return -1L;
    }

    public CompanyGovernRiskConf getCompanyGovernRiskConf(Long areaId) {
        if (areaId == null) {
            return new CompanyGovernRiskConf();
        }
        Long governRiskTypeAreaId = this.getGovernRiskTypeAreaId(areaId);
        if (governRiskTypeAreaId == null) {
            return new CompanyGovernRiskConf();
        }
        Example e = new Example(CompanyGovernRiskConf.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)governRiskTypeAreaId);
        CompanyGovernRiskConf companyGovernRiskConf = (CompanyGovernRiskConf)((CompanyGovernRiskConfMapper)this.dao).selectOneByExample(e);
        return companyGovernRiskConf;
    }

    @Transactional(readOnly=false)
    public CompanyGovernRiskConf saveCompanyGovernRiskConf(CompanyGovernRiskConf riskConf, Long loginId) {
        if (riskConf == null || riskConf.getAreaId() == null) {
            return null;
        }
        CompanyGovernRiskConf companyGovernRiskConf = this.getCompanyGovernRiskConf(riskConf.getAreaId());
        if (companyGovernRiskConf != null) {
            companyGovernRiskConf.setConf(riskConf.getConf());
            this.update(companyGovernRiskConf, loginId);
            return companyGovernRiskConf;
        }
        this.add(riskConf, loginId, null);
        return riskConf;
    }
}

