/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.govern;

import cn.smarthse.modules.health.entity.base.company.govern.CompanyGovern;
import cn.smarthse.modules.health.enums.company.govern.CompanyGovernReformStatusEnum;
import cn.smarthse.modules.health.supervise.dao.company.govern.CompanyGovernMapper;
import cn.smarthse.modules.health.supervise.model.govern.CompanyReformCollectDto;
import cn.smarthse.modules.health.supervise.service.company.govern.ICompanyGovernService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyGovernCollectServiceImpl {
    @Autowired
    private CompanyGovernMapper dao;
    @Autowired
    private ICompanyGovernService companyGovernService;

    @Transactional(readOnly=false)
    public void collectCompanyGovern() {
        try {
            List<CompanyReformCollectDto> companyGovernCollectDtos = this.dao.reformCollectInfo();
            if (CollectionUtils.isEmpty(companyGovernCollectDtos)) {
                return;
            }
            List<CompanyGovern> companyGovernList = this.dao.listAllCompanyGovern();
            Map<Object, Object> companyHisGovernMap = new HashMap();
            if (CollectionUtils.isNotEmpty(companyGovernList)) {
                companyHisGovernMap = companyGovernList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
            }
            Map<Long, List<CompanyReformCollectDto>> reformDtoMap = companyGovernCollectDtos.stream().collect(Collectors.groupingBy(k -> k.getCid()));
            Set<Long> reformDtoSet = reformDtoMap.keySet();
            ArrayList<CompanyGovern> resultList = new ArrayList<CompanyGovern>();
            for (Long reformCid : reformDtoSet) {
                List<CompanyReformCollectDto> companyReformCollectDtos = reformDtoMap.get(reformCid);
                CompanyGovern companyGovernHis = (CompanyGovern)companyHisGovernMap.get(reformCid);
                CompanyGovern companyGovern = this.generateNewCompanyGovern(reformCid);
                if (companyGovernHis == null || !CompanyGovernReformStatusEnum.HOPELESS.getCode().equals(companyGovernHis.getReformStatus())) {
                    this.settingCompanyReformStatus(companyGovern, companyReformCollectDtos);
                }
                resultList.add(companyGovern);
            }
            this.companyGovernService.delCompanyGovern();
            this.saveCompanyGovernBatch(resultList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CompanyGovern generateNewCompanyGovern(Long cid) {
        CompanyGovern companyGovern = new CompanyGovern();
        companyGovern.setCid(cid);
        return companyGovern;
    }

    private CompanyGovernReformStatusEnum handleCompanyGovernHis(CompanyGovern companyGovernHis, CompanyGovernReformStatusEnum companyGovernReformStatus) {
        if (companyGovernHis == null) {
            return companyGovernReformStatus;
        }
        if (CompanyGovernReformStatusEnum.HOPELESS.getCode().equals(companyGovernHis.getReformStatus())) {
            return CompanyGovernReformStatusEnum.HOPELESS;
        }
        return companyGovernReformStatus;
    }

    public CompanyGovernReformStatusEnum calcCompanyReformStatus(List<CompanyReformCollectDto> governCollectDtoList) {
        if (CollectionUtils.isEmpty(governCollectDtoList)) {
            return null;
        }
        boolean allFinish = governCollectDtoList.stream().allMatch(g -> Byte.valueOf("3").equals(g.getStatus()));
        if (allFinish) {
            return CompanyGovernReformStatusEnum.FINISH;
        }
        boolean hasOverTime = governCollectDtoList.stream().anyMatch(g -> !Byte.valueOf("3").equals(g.getStatus()) && g.getRequireFinishTime() != null && g.getRequireFinishTime().getTime() < new Date().getTime());
        if (hasOverTime) {
            return CompanyGovernReformStatusEnum.OVERTIME;
        }
        return CompanyGovernReformStatusEnum.ING;
    }

    public void settingCompanyReformStatus(CompanyGovern companyGovern, List<CompanyReformCollectDto> governCollectDtoList) {
        boolean hasOverTime;
        boolean allFinish;
        Optional<Date> actualFinishTime;
        Optional<Date> requireFinishTime = governCollectDtoList.stream().filter(d -> d.getRequireFinishTime() != null).map(CompanyReformCollectDto::getRequireFinishTime).min(Date::compareTo);
        if (requireFinishTime.isPresent()) {
            companyGovern.setRequireFinishTime(requireFinishTime.get());
        }
        if ((actualFinishTime = governCollectDtoList.stream().filter(d -> d.getActualFinishTime() != null).map(CompanyReformCollectDto::getActualFinishTime).max(Date::compareTo)).isPresent()) {
            companyGovern.setActualFinishTime(actualFinishTime.get());
        }
        if (allFinish = governCollectDtoList.stream().allMatch(g -> Byte.valueOf("3").equals(g.getStatus()))) {
            companyGovern.setReformStatus(CompanyGovernReformStatusEnum.FINISH.getCode());
        }
        if (hasOverTime = governCollectDtoList.stream().anyMatch(g -> !Byte.valueOf("3").equals(g.getStatus()) && g.getRequireFinishTime() != null && g.getRequireFinishTime().getTime() < new Date().getTime())) {
            companyGovern.setReformStatus(CompanyGovernReformStatusEnum.OVERTIME.getCode());
        }
        companyGovern.setReformStatus(CompanyGovernReformStatusEnum.ING.getCode());
    }

    private int saveCompanyGovernBatch(List<CompanyGovern> gradeList) {
        int pointsDataLimit = 1000;
        int listSize = gradeList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<CompanyGovern> newList = new ArrayList<CompanyGovern>();
        for (int i = 0; i < gradeList.size(); ++i) {
            newList.add(gradeList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = this.dao.batchInsertGovern(newList);
            n += count;
            newList.clear();
        }
        return n;
    }
}

