/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.common.model.TrainCompanyModel;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.sys.SysParam;
import cn.smarthse.modules.health.supervise.dao.company.CompanyBaseInfoMapper;
import cn.smarthse.modules.health.supervise.dao.company.CompanyMapper;
import cn.smarthse.modules.health.supervise.entity.company.CompanyHarmCollectModel;
import cn.smarthse.modules.health.supervise.entity.company.CompanyIndusInfoCount;
import cn.smarthse.modules.health.supervise.entity.company.CompanyMajorInduCollectModel;
import cn.smarthse.modules.health.supervise.enums.ImportantIndustryTypeEnum;
import cn.smarthse.modules.health.supervise.enums.company.CompanyCollectListEnum;
import cn.smarthse.modules.health.supervise.service.company.ICompanyFunOrgService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.health.supervise.service.sys.ISysParamService;
import cn.smarthse.modules.health.supervise.vo.company.CompanyCollectListVo;
import cn.smarthse.modules.health.supervise.vo.company.CompanySearchVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ThirdCompanyServiceImpl
extends BaseServiceImpl<CompanyMapper, Company>
implements IThirdCompanyService {
    @Autowired
    private CompanyMapper companyMapper;
    @Autowired
    private CompanyBaseInfoMapper companyBaseMapper;
    @Autowired
    @Qualifier(value="sysParamServiceImpl")
    private ISysParamService sysParamService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @Autowired
    private ICompanyFunOrgService companyFunOrgService;

    public List<Company> getCompanyByUnifiedSocialCc(String unifiedSocialCc) {
        return this.companyBaseMapper.getCompanyByUnifiedSocialCc(unifiedSocialCc);
    }

    public Company getCompanyById(Long cid) {
        return (Company)this.getById(cid);
    }

    public void settingCompanyCollectList(List<CompanyCollectListVo> listData, CompanyCollectListEnum companyCollectListEnum, Date start, Date end) {
        if (listData != null && !listData.isEmpty()) {
            List industryCategoryList = this.sysParamService.getListByGroup("industrial_classification");
            for (CompanyCollectListVo data : listData) {
                if (CompanyCollectListEnum.EXPIRE.equals((Object)companyCollectListEnum)) {
                    Date now = DateUtils.StringToDate((String)DateUtils.getDate((Date)new Date()));
                    if (data.getJkjcDate() == null) {
                        data.setJkjcDateStr("/");
                    } else if (data.getJkjcDate().getTime() <= now.getTime()) {
                        data.setJkjcDateStr(DateUtils.formatDate((Date)data.getJkjcDate()));
                    } else {
                        data.setJkjcDateStr("/");
                    }
                    if (data.getHarmfactortestDate() == null) {
                        data.setHarmfactortestDateStr("/");
                    } else if (data.getHarmfactortestDate().getTime() <= now.getTime()) {
                        data.setHarmfactortestDateStr(DateUtils.formatDate((Date)data.getHarmfactortestDate()));
                    } else {
                        data.setHarmfactortestDateStr("/");
                    }
                    if (data.getLeadertrainDate() == null) {
                        data.setLeadertrainDateStr("/");
                    } else if (data.getLeadertrainDate().getTime() <= now.getTime()) {
                        data.setLeadertrainDateStr(DateUtils.formatDate((Date)data.getLeadertrainDate()));
                    } else {
                        data.setLeadertrainDateStr("/");
                    }
                    if (data.getManagertrainDate() == null) {
                        data.setManagertrainDateStr("/");
                    } else if (data.getManagertrainDate().getTime() <= now.getTime()) {
                        data.setManagertrainDateStr(DateUtils.formatDate((Date)data.getManagertrainDate()));
                    } else {
                        data.setManagertrainDateStr("/");
                    }
                    if (data.getRiskDate() == null) {
                        data.setRiskDateStr("/");
                    } else if (data.getRiskDate().getTime() <= now.getTime()) {
                        data.setRiskDateStr(DateUtils.formatDate((Date)data.getRiskDate()));
                    } else {
                        data.setRiskDateStr("/");
                    }
                } else if (CompanyCollectListEnum.EXPIRENEVER.equals((Object)companyCollectListEnum)) {
                    if (data.getJkjcDate() == null) {
                        data.setJkjcDateStr("\u4ece\u672a\u6267\u884c");
                    } else {
                        data.setJkjcDateStr("/");
                    }
                    if (data.getHarmfactortestDate() == null) {
                        data.setHarmfactortestDateStr("\u4ece\u672a\u6267\u884c");
                    } else {
                        data.setHarmfactortestDateStr("/");
                    }
                    if (data.getLeadertrainDate() == null) {
                        data.setLeadertrainDateStr("\u4ece\u672a\u6267\u884c");
                    } else {
                        data.setLeadertrainDateStr("/");
                    }
                    if (data.getManagertrainDate() == null) {
                        data.setManagertrainDateStr("\u4ece\u672a\u6267\u884c");
                    } else {
                        data.setManagertrainDateStr("/");
                    }
                    if (data.getRiskDate() == null) {
                        data.setRiskDateStr("\u4ece\u672a\u6267\u884c");
                    } else {
                        data.setRiskDateStr("/");
                    }
                } else {
                    if (data.getJkjcDate() == null) {
                        data.setJkjcDateStr("/");
                    } else if (start.getTime() < data.getJkjcDate().getTime() && data.getJkjcDate().getTime() <= end.getTime()) {
                        data.setJkjcDateStr(DateUtils.formatDate((Date)data.getJkjcDate()));
                    } else {
                        data.setJkjcDateStr("/");
                    }
                    if (data.getHarmfactortestDate() == null) {
                        data.setHarmfactortestDateStr("/");
                    } else if (start.getTime() < data.getHarmfactortestDate().getTime() && data.getHarmfactortestDate().getTime() <= end.getTime()) {
                        data.setHarmfactortestDateStr(DateUtils.formatDate((Date)data.getHarmfactortestDate()));
                    } else {
                        data.setHarmfactortestDateStr("/");
                    }
                    if (data.getLeadertrainDate() == null) {
                        data.setLeadertrainDateStr("/");
                    } else if (start.getTime() < data.getLeadertrainDate().getTime() && data.getLeadertrainDate().getTime() <= end.getTime()) {
                        data.setLeadertrainDateStr(DateUtils.formatDate((Date)data.getLeadertrainDate()));
                    } else {
                        data.setLeadertrainDateStr("/");
                    }
                    if (data.getManagertrainDate() == null) {
                        data.setManagertrainDateStr("/");
                    } else if (start.getTime() < data.getManagertrainDate().getTime() && data.getManagertrainDate().getTime() <= end.getTime()) {
                        data.setManagertrainDateStr(DateUtils.formatDate((Date)data.getManagertrainDate()));
                    } else {
                        data.setManagertrainDateStr("/");
                    }
                    if (data.getRiskDate() == null) {
                        data.setRiskDateStr("/");
                    } else if (start.getTime() < data.getRiskDate().getTime() && data.getRiskDate().getTime() <= end.getTime()) {
                        data.setRiskDateStr(DateUtils.formatDate((Date)data.getRiskDate()));
                    } else {
                        data.setRiskDateStr("/");
                    }
                }
                Company c = (Company)this.getById(data.getCid());
                if (c != null) {
                    data.setCname(c.getName());
                    data.setAreaName(this.sysAreaService.getFullName(c.getAreaId(), ">"));
                    if (c.getIndustryCategory() != null) {
                        for (SysParam s : industryCategoryList) {
                            if (!s.getId().equals(c.getIndustryCategory())) continue;
                            data.setIndustryCategoryName(s.getParamCode() + "-" + s.getParamValue());
                        }
                    }
                }
                data.setId(data.getCid());
            }
        }
    }

    @Transactional(readOnly=false)
    public Company saveCompany(Company c, String directorName, String companyContactTel) {
        if (c != null && c.getId() != null) {
            Company dbcompany = (Company)this.companyMapper.selectByPrimaryKey(c.getId());
            if (dbcompany != null) {
                dbcompany.setName(c.getName());
                dbcompany.setAreaId(c.getAreaId());
                dbcompany.setIndustryCategory(c.getIndustryCategory());
                dbcompany.setCompanyContactTel(c.getCompanyContactTel());
                dbcompany.setRegisterAddress(c.getRegisterAddress());
                dbcompany.setWorkAddress(c.getWorkAddress());
                dbcompany.setUnifiedSocialCc(c.getUnifiedSocialCc());
                dbcompany.setRegisterType(c.getRegisterType());
                dbcompany.setScale(c.getScale());
                dbcompany.setLegalName(c.getLegalName());
                dbcompany.setLegalTel(c.getLegalTel());
                this.companyMapper.updateByPrimaryKey(dbcompany);
            }
            this.companyFunOrgService.updateCompanyFunOrgDirectorInfo(directorName, companyContactTel, c.getId());
        }
        return c;
    }

    @Transactional(readOnly=true)
    public List<Company> listCompanyByName(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            Example e = new Example(Company.class);
            e.createCriteria().andEqualTo("name", (Object)name).andEqualTo("isValid", (Object)true);
            return this.companyMapper.selectByExample(e);
        }
        return Collections.emptyList();
    }

    @Transactional(readOnly=false)
    public void delCompanyByIds(String ids) {
        String[] strings;
        List idList;
        if (StringUtils.isNotEmpty((String)ids) && CommonUtil.listIsNotEmpty(idList = Arrays.stream(strings = StringUtils.splitByWholeSeparator((String)ids, (String)",")).filter(s -> StringUtils.isNumber((String)s)).map(s -> {
            s = s.trim();
            return Long.parseLong(s);
        }).collect(Collectors.toList()))) {
            Example e = new Example(Company.class);
            e.createCriteria().andIn("id", idList);
            Company result = new Company();
            result.setUpdateDate(new Date());
            this.companyMapper.updateByExampleSelective(result, e);
        }
    }

    public List<Map<String, Object>> countCompanyGroupNumByHarmType(Long areaId) {
        List<Map<String, Object>> majorIndu = this.companyBaseMapper.countCompanyGroupNumByHarmType(areaId);
        return majorIndu;
    }

    public List<CompanyIndusInfoCount> collectCompanyMajorInduGroup(Long areaId) {
        List<CompanyIndusInfoCount> majorIndu = this.companyBaseMapper.collectCompanyMajorInduGroup(areaId);
        return majorIndu;
    }

    public CompanyMajorInduCollectModel collectCompanyMajorIndu(Long areaId, Integer belongType) {
        List<Map<String, Object>> majorIndu = this.companyBaseMapper.collectCompanyMajorIndu(areaId, belongType);
        CompanyMajorInduCollectModel result = new CompanyMajorInduCollectModel();
        if (CommonUtil.listIsNotEmpty(majorIndu)) {
            for (Map<String, Object> stringIntegerMap : majorIndu) {
                Integer type = (Integer)stringIntegerMap.get("important_type");
                Long count = (Long)stringIntegerMap.get("induCount");
                if (type.equals(ImportantIndustryTypeEnum.mine.getCodeVal())) {
                    result.setMine(result.getMine() + count);
                }
                if (type.equals(ImportantIndustryTypeEnum.building.getCodeVal())) {
                    result.setBuild(result.getBuild() + count);
                }
                if (type.equals(ImportantIndustryTypeEnum.chemical.getCodeVal())) {
                    result.setChemical(result.getChemical() + count);
                }
                if (!type.equals(ImportantIndustryTypeEnum.metallurgy.getCodeVal())) continue;
                result.setMetallurgy(result.getMetallurgy() + count);
            }
            result.setTotal(result.getMine() + result.getBuild() + result.getChemical() + result.getMetallurgy());
        }
        return result;
    }

    public int countCompanyNumByAreaId(Long areaId, Byte levle, Byte isOwnLevel) {
        if (areaId == null) {
            return 0;
        }
        CompanySearchVo search = new CompanySearchVo();
        search.setAreaId(areaId);
        search.setOrgAreaId(areaId);
        search.setOrgAreaLevel(levle);
        return this.companyBaseMapper.countCompanyNum(search, isOwnLevel);
    }

    public CompanyHarmCollectModel countCompanyHarm(Long areaId, Integer belongType) {
        List<Map<String, Object>> harmTypeCompany = this.companyBaseMapper.countCompanyNumByHarmType(areaId, belongType);
        CompanyHarmCollectModel result = new CompanyHarmCollectModel();
        if (CommonUtil.listIsNotEmpty(harmTypeCompany)) {
            for (Map<String, Object> stringIntegerMap : harmTypeCompany) {
                Long type = (Long)stringIntegerMap.get("harm_type");
                Long count = (Long)stringIntegerMap.get("cidNum");
                if (type.equals(1L)) {
                    result.setChenx(result.getChenx() + count);
                }
                if (type.equals(2L)) {
                    result.setMeix(result.getMeix() + count);
                }
                if (type.equals(3L)) {
                    result.setSlfc(result.getSlfc() + count);
                }
                if (type.equals(4L)) {
                    result.setShimc(result.getShimc() + count);
                }
                if (type.equals(5L)) {
                    result.setBen(result.getBen() + count);
                }
                if (type.equals(6L)) {
                    result.setQian(result.getQian() + count);
                }
                if (!type.equals(7L)) continue;
                result.setZaos(result.getZaos() + count);
            }
            int harmTotal = this.companyBaseMapper.countCompanyNumByHarm(areaId);
            result.setTotal((long)harmTotal);
        }
        return result;
    }

    public PageInfo<CompanySuperviseModel> pageCompanyByBest(JqGridParam param, Long areaId, Boolean isBest) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanySuperviseModel> companyList = this.companyBaseMapper.listCompanyByBest(areaId, isBest);
        PageInfo page = new PageInfo(companyList);
        return page;
    }

    public int countStaffNum(Long areaId) {
        return this.companyBaseMapper.countStaffNum(areaId);
    }

    public int countCompanyNumByEvaluate1(Long areaId, Date startDate, Date endDate) {
        return this.companyBaseMapper.countCompanyNumByEvaluate1(areaId, startDate, endDate);
    }

    public int countOverdueEvaluate1(Long areaId) {
        Date startDate = DateUtils.addYear((Date)new Date(), (int)-3);
        startDate = DateUtils.StringToDate((String)DateUtils.getDate((Date)startDate));
        Date endDate = DateUtils.addDay((Date)new Date(), (int)1);
        endDate = DateUtils.StringToDate((String)DateUtils.getDate((Date)endDate));
        return this.companyBaseMapper.countCompanyNumByEvaluate1(areaId, startDate, endDate);
    }

    public int countThreeMonthSoonEvaluate1(Long areaId) {
        Date startDate = DateUtils.addDay((Date)new Date(), (int)-30);
        startDate = DateUtils.StringToDate((String)DateUtils.getDate((Date)startDate));
        Date endDate = DateUtils.addDay((Date)new Date(), (int)1);
        endDate = DateUtils.StringToDate((String)DateUtils.getDate((Date)endDate));
        return this.companyBaseMapper.countCompanyNumByEvaluate1(areaId, startDate, endDate);
    }

    public int countCompanyByIndusties(Long areaId, Byte areaLevel, String industies) {
        return this.companyBaseMapper.countCompanyByIndusties(areaId, areaLevel, industies);
    }

    public int countCompanyByHarmIds(Long areaId, Byte areaLevel, String harmIds) {
        return this.companyBaseMapper.countCompanyByHarmIds(areaId, areaLevel, harmIds);
    }

    public List<Long> getCidByArea(Long areaId, Byte areaLevel) {
        return this.companyBaseMapper.getCidByArea(areaId, areaLevel);
    }

    public List<Long> getCidByIndustry(List<Long> industryIds) {
        if (industryIds == null || industryIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.companyBaseMapper.getCidByIndustry(industryIds);
    }

    public List<Long> getCidByScale(String scale) {
        return this.companyBaseMapper.getCidByScale(scale);
    }

    public List<TrainCompanyModel> getTrainCompanyList(CompanySuperviseSearchModel searchVo, List<Long> cidList) {
        searchVo.setNameEncrypt(searchVo.getName());
        return this.companyMapper.getTrainCompanyList(searchVo, cidList);
    }

    public List<TrainCompanyModel> getOnlineTrainCompanyList(CompanySuperviseSearchModel searchVo) {
        return this.companyMapper.getOnlineTrainCompanyList(searchVo);
    }

    public int countCompanyNumByAreaId2(Long areaId, Byte levle, Byte isOwnLevel) {
        CompanySearchVo search = new CompanySearchVo();
        search.setAreaId(areaId);
        search.setOrgAreaId(areaId);
        search.setOrgAreaLevel(levle);
        return this.companyBaseMapper.countCompanyNum2(search, isOwnLevel);
    }

    public List<Company> listPage(Integer start, Integer size) {
        return this.companyMapper.listPage(start, size);
    }

    public int countCompanyTotalNum() {
        return this.companyMapper.countCompanyTotalNum();
    }
}

