/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.supervise.dao.company.SuperviseHomeCompanyMapper;
import cn.smarthse.modules.health.supervise.service.company.ISuperviseHomeCompanyService;
import cn.smarthse.modules.health.supervise.service.staff.ISuperviseStaffInfoService;
import cn.smarthse.modules.health.supervise.service.sys.ISysParamService;
import cn.smarthse.modules.health.supervise.vo.company.CompanyDutyItem;
import cn.smarthse.modules.health.supervise.vo.company.SuperviseHomeCompanyVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SuperviseHomeCompanyServiceImpl
extends BaseServiceImpl<SuperviseHomeCompanyMapper, Company>
implements ISuperviseHomeCompanyService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @Autowired
    @Qualifier(value="sysParamServiceImpl")
    private ISysParamService paramService;
    @Autowired
    private ISuperviseStaffInfoService superviseStaffInfoService;
    @DubboReference
    private ICheckPlanService checkPlanService;

    private List<SuperviseHomeCompanyVo> convertCompanyVo(List<SuperviseHomeCompanyVo> superviseHomeCompanyVos) {
        if (CollectionUtils.isNotEmpty(superviseHomeCompanyVos)) {
            for (SuperviseHomeCompanyVo companyInfo : superviseHomeCompanyVos) {
                Integer businessState;
                Long areaId = companyInfo.getAreaId();
                String areaName = this.areaService.getFullName(areaId, ">");
                companyInfo.setAreaName(areaName);
                if (companyInfo.getIndustryCategory() != null && companyInfo.getIndustryCategory() > 0L) {
                    String industryCategory = this.paramService.getParamValue(companyInfo.getIndustryCategory());
                    companyInfo.setIndustryCategoryName(industryCategory);
                }
                if (companyInfo.getRegisterType() != null && companyInfo.getRegisterType() > 0L) {
                    String registerType = this.paramService.getParamValue(companyInfo.getRegisterType());
                    companyInfo.setRegisterTypeName(registerType);
                }
                if (companyInfo.getOccupationalRiskClassify() != null) {
                    if (companyInfo.getOccupationalRiskClassify() == 0) {
                        companyInfo.setOccupationalRiskClassifyName("\u4e25\u91cd");
                    } else if (companyInfo.getOccupationalRiskClassify() == 1) {
                        companyInfo.setOccupationalRiskClassifyName("\u8f83\u91cd");
                    } else if (companyInfo.getOccupationalRiskClassify() == 2) {
                        companyInfo.setOccupationalRiskClassifyName("\u4e00\u822c");
                    }
                }
                if (StringUtils.isNotEmpty((String)companyInfo.getScale()) && NumberUtil.isNumber((String)companyInfo.getScale())) {
                    Integer scale = NumberUtil.toInt((String)companyInfo.getScale());
                    if (scale == -1) {
                        companyInfo.setScaleName("\u5176\u4ed6");
                    } else {
                        String scaleName = CompanySizeEnum.getName((Integer)scale);
                        companyInfo.setScaleName(scaleName);
                    }
                }
                if ((businessState = companyInfo.getBusinessState()) != null) {
                    String businessStatename = CompanyBusinessState.getName((Integer)businessState);
                    companyInfo.setBusinessStateName(businessStatename);
                }
                if (companyInfo.getIsBest() != null) {
                    if (companyInfo.getIsBest().booleanValue()) {
                        companyInfo.setIsBestStr("\u662f");
                    } else {
                        companyInfo.setIsBestStr("\u5426");
                    }
                }
                if (companyInfo.getGovern() != null) {
                    if (companyInfo.getGovern().booleanValue()) {
                        companyInfo.setGovernStr("\u662f");
                    } else {
                        companyInfo.setGovernStr("\u5426");
                    }
                }
                if (companyInfo.getGrade() != null) {
                    if (companyInfo.getGrade().intValue() == 1) {
                        companyInfo.setGradeStr("\u7532\u7c7b");
                    } else if (companyInfo.getGrade().intValue() == 3) {
                        companyInfo.setGradeStr("\u4e59\u7c7b");
                    } else if (companyInfo.getGrade().intValue() == 2) {
                        companyInfo.setGradeStr("\u4e19\u7c7b");
                    }
                }
                int jhrs = this.superviseStaffInfoService.getSuperviseStaffInfoCountByCids(Arrays.asList(companyInfo.getId()));
                companyInfo.setJhrs(Integer.valueOf(jhrs));
            }
        }
        return superviseHomeCompanyVos;
    }

    public List<SuperviseHomeCompanyVo> listSuperviseHomeCompanyIndu(CompanySuperviseSearchModel searchVo) {
        if (searchVo.getIndustrs() == null) {
            return null;
        }
        if (searchVo.getSearchType() == 2) {
            LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
            LocalDateTime end = LocalDateTime.now();
            List cids = this.checkPlanService.getCidList(searchVo.getAreaId(), searchVo.getAreaLevel(), start, end);
            searchVo.setIncludeCds(cids);
        }
        List<SuperviseHomeCompanyVo> superviseHomeCompanyVos = ((SuperviseHomeCompanyMapper)this.dao).listSuperviseHomeCompanyIndu(searchVo);
        return this.convertCompanyVo(superviseHomeCompanyVos);
    }

    public PageInfo<SuperviseHomeCompanyVo> pageSuperviseHomeCompanyIndu(JqGridParam param, CompanySuperviseSearchModel searchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SuperviseHomeCompanyVo> companyList = this.listSuperviseHomeCompanyIndu(searchVo);
        PageInfo page = new PageInfo(companyList);
        return page;
    }

    public List<SuperviseHomeCompanyVo> listSuperviseHomeCompanyHarm(CompanySuperviseSearchModel searchVo) {
        if (searchVo.getHarmIds() == null) {
            return null;
        }
        ArrayList<Long> harmIds = new ArrayList<Long>();
        for (String s : searchVo.getHarmIds().split(",")) {
            harmIds.add(Long.parseLong(s));
        }
        List cids = this.checkPlanService.getCidListByFactorAndArea(searchVo.getAreaId(), searchVo.getAreaLevel(), Integer.valueOf(DateUtil.getYear()), harmIds);
        searchVo.setIncludeCds(cids);
        if (searchVo.getSearchType() == 2) {
            LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
            LocalDateTime end = LocalDateTime.now();
            List checkcids = this.checkPlanService.getCidList(searchVo.getAreaId(), searchVo.getAreaLevel(), start, end);
            searchVo.setCheckCidList(checkcids);
        }
        List<SuperviseHomeCompanyVo> superviseHomeCompanyVos = ((SuperviseHomeCompanyMapper)this.dao).listSuperviseHomeCompanyHarm(searchVo);
        return this.convertCompanyVo(superviseHomeCompanyVos);
    }

    public PageInfo<SuperviseHomeCompanyVo> pageSuperviseHomeCompanyHarm(JqGridParam param, CompanySuperviseSearchModel searchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SuperviseHomeCompanyVo> companyList = this.listSuperviseHomeCompanyHarm(searchVo);
        PageInfo page = new PageInfo(companyList);
        return page;
    }

    public List<Long> getHaveProjectInAreaOrgIds(Long areaId, Byte level) {
        if (areaId == null) {
            return null;
        }
        List<Long> orgids = ((SuperviseHomeCompanyMapper)this.dao).getHaveProjectInAreaOrgIds(areaId, level);
        Long[] checkOrdIds = this.checkPlanService.getOrgIdByArea(areaId, level, null);
        orgids.addAll(Arrays.asList(checkOrdIds));
        return orgids;
    }

    public CompanyDutyItem getOrgAndEmpInfo(Long areaId, Byte level, List<Long> keyIndustryIds, Integer scale) {
        List<CompanyReportInfo> list = ((SuperviseHomeCompanyMapper)this.dao).getOrgAndEmpInfo(areaId, level, keyIndustryIds, scale);
        CompanyDutyItem item = new CompanyDutyItem();
        int hasOrgCompanyNum = 0;
        int hasEmpCompanyNum = 0;
        for (CompanyReportInfo info : list) {
            if (Objects.isNull(info)) continue;
            if (!(info.getManageMajorStaffCount() == null && info.getManagePluralityStaffCount() == null || info.getManageMajorStaffCount() <= 0L && info.getManagePluralityStaffCount() <= 0L)) {
                ++hasEmpCompanyNum;
            }
            if (!"1".equals(info.getManageOrg())) continue;
            ++hasOrgCompanyNum;
        }
        item.setHasEmpCompanyNum(Integer.valueOf(hasEmpCompanyNum));
        item.setHasOrgCompanyNum(Integer.valueOf(hasOrgCompanyNum));
        return item;
    }
}

