/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.dao.company.HomeCountCompanyMapper;
import cn.smarthse.modules.health.supervise.service.company.IHomeCountCompanyService;
import cn.smarthse.modules.health.supervise.service.staff.ISuperviseStaffInfoService;
import cn.smarthse.modules.health.supervise.service.sys.ISysParamService;
import cn.smarthse.modules.health.supervise.vo.company.SuperviseHomeCompanyVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class HomeCountCompanyServiceImpl
implements IHomeCountCompanyService {
    @Autowired
    private HomeCountCompanyMapper homeCountCompanyMapper;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @Autowired
    @Qualifier(value="sysParamServiceImpl")
    private ISysParamService paramService;
    @Autowired
    private ISuperviseStaffInfoService superviseStaffInfoService;
    @DubboReference
    private ICheckPlanService checkPlanService;

    public PageInfo<SuperviseHomeCompanyVo> getKeyWorkCompList(JqGridParam jqGridParam, CompanySuperviseSearchModel companySearchVo) {
        if (companySearchVo == null) {
            companySearchVo = new CompanySuperviseSearchModel();
        }
        if (companySearchVo.getSearchType() == 2) {
            if (companySearchVo.getBeginTime() != null) {
                cids = this.checkPlanService.getCidList(companySearchVo.getAreaId(), companySearchVo.getAreaLevel(), DateUtil.getFromDate((Date)companySearchVo.getBeginTime()), DateUtil.getFromDate((Date)companySearchVo.getEndTime()));
                companySearchVo.setIncludeCds(cids);
            } else {
                cids = this.checkPlanService.getCidList(companySearchVo.getAreaId(), companySearchVo.getAreaLevel(), null, null);
                companySearchVo.setIncludeCds(cids);
            }
        }
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<SuperviseHomeCompanyVo> companyList = this.homeCountCompanyMapper.getKeyWorkCompList(companySearchVo);
        PageInfo page = new PageInfo(this.convertCompanyVo(companyList));
        return page;
    }

    public List<SuperviseHomeCompanyVo> getKeyWorkCompListExport(CompanySuperviseSearchModel companySearchVo) {
        if (companySearchVo == null) {
            companySearchVo = new CompanySuperviseSearchModel();
        }
        if (companySearchVo.getSearchType() == 2) {
            List cids = this.checkPlanService.getCidList(companySearchVo.getAreaId(), companySearchVo.getAreaLevel(), DateUtil.getFromDate((Date)companySearchVo.getBeginTime()), DateUtil.getFromDate((Date)companySearchVo.getEndTime()));
            companySearchVo.setIncludeCds(cids);
        }
        List<SuperviseHomeCompanyVo> companyList = this.homeCountCompanyMapper.getKeyWorkCompList(companySearchVo);
        return this.convertCompanyVo(companyList);
    }

    private List<SuperviseHomeCompanyVo> convertCompanyVo(List<SuperviseHomeCompanyVo> superviseHomeCompanyVos) {
        if (CollectionUtils.isNotEmpty(superviseHomeCompanyVos)) {
            for (SuperviseHomeCompanyVo companyInfo : superviseHomeCompanyVos) {
                Integer businessState;
                Long areaId = companyInfo.getAreaId();
                String areaName = this.areaService.getFullName(areaId, ">");
                companyInfo.setAreaName(areaName);
                if (companyInfo.getIndustryCategory() != null && companyInfo.getIndustryCategory() > 0L) {
                    String industryCategory = this.paramService.getParamValue(companyInfo.getIndustryCategory());
                    companyInfo.setIndustryCategoryName(industryCategory);
                }
                if (companyInfo.getRegisterType() != null && companyInfo.getRegisterType() > 0L) {
                    String registerType = this.paramService.getParamValue(companyInfo.getRegisterType());
                    companyInfo.setRegisterTypeName(registerType);
                }
                if (companyInfo.getOccupationalRiskClassify() != null) {
                    if (companyInfo.getOccupationalRiskClassify() == 0) {
                        companyInfo.setOccupationalRiskClassifyName("\u4e25\u91cd");
                    } else if (companyInfo.getOccupationalRiskClassify() == 1) {
                        companyInfo.setOccupationalRiskClassifyName("\u8f83\u91cd");
                    } else if (companyInfo.getOccupationalRiskClassify() == 2) {
                        companyInfo.setOccupationalRiskClassifyName("\u4e00\u822c");
                    }
                }
                if (StringUtils.isNotEmpty((String)companyInfo.getScale()) && NumberUtil.isNumber((String)companyInfo.getScale())) {
                    Integer scale = NumberUtil.toInt((String)companyInfo.getScale());
                    if (scale == -1) {
                        companyInfo.setScaleName("\u5176\u4ed6");
                    } else {
                        String scaleName = CompanySizeEnum.getName((Integer)scale);
                        companyInfo.setScaleName(scaleName);
                    }
                }
                if ((businessState = companyInfo.getBusinessState()) != null) {
                    String businessStatename = CompanyBusinessState.getName((Integer)businessState);
                    companyInfo.setBusinessStateName(businessStatename);
                }
                int jhrs = this.superviseStaffInfoService.getSuperviseStaffInfoCountByCids(Arrays.asList(companyInfo.getId()));
                companyInfo.setJhrs(Integer.valueOf(jhrs));
                if (companyInfo.getIsBest() != null) {
                    if (companyInfo.getIsBest().booleanValue()) {
                        companyInfo.setIsBestStr("\u662f");
                    } else {
                        companyInfo.setIsBestStr("\u5426");
                    }
                }
                if (companyInfo.getGovern() != null) {
                    if (companyInfo.getGovern().booleanValue()) {
                        companyInfo.setGovernStr("\u662f");
                    } else {
                        companyInfo.setGovernStr("\u5426");
                    }
                }
                if (companyInfo.getGrade() == null) continue;
                if (companyInfo.getGrade().intValue() == 1) {
                    companyInfo.setGradeStr("\u7532\u7c7b");
                    continue;
                }
                if (companyInfo.getGrade().intValue() == 3) {
                    companyInfo.setGradeStr("\u4e59\u7c7b");
                    continue;
                }
                if (companyInfo.getGrade().intValue() != 2) continue;
                companyInfo.setGradeStr("\u4e19\u7c7b");
            }
        }
        return superviseHomeCompanyVos;
    }
}

