/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.CreditCodeUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.dy.dy.provider.IDyCompanyProviderService;
import cn.smarthse.modules.busilog.RecordOperationLog;
import cn.smarthse.modules.busilog.RecordOperationTypeEnum;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyDelReasonEnum;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.companyoutpack.CompanyOutpackSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyBaseChangeInfo;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.WaitSureCompanySearchModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ICompanyStorageProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.provider.ICompanyChangeV3ProviderService;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.dataservice.service.ICompanyBaseDcInfoService;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceAccordingTypeEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.supervise.dao.company.CompanyDcMapper;
import cn.smarthse.modules.health.supervise.dao.company.CompanyMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.enums.company.grade.OccTypeChangeEvent;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeVictimsIdentifyEnum;
import cn.smarthse.modules.health.supervise.model.CreateUserModel;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeReceivingUnitVo;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.companyoutpack.ICompanyOutpackService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.health.supervise.vo.company.CompanyTrainVo;
import cn.smarthse.modules.health.supervise.vo.company.SimpleCollectVo;
import cn.smarthse.modules.health.supervise.vo.statistics.CloseAndPauseCompanySearchVo;
import cn.smarthse.modules.health.supervise.vo.statistics.CompanyBaseChangeSearchVo;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3AddParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3BestParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3EditParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3ListParam;
import cn.smarthse.modules.health.supervise.vo.v3.company.CompanyUserV3ListVo;
import cn.smarthse.modules.health.vo.base.company.companyCountState;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.services.hfi.api.model.grade.CompanyRiskInduOccTypeVo;
import cn.smarthse.services.wanda.api.entity.irs.IrsMarketEntities;
import com.alibaba.dubbo.rpc.RpcContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class DcCompanyServiceImpl
extends BaseServiceImpl<CompanyMapper, Company>
implements IDcCompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DcCompanyServiceImpl.class);
    @Qualifier(value="threadPoolTaskExecutorToCompanyChange")
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolExecutor;
    @Autowired
    private CompanyDcMapper companyDcMapper;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IOrganizationService organizationService;
    @DubboReference
    private IOrganizationUserService organizationUserService;
    @Autowired
    private ICompanyOutpackService outpackService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private ISysUserThirdService sysUserThirdService;
    @Autowired
    private ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    @Autowired
    private ICompanyChangeV3ProviderService companyChangeV3ProviderService;
    @DubboReference
    private ICompanyHsePreventionControlSelfJudgeService companyHsePreventionControlSelfJudgeService;
    @Autowired
    private ICompanyGradeV3RefreshService companyGradeV3RefreshService;
    @DubboReference
    private ISysFileProvideService sysFileService;
    @DubboReference(version="1.0.0")
    private ICompanyStorageProvideService companyStorageProvideService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @DubboReference
    private IDyCompanyProviderService dyCompanyProviderService;
    @DubboReference
    private ICompanyBaseDcInfoService companyBaseDcInfoService;
    private final AreaModel protoArea = new AreaModel();
    private final Organization protoOrg = new Organization();
    private final SysParamModel protoSysParam = new SysParamModel();
    List<byte[]> memoryList = new ArrayList<byte[]>();

    public void setSearchVo(CompanySuperviseSearchModel companySearchVo) {
        AreaModel areaModel;
        SysParamModel sysParamIndustryCategory;
        Organization organization;
        Page localPage = PageHelper.getLocalPage();
        int pageNum = 0;
        int pageSize = 0;
        if (localPage != null) {
            pageNum = localPage.getPageNum();
            pageSize = localPage.getPageSize();
            localPage.clear();
        }
        if (companySearchVo.getSupervisionUnit() != null && (organization = this.organizationService.getOrgById(companySearchVo.getSupervisionUnit())) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                companySearchVo.setBelongType(Integer.valueOf(level));
            } else {
                companySearchVo.setBelongType(Integer.valueOf(0));
            }
        }
        if (companySearchVo == null) {
            companySearchVo = new CompanySuperviseSearchModel();
        }
        if (companySearchVo.getAreaId() == null) {
            companySearchVo.setAreaId(companySearchVo.getOrgAreaId());
        }
        if (companySearchVo.getIndustryCategory() != null && (sysParamIndustryCategory = this.sysParamProvideService.getById(companySearchVo.getIndustryCategory())) != null) {
            companySearchVo.setIndustryCategoryCode(sysParamIndustryCategory.getParamCode());
            companySearchVo.setIndustryCategory(null);
        }
        if (companySearchVo.getAreaId() != null && companySearchVo.getAreaLevel() == null && (areaModel = this.sysAreaProvideService.getAreaById(companySearchVo.getAreaId())) != null) {
            companySearchVo.setAreaLevel(areaModel.getLevel());
        }
        if (localPage != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize, (boolean)false);
        }
    }

    public Map<String, Long> countState(CompanySuperviseSearchModel companySearchVo) {
        this.setSearchVo(companySearchVo);
        HashMap<String, Long> stringLongMap = new HashMap<String, Long>();
        companyCountState companyCountState2 = this.companyDcMapper.countState(companySearchVo);
        stringLongMap.put("normalCount", companyCountState2 == null ? 0L : companyCountState2.getNormalCount());
        stringLongMap.put("suspendedCount", companyCountState2 == null ? 0L : companyCountState2.getSuspendedCount());
        stringLongMap.put("closeCount", companyCountState2 == null ? 0L : companyCountState2.getCloseCount());
        return stringLongMap;
    }

    public PageInfo<CompanyBaseChangeInfo> companybaseChangeListData(JqGridParam param, CompanyBaseChangeSearchVo searchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)false);
        List<CompanyBaseChangeInfo> companyBaseChangeInfos = this.companyDcMapper.companybaseChangeListData(searchVo);
        this.settingData(companyBaseChangeInfos);
        return new PageInfo(companyBaseChangeInfos);
    }

    public List<CompanyBaseChangeInfo> companybaseChangeListDataCount(CompanyBaseChangeSearchVo searchVo) {
        return this.companyDcMapper.companybaseChangeListDataCount(searchVo);
    }

    private void settingData(List<CompanyBaseChangeInfo> companyBaseChangeInfos) {
        if (CollUtil.isNotEmpty(companyBaseChangeInfos)) {
            List areaModelList;
            List allAreaIdList = Stream.concat(companyBaseChangeInfos.stream().filter(f -> Objects.equals(f.getChangeType(), CompanyBaseChangeTypeEnum.AREA_CHANGE.getValue())).flatMap(m -> Stream.of(m.getBeforeValue(), m.getAfterValue()).filter(Objects::nonNull).map(strVal -> strVal.isEmpty() ? null : Long.valueOf(strVal))), companyBaseChangeInfos.stream().map(CompanyBaseChangeInfo::getDetailAreaId)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> areaModelMap = new HashMap();
            if (CollUtil.isNotEmpty(allAreaIdList) && CollectionUtils.isNotEmpty((Collection)(areaModelList = this.sysAreaProvideService.getAreaListByIds(StringUtils.join(allAreaIdList, (String)","))))) {
                areaModelMap = areaModelList.stream().collect(Collectors.toMap(AreaModel::getId, v -> v));
            }
            for (CompanyBaseChangeInfo companyBaseChangeInfo : companyBaseChangeInfos) {
                companyBaseChangeInfo.setAreaDetailName(areaModelMap.getOrDefault(companyBaseChangeInfo.getDetailAreaId(), this.protoArea).getFullname(">"));
                Integer type = companyBaseChangeInfo.getChangeType();
                String beforeValue = companyBaseChangeInfo.getBeforeValue();
                String beforeValue2 = companyBaseChangeInfo.getBeforeValue2();
                String afterValue = companyBaseChangeInfo.getAfterValue();
                if (Objects.equals(type, CompanyBaseChangeTypeEnum.AREA_CHANGE.getValue())) {
                    if (StrUtil.isBlank((CharSequence)beforeValue)) {
                        companyBaseChangeInfo.setBeforeValueText("\u7a7a");
                    } else {
                        AreaModel beforeArea = (AreaModel)areaModelMap.get(Long.valueOf(beforeValue));
                        if (beforeArea != null) {
                            companyBaseChangeInfo.setBeforeValueText(beforeArea.getFullname());
                        } else {
                            companyBaseChangeInfo.setBeforeValueText("\u65e0\u6548\u533a\u57df\u503c" + beforeValue);
                        }
                    }
                    if (StrUtil.isBlank((CharSequence)afterValue)) {
                        companyBaseChangeInfo.setAfterValueText("\u7a7a");
                        continue;
                    }
                    AreaModel afterArea = (AreaModel)areaModelMap.get(Long.valueOf(afterValue));
                    if (afterArea != null) {
                        companyBaseChangeInfo.setAfterValueText(afterArea.getFullname());
                        continue;
                    }
                    companyBaseChangeInfo.setAfterValueText("\u65e0\u6548\u533a\u57df\u503c" + afterValue);
                    continue;
                }
                if (Objects.equals(type, CompanyBaseChangeTypeEnum.BUSINESS_STATE_CHANGE.getValue())) {
                    if (CharSequenceUtil.isNotBlank((CharSequence)beforeValue)) {
                        companyBaseChangeInfo.setBeforeValueText(CompanyBusinessState.getName((Integer)Integer.valueOf(beforeValue)));
                    }
                    if (!CharSequenceUtil.isNotBlank((CharSequence)afterValue)) continue;
                    companyBaseChangeInfo.setAfterValueText(CompanyBusinessState.getName((Integer)Integer.valueOf(afterValue)));
                    continue;
                }
                if (Objects.equals(type, CompanyBaseChangeTypeEnum.PICKUPCOUNT.getValue())) {
                    companyBaseChangeInfo.setBeforeValueText(beforeValue);
                    companyBaseChangeInfo.setAfterValueText(afterValue);
                    continue;
                }
                if (Objects.equals(type, CompanyBaseChangeTypeEnum.PICKUPCOUNT_VICTIMS.getValue())) {
                    if (CharSequenceUtil.isNotBlank((CharSequence)beforeValue)) {
                        companyBaseChangeInfo.setBeforeValueText(CompanyChangeVictimsIdentifyEnum.getName((Integer)Integer.valueOf(beforeValue)));
                        if ("0".equals(beforeValue)) {
                            companyBaseChangeInfo.setBeforeValueText(companyBaseChangeInfo.getBeforeValueText() + "\uff08" + (StrUtil.isBlank((CharSequence)beforeValue2) ? "\u65e0\u6570\u636e" : beforeValue2) + "\uff09");
                        }
                    }
                    if (!CharSequenceUtil.isNotBlank((CharSequence)afterValue)) continue;
                    companyBaseChangeInfo.setAfterValueText(CompanyChangeVictimsIdentifyEnum.getName((Integer)Integer.valueOf(afterValue)));
                    continue;
                }
                companyBaseChangeInfo.setBeforeValueText(beforeValue);
                companyBaseChangeInfo.setAfterValueText(afterValue);
            }
        }
    }

    public List<Long> listCid(CompanySuperviseSearchModel companySearchVo) {
        return this.companyDcMapper.listCid(companySearchVo);
    }

    public List<CompanySuperviseModel> listCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo) {
        this.setSearchVo(companySearchVo);
        List<CompanySuperviseModel> companyList = null;
        companyList = companySearchVo.getChooseCompanyInfo() != null && companySearchVo.getChooseCompanyInfo() != false ? this.companyDcMapper.chooseCompanyInfo(companySearchVo) : this.companyDcMapper.listCompanyInfo(companySearchVo);
        this.judgeSystemIrsCompanyInfo(companyList);
        this.judgeCompanyOccupationalDiseaseInfo(companyList);
        this.settingCompanyGradeInfo(companyList);
        this.settingComplianceInfo(companyList);
        if (getBaseInfo) {
            this.fillParamValue(companyList);
        }
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (CompanySuperviseModel companySuperviseModel : companyList) {
                Integer gradeReason = companySuperviseModel.getGradeReason();
                String name = CompanyGradeReasonEnum.getName((Integer)gradeReason);
                companySuperviseModel.setGradeReasonName(name);
                this.setRiskResolveData(companySuperviseModel);
            }
        }
        return companyList;
    }

    private void setRiskResolveData(CompanySuperviseModel value) {
        if (value.getDeclare() == null) {
            return;
        }
        value.setDeclareState(value.getDeclare() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
        if (value.getDeclare().booleanValue() && value.getDeclareNum() == 0) {
            value.setDeclareState("\u6682\u65e0\u98ce\u9669");
            if (value.getDeclareCount() == 0) {
                value.setDeclareState("\u6682\u65e0\u7533\u62a5\u6570\u636e");
            }
        }
        value.setCheckRiskState(value.getCheck() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
        if (value.getCheck().booleanValue() && value.getCheckNum() == 0) {
            value.setCheckRiskState("\u6682\u65e0\u98ce\u9669");
        }
        value.setPhysicalExaminationState(value.getPhysicalExamination() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
        if (value.getPhysicalExamination().booleanValue() && value.getPhysicalExaminationNum() == 0) {
            value.setPhysicalExaminationState("\u6682\u65e0\u98ce\u9669");
        }
        value.setTrainingState(value.getTraining() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
        if (value.getTraining().booleanValue() && value.getTrainingNum() == 0) {
            value.setTrainingState("\u6682\u65e0\u98ce\u9669");
        }
        value.setThreeTimeState(value.getThreeSimultaneous() != false ? "\u5df2\u5316\u89e3[" + value.getThreeComplete() + "/" + value.getThreeAllComplete() + "]" : "\u672a\u5316\u89e3[" + value.getThreeComplete() + "/" + value.getThreeAllComplete() + "]");
        if (value.getThreeSimultaneous().booleanValue() && value.getThreeSimultaneousNum() == 0) {
            value.setThreeTimeState("\u6682\u65e0\u98ce\u9669");
        }
        value.setProtectEquipState(value.getProtectEquip() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
        if (value.getProtectEquip().booleanValue() && value.getProtectEquipNum() == 0) {
            value.setProtectEquipState("\u6682\u65e0\u98ce\u9669");
        }
        value.setWarnSignManageState(value.getWarnSignManage() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
        if (value.getWarnSignManage().booleanValue() && value.getWarnSignManageNum() == 0) {
            value.setWarnSignManageState("\u6682\u65e0\u98ce\u9669");
        }
        value.setHealthManageState(value.getHealthManageFiles() != false ? "\u5df2\u5316\u89e3[" + value.getHealthComplete() + "/6]" : "\u672a\u5316\u89e3[" + value.getHealthComplete() + "/6]");
        if (value.getHealthManageFiles().booleanValue() && value.getHealthManageFilesNum() == 0) {
            value.setHealthManageState("\u6682\u65e0\u98ce\u9669");
        }
        int total = 0;
        int unComplete = 0;
        total = value.getYszybNum() == null ? 0 : value.getYszybNum();
        unComplete = value.getYszybNoNum() == null ? 0 : value.getYszybNoNum();
        value.setYszybState(value.getYszyb() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
        if (value.getYszyb().booleanValue() && value.getYszybNum() == 0) {
            value.setYszybState("\u6682\u65e0\u98ce\u9669");
            if (value.getPhysicalCurCount() == 0) {
                value.setYszybState("\u6682\u65e0\u98ce\u9669");
            }
        }
        total = value.getJjzNum() == null ? 0 : value.getJjzNum();
        unComplete = value.getJjzNoNum() == null ? 0 : value.getJjzNoNum();
        value.setJjzState(value.getJjz() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
        if (value.getJjz().booleanValue() && value.getJjzNum() == 0) {
            value.setJjzState("\u6682\u65e0\u98ce\u9669");
            if (value.getPhysicalCurCount() == 0) {
                value.setJjzState("\u6682\u65e0\u98ce\u9669");
            }
        }
        total = value.getJccbNum() == null ? 0 : value.getJccbNum();
        unComplete = value.getJccbNoNum() == null ? 0 : value.getJccbNoNum();
        value.setJccbState(value.getJccb() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
        if (value.getJccb().booleanValue() && value.getJccbNum() == 0) {
            value.setJccbState("\u6682\u65e0\u98ce\u9669");
            if (value.getCheckCurCount() == 0) {
                value.setJccbState("\u6682\u65e0\u98ce\u9669");
            }
        }
        total = value.getPersonDoseNum() == null ? 0 : value.getPersonDoseNum();
        unComplete = value.getPersonDoseNoNum() == null ? 0 : value.getPersonDoseNoNum();
        value.setPersonDoseState(value.getPersonDose() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
        if (value.getPersonDose().booleanValue() && value.getPersonDoseNum() == 0) {
            if (Objects.equals(value.getCompanyRadioactivityType(), 7)) {
                value.setPersonDoseState("\u6682\u65e0\u98ce\u9669");
            } else {
                value.setPersonDoseState("-");
            }
        }
        total = value.getPersonDoseCbNum() == null ? 0 : value.getPersonDoseCbNum();
        unComplete = value.getPersonDoseCbNoNum() == null ? 0 : value.getPersonDoseCbNoNum();
        value.setPersonDoseCbState(value.getPersonDoseCb() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
        if (value.getPersonDoseCb().booleanValue() && value.getPersonDoseCbNum() == 0) {
            if (Objects.equals(value.getCompanyRadioactivityType(), 7)) {
                value.setPersonDoseCbState("\u6682\u65e0\u98ce\u9669");
            } else {
                value.setPersonDoseCbState("-");
            }
        }
    }

    private void settingCompanyGradeInfo(List<CompanySuperviseModel> companyList) {
        if (CollectionUtils.isNotEmpty(companyList)) {
            companyList.forEach(comInfo -> {
                Long riskId = comInfo.getRiskId();
                Long selfId = comInfo.getSelfId();
                Long evaluateId = comInfo.getEvaluateId();
                String stateStr = "(\u5f85\u5ba1\u6838)";
                if (Objects.equals(comInfo.getCheckState(), 1)) {
                    stateStr = "";
                }
                if (riskId == null) {
                    comInfo.setExposureRiskLevelName("\u672a\u63d0\u4ea4");
                } else {
                    comInfo.setExposureRiskLevelName(HazardsExposureRiskLevelEnum.getNameByCode((Integer)comInfo.getExposureRiskLevel()) + stateStr);
                }
                if (selfId == null) {
                    comInfo.setSelfJudgeLevelName("\u672a\u63d0\u4ea4");
                } else {
                    comInfo.setSelfJudgeLevelName(JudgeResultLevelEnum.getNameByCode((Integer)comInfo.getSelfJudgeLevel()) + stateStr);
                }
                if (comInfo.getGradeSource() == null || GradeSourceEnum.NOSOURCE.getCode().equals(comInfo.getGradeSource())) {
                    comInfo.setEvaluateLevelName("\u65e0\u6cd5\u5206\u7c7b");
                } else {
                    String gradeName = CompanyGradeEnum.getName((Byte)comInfo.getGrade());
                    if (evaluateId == null) {
                        comInfo.setEvaluateLevelName(gradeName + "(\u672a\u63d0\u4ea4)");
                    } else {
                        comInfo.setEvaluateLevelName(gradeName + stateStr);
                    }
                }
            });
        }
    }

    private void settingComplianceInfo(List<CompanySuperviseModel> companyList) {
        if (CollectionUtils.isNotEmpty(companyList)) {
            companyList.forEach(comInfo -> {
                comInfo.setComplianceStatusStr(NewComplianceInfoStatusEnum.getValue((Integer)comInfo.getComplianceStatus()));
                comInfo.setComplianceAccordingTypeStr(NewComplianceAccordingTypeEnum.getValue((Integer)comInfo.getComplianceAccordingType()));
            });
        }
    }

    public List<CompanySuperviseModel> exportCompanyInfo(CompanySuperviseSearchModel companySearchVo) {
        this.setSearchVo(companySearchVo);
        List<CompanySuperviseModel> companyList = Collections.synchronizedList(new ArrayList());
        List<Long> allCidList = this.companyDcMapper.listCid(companySearchVo);
        List partitionCidList = ListUtil.partition(allCidList, (int)10000);
        CompletableFuture[] futures2 = (CompletableFuture[])partitionCidList.stream().map(cidList -> CompletableFuture.supplyAsync(() -> {
            CompanySuperviseSearchModel detailDataSearchVo2 = new CompanySuperviseSearchModel();
            BeanUtils.copyProperties((Object)companySearchVo, (Object)detailDataSearchVo2);
            detailDataSearchVo2.setIncludeCds(cidList);
            detailDataSearchVo2.setStartCid((Long)cidList.get(0));
            detailDataSearchVo2.setIsExport(Integer.valueOf(1));
            detailDataSearchVo2.setEndCid((Long)cidList.get(cidList.size() - 1));
            List<CompanySuperviseModel> innerCompanyList = this.companyDcMapper.listCompanyInfo(detailDataSearchVo2);
            return innerCompanyList;
        }, (Executor)this.threadPoolExecutor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures2).join();
        try {
            for (CompletableFuture future : futures2) {
                List companySuperviseModels = (List)future.get();
                if (!CollectionUtils.isNotEmpty((Collection)companySuperviseModels)) continue;
                companyList.addAll(companySuperviseModels);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f01\u4e1a\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        this.fillParamValue(companyList);
        this.settingCompanyGradeInfo(companyList);
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (CompanySuperviseModel companySuperviseModel : companyList) {
                Integer gradeReason = companySuperviseModel.getGradeReason();
                String name = CompanyGradeReasonEnum.getName((Integer)gradeReason);
                companySuperviseModel.setGradeReasonName(name);
                this.setRiskResolveData(companySuperviseModel);
            }
        }
        return companyList;
    }

    private void judgeSystemIrsCompanyInfo(List<CompanySuperviseModel> companyList) {
        if (CollUtil.isNotEmpty(companyList)) {
            int size = companyList.size();
            if (size > 10) {
                return;
            }
            List<String> uccList = companyList.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).collect(Collectors.toList());
            QueryWrapper irsWrapper = new QueryWrapper();
            irsWrapper.in((Object)"uniscid", uccList);
            List<IrsMarketEntities> irsCompanyList = this.companyDcMapper.getIrsCompanyInfoByUccList(uccList);
            if (CollUtil.isNotEmpty(irsCompanyList)) {
                Map irsMap = irsCompanyList.stream().collect(Collectors.toMap(IrsMarketEntities::getUniscid, Function.identity(), (v1, v2) -> v1));
                for (CompanySuperviseModel company : companyList) {
                    boolean eql;
                    String ucc = company.getUnifiedSocialCc();
                    String name = company.getName();
                    Byte businessState = company.getBusinessState();
                    IrsMarketEntities irsCompany = (IrsMarketEntities)irsMap.get(StringUtils.isNotEmpty((CharSequence)ucc) ? ucc.toUpperCase() : ucc);
                    if (irsCompany == null) continue;
                    String irsName = irsCompany.getEntname();
                    try {
                        eql = DcCompanyServiceImpl.compareIgnoreFullHalf(name, irsName);
                    }
                    catch (Exception e) {
                        name = name.toLowerCase();
                        String name1 = name.replace('\uff08', '(').replace('\uff09', ')');
                        irsName = irsName.toLowerCase();
                        String irsName1 = irsName.replace('\uff08', '(').replace('\uff09', ')');
                        eql = Objects.equals(name1, irsName1);
                    }
                    if (!eql) {
                        company.setNameDiff(Boolean.TRUE);
                        company.setIrsName(irsName);
                        continue;
                    }
                    String irsBusinessStateName = irsCompany.getRegstate();
                    switch (businessState) {
                        case 0: {
                            if (!"\u5f00\u4e1a".equals(irsBusinessStateName) && !"\u6b47\u4e1a".equals(irsBusinessStateName)) break;
                            company.setBusinessStateDiff(Boolean.TRUE);
                            break;
                        }
                        case 1: {
                            if ("\u5f00\u4e1a".equals(irsBusinessStateName) || "\u53d8\u66f4".equals(irsBusinessStateName) || "\u64a4\u9500".equals(irsBusinessStateName) || "\u5907\u6848".equals(irsBusinessStateName)) break;
                            company.setBusinessStateDiff(Boolean.TRUE);
                            break;
                        }
                        case 2: {
                            if ("\u53d8\u66f4".equals(irsBusinessStateName) || "\u64a4\u9500".equals(irsBusinessStateName) || "\u6b47\u4e1a".equals(irsBusinessStateName) || "\u5907\u6848".equals(irsBusinessStateName)) break;
                            company.setBusinessStateDiff(Boolean.TRUE);
                            break;
                        }
                    }
                    if (!Boolean.TRUE.equals(company.getBusinessStateDiff())) continue;
                    company.setIrsBusinessStateName(irsBusinessStateName);
                }
            }
        }
    }

    private void judgeCompanyOccupationalDiseaseInfo(List<CompanySuperviseModel> companyList) {
        if (CollUtil.isEmpty(companyList)) {
            return;
        }
        companyList.forEach(c -> c.setOccupationalDisease(Integer.valueOf(StrUtil.isNotEmpty((CharSequence)c.getDiagnosisYearGroup()) ? 1 : 0)));
    }

    public static boolean compareIgnoreFullHalf(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return str1 == str2;
        }
        String normalized1 = Normalizer.normalize(str1, Normalizer.Form.NFKC);
        String normalized2 = Normalizer.normalize(str2, Normalizer.Form.NFKC);
        return normalized1.equals(normalized2);
    }

    private void fillParamValue(List<CompanySuperviseModel> companyList) {
        if (companyList != null && !companyList.isEmpty()) {
            Map paramMap = this.sysParamProvideService.getParamMap();
            for (CompanySuperviseModel c : companyList) {
                String industryCategoryCode = c.getIndustryCategoryCode();
                String industryCategoryName = c.getIndustryCategoryName();
                if (StringUtils.isNotEmpty((CharSequence)industryCategoryCode)) {
                    c.setIndustryCategoryName(industryCategoryCode + "-" + industryCategoryName);
                }
                c.setTingDetailName("\uff1e");
                if (c.getRegisterType() != null && MapUtils.isNotEmpty((Map)paramMap)) {
                    SysParamModel paramRegisterType = (SysParamModel)paramMap.get(c.getRegisterType());
                    if (paramRegisterType == null) {
                        paramRegisterType = this.sysParamProvideService.getById(c.getRegisterType());
                    }
                    if (paramRegisterType != null) {
                        c.setRegisterTypeName(paramRegisterType.getParamValue());
                    }
                }
                if (c.getScale() == null || !StringUtils.isNumeric((CharSequence)c.getScale()) || Long.parseLong(c.getScale()) >= 6L) continue;
                String scaleName = CompanySizeEnum.getName((Byte)Byte.parseByte(c.getScale()));
                c.setScaleName(scaleName);
            }
        }
    }

    private void calcNormalBussiness(List<CompanySuperviseModel> companyList, CompanySuperviseSearchModel companySearchVo) {
        if (companySearchVo.isCalcNormalBusiness() && CollectionUtils.isNotEmpty(companyList)) {
            Byte businessState = companySearchVo.getBusinessState();
            CompanySuperviseSearchModel newCompanySearchVo = new CompanySuperviseSearchModel();
            newCompanySearchVo.setAreaId(companySearchVo.getAreaId());
            newCompanySearchVo.setAreaLevel(companySearchVo.getAreaLevel());
            newCompanySearchVo.setOrgAreaId(companySearchVo.getAreaId());
            newCompanySearchVo.setOrgAreaLevel(companySearchVo.getAreaLevel());
            newCompanySearchVo.setCompanyType(companySearchVo.getCompanyType());
            newCompanySearchVo.setIsTest(companySearchVo.getIsTest());
            newCompanySearchVo.setExcludeGrade(companySearchVo.getExcludeGrade());
            newCompanySearchVo.setDataCategory(companySearchVo.getDataCategory());
            newCompanySearchVo.setIsOwnLevel(companySearchVo.getIsOwnLevel());
            newCompanySearchVo.setSuperviseIsHide(companySearchVo.getSuperviseIsHide());
            newCompanySearchVo.setCalcNormalBusiness(companySearchVo.isCalcNormalBusiness());
            newCompanySearchVo.setGradeTableName(companySearchVo.getGradeTableName());
            newCompanySearchVo.setAccountState(companySearchVo.getAccountState());
            newCompanySearchVo.setBusinessState(Byte.valueOf((byte)1));
            int coutListCompanyInfo = this.companyDcMapper.coutListCompanyInfo(newCompanySearchVo);
            companyList.get(0).setThisAreaCompanyNum(coutListCompanyInfo);
            newCompanySearchVo.setBusinessState(Byte.valueOf((byte)2));
            int coutStopListCompanyInfo = this.companyDcMapper.coutListCompanyInfo(newCompanySearchVo);
            companyList.get(0).setThisAreaStopCompanyNum(coutStopListCompanyInfo);
        }
    }

    public PageInfo<CompanySuperviseModel> pageCompanyInfo(JqGridParam param, CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        companySearchVo.setSuperviseIsHide(Boolean.valueOf(false));
        List<CompanySuperviseModel> companyList = this.listCompanyInfo(companySearchVo, getBaseInfo);
        PageInfo page = new PageInfo(companyList);
        return page;
    }

    public PageInfo<CompanySuperviseModel> pageWaitSureCompanyInfo(JqGridParam param, WaitSureCompanySearchModel companySearchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        companySearchVo.setDataSource(CompanyDataSourceEnum.WAITSURE.getValue());
        List<CompanySuperviseModel> superviseModelList = this.companyDcMapper.listwaitsureCompanyInfo(companySearchVo);
        PageInfo pageModel = new PageInfo(superviseModelList);
        return pageModel;
    }

    public List<CompanySuperviseModel> listWaitSureCompanyInfo(WaitSureCompanySearchModel companySearchVo) {
        companySearchVo.setDataSource(CompanyDataSourceEnum.WAITSURE.getValue());
        List<CompanySuperviseModel> superviseModelList = this.companyDcMapper.listwaitsureCompanyInfo(companySearchVo);
        return superviseModelList;
    }

    public RecordOperationLog generateOccTypeLog(CompanyRiskInduOccTypeVo csm, OccTypeChangeEvent event, Long updateBy, String updateName) {
        if (csm == null || csm.getNewOccType() == null || csm.getOldOccType() == null) {
            return null;
        }
        RecordOperationLog recordOperationLog = new RecordOperationLog();
        String before = CompanyOccTypeEnum.getName((Integer)csm.getOldOccType());
        String after = CompanyOccTypeEnum.getName((Integer)csm.getNewOccType());
        recordOperationLog.setCompanyId(csm.getCid());
        recordOperationLog.setCompanyName(csm.getName());
        recordOperationLog.setAfterInfo(after);
        recordOperationLog.setBeforeInfo(before);
        recordOperationLog.setId(Long.valueOf(this.idworker.nextId()));
        recordOperationLog.setTableName("company");
        if (Objects.equals(csm.getRiskOccType(), csm.getNewOccType())) {
            recordOperationLog.setLogTitle(OccTypeChangeEvent.BY_CHECKINDU.getName());
        } else if (Objects.equals(event, OccTypeChangeEvent.BY_CHECKINDU)) {
            recordOperationLog.setLogTitle(OccTypeChangeEvent.BY_CHECKINDU.getName());
        } else {
            recordOperationLog.setLogTitle(OccTypeChangeEvent.BY_UPDATEINDU.getName());
        }
        recordOperationLog.setChangeField("occupational_risk_classify");
        recordOperationLog.setLogType(Integer.valueOf(3));
        recordOperationLog.setBusiType(RecordOperationTypeEnum.COMPANY_OCCUPATIONALRISKCLASSIFY.getKey());
        recordOperationLog.setCreateDate(new Date());
        recordOperationLog.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        recordOperationLog.setCreateBy(updateBy);
        recordOperationLog.setCreateByName(updateName);
        return recordOperationLog;
    }

    @Transactional
    public void doCompanyOccTypeTask(List<Long> cids, OccTypeChangeEvent event, Boolean refreshGrade) {
        List<CompanyRiskInduOccTypeVo> modelList = this.companyDcMapper.listAllCompanyInduRisk(cids);
        if (CollectionUtils.isNotEmpty(modelList)) {
            for (List modelListPart : ListUtil.partition(modelList, (int)1000)) {
                List superviseModelList = modelListPart.stream().map(m -> {
                    CompanySuperviseModel companySuperviseModel = new CompanySuperviseModel();
                    companySuperviseModel.setId(m.getCid());
                    companySuperviseModel.setOccupationalRiskClassify(m.getNewOccType());
                    companySuperviseModel.setOccType(m.getNewOccType());
                    return companySuperviseModel;
                }).collect(Collectors.toList());
                this.companyProvideByHSEService.batchUpdateOccType(superviseModelList);
                ArrayList<RecordOperationLog> logList = new ArrayList<RecordOperationLog>();
                for (CompanyRiskInduOccTypeVo csm2 : modelListPart) {
                    RecordOperationLog recordOperationLog = this.generateOccTypeLog(csm2, event, null, null);
                    if (recordOperationLog == null) continue;
                    logList.add(recordOperationLog);
                }
                if (CollectionUtils.isNotEmpty(logList)) {
                    ((CompanyMapper)this.dao).insertRecordOperationLog(logList);
                }
                List cidList = modelListPart.stream().map(csm -> csm.getCid()).collect(Collectors.toList());
                if (refreshGrade != null && !Objects.equals(refreshGrade, true)) continue;
                this.companyGradeV3RefreshService.refreshCompanyGradeByCids(cidList, CompanyGradeEventSource.OCCTYPECHANGE);
            }
        }
    }

    public Collection<SimpleCollectVo> countCompanyByIndutry(Long areaId, Byte areaLevel, String victimsCase) {
        List<SimpleCollectVo> simpleCollectVos = this.companyDcMapper.countCompanyByIndutry(areaId, areaLevel, victimsCase);
        String[] induArr = new String[]{"\u91c7\u77ff\u4e1a", "\u5236\u9020\u4e1a", "\u7535\u529b\u3001\u70ed\u529b\u3001\u71c3\u6c14\u53ca\u6c34\u751f\u4ea7\u548c\u4f9b\u5e94\u4e1a", "\u6c34\u5229\u3001\u73af\u5883\u548c\u516c\u5171\u8bbe\u65bd\u7ba1\u7406\u4e1a", "\u5176\u4ed6"};
        LinkedHashMap<String, SimpleCollectVo> map = new LinkedHashMap<String, SimpleCollectVo>();
        for (String indu2 : induArr) {
            map.put(indu2, new SimpleCollectVo(indu2));
        }
        if (CollectionUtils.isNotEmpty(simpleCollectVos)) {
            simpleCollectVos.forEach(indu -> {
                SimpleCollectVo simpleCollectVo = (SimpleCollectVo)map.get(indu.getName());
                if (simpleCollectVo == null) {
                    simpleCollectVo = (SimpleCollectVo)map.get("\u5176\u4ed6");
                }
                Long num = simpleCollectVo.getNum();
                simpleCollectVo.setNum(Long.valueOf(indu.getNum() + num));
            });
        }
        return map.values();
    }

    public List<SimpleCollectVo> countCompanyBySize(Long areaId, Byte areaLevel, String victimsCase) {
        List<SimpleCollectVo> simpleCollectVos = this.companyDcMapper.countCompanyBySize(areaId, areaLevel, victimsCase);
        if (CollectionUtils.isNotEmpty(simpleCollectVos)) {
            List<SimpleCollectVo> collectVoList = simpleCollectVos.stream().filter(s -> s != null && StringUtils.isNotBlank((CharSequence)s.getExtra()) && StringUtils.isNumeric((CharSequence)s.getExtra())).collect(Collectors.toList());
            collectVoList.forEach(s -> s.setName(CompanySizeEnum.getName((Byte)Byte.parseByte(s.getExtra()))));
            return collectVoList;
        }
        return Collections.emptyList();
    }

    public Collection<SimpleCollectVo> countCompanyByRegisterType(Long areaId, Byte areaLevel, String victimsCase) {
        String[] registerTypeArr = new String[]{"\u56fd\u6709\u4f01\u4e1a", "\u96c6\u4f53\u4f01\u4e1a", "\u80a1\u4efd\u5408\u4f5c\u4f01\u4e1a", "\u8054\u8425\u4f01\u4e1a", "\u6709\u9650\u8d23\u4efb\u516c\u53f8", "\u80a1\u4efd\u6709\u9650\u516c\u53f8", "\u79c1\u8425\u4f01\u4e1a", "\u6e2f\u3001\u6fb3\u3001\u53f0\u5546\u6295\u8d44\u4f01\u4e1a", "\u5916\u5546\u6295\u8d44\u4f01\u4e1a", "\u5176\u4ed6"};
        List<SimpleCollectVo> simpleCollectVos = this.companyDcMapper.countCompanyByRegisterType(areaId, areaLevel, victimsCase);
        LinkedHashMap<String, SimpleCollectVo> map = new LinkedHashMap<String, SimpleCollectVo>();
        for (String indu2 : registerTypeArr) {
            map.put(indu2, new SimpleCollectVo(indu2));
        }
        if (CollectionUtils.isNotEmpty(simpleCollectVos)) {
            simpleCollectVos.forEach(indu -> {
                SimpleCollectVo simpleCollectVo = (SimpleCollectVo)map.get(indu.getName());
                if (simpleCollectVo == null) {
                    simpleCollectVo = (SimpleCollectVo)map.get("\u5176\u4ed6");
                }
                Long num = simpleCollectVo.getNum();
                simpleCollectVo.setNum(Long.valueOf(indu.getNum() + num));
            });
        }
        return map.values();
    }

    public List<SimpleCollectVo> countCompanyBasic(Long areaId, Byte areaLevel, String victimsCase) throws ExecutionException, InterruptedException {
        CompletableFuture<Collection> induFuture = CompletableFuture.supplyAsync(() -> {
            Collection<SimpleCollectVo> countCompanyByIndutry = this.countCompanyByIndutry(areaId, areaLevel, victimsCase);
            return countCompanyByIndutry;
        });
        CompletableFuture<Collection> sizeFuture = CompletableFuture.supplyAsync(() -> {
            List<SimpleCollectVo> countCompanyBySize = this.countCompanyBySize(areaId, areaLevel, victimsCase);
            return countCompanyBySize;
        });
        CompletionStage registerIndu = CompletableFuture.supplyAsync(() -> {
            Collection<SimpleCollectVo> registerType = this.countCompanyByRegisterType(areaId, areaLevel, victimsCase);
            return registerType;
        }).exceptionally(err -> null);
        CompletableFuture.allOf(new CompletableFuture[]{induFuture, sizeFuture, registerIndu}).join();
        LinkedList<SimpleCollectVo> result = new LinkedList<SimpleCollectVo>();
        for (SimpleCollectVo simpleCollectVo : sizeFuture.get()) {
            if (simpleCollectVo == null) continue;
            simpleCollectVo.setCategory("\u89c4\u6a21");
            result.add(simpleCollectVo);
        }
        for (SimpleCollectVo simpleCollectVo : induFuture.get()) {
            simpleCollectVo.setCategory("\u884c\u4e1a\u7c7b\u578b");
            result.add(simpleCollectVo);
        }
        for (SimpleCollectVo simpleCollectVo : (Collection)((CompletableFuture)registerIndu).get()) {
            simpleCollectVo.setCategory("\u7ecf\u6d4e\u7c7b\u578b");
            result.add(simpleCollectVo);
        }
        return result;
    }

    public int countCompanyByBelong(Long areaId, Byte level, Boolean thisLevel) {
        if (areaId == null) {
            return 0;
        }
        CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
        companySearchVo.setAreaId(areaId);
        companySearchVo.setAreaLevel(level);
        if (thisLevel != null && thisLevel.booleanValue() && level != null) {
            companySearchVo.setBelongType(Integer.valueOf(level.intValue()));
        }
        int companyByBelong = this.companyDcMapper.countCompanyByBelong(companySearchVo);
        return companyByBelong;
    }

    public PageInfo<CompanySuperviseModel> getCloseAndPauseComPage(JqGridParam param, CloseAndPauseCompanySearchVo searchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanySuperviseModel> list = this.companyDcMapper.getCloseAndPauseComList(searchVo);
        return new PageInfo(list);
    }

    public HomeReceivingUnitVo getData1(HomeIndexSearchVo searchVo) {
        HomeReceivingUnitVo unitVo = new HomeReceivingUnitVo();
        CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
        companySearchVo.setAreaId(Long.valueOf(Objects.equals(searchVo.getAreaId(), 0L) ? 100000000000L : searchVo.getAreaId()));
        companySearchVo.setBelongType(searchVo.getBelongType());
        companySearchVo.setOnlyThisLevel(searchVo.getIsCurrent());
        companySearchVo.setAreaId(searchVo.getAreaId());
        companySearchVo.setAreaLevel(searchVo.getAreaLevel());
        companySearchVo.setNoUnitCode(Boolean.valueOf(false));
        companySearchVo.setContainCategory(Boolean.valueOf(false));
        companySearchVo.setContainLess3Result(Boolean.valueOf(false));
        companySearchVo.setCompanyType(Integer.valueOf(1));
        companySearchVo.setGradeSource("1,2");
        companySearchVo.setIsTest(Boolean.valueOf(false));
        companySearchVo.setSuperviseIsHide(Boolean.valueOf(false));
        companySearchVo.setSystemDeploymentSource(SystemDeploymentSourceEnum.NO.getCode());
        companySearchVo.setIsFcImportanceCompany(searchVo.getIsFcImportanceCompany());
        companySearchVo.setIsDeclare("all");
        Map<String, Long> searchRetMap1 = this.countState(companySearchVo);
        if (searchRetMap1 != null) {
            Long normalCountObj = searchRetMap1.get("normalCount");
            Long suspendedCountObj = searchRetMap1.get("suspendedCount");
            int num = Integer.parseInt(((Object)normalCountObj).toString()) + Integer.parseInt(((Object)suspendedCountObj).toString());
            unitVo.setCompanyNum(Integer.valueOf(num));
            unitVo.setSuperviseObjNum(Integer.valueOf(num));
            unitVo.setNum2(Integer.valueOf(Integer.parseInt(((Object)normalCountObj).toString())));
        }
        companySearchVo.setIsDeclare("all");
        companySearchVo.setIsExistRadioactivity(Integer.valueOf(1));
        Map<String, Long> searchRetMap2 = this.countState(companySearchVo);
        if (searchRetMap2 != null) {
            Long normalCountObj = searchRetMap2.get("normalCount");
            Long suspendedCountObj = searchRetMap2.get("suspendedCount");
            int num = Integer.parseInt(((Object)normalCountObj).toString()) + Integer.parseInt(((Object)suspendedCountObj).toString());
            unitVo.setRadiologyNum(Integer.valueOf(num));
        }
        companySearchVo.setIsDeclare("all");
        companySearchVo.setIsExistRadioactivity(null);
        companySearchVo.setPickupCount3("0");
        Map<String, Long> searchRetMap3 = this.countState(companySearchVo);
        if (searchRetMap3 != null) {
            Long normalCountObj = searchRetMap3.get("normalCount");
            Long suspendedCountObj = searchRetMap3.get("suspendedCount");
            int num = Integer.parseInt(((Object)normalCountObj).toString()) + Integer.parseInt(((Object)suspendedCountObj).toString());
            unitVo.setPickUpCountLessNum(Integer.valueOf(Integer.parseInt(((Object)normalCountObj).toString())));
        }
        companySearchVo.setIsDeclare("all");
        companySearchVo.setIsExistRadioactivity(null);
        companySearchVo.setPickupCount3("1");
        Map<String, Long> searchGrOrEqMap3 = this.countState(companySearchVo);
        if (searchGrOrEqMap3 != null) {
            Long normalCountObj = searchGrOrEqMap3.get("normalCount");
            Long suspendedCountObj = searchGrOrEqMap3.get("suspendedCount");
            int num = Integer.parseInt(((Object)normalCountObj).toString()) + Integer.parseInt(((Object)suspendedCountObj).toString());
            unitVo.setPickUpCountGrOrEqNum(Integer.valueOf(Integer.parseInt(((Object)normalCountObj).toString())));
        }
        CompanyOutpackSearchModel outpackSearchModel = new CompanyOutpackSearchModel();
        outpackSearchModel.setSearchAll(Boolean.valueOf(true));
        outpackSearchModel.setAreaId(searchVo.getAreaId());
        outpackSearchModel.setOutAreaId(searchVo.getAreaId());
        outpackSearchModel.setAreaLevel(searchVo.getAreaLevel());
        outpackSearchModel.setOutAreaLevel(searchVo.getAreaLevel());
        outpackSearchModel.setBelongType(searchVo.getBelongType());
        outpackSearchModel.setOnlyThisLevel(searchVo.getIsCurrent());
        outpackSearchModel.setIsFcImportanceCompany(searchVo.getIsFcImportanceCompany());
        List list = this.outpackService.listLaborDispatchUnitInfo(outpackSearchModel);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            unitVo.setLaborCompanyNum(Integer.valueOf(list.size()));
        }
        if (Objects.equals(1, searchVo.getIsFcImportanceCompany())) {
            unitVo.setLaborCompanyNum(null);
        }
        return unitVo;
    }

    public HomeReceivingUnitVo getData5(HomeIndexSearchVo searchVo) {
        CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
        companySearchVo.setAreaId(Long.valueOf(Objects.equals(searchVo.getAreaId(), 0L) ? 100000000000L : searchVo.getAreaId()));
        companySearchVo.setBelongType(searchVo.getBelongType());
        companySearchVo.setOnlyThisLevel(searchVo.getIsCurrent());
        companySearchVo.setAreaId(searchVo.getAreaId());
        companySearchVo.setAreaLevel(searchVo.getAreaLevel());
        companySearchVo.setNoUnitCode(Boolean.valueOf(false));
        companySearchVo.setContainCategory(Boolean.valueOf(false));
        companySearchVo.setContainLess3Result(Boolean.valueOf(false));
        companySearchVo.setCompanyType(Integer.valueOf(1));
        companySearchVo.setGradeSource("1,2");
        companySearchVo.setIsTest(Boolean.valueOf(false));
        companySearchVo.setSuperviseIsHide(Boolean.valueOf(false));
        companySearchVo.setRiskType("***");
        companySearchVo.setIsDeclare("all");
        companySearchVo.setBusinessState(Byte.valueOf((byte)1));
        companySearchVo.setIsFcImportanceCompany(searchVo.getIsFcImportanceCompany());
        if (CharSequenceUtil.isNotBlank((CharSequence)searchVo.getPickupCount3())) {
            companySearchVo.setPickupCount3(searchVo.getPickupCount3());
        }
        companySearchVo.setIsFcImportanceCompany(searchVo.getIsFcImportanceCompany());
        if (CharSequenceUtil.isNotBlank((CharSequence)searchVo.getIsDeclare())) {
            companySearchVo.setIsDeclare(searchVo.getIsDeclare());
        }
        return this.companyDcMapper.countHomeReceivingUnitVo(companySearchVo);
    }

    public List<CompanyTrainVo> statisticRegionCompanyTrainRateBatch(HomeIndexSearchVo searchVo) {
        CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
        companySearchVo.setBelongType(searchVo.getBelongType());
        companySearchVo.setOnlyThisLevel(searchVo.getIsCurrent());
        companySearchVo.setAreaId(searchVo.getAreaId());
        companySearchVo.setAreaLevel(searchVo.getAreaLevel());
        companySearchVo.setNoUnitCode(Boolean.FALSE);
        companySearchVo.setContainCategory(Boolean.FALSE);
        companySearchVo.setContainLess3Result(Boolean.FALSE);
        companySearchVo.setCompanyType(Integer.valueOf(1));
        companySearchVo.setGradeSource("1,2");
        companySearchVo.setIsTest(Boolean.FALSE);
        companySearchVo.setSuperviseIsHide(Boolean.FALSE);
        companySearchVo.setRiskType("***");
        companySearchVo.setIsDeclare("all");
        companySearchVo.setBusinessState(Byte.valueOf((byte)1));
        companySearchVo.setIsFcImportanceCompany(searchVo.getIsFcImportanceCompany());
        if (CharSequenceUtil.isNotBlank((CharSequence)searchVo.getPickupCount3())) {
            companySearchVo.setPickupCount3(searchVo.getPickupCount3());
        }
        companySearchVo.setIsFcImportanceCompany(searchVo.getIsFcImportanceCompany());
        if (CharSequenceUtil.isNotBlank((CharSequence)searchVo.getIsDeclare())) {
            companySearchVo.setIsDeclare(searchVo.getIsDeclare());
        }
        companySearchVo.setSearchLevel(searchVo.getSearchLevel());
        return this.companyDcMapper.statisticRegionCompanyTrainRateBatch(companySearchVo);
    }

    public List<CompanyTrainVo> getRegionCompanyTrainRateList(RiskResolveResSearch param) {
        Long regionId = param.getAreaId();
        Byte regionLevel = param.getAreaLevel();
        Boolean isCurrent = param.getIsCurrent();
        Integer isFcImportanceCompany = Optional.ofNullable(param.getIsFcImportanceCompany()).orElse(0);
        HomeIndexSearchVo searchVo = this.setHomeIndexSearchVo(regionId, regionLevel, isCurrent, isFcImportanceCompany);
        searchVo.setPickupCount3("1,2");
        searchVo.setIsDeclare("olddec");
        searchVo.setSearchLevel(param.getSearchLevel());
        List<Object> companyTrainList = this.statisticRegionCompanyTrainRateBatch(searchVo);
        companyTrainList = companyTrainList.stream().filter(t -> t.getCompanyNum() != 0 && t.getCompanyTrainNum() != 0).collect(Collectors.toList());
        for (CompanyTrainVo companyTrainVo : companyTrainList) {
            BigDecimal companyTrainRate = Convert.toBigDecimal((Object)companyTrainVo.getCompanyTrainNum()).multiply(Convert.toBigDecimal((Object)100)).divide(Convert.toBigDecimal((Object)companyTrainVo.getCompanyNum()), 2, RoundingMode.HALF_UP);
            companyTrainVo.setCompanyTrainRate(Double.valueOf(companyTrainRate.doubleValue()));
        }
        return companyTrainList;
    }

    public void demomemory() {
        int counter = 0;
        Runtime runtime = Runtime.getRuntime();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(500L);
                    log.error("====================================================start");
                    log.error("Free Memory: " + runtime.freeMemory() / 1024L / 1024L + " MB");
                    log.error("Total Memory: " + runtime.totalMemory() / 1024L / 1024L + " MB");
                    log.error("Max Memory: " + runtime.maxMemory() / 1024L / 1024L + " MB");
                    byte[] bigArray = new byte[0x1400000];
                    this.memoryList.add(bigArray);
                    log.error("Allocated memory blocks: " + ++counter);
                    log.error("====================================================end");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public PageInfo<CompanyUserV3ListVo> getCompanyUserV3List(CompanyUserV3ListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<CompanyUserV3ListVo> rst = this.companyDcMapper.getCompanyUserV3List(param);
        this.enrichCompanyUserInfo(rst, param);
        if (Objects.equals(param.getSystemDeploymentSource(), SystemDeploymentSourceEnum.NO.getCode())) {
            this.setCloseSource(rst);
        }
        return new PageInfo(rst);
    }

    private void setCloseSource(List<CompanyUserV3ListVo> rst) {
        List<Long> cidList = rst.stream().map(CompanyUserV3ListVo::getId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(cidList)) {
            List<Long> irsCidList = this.companyDcMapper.getIrsCloseCidList(cidList);
            rst.forEach(c -> {
                if (Objects.equals(c.getBusinessState(), 0)) {
                    int closeSource = irsCidList.contains(c.getId()) ? 1 : 2;
                    c.setCloseSource(Integer.valueOf(closeSource));
                }
            });
        }
    }

    public JqGridData<CompanyUserV3ListVo> getNewCompanyGuideList(CompanyUserV3ListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyUserV3ListVo> rst = this.companyDcMapper.getNewCompanyGuideList(param);
        this.enrichCompanyUserInfo(rst, param);
        return new JqGridData((Page)rst, (JqGridParam)param);
    }

    public Long getCompanyUserV3ListCount(CompanyUserV3ListParam param) {
        return this.companyDcMapper.getCompanyUserV3ListCount(param);
    }

    @Transactional
    public Boolean save(CompanyUserV3AddParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (!CreditCodeUtil.isCreditCodeSimple((CharSequence)param.getUnifiedSocialCc())) {
            throw new HealthException("\u8be5\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (this.companyProvideBySuperviseService.isHaveThisName(param.getName(), null, Boolean.TRUE).booleanValue()) {
            throw new HealthException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(param.getDetailAreaId());
        if (Objects.isNull(area)) {
            throw new HealthException("\u8be5\u884c\u653f\u533a\u5212\u5df2\u4e0d\u5b58\u5728");
        }
        if (area.getLevel() < 4 && !area.getName().contains("\u5f00\u53d1\u533a")) {
            throw new HealthException("\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
        }
        CompanySuperviseModel c = new CompanySuperviseModel();
        c.setId(Long.valueOf(IdWorker.getId()));
        c.setName(param.getName());
        c.setUnifiedSocialCc(param.getUnifiedSocialCc());
        c.setAreaDetailId(param.getDetailAreaId());
        c.setWorkAddress(param.getWorkAddress());
        c.setBelongType(param.getBelongType());
        c.setBusinessState(param.getBusinessState());
        c.setIsTest(param.getIsTest());
        c.setSuperviseIsHide(param.getSuperviseIsHide());
        c.setRegisterType(param.getRegisterType());
        c.setScale(param.getScale());
        c.setIndustryCategory(param.getIndustryCategory());
        c.setRegisterAddress(param.getRegisterAddress());
        c.setCompanyContactTel(param.getCompanyContactTel());
        c.setLegalName(param.getLegalName());
        c.setLegalTel(param.getLegalTel());
        c.setOccManagerName(param.getOccManagerName());
        c.setOccManagerTel(param.getOccManagerTel());
        c.setMainLeaderName(param.getMainLeaderName());
        c.setMainLeaderTel(param.getMainLeaderTel());
        c.setPickupCount(null);
        this.setSupervisionInfo(c, area);
        this.companyProvideBySuperviseService.saveCompanyAndCompanySuperviseByOne(c, param.getLoginUserId());
        if (Objects.equals(param.getIsCreateUser(), Boolean.TRUE)) {
            if (this.sysUserThirdService.isHaveThisName(param.getName(), null).booleanValue()) {
                throw new HealthException("\u8981\u521b\u5efa\u8d26\u53f7\u7684\u4f01\u4e1a\u9ed8\u8ba4\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            ArrayList<CreateUserModel> list = new ArrayList<CreateUserModel>(1);
            CreateUserModel createUserModel = new CreateUserModel();
            createUserModel.setCid(c.getId());
            createUserModel.setUsername(param.getName());
            createUserModel.setPassword("Zyj@2022");
            createUserModel.setCreateBy(param.getLoginUserId());
            list.add(createUserModel);
            this.sysUserThirdService.create(list);
        }
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean saveForTrain(CompanyUserV3AddParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (!CreditCodeUtil.isCreditCodeSimple((CharSequence)param.getUnifiedSocialCc())) {
            throw new HealthException("\u8be5\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (this.companyProvideBySuperviseService.isHaveThisName(param.getName(), null, Boolean.TRUE).booleanValue()) {
            throw new HealthException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(param.getDetailAreaId());
        if (Objects.isNull(area)) {
            throw new HealthException("\u8be5\u884c\u653f\u533a\u5212\u5df2\u4e0d\u5b58\u5728");
        }
        if (area.getLevel() < 4 && !area.getName().contains("\u5f00\u53d1\u533a")) {
            throw new HealthException("\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
        }
        CompanySuperviseModel c = new CompanySuperviseModel();
        c.setId(Long.valueOf(IdWorker.getId()));
        c.setName(param.getName());
        c.setUnifiedSocialCc(param.getUnifiedSocialCc());
        c.setAreaDetailId(param.getDetailAreaId());
        c.setBelongType(param.getBelongType());
        c.setIsTest(param.getIsTest());
        c.setSuperviseIsHide(param.getSuperviseIsHide());
        c.setIndustryCategory(param.getIndustryCategory());
        if (area.getAreaId() == 330783000000L) {
            c.setDataSource(CompanyDataSourceEnum.DONG_YANG_SYSTEMS.getValue());
        } else {
            c.setDataSource(CompanyDataSourceEnum.OLINETRAIN.getValue());
        }
        this.setSupervisionInfo(c, area);
        this.companyProvideBySuperviseService.saveCompanyAndCompanySuperviseByOne(c, param.getLoginUserId());
        if (Objects.equals(param.getIsCreateUser(), Boolean.TRUE)) {
            if (this.sysUserThirdService.isHaveThisName(param.getName(), null).booleanValue()) {
                throw new HealthException("\u8981\u521b\u5efa\u8d26\u53f7\u7684\u4f01\u4e1a\u9ed8\u8ba4\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            ArrayList<CreateUserModel> list = new ArrayList<CreateUserModel>(1);
            CreateUserModel createUserModel = new CreateUserModel();
            createUserModel.setCid(c.getId());
            createUserModel.setUsername(param.getName());
            createUserModel.setPassword("Zyj@2022");
            createUserModel.setCreateBy(param.getLoginUserId());
            list.add(createUserModel);
            this.sysUserThirdService.create(list);
        }
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean update(CompanyUserV3EditParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (!CreditCodeUtil.isCreditCodeSimple((CharSequence)param.getUnifiedSocialCc())) {
            throw new HealthException("\u8be5\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (this.companyProvideBySuperviseService.isHaveThisName(param.getName(), param.getId(), Boolean.TRUE).booleanValue()) {
            throw new HealthException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(param.getDetailAreaId());
        if (Objects.isNull(area)) {
            throw new HealthException("\u8be5\u884c\u653f\u533a\u5212\u5df2\u4e0d\u5b58\u5728");
        }
        if (area.getLevel() < 4 && !area.getName().contains("\u5f00\u53d1\u533a")) {
            throw new HealthException("\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
        }
        CompanySuperviseModel companySuperviseModel = this.companyProvideBySuperviseService.getCompanyInfoById(param.getId());
        SysAreaV3OneVo area2 = Objects.isNull(companySuperviseModel.getAreaDetailId()) ? this.sysAreaProvideService.getAreaByIdV3(param.getLoginUserAreaId()) : this.sysAreaProvideService.getAreaByIdV3(companySuperviseModel.getAreaId());
        this.validateAreaPermission(param.getLoginAreaLevle(), area, area2);
        List<CompanyChangeInfoDetailV3> companyIsFormalProcess = this.companyChangeInfoDetailV3Service.getCompanyIsFormalProcessListByCidList(null, Collections.singletonList(param.getId()));
        if (CollUtil.isNotEmpty(companyIsFormalProcess)) {
            List companyIsFormalProcessFilterList = companyIsFormalProcess.stream().filter(i -> Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.crossMigration.getCode()) || Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.intraMigration.getCode()) || Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.districtMigration.getCode())).collect(Collectors.toList());
            if (CollUtil.isEmpty(companyIsFormalProcessFilterList)) {
                throw new HealthException("\u8be5\u4f01\u4e1a\u6b63\u5904\u4e8e\u4fe1\u606f\u53d8\u66f4\uff08\u975e\u8fc1\u79fb\uff09\u6b63\u5f0f\u6d41\u7a0b\u4e2d");
            }
            if (companyIsFormalProcess.size() > companyIsFormalProcessFilterList.size()) {
                throw new HealthException("\u8be5\u4f01\u4e1a\u6b63\u5904\u4e8e\u4fe1\u606f\u53d8\u66f4\uff08\u975e\u8fc1\u79fb\uff09\u6b63\u5f0f\u6d41\u7a0b\u4e2d");
            }
            this.companyChangeV3ProviderService.delCompanyIsFormalProcessByCid(param.getId(), param.getName(), param.getDetailAreaId(), param.getLoginUserId(), param.getUserName());
        }
        if (this.companyProvideBySuperviseService.isHaveThisCreditCode(param.getUnifiedSocialCc(), param.getId(), Boolean.TRUE).booleanValue() && !Objects.equals(param.getIsForceUpdateWithCreditCode(), Boolean.TRUE)) {
            throw new HealthException(ErrorEnum.FAIL_1111, "\u8be5\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u82e5\u786e\u5b9a\u8be5\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u88ab\u591a\u4e2a\u4f01\u4e1a\u540d\u79f0\u4f7f\u7528\uff0c\u8bf7\u70b9\u51fb\u2018\u662f\u2019\uff0c\u5c06\u7ee7\u7eed\u66f4\u65b0\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f");
        }
        CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(param.getId());
        if (Objects.equals(companyInfo.getIrsBusinessState(), 0)) {
            throw new HealthException("\u8be5\u4f01\u4e1a\u5728\u5de5\u5546\u6570\u636e\u4e2d\u5df2\u6ce8\u9500\uff0c\u65e0\u6cd5\u53d8\u66f4\u8425\u4e1a\u72b6\u6001");
        }
        CompanySuperviseModel c = new CompanySuperviseModel();
        c.setId(param.getId());
        c.setName(param.getName());
        c.setUnifiedSocialCc(param.getUnifiedSocialCc());
        c.setAreaDetailId(param.getDetailAreaId());
        c.setWorkAddress(param.getWorkAddress());
        c.setBelongType(param.getBelongType());
        c.setBusinessState(param.getBusinessState());
        c.setIsTest(param.getIsTest());
        c.setIsExistRadioactivity(param.getIsExistRadioactivity());
        c.setSuperviseIsHide(param.getSuperviseIsHide());
        c.setRegisterType(param.getRegisterType());
        c.setScale(param.getScale());
        c.setIndustryCategory(param.getIndustryCategory());
        c.setRegisterAddress(param.getRegisterAddress());
        c.setCompanyContactTel(param.getCompanyContactTel());
        c.setLegalName(param.getLegalName());
        c.setLegalTel(param.getLegalTel());
        c.setOccManagerName(param.getOccManagerName());
        c.setOccManagerTel(param.getOccManagerTel());
        c.setMainLeaderName(param.getMainLeaderName());
        c.setMainLeaderTel(param.getMainLeaderTel());
        this.setSupervisionInfo(c, area);
        this.companyProvideBySuperviseService.updateCompanyAndCompanySuperviseByOne(c, param.getLoginUserId());
        this.regionChangeRemoveClueCard(companyInfo, param, area);
        this.businessStateChangeRemoveClueCard(companyInfo, param);
        if (Objects.equals(param.getBusinessState(), CompanyBusinessState.CLOSE.getCode().byteValue())) {
            this.sysUserThirdService.disableOrEnableUserByCid(param.getId(), Integer.valueOf(1), param.getLoginUserId());
        } else if (Objects.equals(param.getBusinessState(), CompanyBusinessState.NORMAL.getCode().byteValue())) {
            this.sysUserThirdService.disableOrEnableUserByCid(param.getId(), Integer.valueOf(0), param.getLoginUserId());
        }
        return Boolean.TRUE;
    }

    private void validateAreaPermission(Byte loginAreaLevel, AreaModel area, SysAreaV3OneVo area2) {
        switch (loginAreaLevel) {
            case 0: {
                break;
            }
            case 1: {
                if (Objects.equals(area.getProvinceId(), area2.getProvinceId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u672c\u7701\u53ca\u4ee5\u4e0b\u7684\u533a\u57df");
            }
            case 2: {
                if (Objects.equals(area.getCityId(), area2.getCityId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u672c\u5e02\u53ca\u4ee5\u4e0b\u7684\u533a\u57df");
            }
            case 3: {
                if (Objects.equals(area.getAreaId(), area2.getAreaId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u672c\u533a\u53bf\u53ca\u4ee5\u4e0b\u7684\u533a\u57df");
            }
            case 4: {
                if (Objects.equals(area.getStreetId(), area2.getStreetId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u8857\u9053\u7ea7\u522b\u7684\u533a\u57df");
            }
        }
    }

    private void regionChangeRemoveClueCard(CompanySuperviseModel preCompany, CompanyUserV3EditParam postCompany, AreaModel postRegion) {
        Long postRegionId;
        Long preRegionId = preCompany.getAreaDetailId();
        if (Objects.equals(preRegionId, postRegionId = postCompany.getDetailAreaId())) {
            return;
        }
        Long cid = preCompany.getId();
        AreaModel preRegion = this.sysAreaProvideService.getAreaById(preRegionId);
        if (!Objects.equals(preRegion.getProvinceId(), postRegion.getProvinceId())) {
            this.sysUserThirdService.disableOrEnableUserByCidList(List.of(cid), Integer.valueOf(1), postCompany.getLoginUserId());
            return;
        }
        Object stopType = !Objects.equals(preRegion.getCityId(), postRegion.getCityId()) ? StopTypeEnums.CHANGECROSS : (!Objects.equals(preRegion.getAreaId(), postRegion.getAreaId()) ? StopTypeEnums.CHANGEWITHIN : (!Objects.equals(preRegion.getStreetId(), postRegion.getStreetId()) ? StopTypeEnums.CHANGEDISTRICTWITHIN : null));
        if (stopType != null) {
            this.companyProvideByHSEService.updateRegionProposedStatus(cid, preRegionId, postRegionId, postCompany.getLoginUserId(), stopType);
        }
    }

    private void businessStateChangeRemoveClueCard(CompanySuperviseModel preCompany, CompanyUserV3EditParam postCompany) {
        StopTypeEnums stopType;
        Byte postBusinessState;
        Byte preBusinessState = preCompany.getBusinessState();
        if (Objects.equals(preBusinessState, postBusinessState = postCompany.getBusinessState())) {
            return;
        }
        Long cid = preCompany.getId();
        CompanyBusinessState postStateEnum = CompanyBusinessState.getEnum((Integer)Convert.toInt((Object)postBusinessState));
        switch (postStateEnum) {
            case NORMAL: {
                stopType = StopTypeEnums.NORMAL;
                break;
            }
            case STOP: {
                stopType = StopTypeEnums.PAUSE;
                break;
            }
            case CLOSE: {
                stopType = StopTypeEnums.CLOSE;
                this.sysUserThirdService.disableOrEnableUserByCidList(List.of(cid), Integer.valueOf(1), postCompany.getLoginUserId());
                break;
            }
            default: {
                stopType = null;
            }
        }
        if (stopType != null) {
            this.companyProvideByHSEService.updateBusinessStateProposedStatus(cid, Convert.toInt((Object)preBusinessState), Convert.toInt((Object)postBusinessState), postCompany.getLoginUserId(), stopType);
        }
    }

    @Transactional
    public Boolean updateForTrain(CompanyUserV3EditParam param) {
        CompanySuperviseModel companySuperviseModel;
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (!CreditCodeUtil.isCreditCodeSimple((CharSequence)param.getUnifiedSocialCc())) {
            throw new HealthException("\u8be5\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (this.companyProvideBySuperviseService.isHaveThisName(param.getName(), param.getId(), Boolean.TRUE).booleanValue()) {
            throw new HealthException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(param.getDetailAreaId());
        if (Objects.isNull(area)) {
            throw new HealthException("\u8be5\u884c\u653f\u533a\u5212\u5df2\u4e0d\u5b58\u5728");
        }
        if (area.getLevel() < 4) {
            throw new HealthException("\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
        }
        if (!Objects.equals(param.getIsOnlineSpecialTestUser(), Boolean.TRUE) && !Objects.equals((companySuperviseModel = this.companyProvideBySuperviseService.getCompanyInfoById(param.getId())).getAreaId(), area.getAreaId())) {
            throw new HealthException("\u60a8\u4ec5\u80fd\u4fee\u6539\u5f53\u524d\u4f01\u4e1a\u6240\u5728\u8857\u9053");
        }
        CompanySuperviseModel c = new CompanySuperviseModel();
        c.setId(param.getId());
        c.setName(param.getName());
        c.setUnifiedSocialCc(param.getUnifiedSocialCc());
        c.setAreaDetailId(param.getDetailAreaId());
        c.setBelongType(param.getBelongType());
        c.setIsTest(param.getIsTest());
        c.setSuperviseIsHide(param.getSuperviseIsHide());
        c.setIndustryCategory(param.getIndustryCategory());
        this.setSupervisionInfo(c, area);
        this.companyProvideBySuperviseService.updateCompanyAndCompanySuperviseByOne(c, param.getLoginUserId());
        return Boolean.TRUE;
    }

    private void setSupervisionInfo(CompanySuperviseModel c, AreaModel area) {
        Long areaId;
        if (Objects.equals(c.getBelongType(), CompanyBelongTypeEnum.SHI.getValue())) {
            areaId = area.getCityId();
        } else if (Objects.equals(c.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue())) {
            areaId = area.getProvinceId();
        } else {
            areaId = area.getAreaId();
            c.setBelongType(CompanyBelongTypeEnum.NO.getValue());
        }
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        if (Objects.nonNull(org)) {
            c.setSupervisionUnit(org.getId());
            c.setSupervisionAreaId(org.getAreaId());
        }
    }

    @Transactional
    public Boolean changeBusinessState(Long cid, Byte businessState, Long loginUserId) {
        CompanySuperviseModel c = new CompanySuperviseModel();
        c.setId(cid);
        c.setBusinessState(businessState);
        c.setBusinessUpdateTime(new Date());
        if (Objects.equals(businessState, CompanyBusinessState.CLOSE.getCode().byteValue())) {
            this.sysUserThirdService.disableOrEnableUserByCid(cid, Integer.valueOf(1), loginUserId);
        } else if (Objects.equals(businessState, CompanyBusinessState.NORMAL.getCode().byteValue())) {
            CompanySuperviseModel company;
            List companyList = this.companyProvideBySuperviseService.getOnlyCompanySuperviseByCidExcludeDelete(Collections.singletonList(cid));
            if (CollUtil.isNotEmpty((Collection)companyList) && Objects.nonNull(company = (CompanySuperviseModel)companyList.get(0)) && Objects.equals(company.getIrsBusinessState(), (byte)0)) {
                throw new HealthException("\u8be5\u4f01\u4e1a\u5728\u5de5\u5546\u6570\u636e\u4e2d\u5df2\u6ce8\u9500\uff0c\u65e0\u6cd5\u53d8\u66f4\u8425\u4e1a\u72b6\u6001\uff01");
            }
            this.sysUserThirdService.disableOrEnableUserByCid(cid, Integer.valueOf(0), loginUserId);
        }
        this.companyProvideBySuperviseService.updateCompanyAndCompanySuperviseByOne(c, loginUserId);
        this.companyGradeV3RefreshService.refreshCompanyGradeByCid(cid, CompanyGradeEventSource.COMPANYCHANGE);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean bestCompany(CompanyUserV3BestParam param) {
        if (CollUtil.isEmpty((Collection)param.getIdList()) || Objects.isNull(param.getBest())) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        try {
            String ids = param.getIdList().stream().map(Object::toString).collect(Collectors.joining(","));
            if (Boolean.TRUE.equals(param.getBest())) {
                this.companyProvideBySuperviseService.bestCompanyByIds(ids, param.getLoginUserId());
            } else {
                this.companyProvideBySuperviseService.cancelBestCompany((Long)param.getIdList().get(0), param.getLoginUserId());
            }
            this.companyHsePreventionControlSelfJudgeService.checkAndChangeSelfLevel(ids, param.getBest());
            Set cidSet = CommonUtil.str2LongSet((String)ids, (String)",");
            if (CollectionUtils.isNotEmpty((Collection)cidSet)) {
                this.companyGradeV3RefreshService.refreshCompanyGradeByCids(new ArrayList(cidSet), CompanyGradeEventSource.BESTCHANGE);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u6574\u5065\u5eb7\u4f01\u4e1a\u5931\u8d25", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Transactional
    public Boolean delete(List<Long> cidList, Long loginUserId) {
        if (CollUtil.isEmpty(cidList)) {
            return Boolean.FALSE;
        }
        this.companyProvideBySuperviseService.delCompanyByIds(cidList.stream().map(Object::toString).collect(Collectors.joining(",")), CompanyDelReasonEnum.OTHER.getCode(), "\u6765\u81ea\u6d59\u91cc\u536b\u4f01\u5728\u7ebf\u57f9\u8bad\u7684\u5220\u9664\u64cd\u4f5c");
        this.sysUserThirdService.deleteUserByCid(cidList, loginUserId);
        this.dyCompanyProviderService.updateIsStoreSet0(cidList);
        return Boolean.TRUE;
    }

    public Map<Long, String> getOperators(List<Long> updateByList) {
        HashMap<Long, String> operatorMap = new HashMap<Long, String>();
        operatorMap.put(Constants.SYSTEM_AUTOMATIC_CONFIRMATION_KEY, "\u7cfb\u7edf\u81ea\u52a8\u786e\u8ba4");
        updateByList.remove(Constants.SYSTEM_AUTOMATIC_CONFIRMATION_KEY);
        Map userWithOrgV3VoMap = this.organizationUserService.getUserInfoMapByIdList(updateByList);
        if (MapUtils.isNotEmpty((Map)userWithOrgV3VoMap)) {
            userWithOrgV3VoMap.forEach((k, v) -> operatorMap.put((Long)k, v.getFullName() != null ? v.getFullName() : v.getUsername()));
        }
        updateByList.removeAll(userWithOrgV3VoMap.keySet());
        if (CollectionUtils.isEmpty(updateByList)) {
            return operatorMap;
        }
        List sysUsers = this.sysUserThirdService.listUserNameByStaffIds(updateByList);
        if (CollectionUtils.isNotEmpty((Collection)sysUsers)) {
            for (SysUser sysUser : sysUsers) {
                operatorMap.put(sysUser.getId(), sysUser.getUsername());
            }
        }
        return operatorMap;
    }

    public List<Long> getNoSupervisionUnitCompany(CompanySuperviseSearchModel companySearchVo) {
        return this.companyDcMapper.getNoSupervisionUnitCompany(companySearchVo);
    }

    @Transactional
    public List<Long> updateCompanyIndustryByCheck(List<Long> cidList) {
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        List<RecordOperationLog> logList = ((CompanyMapper)this.dao).getNeedUpdateCompanyIndustry(cidList);
        if (CollUtil.isNotEmpty(logList)) {
            for (RecordOperationLog recordOperationLog : logList) {
                if (recordOperationLog == null) continue;
                recordOperationLog.setAfterInfo(this.convertSpecialCode(recordOperationLog.getAfterInfo()));
                recordOperationLog.setId(Long.valueOf(this.idworker.nextId()));
                recordOperationLog.setTableName("company");
                recordOperationLog.setLogTitle("\u7531" + recordOperationLog.getBeforeInfo() + "\u53d8\u66f4\u4e3a" + recordOperationLog.getAfterInfo());
                recordOperationLog.setChangeField("industry_category");
                recordOperationLog.setLogType(Integer.valueOf(1));
                recordOperationLog.setBusiType(Byte.valueOf((byte)8));
                recordOperationLog.setCreateDate(new Date());
                recordOperationLog.setCreateBy(Long.valueOf(16509627617542234L));
                recordOperationLog.setCreateByName("\u5168\u6d41\u7a0b\u68c0\u6d4b\u7cfb\u7edf");
                recordOperationLog.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            }
            RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
            ((CompanyMapper)this.dao).updateCompanyIndustryByCheck(logList);
            ((CompanyMapper)this.dao).insertRecordOperationLog(logList);
            List<Long> changeCidList = logList.stream().filter(log -> log.getCompanyId() != null).map(log -> log.getCompanyId()).collect(Collectors.toList());
            return changeCidList;
        }
        this.logger.error("\u6839\u636e\u68c0\u6d4b\u6570\u636e\u4fee\u6539\u884c\u4e1a\u7c7b\u578b--\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u4f01\u4e1a");
        return null;
    }

    public Map<String, String> getIndustryUpdateLog(Long cid) {
        RecordOperationLog logLatest;
        HashMap<String, String> map = new HashMap<String, String>();
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company != null && company.getIndustryCategory() != null) {
            map.put("industryCategory", company.getIndustryCategory().toString());
        }
        if ((logLatest = ((CompanyMapper)this.dao).getIndustryUpdateLog(cid)) != null && logLatest.getCreateBy() != null && logLatest.getCreateBy().equals(16509627617542234L)) {
            map.put("isQuanLiuCheng", "true");
        } else {
            map.put("isQuanLiuCheng", "false");
        }
        return map;
    }

    @Transactional(readOnly=false)
    public void addCompanyStorageFiles(String files, Long cid, Long userId) {
        if (StringUtils.isBlank((CharSequence)files) || Objects.isNull(cid)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        String[] split = files.split(",");
        if (split.length > 3) {
            throw new HealthException("\u6700\u591a\u4e0a\u4f20\u4e09\u5f20\u7167\u7247");
        }
        Set<String> allowedTypes = Set.of("png", "jpg", "jpeg", "pdf");
        String result = this.sysFileService.checkFileType(files, allowedTypes);
        if (result != null) {
            throw new HealthException(result);
        }
        CompanyBaseInfoModel companyBaseInfoModel = new CompanyBaseInfoModel();
        companyBaseInfoModel.setCid(cid);
        companyBaseInfoModel.setStorageFiles(files);
        this.companyStorageProvideService.saveOrUpdateCompanyStorage(companyBaseInfoModel, userId);
    }

    @Transactional
    public void changeGradeReason(String files, Long cid, Integer gradeReason, Long loginUserId) throws Exception {
        String[] split;
        if (Objects.isNull(cid) || ObjectUtil.isNull((Object)gradeReason)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        if (!(CompanyGradeReasonEnum.REPORTCOMPLAINTS.getValue().equals(gradeReason) || CompanyGradeReasonEnum.STATUTORYREPORTING.getValue().equals(gradeReason) || CompanyGradeReasonEnum.OTHERCASESINVOLVED.getValue().equals(gradeReason))) {
            throw new HealthException("\u5165\u5e93\u539f\u56e0\u53ea\u80fd\u9009\u62e9\uff1a\u4e3e\u62a5\u6295\u8bc9\u3001\u6cd5\u5b9a\u4e0a\u62a5\u3001\u5176\u4ed6\u6d89\u6848");
        }
        if (StringUtils.isNotEmpty((CharSequence)files) && (split = files.split(",")).length > 3) {
            throw new HealthException("\u6700\u591a\u4e0a\u4f20\u4e09\u5f20\u7167\u7247");
        }
        CompanyBaseInfoModel companyBaseInfoModel = new CompanyBaseInfoModel();
        companyBaseInfoModel.setCid(cid);
        companyBaseInfoModel.setStorageFiles(files);
        companyBaseInfoModel.setStorageReason(gradeReason);
        this.companyStorageProvideService.saveOrUpdateCompanyStorage(companyBaseInfoModel, loginUserId);
        this.companyProvideBySuperviseService.updateCompanyGradeReason(cid, gradeReason, null, loginUserId);
        this.companyBaseDcInfoService.updateChuangdePushInfoByCid(Arrays.asList(cid));
    }

    private void enrichCompanyUserInfo(List<CompanyUserV3ListVo> rst, CompanyUserV3ListParam param) {
        if (CollUtil.isNotEmpty(rst)) {
            CompletionStage mapFuture1 = CompletableFuture.supplyAsync(() -> {
                Map<Object, Object> areaMap = new HashMap();
                String areaIdList = rst.stream().map(CompanyUserV3ListVo::getDetailAreaId).map(String::valueOf).collect(Collectors.joining(","));
                List areaList = this.sysAreaProvideService.getAreaListByIds(areaIdList);
                if (CollUtil.isNotEmpty((Collection)areaList)) {
                    areaMap = areaList.stream().collect(Collectors.toMap(AreaModel::getId, item -> item, (v1, v2) -> v1));
                }
                return areaMap;
            }, (Executor)this.threadPoolTaskExecutor).exceptionally(e -> {
                this.logger.error("\u5931\u8d25\uff0c", e);
                return new HashMap();
            });
            CompletionStage mapFuture2 = CompletableFuture.supplyAsync(() -> this.organizationService.getOrgMapByIdList(rst.stream().map(CompanyUserV3ListVo::getSupervisionUnit).collect(Collectors.toSet())), (Executor)this.threadPoolTaskExecutor).exceptionally(e -> {
                this.logger.error("\u5931\u8d25\uff0c", e);
                return new HashMap();
            });
            CompletionStage mapFuture3 = CompletableFuture.supplyAsync(() -> this.sysParamProvideService.getParamMap(), (Executor)this.threadPoolTaskExecutor).exceptionally(e -> {
                this.logger.error("\u5931\u8d25\uff0c", e);
                return new HashMap();
            });
            CompletionStage mapFuture4 = CompletableFuture.supplyAsync(() -> {
                List industryList = this.industryProvideService.getIndustryByIds(rst.stream().map(i -> String.valueOf(i.getIndustryCategory())).collect(Collectors.joining(",")));
                return industryList.stream().collect(Collectors.toMap(IndustryModel::getId, IndustryModel::getName, (v1, v2) -> v1));
            }, (Executor)this.threadPoolTaskExecutor).exceptionally(e -> {
                this.logger.error("\u5931\u8d25\uff0c", e);
                return new HashMap();
            });
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(new CompletableFuture[]{mapFuture1, mapFuture2, mapFuture3, mapFuture4});
            allFutures.join();
            Map areaMap = (Map)((CompletableFuture)mapFuture1).join();
            Map orgMap = (Map)((CompletableFuture)mapFuture2).join();
            Map paramMap = (Map)((CompletableFuture)mapFuture3).join();
            Map industryMap = (Map)((CompletableFuture)mapFuture4).join();
            HashMap<Long, CompanyHsePreventionControlSelfJudge> selfJudgeMap = new HashMap<Long, CompanyHsePreventionControlSelfJudge>();
            if (Objects.equals(param.getSystemDeploymentSource(), SystemDeploymentSourceEnum.NO.getCode())) {
                List cids = rst.stream().map(CompanyUserV3ListVo::getId).collect(Collectors.toList());
                selfJudgeMap.putAll(this.companyBaseDcInfoService.getSelfReportPassByCids(cids).stream().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getCid, c -> c, (c1, c2) -> c1)));
            }
            for (CompanyUserV3ListVo row : rst) {
                String name;
                if (Objects.nonNull(row.getDetailAreaId())) {
                    row.setDetailAreaName(areaMap.getOrDefault(row.getDetailAreaId(), this.protoArea).getFullname(">"));
                }
                if (Objects.nonNull(row.getSupervisionUnit())) {
                    row.setSupervisionUnitName(orgMap.getOrDefault(row.getSupervisionUnit(), this.protoOrg).getName());
                }
                if (Objects.nonNull(row.getRegisterType())) {
                    row.setRegisterTypeName(paramMap.getOrDefault(row.getRegisterType(), this.protoSysParam).getParamValue());
                }
                if (Objects.nonNull(row.getIndustryCategory())) {
                    row.setIndustryCategoryName(industryMap.getOrDefault(row.getIndustryCategory(), ""));
                }
                if (!Objects.equals(param.getSystemDeploymentSource(), SystemDeploymentSourceEnum.NO.getCode())) continue;
                if (ObjectUtil.isNull((Object)row.getIsUpload()) || row.getIsUpload().booleanValue()) {
                    Date date;
                    long l;
                    long day;
                    Date createDate;
                    if (StringUtils.isNotBlank((CharSequence)row.getStorageFiles())) {
                        String[] fileIds = row.getStorageFiles().split(",");
                        ArrayList<SysFileModel> storageFileList = new ArrayList<SysFileModel>();
                        for (String fileId : fileIds) {
                            if (!fileId.chars().allMatch(Character::isDigit)) continue;
                            SysFileModel file = this.sysFileService.getFileById(Long.valueOf(Long.parseLong(fileId)));
                            storageFileList.add(file);
                        }
                        row.setStorageFileList(storageFileList);
                    } else if (Objects.nonNull(row.getStorageReason()) && (CompanyGradeReasonEnum.REPORTCOMPLAINTS.getValue().equals(row.getStorageReason()) || CompanyGradeReasonEnum.STATUTORYREPORTING.getValue().equals(row.getStorageReason()) || CompanyGradeReasonEnum.OTHERCASESINVOLVED.getValue().equals(row.getStorageReason())) && (createDate = row.getCreateDate()) != null && (day = (l = (date = new Date()).getTime() - createDate.getTime()) / 86400000L) >= 7L) {
                        row.setIsStorageFiles(Boolean.valueOf(true));
                    }
                }
                if (!Objects.nonNull(row.getStorageReason())) continue;
                Year year = Year.now();
                String currentYear = year.toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                if (CompanyGradeReasonEnum.DECLARATIONIMPORT.getValue().equals(row.getStorageReason()) && ObjectUtil.isNotNull((Object)row.getStorageDate()) && sdf.format(row.getStorageDate()).equals(currentYear) && ObjectUtil.isNull(selfJudgeMap.get(row.getId()))) {
                    row.setIsAbleChange(Boolean.valueOf(true));
                }
                if (!StringUtils.isNotEmpty((CharSequence)(name = CompanyGradeReasonEnum.getName((Integer)row.getStorageReason())))) continue;
                row.setStorageReasonName(name);
            }
        }
    }

    public String convertSpecialCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return code;
        }
        if (code.equals("2572")) {
            return "2571";
        }
        if (code.equals("4335")) {
            return "2571";
        }
        if (code.equals("2573")) {
            return "2571";
        }
        if (code.equals("4336")) {
            return "2571";
        }
        if (code.equals("2588")) {
            return "2587";
        }
        if (code.equals("4337")) {
            return "2587";
        }
        if (code.equals("2589")) {
            return "2587";
        }
        if (code.equals("4338")) {
            return "2587";
        }
        if (code.equals("2849")) {
            return "2848";
        }
        if (code.equals("4339")) {
            return "2848";
        }
        if (code.equals("3416")) {
            return "3404";
        }
        if (code.equals("4340")) {
            return "3404";
        }
        if (code.equals("3420")) {
            return "3419";
        }
        if (code.equals("4341")) {
            return "3419";
        }
        if (code.equals("3421")) {
            return "3419";
        }
        if (code.equals("4342")) {
            return "3419";
        }
        if (code.equals("3422")) {
            return "3419";
        }
        if (code.equals("4343")) {
            return "3419";
        }
        return code;
    }

    private HomeIndexSearchVo setHomeIndexSearchVo(Long areaId, Byte areaLevel, Boolean isCurrent, Integer isFcImportanceCompany) {
        HomeIndexSearchVo searchVo = new HomeIndexSearchVo().setAreaId(areaId).setAreaLevel(areaLevel).setIsCurrent(isCurrent).setIsFcImportanceCompany(isFcImportanceCompany);
        if (searchVo.getAreaId() == null) {
            if (Objects.equals(searchVo.getAreaLevel(), (byte)1) || Objects.equals(searchVo.getAreaLevel(), (byte)2)) {
                searchVo.setBelongType(Integer.valueOf(searchVo.getAreaLevel().intValue()));
            } else {
                searchVo.setBelongType(Integer.valueOf(0));
            }
        } else {
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(searchVo.getAreaId());
            if (areaModel != null) {
                searchVo.setAreaLevel(areaModel.getLevel());
                searchVo.setAreaName(areaModel.getAreaName());
                if (Objects.equals(areaModel.getLevel(), (byte)1) || Objects.equals(areaModel.getLevel(), (byte)2)) {
                    searchVo.setBelongType(Integer.valueOf(areaModel.getLevel().intValue()));
                } else {
                    searchVo.setBelongType(Integer.valueOf(0));
                }
            }
        }
        return searchVo;
    }
}

