/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.enums.PickupCountSourceEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyVictimsInfo;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByVictimsInfoService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyHarmNumVo;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyPickupCountService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.util.common.ListUtils;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class CompanyPickupCountServiceImpl
implements ICompanyPickupCountService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyPickupCountServiceImpl.class);
    @Autowired
    ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService provideByHSEService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @DubboReference
    private IRiskExposeEvaluateService exposeEvaluateService;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByVictimsInfoService victimsInfoService;
    @Resource(name="gradeThreadPoolExecutor")
    private ExecutorService executorService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;

    public void handHarmNum(List<Long> cidParams) throws InterruptedException {
        CompletableFuture<List> companyGradeModelListFutrure = CompletableFuture.supplyAsync(() -> {
            List companyGradeModelList2 = this.companyProvideService.listComapnyGradeInfo(cidParams);
            return companyGradeModelList2;
        }, this.executorService);
        CompletableFuture<List> victimsInfosTempFutrure = CompletableFuture.supplyAsync(() -> {
            List victimsInfosTemp = this.victimsInfoService.listCompanyVictimsInfo(cidParams);
            return victimsInfosTemp;
        }, this.executorService);
        CompletableFuture.allOf(companyGradeModelListFutrure, victimsInfosTempFutrure).join();
        List companyGradeModelList = companyGradeModelListFutrure.get();
        if (CollectionUtils.isEmpty((Collection)companyGradeModelList)) {
            return;
        }
        List victimsInfos = victimsInfosTempFutrure.get();
        long jobId = XxlJobHelper.getJobId();
        if (jobId > 0L) {
            XxlJobHelper.log((String)"\u9700\u8981\u5904\u7406companyGradeModelList \u6570\uff1a{}", (Object[])new Object[]{companyGradeModelList.size()});
            XxlJobHelper.log((String)"\u9700\u8981\u5904\u7406victimsInfos \u6570\uff1a{}", (Object[])new Object[]{victimsInfos.size()});
        }
        List riskHarmList = Collections.synchronizedList(new ArrayList());
        HashMap victimsInfoMap = victimsInfos == null ? new HashMap() : victimsInfos.stream().collect(Collectors.toMap(CompanyVictimsInfo::getCid, Function.identity(), (v1, v2) -> v1));
        List cidListTemp = companyGradeModelList.stream().map(CompanyGradeModel::getCid).collect(Collectors.toList());
        List cidSplitList = ListUtils.split(cidListTemp, (int)1000);
        if (CollectionUtils.isNotEmpty((Collection)cidSplitList)) {
            CompletableFuture[] futures = (CompletableFuture[])cidSplitList.stream().map(cidSplit -> CompletableFuture.runAsync(() -> {
                List touchHarmPeopleNumber;
                List collect;
                if (CollectionUtils.isNotEmpty((Collection)cidSplit) && CollectionUtils.isNotEmpty(collect = (touchHarmPeopleNumber = this.exposeEvaluateService.getTouchHarmPeopleNumber(cidSplit)).stream().map(t -> {
                    CompanyHarmNumVo chv = new CompanyHarmNumVo();
                    chv.setCid(t.getCid());
                    chv.setHarmNum(t.getWorkNum());
                    chv.setUpdateDate(cn.smarthse.util.common.date.DateUtils.getDate((LocalDateTime)t.getLastDate()));
                    chv.setRiskId(t.getId());
                    chv.setRiskCreateDate(cn.smarthse.util.common.date.DateUtils.getDate((LocalDateTime)t.getCreateDate()));
                    return chv;
                }).collect(Collectors.toList()))) {
                    riskHarmList.addAll(collect);
                }
            }, this.executorService)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
        }
        if (jobId > 0L) {
            XxlJobHelper.log((String)"\u52a0\u8f7driskHarmList \u6570\uff1a{}", (Object[])new Object[]{riskHarmList.size()});
        }
        Map<Long, CompanyHarmNumVo> riskHarmMap = riskHarmList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        List result = Collections.synchronizedList(new ArrayList());
        List victimRecList = Collections.synchronizedList(new ArrayList());
        List invalidCidList = Collections.synchronizedList(new ArrayList());
        companyGradeModelList.parallelStream().forEach(companyGrade -> {
            Long cid = companyGrade.getCid();
            CompanyVictimsInfo victimRec = new CompanyVictimsInfo();
            victimRec.setCid(cid);
            victimRec.setForceUpdateInfoPickupCount(true);
            victimRec.setForceUpdateInfoPickupDate(true);
            victimRec.setForceUpdateDecPickupCount(true);
            victimRec.setForceUpdateDecPickupDate(true);
            victimRec.setForceUpdateRiskId(true);
            victimRec.setForceUpdateRiskPickupCount(true);
            victimRec.setForceUpdateRiskPickupDate(true);
            victimRecList.add(victimRec);
            CompanyHarmNumVo riskInfoHarm = (CompanyHarmNumVo)riskHarmMap.get(cid);
            if (riskInfoHarm != null) {
                victimRec.setRiskId(riskInfoHarm.getRiskId());
                victimRec.setRiskPickupCount(riskInfoHarm.getHarmNum());
                victimRec.setRiskPickupDate(riskInfoHarm.getUpdateDate());
                victimRec.setRiskCreateDate(riskInfoHarm.getRiskCreateDate());
                riskInfoHarm.setSource(PickupCountSourceEnum.riskInfo.getCode());
            }
            CompanySuperviseModel cm = new CompanySuperviseModel();
            if (riskInfoHarm != null) {
                CompanyHarmNumVo companyHarmNumVo = riskInfoHarm;
                cm.setCid(companyHarmNumVo.getCid());
                cm.setId(companyHarmNumVo.getCid());
                cm.setPickupCount(companyHarmNumVo.getHarmNum());
                if (companyGrade.getVictimsIdentify() != null && companyGrade.getVictimsIdentify() > 0) {
                    Date dbIdentifyTime;
                    CompanyVictimsInfo companyVictimsInfo;
                    cm.setPickupCountSource(PickupCountSourceEnum.supervise.getCode());
                    Integer harmSource = companyHarmNumVo.getSource();
                    Integer harmNum = companyHarmNumVo.getHarmNum();
                    Long riskId = companyHarmNumVo.getRiskId();
                    if (Objects.equals(companyGrade.getVictimsIdentify(), 1) && Objects.equals(harmSource, PickupCountSourceEnum.riskInfo.getCode()) && harmNum != null && harmNum > 2 && (companyVictimsInfo = (CompanyVictimsInfo)victimsInfoMap.get(cid)) != null && (dbIdentifyTime = companyVictimsInfo.getIdentifyTime()) != null && companyHarmNumVo.getRiskCreateDate() != null && dbIdentifyTime.getTime() < companyHarmNumVo.getRiskCreateDate().getTime()) {
                        cm.setPickupCountSource(PickupCountSourceEnum.riskInfo.getCode());
                        victimRec.setIdentifyInvalidTime(new Date());
                        invalidCidList.add(cid);
                    }
                } else {
                    cm.setPickupCountSource(companyHarmNumVo.getSource());
                }
            } else {
                cm.setCid(cid);
                cm.setId(cid);
                cm.setPickupCount(null);
                if (companyGrade.getVictimsIdentify() != null && companyGrade.getVictimsIdentify() > 0) {
                    cm.setPickupCountSource(PickupCountSourceEnum.supervise.getCode());
                } else {
                    cm.setPickupCountSource(PickupCountSourceEnum.none.getCode());
                }
            }
            victimRec.setPickupCount(cm.getPickupCount());
            victimRec.setPickupCountSource(cm.getPickupCountSource());
            result.add(cm);
        });
        if (jobId > 0L) {
            XxlJobHelper.log((String)"\u9700\u66f4\u65b0victimRecList \u6570\uff1a{}", (Object[])new Object[]{victimRecList.size()});
        }
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        this.victimsInfoService.saveCompanyVictimsInfoList(victimRecList);
        if (jobId > 0L) {
            XxlJobHelper.log((String)"\u9700\u66f4\u65b0result \u6570\uff1a{}", (Object[])new Object[]{result.size()});
        }
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        this.provideByHSEService.batchUpdatePickupCount(result);
        if (jobId > 0L) {
            XxlJobHelper.log((String)"\u9700\u66f4\u65b0invalidCidList \u6570\uff1a{}", (Object[])new Object[]{invalidCidList.size()});
        }
        this.companyProvideBySuperviseService.updateVictimsIdentifyIds(invalidCidList, Integer.valueOf(0));
    }

    public void handHarmNum2(Long cidParam) {
        List declareHarmInfoList = this.gradeV3RecService.listAllCompanyDeclareInfo(Arrays.asList(cidParam));
        List reportInfoHarmList = this.gradeV3RecService.listAllCompanyReportInfo(Arrays.asList(cidParam));
        log.info("\u83b7\u53d6\u7533\u62a5\u6570\u636e{}\u6761", (Object)declareHarmInfoList.size());
        log.info("\u83b7\u53d6\u7f16\u8f91\u7684\u7ed3\u679c{}\u6761", (Object)reportInfoHarmList.size());
        Map<Long, CompanyHarmNumVo> declareHarmInfoMap = declareHarmInfoList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        Map<Long, CompanyHarmNumVo> reportInfoHarmMap = reportInfoHarmList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        List riskHarmList = Collections.synchronizedList(new ArrayList());
        List<CompanyGradeModel> companyGradeModelList = new ArrayList();
        if (cidParam == null) {
            companyGradeModelList = this.companyProvideService.listComapnyGradeInfo(null);
            List cidListTemp = companyGradeModelList.stream().map(CompanyGradeModel::getCid).collect(Collectors.toList());
            List cidSplitList = ListUtils.split(cidListTemp, (int)1000);
            for (List cidList : cidSplitList) {
                List touchHarmPeopleNumber = this.exposeEvaluateService.getTouchHarmPeopleNumber(cidList);
                List collect = touchHarmPeopleNumber.stream().map(t -> {
                    CompanyHarmNumVo chv = new CompanyHarmNumVo();
                    chv.setCid(t.getCid());
                    chv.setHarmNum(t.getWorkNum());
                    chv.setUpdateDate(cn.smarthse.util.common.date.DateUtils.getDate((LocalDateTime)t.getLastDate()));
                    return chv;
                }).collect(Collectors.toList());
                riskHarmList.addAll(collect);
            }
        } else {
            List touchHarmPeopleNumber = this.exposeEvaluateService.getTouchHarmPeopleNumber(Arrays.asList(cidParam));
            if (CollectionUtils.isNotEmpty((Collection)touchHarmPeopleNumber)) {
                List collect = touchHarmPeopleNumber.stream().map(t -> {
                    CompanyHarmNumVo chv = new CompanyHarmNumVo();
                    chv.setCid(t.getCid());
                    chv.setHarmNum(t.getWorkNum());
                    chv.setUpdateDate(cn.smarthse.util.common.date.DateUtils.getDate((LocalDateTime)t.getLastDate()));
                    return chv;
                }).collect(Collectors.toList());
                riskHarmList.addAll(collect);
            }
            CompanyGradeModel cgm = new CompanyGradeModel();
            cgm.setCid(cidParam);
            companyGradeModelList.add(cgm);
        }
        log.info("\u603b\u5171\u83b7\u53d6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u4e00\u89c8\u8868\u7684\u7ed3\u679c{}\u6761", (Object)riskHarmList.size());
        Map<Long, CompanyHarmNumVo> riskHarmMap = riskHarmList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        List result = Collections.synchronizedList(new ArrayList());
        companyGradeModelList.parallelStream().forEach(companyGrade -> {
            List<CompanyHarmNumVo> companyHarmNumVos;
            Long cid = companyGrade.getCid();
            CompanyHarmNumVo declareHarmInfo = (CompanyHarmNumVo)declareHarmInfoMap.get(cid);
            CompanyHarmNumVo reportInfoHarm = (CompanyHarmNumVo)reportInfoHarmMap.get(cid);
            CompanyHarmNumVo riskInfoHarm = (CompanyHarmNumVo)riskHarmMap.get(cid);
            if (declareHarmInfo != null && declareHarmInfo.getHarmNum() == 0) {
                declareHarmInfo = null;
            }
            if (CollectionUtils.isNotEmpty(companyHarmNumVos = CompanyPickupCountServiceImpl.sortCompanyHarmNumVo(declareHarmInfo, riskInfoHarm, reportInfoHarm))) {
                CompanyHarmNumVo companyHarmNumVo = companyHarmNumVos.get(0);
                CompanySuperviseModel cm = new CompanySuperviseModel();
                cm.setCid(companyHarmNumVo.getCid());
                cm.setId(companyHarmNumVo.getCid());
                cm.setPickupCount(companyHarmNumVo.getHarmNum());
                result.add(cm);
            } else {
                CompanySuperviseModel cm = new CompanySuperviseModel();
                cm.setCid(cid);
                cm.setId(cid);
                cm.setPickupCount(null);
                result.add(cm);
            }
        });
        log.info("\u9700\u66f4\u65b0\u4f01\u4e1a\u63a5\u5bb3\u4eba\u6570\uff1a{}\u6761", (Object)result.size());
        this.provideByHSEService.batchUpdatePickupCount(result);
    }

    private static List<CompanyHarmNumVo> sortCompanyHarmNumVo(CompanyHarmNumVo ... list) {
        if (ArrayUtils.isNotEmpty((Object[])list)) {
            List<CompanyHarmNumVo> collect = Arrays.stream(list).filter(f -> f != null && f.getHarmNum() != null).sorted((v1, v2) -> {
                if (v1.getUpdateDate() == null && v2.getUpdateDate() == null) {
                    return 0;
                }
                if (v1.getUpdateDate() == null && v2.getUpdateDate() != null) {
                    return 1;
                }
                if (v1.getUpdateDate() != null && v2.getUpdateDate() == null) {
                    return -1;
                }
                if (DateUtils.getYear((Date)v1.getUpdateDate()) > DateUtils.getYear((Date)v2.getUpdateDate())) {
                    return -1;
                }
                return 0;
            }).collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    public void recordLastYearHarmNum(Long cidParam) {
        List declareHarmInfoList = this.gradeV3RecService.listAllCompanyDeclareInfo(Arrays.asList(cidParam));
        List reportInfoHarmList = this.gradeV3RecService.listAllCompanyReportInfo(Arrays.asList(cidParam));
        List systemHarmList = this.workRoleInfoService.getContactHazardsStaffNumByCid2(cidParam);
        log.info("\u83b7\u53d6\u7533\u62a5\u6570\u636e{}\u6761", (Object)declareHarmInfoList.size());
        log.info("\u83b7\u53d6\u7f16\u8f91\u7684\u7ed3\u679c{}\u6761", (Object)reportInfoHarmList.size());
        log.info("\u83b7\u53d6\u7cfb\u7edf\u4eba\u5458\u7ba1\u7406\u8868\u7684\u7ed3\u679c{}\u6761", (Object)systemHarmList.size());
        Map<Long, CompanyHarmNumVo> declareHarmInfoMap = declareHarmInfoList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        Map<Long, CompanyHarmNumVo> reportInfoHarmMap = reportInfoHarmList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        Map<Long, CompanyHarmNumVo> systemHarmMap = systemHarmList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        List riskHarmList = Collections.synchronizedList(new ArrayList());
        List<CompanyGradeModel> companyGradeModelList = new ArrayList();
        if (cidParam == null) {
            companyGradeModelList = this.companyProvideService.listComapnyGradeInfo(null);
            int splitSize = 1000;
            int maxSize = (companyGradeModelList.size() + splitSize - 1) / splitSize;
            List<CompanyGradeModel> finalCompanyGradeModelList = companyGradeModelList;
            List cidListList = ((Stream)Stream.iterate(0, n -> n + 1).limit(maxSize).parallel()).map(a -> finalCompanyGradeModelList.parallelStream().map(CompanyGradeModel::getCid).skip(a * splitSize).limit(splitSize).collect(Collectors.toList())).filter(b -> !b.isEmpty()).collect(Collectors.toList());
            cidListList.parallelStream().forEach(cidList -> {
                List touchHarmPeopleNumber = this.exposeEvaluateService.getTouchHarmPeopleNumber(cidList);
                if (CollectionUtils.isNotEmpty((Collection)touchHarmPeopleNumber)) {
                    List collect = touchHarmPeopleNumber.stream().map(t -> {
                        CompanyHarmNumVo chv = new CompanyHarmNumVo();
                        chv.setCid(t.getCid());
                        chv.setHarmNum(t.getWorkNum());
                        chv.setUpdateDate(cn.smarthse.util.common.date.DateUtils.getDate((LocalDateTime)t.getLastDate()));
                        return chv;
                    }).collect(Collectors.toList());
                    riskHarmList.addAll(collect);
                }
            });
        } else {
            List touchHarmPeopleNumber = this.exposeEvaluateService.getTouchHarmPeopleNumber(Arrays.asList(cidParam));
            if (CollectionUtils.isNotEmpty((Collection)touchHarmPeopleNumber)) {
                List collect = touchHarmPeopleNumber.stream().map(t -> {
                    CompanyHarmNumVo chv = new CompanyHarmNumVo();
                    chv.setCid(t.getCid());
                    chv.setHarmNum(t.getWorkNum());
                    chv.setUpdateDate(cn.smarthse.util.common.date.DateUtils.getDate((LocalDateTime)t.getLastDate()));
                    return chv;
                }).collect(Collectors.toList());
                riskHarmList.addAll(collect);
            }
            CompanyGradeModel cgm = new CompanyGradeModel();
            cgm.setCid(cidParam);
            companyGradeModelList.add(cgm);
        }
        log.info("\u603b\u5171\u83b7\u53d6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u4e00\u89c8\u8868\u7684\u7ed3\u679c{}\u6761", (Object)riskHarmList.size());
        Map<Long, CompanyHarmNumVo> riskHarmMap = riskHarmList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
        List result = Collections.synchronizedList(new ArrayList());
        companyGradeModelList.parallelStream().forEach(companyGrade -> {
            HashMap<String, String> map;
            Long cid = companyGrade.getCid();
            CompanyHarmNumVo declareHarmInfo = (CompanyHarmNumVo)declareHarmInfoMap.get(cid);
            CompanyHarmNumVo reportInfoHarm = (CompanyHarmNumVo)reportInfoHarmMap.get(cid);
            CompanyHarmNumVo riskInfoHarm = (CompanyHarmNumVo)riskHarmMap.get(cid);
            CompanyHarmNumVo systemHarm = (CompanyHarmNumVo)systemHarmMap.get(cid);
            ArrayList mapList = new ArrayList();
            if (declareHarmInfo != null && declareHarmInfo.getHarmNum() != null && declareHarmInfo.getUpdateDate() != null) {
                map = new HashMap<String, String>();
                map.put("type", "\u4f9d\u636e\u7533\u62a5");
                map.put("number", declareHarmInfo.getHarmNum().toString());
                map.put("time", DateUtils.formatDate((Date)declareHarmInfo.getUpdateDate()));
                mapList.add(map);
            }
            if (reportInfoHarm != null && reportInfoHarm.getHarmNum() != null && reportInfoHarm.getUpdateDate() != null) {
                map = new HashMap();
                map.put("type", "\u4f9d\u636e\u57fa\u7840\u4fe1\u606f\u7f16\u8f91\u6570\u636e");
                map.put("number", reportInfoHarm.getHarmNum().toString());
                map.put("time", DateUtils.formatDate((Date)reportInfoHarm.getUpdateDate()));
                mapList.add(map);
            }
            if (riskInfoHarm != null && riskInfoHarm.getHarmNum() != null && riskInfoHarm.getUpdateDate() != null) {
                map = new HashMap();
                map.put("type", "\u4f9d\u636e\u68c0\u6d4b\u6570\u636e");
                map.put("number", riskInfoHarm.getHarmNum().toString());
                map.put("time", DateUtils.formatDate((Date)riskInfoHarm.getUpdateDate()));
                mapList.add(map);
            }
            if (systemHarm != null && systemHarm.getHarmNum() != null) {
                map = new HashMap();
                map.put("type", "\u4f9d\u636e\u7cfb\u7edf\u4eba\u5458\u7ba1\u7406\u8868");
                map.put("number", systemHarm.getHarmNum().toString());
                map.put("time", DateUtils.formatDate((Date)systemHarm.getUpdateDate()));
                mapList.add(map);
            }
            if (!mapList.isEmpty()) {
                String harmNum = JSONObject.toJSONString(mapList);
                CompanySuperviseModel companySuperviseModel = new CompanySuperviseModel();
                companySuperviseModel.setId(cid);
                companySuperviseModel.setLastYearPickupCount(harmNum);
                result.add(companySuperviseModel);
            }
        });
        log.info("\u9700\u66f4\u65b0\u4f01\u4e1a\u63a5\u5bb3\u4eba\u6570\uff1a{}\u6761", (Object)result.size());
        List list = ListUtils.split(result, (int)1000);
        for (List modelList : list) {
            this.gradeV3RecService.batchUpdateLastYearPickupCount(modelList);
        }
    }
}

