/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.enums.company.FunOrgMemberTypeEnum;
import cn.smarthse.modules.health.enums.company.FunOrgTypeEnum;
import cn.smarthse.modules.health.supervise.dao.company.CompanyFunctionalOrganizationMapper;
import cn.smarthse.modules.health.supervise.dao.company.CompanyFunctionalOrganizationMemberMapper;
import cn.smarthse.modules.health.supervise.entity.company.CompanyFunOrgInfo;
import cn.smarthse.modules.health.supervise.service.company.ICompanyFunOrgService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
public class CompanyFunOrgMemberServiceImpl
extends BaseServiceImpl<CompanyFunctionalOrganizationMemberMapper, CompanyFunctionalOrganizationMember>
implements ICompanyFunOrgService {
    @Autowired
    CompanyFunctionalOrganizationMemberMapper companyFunctionalOrganizationMemberMapper;
    @Autowired
    CompanyFunctionalOrganizationMapper companyFunctionalOrganizationMapper;

    private CompanyFunctionalOrganization getCompanyFunOrgHSEByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        CompanyFunctionalOrganization record = new CompanyFunctionalOrganization();
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        record.setOrganizationType(FunOrgTypeEnum.occupationHealth.getCode());
        List list = this.companyFunctionalOrganizationMapper.select(record);
        if (list == null || list.isEmpty()) {
            return null;
        }
        CompanyFunctionalOrganization funOrg = (CompanyFunctionalOrganization)list.get(0);
        return funOrg;
    }

    public List<CompanyFunctionalOrganizationMember> getMemberListByCids(List<Long> cidList) {
        Example example = new Example(CompanyFunctionalOrganization.class);
        if (cidList == null || cidList.isEmpty()) {
            return Collections.emptyList();
        }
        for (Long cid : cidList) {
            example.or().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("organizationType", (Object)FunOrgTypeEnum.occupationHealth.getCode());
        }
        List list = this.companyFunctionalOrganizationMapper.selectByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        Example exampleMember = new Example(CompanyFunctionalOrganizationMember.class);
        for (CompanyFunctionalOrganization o : list) {
            exampleMember.or().andEqualTo("isValid", (Object)true).andEqualTo("companyFunctionalOrganizationId", (Object)o.getId());
        }
        List listMember = ((CompanyFunctionalOrganizationMemberMapper)this.dao).selectByExample(exampleMember);
        return listMember;
    }

    public List<CompanyFunctionalOrganizationMember> getMemberListByCid(Long cid) {
        CompanyFunctionalOrganization funOrg = this.getCompanyFunOrgHSEByCid(cid);
        if (funOrg == null) {
            return Collections.emptyList();
        }
        return this.getMemberListByOrgId(funOrg.getId());
    }

    private List<CompanyFunctionalOrganizationMember> getMemberListByOrgId(Long orgId) {
        if (orgId == null) {
            return Collections.emptyList();
        }
        CompanyFunctionalOrganizationMember member = new CompanyFunctionalOrganizationMember();
        member.setCompanyFunctionalOrganizationId(orgId);
        member.setIsValid(Boolean.valueOf(true));
        List members = ((CompanyFunctionalOrganizationMemberMapper)this.dao).select(member);
        return members;
    }

    public CompanyFunOrgInfo getCompanyFunOrgInfoByCid(Long cid) {
        CompanyFunctionalOrganization funOrg = this.getCompanyFunOrgHSEByCid(cid);
        CompanyFunOrgInfo orgInfo = new CompanyFunOrgInfo();
        if (funOrg == null) {
            return orgInfo;
        }
        orgInfo.setDirectorName(funOrg.getDirectorName());
        orgInfo.setTelephone(funOrg.getTelephone());
        List<CompanyFunctionalOrganizationMember> memberList = this.getMemberListByOrgId(funOrg.getId());
        int specialNum = 0;
        int sidelineNum = 0;
        for (CompanyFunctionalOrganizationMember m : memberList) {
            if (FunOrgMemberTypeEnum.special.getCode().equals(m.getMemberType())) {
                ++specialNum;
                continue;
            }
            if (!FunOrgMemberTypeEnum.sideline.getCode().equals(m.getMemberType())) continue;
            ++sidelineNum;
        }
        orgInfo.setMemberInfo("\u4e13\u804c\uff1a" + specialNum + "\u4eba,\u517c\u804c\uff1a" + sidelineNum + "\u4eba");
        return orgInfo;
    }

    @Transactional
    public int updateCompanyFunOrgDirectorInfo(String directorName, String directorTel, Long cid) {
        if (cid == null) {
            return 0;
        }
        directorName = directorName == null ? "" : directorName;
        directorTel = directorTel == null ? "" : directorTel;
        CompanyFunctionalOrganization funOrg = this.getCompanyFunOrgHSEByCid(cid);
        if (funOrg == null) {
            this.addDefaultFunOrg(cid, directorName, directorTel);
        } else {
            funOrg.setDirectorName(directorName);
            funOrg.setTelephone(directorTel);
            this.companyFunctionalOrganizationMapper.updateByPrimaryKey(funOrg);
        }
        return 1;
    }

    public List<CompanyFunctionalOrganization> addDefaultFunOrg(Long cid, String hseDirectorName, String hseDirectorTel) {
        ArrayList<CompanyFunctionalOrganization> funOrgList = new ArrayList<CompanyFunctionalOrganization>();
        for (FunOrgTypeEnum type : FunOrgTypeEnum.getValues()) {
            if (type.getCode().equals(FunOrgTypeEnum.custom.getCode())) continue;
            CompanyFunctionalOrganization funOrg = new CompanyFunctionalOrganization();
            funOrg.setCid(cid);
            if (FunOrgTypeEnum.occupationHealth.getCode().equals(type.getCode())) {
                if (StringUtils.isNotBlank((CharSequence)hseDirectorName)) {
                    funOrg.setDirectorName(hseDirectorName);
                }
                if (StringUtils.isNotBlank((CharSequence)hseDirectorTel)) {
                    if (hseDirectorTel.length() < 32) {
                        funOrg.setTelephone(hseDirectorTel);
                    } else {
                        funOrg.setTelephone(hseDirectorTel.substring(0, 32));
                    }
                }
            }
            funOrg.setOrganizationType(type.getCode());
            funOrg.setOrganizationName(type.getName());
            funOrg.setIsValid(Boolean.valueOf(true));
            ValidateUtil.valid((Object)funOrg, (String)"add");
            this.companyFunctionalOrganizationMapper.insert(funOrg);
            funOrgList.add(funOrg);
        }
        return funOrgList;
    }
}

