/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.companyoutpack.OutpackRelationDto;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.base.disease.Disease;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserVo;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.dao.check.SupervisePhcPhysicalOdMapper;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.check.CompanyCountInfo;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckAbnormalService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdImportService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.modules.health.supervise.service.companyoutpack.ICompanyOutpackService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.thirdOrganization.entity.sys.SysUser;
import cn.smarthse.modules.health.thirdOrganization.service.sys.ISysUserService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SupervisePhcPhysicalOdServiceImpl
implements ISupervisePhcPhysicalOdService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupervisePhcPhysicalOdServiceImpl.class);
    @Autowired
    protected IdWorker idworker;
    @Autowired
    SupervisePhcPhysicalOdMapper dao;
    @DubboReference
    IStaffInfoService staffInfoService;
    @Autowired
    ISuperviseCheckThirdOrganizationService checkThirdOrganizationService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    IDiseaseThirdService diseaseThirdService;
    @Autowired
    DataSourceTransactionManager txManager;
    @Autowired
    ISupervisePhcPhysicalOdImportService supervisePhcPhysicalOdImportService;
    @Autowired
    ISuperviseCheckThirdOrganizationService superviseCheckThirdOrganizationService;
    @Autowired
    ICompanyOutpackService companyOutpackService;
    @DubboReference
    IOrganizationUserService organizationUserService;
    @DubboReference
    IStaffBasicInfoService staffBasicInfoService;
    @DubboReference
    ISysUserService sysUserService;
    @Autowired
    IWorkOperateLogService workOperateLogService;
    @Autowired
    ISuperviseCheckAbnormalService superviseCheckAbnormalService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Long> companyMap = new HashMap<String, Long>(0);
    private volatile boolean isInitComMap = false;

    @PostConstruct
    public void initData() {
        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SupervisePhcPhysicalOdServiceImpl.this.logger.info("SupervisePhcPhysicalOdServiceImpl \u83b7\u53d6\u6240\u6709\u4f01\u4e1a");
                SupervisePhcPhysicalOdServiceImpl.this.isInitComMap = true;
                SupervisePhcPhysicalOdServiceImpl.this.logger.info("SupervisePhcPhysicalOdServiceImpl \u83b7\u53d6\u6240\u6709\u4f01\u4e1a\u5b8c\u6210");
            }
        }, 0L, 3600000L);
    }

    public PageInfo<PhcThirdOccupationalDiseaserVo> checkOdInfos(JqGridParam param, PhcThirdOccupationalDiseaserParamVo checkParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcThirdOccupationalDiseaserVo> list = this.checkOdInfoList(checkParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<PhcThirdOccupationalDiseaserVo> checkJdInfos(JqGridParam param, PhcThirdOccupationalDiseaserParamVo checkParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcThirdOccupationalDiseaserVo> list = this.checkJdInfoList(checkParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<PhcThirdOccupationalDiseaserVo> checkZdInfos(JqGridParam param, PhcThirdOccupationalDiseaserParamVo checkParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcThirdOccupationalDiseaserVo> list = this.checkZdInfoList(checkParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<PhcThirdOccupationalDiseaserVo> checkOdInfoList(PhcThirdOccupationalDiseaserParamVo param) {
        param.setKeywordEncrypt(param.getKeyword());
        List<PhcThirdOccupationalDiseaserVo> list = this.dao.checkOdInfoList(param);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setStaffName(SpringEncryptUtils.decrypt((String)l.getStaffName()));
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
            });
        }
        return list;
    }

    public List<PhcThirdOccupationalDiseaserVo> checkJdInfoList(PhcThirdOccupationalDiseaserParamVo param) {
        param.setKeywordEncrypt(param.getKeyword());
        List<PhcThirdOccupationalDiseaserVo> list = this.dao.checkJdInfoList(param);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setStaffName(SpringEncryptUtils.decrypt((String)l.getStaffName()));
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
            });
        }
        List<Object> newlist = new ArrayList();
        newlist = param.getIsIndex() != null && param.getIsIndex() != false ? this.getIndexData(list) : list;
        return newlist;
    }

    public List<PhcThirdOccupationalDiseaserVo> checkZdInfoList(PhcThirdOccupationalDiseaserParamVo param) {
        param.setKeywordEncrypt(param.getKeyword());
        List<PhcThirdOccupationalDiseaserVo> list = this.dao.checkJdInfoList(param);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setStaffName(SpringEncryptUtils.decrypt((String)l.getStaffName()));
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
            });
        }
        List<Object> newlist = new ArrayList();
        newlist = param.getIsIndex() != null && param.getIsIndex() != false ? this.getIndexData(list) : list;
        return newlist;
    }

    public Integer getCheckNum(PhcThirdOccupationalDiseaserParamVo param) {
        if (param.getCid() == null) {
            return 0;
        }
        return this.dao.getCheckJdNum(param);
    }

    private List<PhcThirdOccupationalDiseaserVo> getIndexData(List<PhcThirdOccupationalDiseaserVo> list) {
        ArrayList<PhcThirdOccupationalDiseaserVo> newlist = new ArrayList<PhcThirdOccupationalDiseaserVo>();
        byte state = 2;
        list.forEach(o -> {
            if (o.getReportStatus() != state) {
                newlist.add((PhcThirdOccupationalDiseaserVo)o);
            }
        });
        return newlist;
    }

    public List<PhcThirdOccupationalDiseaserVo> checkStaffListData(PhcThirdOccupationalDiseaserParamVo param) {
        param.setKeywordEncrypt(param.getKeyword());
        param.setIdCardEncrypt(param.getIdCard());
        List<PhcThirdOccupationalDiseaserVo> list = this.dao.checkStaffListData(param);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
                l.setStaffName(SpringEncryptUtils.decrypt((String)l.getStaffName()));
            });
        }
        return list;
    }

    public PhcThirdOccupationalDiseaserVo checkOdInfo(Long id) {
        PhcThirdOccupationalDiseaserVo vo = this.dao.checkOdInfo(id);
        if (vo == null) {
            return vo;
        }
        vo.setStaffName(SpringEncryptUtils.decrypt((String)vo.getStaffName()));
        vo.setIdCard(SpringEncryptUtils.decrypt((String)vo.getIdCard()));
        if (vo.getCreateBy() != null && vo.getAddFrom() != null) {
            String fullName = this.getCreateByName(vo.getAddFrom(), vo.getCreateBy());
            vo.setCreateByName(fullName);
        }
        if (vo.getHarmId() != null) {
            vo.setHarms(this.harmFactorService.getHarmByIds(vo.getHarmId()));
        }
        if (vo.getCompanyAreaId() != null) {
            AreaModel areaModel = this.sysAreaService.getAreaById(vo.getCompanyAreaId());
            this.setWorkPlaceStr(vo, areaModel);
        } else {
            vo.setWorkPlaceStr(StringUtils.isEmpty((CharSequence)vo.getWorkPlace()) ? null : vo.getWorkPlace());
        }
        vo.setDiseases(this.getDiseaseList(vo.getDiseaseName()));
        return vo;
    }

    private void setWorkPlaceStr(PhcThirdOccupationalDiseaserVo vo, AreaModel area) {
        String provinceName = area.getProvinceName() == null ? "" : area.getProvinceName();
        String cityName = area.getCityName() == null ? "" : area.getCityName();
        String areaName = area.getAreaName() == null ? "" : area.getAreaName();
        String streetName = area.getStreetName() == null ? "" : area.getStreetName();
        String workPlaceName = StringUtil.isEmpty((String)vo.getWorkPlace()) ? "" : vo.getWorkPlace();
        vo.setWorkPlaceStr(provinceName + cityName + areaName + streetName + workPlaceName);
    }

    private String getCreateByName(Byte addFrom, Long createById) {
        String fullName = null;
        switch (addFrom) {
            case 1: {
                StaffBasicInfo staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(createById);
                if (staffBasicInfo == null) break;
                fullName = staffBasicInfo.getRealName();
                break;
            }
            case 2: {
                OrganizationUser organizationUser = (OrganizationUser)this.organizationUserService.getById(createById);
                if (organizationUser == null) break;
                fullName = organizationUser.getFullName();
                break;
            }
            case 3: {
                SysUser sysUser = (SysUser)this.sysUserService.getById(createById);
                if (sysUser == null) break;
                fullName = sysUser.getFullname();
                break;
            }
        }
        return fullName;
    }

    private List<Disease> getDiseaseList(String diseaseName) {
        List names = StringUtils.parseToStringList((String)diseaseName, (String)",");
        if (names.isEmpty()) {
            return null;
        }
        ArrayList<Disease> list = new ArrayList<Disease>();
        Map map = this.diseaseThirdService.getAllDiseaseNameIdMap();
        names.forEach(n -> {
            Integer id = (Integer)map.get(n);
            if (id != null) {
                Disease d = new Disease();
                d.setDiseaseName(n);
                d.setId(id);
                list.add(d);
            }
        });
        return list;
    }

    @Transactional(readOnly=false)
    public PhcThirdOccupationalDiseaserVo addOrUpdateInfo(PhcThirdOccupationalDiseaserVo vo, Long userId, String companyName) {
        vo.setUserId(userId);
        vo.setUpdateDate(new Date());
        vo.setReportCommitTime(vo.getReportStatus() == 2 ? new Date() : null);
        this.supervisePhcPhysicalOdImportService.setStaffInfoByQuery(vo);
        if (vo.getId() == null) {
            vo.setId(Long.valueOf(this.idworker.nextId()));
            vo.setDetailId(Long.valueOf(this.idworker.nextId()));
            this.dao.addOdInfo(vo);
            this.dao.addOdDetailInfo(vo);
            if (vo.getAddFrom() == 3 && vo.getReportStatus() == 2 && vo.getDiagnosedType() == 1) {
                this.superviseCheckAbnormalService.reportDiagnosedInfo(vo.getDetailId(), vo.getDiagnosedId(), vo.getId(), vo.getCid(), vo.getDiseaseName(), vo.getReportCommitTime());
            }
        } else {
            this.dao.updateOdInfo(vo);
            this.dao.updateOdDetailInfo(vo);
        }
        vo.setCreateByName(this.getCreateByName(vo.getAddFrom(), vo.getUserId()));
        if (vo.getReportStatus() == 2) {
            this.workOperateLogService.report(vo.getDetailId(), WorkOperateLogEnum.phc.getTypeVal(), vo.getUserId(), vo.getCreateByName(), companyName);
            if (vo.getDiagnosedType() == 1) {
                this.sysCoreWorkModuleCorrelationService.uploadedDiseaserByOrgan(vo.getDetailId(), vo.getStaffName(), userId, vo.getCid());
                if (vo.getEmployerId() != null) {
                    this.sysCoreWorkModuleCorrelationService.uploadedDiseaserByOrgan(vo.getDetailId(), vo.getStaffName(), userId, vo.getEmployerId());
                }
            }
        }
        this.addComRelation(vo, userId);
        return vo;
    }

    private void addComRelation(PhcThirdOccupationalDiseaserVo vo, Long userId) {
        if (vo.getEmployerId() == null) {
            this.companyOutpackService.delOutpackRelation(vo.getId());
        } else {
            OutpackRelationDto outpackRelation = new OutpackRelationDto();
            outpackRelation.setWorkId(vo.getId());
            outpackRelation.setRealCid(vo.getEmployerId());
            outpackRelation.setBeLongCid(vo.getCid());
            this.companyOutpackService.updateOutpackRelation(outpackRelation, userId);
        }
    }

    @Transactional(readOnly=false)
    public void deleteOd(Long id, Long userId) {
        this.dao.deleteOd(id, userId);
        this.companyOutpackService.delOutpackRelation(id);
    }

    public List<CompanyCountInfo> countCompanyDiseasers(Date beginTime, Date endTime) {
        return this.dao.countCompanyDiseasers(beginTime, endTime);
    }

    public Map<Long, Integer> countThirdOrgReportOds(Integer year, Byte diagnosedType) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        List<CompanyCountInfo> reportCount = this.dao.reportCount(year, diagnosedType);
        if (reportCount == null || reportCount.isEmpty()) {
            return result;
        }
        reportCount.forEach(r -> result.put(r.getCid(), r.getDiseaserCount()));
        return result;
    }

    public ResponseData<StaffBasicVo> checkIdCardAndName(String idCard, String staffName, Long cid) {
        return this.checkThirdOrganizationService.checkIdCardAndName(idCard, staffName, cid);
    }

    public ResponseData<List<StaffBasicVo>> importDataCheck(List<List<String>> contents) {
        ResponseData data = new ResponseData();
        if (contents.isEmpty()) {
            return data;
        }
        ArrayList<StaffBasicVo> result = new ArrayList<StaffBasicVo>();
        ArrayList<String> notSameIdCards = new ArrayList<String>();
        if (!this.isInitComMap) {
            this.companyMap = this.supervisePhcPhysicalOdImportService.getAllCompanyMap();
        }
        for (List<String> content : contents) {
            StaffBasicVo s;
            Long cid;
            if (content == null || content.size() < 2) continue;
            String staffName = content.get(0);
            String idCard = content.get(1);
            if (notSameIdCards.contains(idCard)) continue;
            String companyName = "";
            String sheetName = content.get(content.size() - 1);
            if ("\u8bca\u65ad\u804c\u4e1a\u75c5".equals(sheetName)) {
                companyName = content.get(4);
            } else if ("\u9274\u5b9a\u804c\u4e1a\u75c5".equals(sheetName)) {
                companyName = content.get(4);
            } else if ("\u9274\u5b9a\u804c\u4e1a\u75c5(\u76d1\u7ba1)".equals(sheetName)) {
                companyName = content.get(4);
            } else if ("\u8bca\u65ad\u804c\u4e1a\u75c5(\u76d1\u7ba1)".equals(sheetName)) {
                companyName = content.get(4);
            }
            if (StringUtils.isEmpty((CharSequence)companyName) || (cid = this.companyMap.get(companyName)) == null || StringUtils.isEmpty((CharSequence)staffName) || StringUtils.isEmpty((CharSequence)idCard) || (s = this.checkThirdOrganizationService.getNotSameStaff(idCard, staffName, cid)) == null) continue;
            s.setCompanyName(companyName);
            result.add(s);
            notSameIdCards.add(s.getIdCard());
        }
        if (!result.isEmpty()) {
            data.setState(ResponseStateEnum.warning);
            data.setResult(result);
        }
        return data;
    }

    @Transactional(readOnly=false)
    public void jdBackToThirOrg(PhcThirdOccupationalDiseaserVo vo, Long userId, String companyName) {
        this.dao.jdBackToThirOrg(vo.getWorkId(), userId);
        String getCreateByName = this.getCreateByName((byte)2, userId);
        this.workOperateLogService.back(vo.getWorkId(), WorkOperateLogEnum.phc.getTypeVal(), vo.getReason(), userId, getCreateByName, companyName);
    }

    public void zdBackToThirOrg(Long detailId, Long userId) {
        this.dao.jdBackToThirOrg(detailId, userId);
    }

    public Map<Long, Integer> getCheckOdCountMore(Integer year, Integer count) {
        List<PhcThirdOccupationalDiseaserVo> voList = this.dao.checkAllOdInfoList(year);
        Map<Long, List<PhcThirdOccupationalDiseaserVo>> map = voList.stream().filter(y -> y.getCid() != null).collect(Collectors.groupingBy(PhcThirdOccupationalDiseaserVo::getCid));
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        map.forEach((k, v) -> {
            if (v.size() > count) {
                result.put((Long)k, v.size());
            }
        });
        return result;
    }

    public Map<Long, Integer> getCheckOdWithThirdOrgByArea(Long areaId, Byte areaLevel, List<Long> thirdOrgIdList, Byte diagnosedType) {
        List<PhcThirdOccupationalDiseaserVo> voList = this.dao.checkOdListByAreaAndThirdId(areaId, areaLevel, thirdOrgIdList, diagnosedType);
        Map<Long, Integer> map = voList.stream().collect(Collectors.toMap(PhcThirdOccupationalDiseaserVo::getDiagnosedId, PhcThirdOccupationalDiseaserVo::getNum, (key1, key2) -> key2));
        return map;
    }

    public Integer getCheckOdWithThirdOrgByAreaTotal(Long areaId, Byte areaLevel, Byte diagnosedType) {
        return this.dao.checkOdListByAreaTotal(areaId, areaLevel, diagnosedType);
    }

    public PageInfo<PhcThirdOccupationalDiseaserVo> checkStaffListDataInfos(JqGridParam param, PhcThirdOccupationalDiseaserParamVo checkParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcThirdOccupationalDiseaserVo> list = this.checkStaffListData(checkParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<Long> getChckOdOrgListByArea(Long areaId, Byte areaLevel) {
        return this.dao.getChckOdOrgListByArea(areaId, areaLevel);
    }

    @Transactional(readOnly=false)
    public ResponseData<Object> importByExcel(List<List<String>> contents, Long userId, Integer coverStaff, Byte addFrom, Long orgId, Byte reportStatus, String companyName) {
        return this.supervisePhcPhysicalOdImportService.importData(contents, userId, coverStaff, addFrom, orgId, reportStatus, companyName);
    }
}

