/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.companyoutpack.OutpackRelationDto;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserVo;
import cn.smarthse.modules.health.enums.check.DiagnosedReportStatusEnum;
import cn.smarthse.modules.health.enums.check.DiagnosedTypeEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.supervise.dao.check.SupervisePhcPhysicalOdMapper;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdImportService;
import cn.smarthse.modules.health.supervise.service.companyoutpack.ICompanyOutpackService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.sys.ISysAreaService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.entity.sys.SysUser;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.thirdOrganization.service.sys.ISysUserService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.modules.health.vo.base.ImportErrorInfo;
import cn.smarthse.snowflake.IdWorker;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
@Transactional(readOnly=true)
public class SupervisePhcPhysicalOdImportServiceImpl
implements ISupervisePhcPhysicalOdImportService {
    @Autowired
    protected IdWorker idworker;
    @Autowired
    SupervisePhcPhysicalOdMapper dao;
    @Autowired
    ISysAreaService sysAreaService;
    @Autowired
    OssClientBean ossClientBean;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    IDiseaseThirdService diseaseThirdService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    ISuperviseCheckThirdOrganizationService superviseCheckThirdOrganizationService;
    @DubboReference
    IThirdOrganizationService thirdOrganizationService;
    @Autowired
    DataSourceTransactionManager txManager;
    @Autowired
    ICompanyOutpackService companyOutpackService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService provideBySuperviseService;
    @Autowired
    IWorkOperateLogService workOperateLogService;
    @DubboReference
    ISysUserService sysUserService;
    private Map<String, List<HarmFactor>> harmMap;
    private Map<String, List<StaffBasicVo>> staffIdCardMap;
    private Map<String, Integer> allDiseaseNameIdMap;
    private Map<String, Long> allCompanyMap;
    private Map<String, Long> thirdOrgMap1;
    private Map<String, Long> thirdOrgMap2;
    private List<ImportErrorInfo> errors;
    private Map<String, Integer> sheetIndex;
    private Map<String, Long> outpackMap;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean isInit = false;

    @PostConstruct
    public void initData() {
        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SupervisePhcPhysicalOdImportServiceImpl.this.logger.info("\u6267\u884cSupervisePhcPhysicalOdImportServiceImpl init\u65b9\u6cd5");
                SupervisePhcPhysicalOdImportServiceImpl.this.isInit = false;
                SupervisePhcPhysicalOdImportServiceImpl.this.init();
                SupervisePhcPhysicalOdImportServiceImpl.this.isInit = true;
                SupervisePhcPhysicalOdImportServiceImpl.this.logger.info("\u6267\u884cSupervisePhcPhysicalOdImportServiceImpl init\u65b9\u6cd5\u5b8c\u6210");
            }
        }, 0L, 3600000L);
    }

    public Map<String, Long> getAllCompanyMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        List companies = null;
        if (companies == null || companies.isEmpty()) {
            return map;
        }
        companies.forEach(c -> map.put(c.getName(), c.getId()));
        return map;
    }

    private void init() {
        this.allCompanyMap = this.getAllCompanyMap();
        this.allDiseaseNameIdMap = this.diseaseThirdService.getAllDiseaseNameIdMap();
        this.staffIdCardMap = new HashMap<String, List<StaffBasicVo>>();
        this.setStaffMap();
        this.thirdOrgMap2 = this.thirdOrganizationService.queryByType(8);
        this.thirdOrgMap1 = this.thirdOrganizationService.queryByType(4);
        this.harmMap = this.harmFactorService.getAllMap();
    }

    private void initImportInfo() {
        this.errors = new ArrayList<ImportErrorInfo>();
        this.sheetIndex = new HashMap<String, Integer>();
        this.outpackMap = new HashMap<String, Long>();
    }

    private void setStaffMap() {
        List staffInfos = this.staffInfoService.getStaffInfoByIdCard(null, null);
        if (staffInfos == null || staffInfos.size() == 0) {
            return;
        }
        for (StaffBasicVo v : staffInfos) {
            String key = v.getIdCard() + "_" + v.getCid();
            this.addStaffIdCardMap(key, v);
        }
    }

    private void addStaffIdCardMap(String mapKey, StaffBasicVo staffInfo) {
        List<StaffBasicVo> staffInfos = this.staffIdCardMap.get(mapKey);
        if (staffInfos == null) {
            staffInfos = new ArrayList<StaffBasicVo>();
        }
        staffInfos.add(staffInfo);
        this.staffIdCardMap.put(mapKey, staffInfos);
    }

    @Transactional(readOnly=false)
    public ResponseData<Object> importData(List<List<String>> contents, Long userId, Integer coverStaff, Byte addFrom, Long orgId, Byte reportStatus, String companyName) {
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.warning);
        if (contents == null || contents.isEmpty()) {
            responseData.setContent("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u6309\u89c4\u5219\u586b\u5199\u4e4b\u540e\u518d\u5bfc\u5165\uff01");
            return responseData;
        }
        if (!this.isInit) {
            this.init();
        }
        this.initImportInfo();
        int len = contents.size();
        int subLen = 500;
        if (len > subLen) {
            int i;
            for (i = 0; i < (len - 1) / subLen; ++i) {
                List<List<String>> subList = contents.subList(i * subLen, (i + 1) * subLen);
                this.importBatch(subList, userId, coverStaff, addFrom, orgId, reportStatus, companyName);
            }
            List<List<String>> lastList = contents.subList(i * subLen, len);
            this.importBatch(lastList, userId, coverStaff, addFrom, orgId, reportStatus, companyName);
        } else {
            this.importBatch(contents, userId, coverStaff, addFrom, orgId, reportStatus, companyName);
        }
        if (!this.errors.isEmpty()) {
            responseData.setResult(this.errors);
            responseData.setContent("\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff01");
        } else {
            responseData.setState(ResponseStateEnum.success);
            responseData.setContent("\u5bfc\u5165\u6210\u529f\uff01");
        }
        return responseData;
    }

    private void importBatch(List<List<String>> subList, Long userId, Integer coverStaff, Byte addFrom, Long orgId, Byte reportStatus, String companyName) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            ArrayList<PhcThirdOccupationalDiseaserVo> addBatchList = new ArrayList<PhcThirdOccupationalDiseaserVo>();
            ArrayList<StaffBasicVo> notExistStaffList = new ArrayList<StaffBasicVo>();
            ArrayList<OutpackRelationDto> outpackRelationDtos = new ArrayList<OutpackRelationDto>();
            for (List<String> content : subList) {
                PhcThirdOccupationalDiseaserVo vo = this.convertData(content, userId, notExistStaffList, coverStaff, addFrom, orgId);
                if (vo == null) continue;
                vo.setId(Long.valueOf(this.idworker.nextId()));
                vo.setDetailId(Long.valueOf(this.idworker.nextId()));
                vo.setReportCommitTime(new Date());
                vo.setReportStatus(reportStatus);
                addBatchList.add(vo);
                this.addOutPack(vo, outpackRelationDtos);
            }
            this.addBatch(addBatchList, companyName);
            this.addNotExistStaffs(notExistStaffList);
            this.companyOutpackService.updateOutpackRelationBatch(outpackRelationDtos, userId);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u5206\u6279\u6b21\u5bfc\u5165\u804c\u4e1a\u75c5\u4fe1\u606f\u51fa\u9519\u3011", (Throwable)e);
        }
    }

    private void addOutPack(PhcThirdOccupationalDiseaserVo vo, List<OutpackRelationDto> outpackRelationDtos) {
        if (vo.getEmployerId() == null) {
            return;
        }
        OutpackRelationDto dto = new OutpackRelationDto();
        dto.setBeLongCid(vo.getCid());
        dto.setRealCid(vo.getEmployerId());
        dto.setWorkId(vo.getId());
        outpackRelationDtos.add(dto);
    }

    private void addNotExistStaffs(List<StaffBasicVo> notExistStaffList) {
        this.staffInfoService.addNotExistStaffs(notExistStaffList);
    }

    private PhcThirdOccupationalDiseaserVo convertData(List<String> content, Long userId, List<StaffBasicVo> notExistStaffList, Integer coverStaff, Byte addFrom, Long orgId) {
        PhcThirdOccupationalDiseaserVo vo = new PhcThirdOccupationalDiseaserVo();
        if (addFrom == 3) {
            vo.setUserId(userId);
            SysUser byId = (SysUser)this.sysUserService.getById(userId);
            if (byId != null) {
                vo.setCreateByName(byId.getFullname());
            }
        }
        vo.setCoverStaff(Integer.valueOf(coverStaff == null ? 0 : coverStaff));
        vo.setAddFrom(addFrom);
        if (orgId != null) {
            ThirdOrganization thirdOrganization = (ThirdOrganization)this.thirdOrganizationService.getById(orgId);
            vo.setDiagnosedId(orgId);
            vo.setDiagnosedName(thirdOrganization.getName());
        }
        Integer index = null;
        String sheetName = "";
        ImportErrorInfo importErrorInfo = new ImportErrorInfo();
        List<Object> errorInfo = new ArrayList<String>();
        try {
            sheetName = content.get(content.size() - 1);
            Integer sheetIdx = this.sheetIndex.get(sheetName);
            if (sheetIdx == null) {
                index = 1;
                this.sheetIndex.put(sheetName, 1);
            } else {
                index = sheetIdx + 1;
                this.sheetIndex.put(sheetName, sheetIdx + 1);
            }
            importErrorInfo.setRowNum(index.intValue());
            importErrorInfo.setSheetName(sheetName);
            errorInfo = this.doConvert(content, userId, index, sheetName, vo, notExistStaffList);
            if (!errorInfo.isEmpty()) {
                importErrorInfo.setErrorMsg(errorInfo);
                this.errors.add(importErrorInfo);
                return null;
            }
            return vo;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            importErrorInfo.setSheetName(sheetName);
            if (index == null) {
                importErrorInfo.setRowNum(this.sheetIndex.get(sheetName).intValue());
            } else {
                importErrorInfo.setRowNum(index.intValue());
            }
            errorInfo.add("\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303!");
            importErrorInfo.setErrorMsg(errorInfo);
            this.errors.add(importErrorInfo);
            return null;
        }
    }

    private List<String> doConvert(List<String> content, Long userId, Integer index, String sheetName, PhcThirdOccupationalDiseaserVo vo, List<StaffBasicVo> notExistStaffList) {
        ArrayList<String> errors = new ArrayList<String>();
        Date now = new Date();
        String staffName = content.get(0);
        if (StringUtils.isEmpty((CharSequence)staffName)) {
            errors.add("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else {
            vo.setStaffName(staffName);
        }
        String idCard = content.get(1);
        if (StringUtils.isEmpty((CharSequence)idCard)) {
            errors.add("\u8eab\u4efd\u8bc1\u53f7\u672a\u586b\u5199\uff01");
        } else if (!IDCardUtil.isIDCard((String)idCard)) {
            errors.add("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7\uff01");
        } else {
            vo.setIdCard(idCard);
        }
        String harmYear = content.get(2);
        String checkWorkName = content.get(3);
        String companyName = content.get(4);
        String employerName = content.get(5);
        String contactWay = content.get(6);
        String diagnosedTimeStr = "";
        String diseaseName = "";
        String harmName = "";
        String reportIssuingTime = "";
        String diagnosedName = "";
        Byte type = null;
        if ("\u9274\u5b9a\u804c\u4e1a\u75c5".equals(sheetName)) {
            diagnosedTimeStr = content.get(7);
            diseaseName = content.get(8);
            reportIssuingTime = content.get(10);
            harmName = content.get(11);
            vo.setHarmName(harmName);
            vo.setOtherResult(content.get(9));
            type = DiagnosedTypeEnum.appraisal.getCode();
            vo.setDiagnosedType(type);
        } else if ("\u9274\u5b9a\u804c\u4e1a\u75c5(\u76d1\u7ba1)".equals(sheetName)) {
            diagnosedTimeStr = content.get(8);
            diseaseName = content.get(9);
            reportIssuingTime = content.get(11);
            harmName = content.get(12);
            vo.setHarmName(harmName);
            vo.setOtherResult(content.get(10));
            diagnosedName = content.get(7);
            type = DiagnosedTypeEnum.appraisal.getCode();
            vo.setDiagnosedType(type);
            this.setOrgId(vo, diagnosedName, errors);
        } else if ("\u8bca\u65ad\u804c\u4e1a\u75c5(\u76d1\u7ba1)".equals(sheetName)) {
            diagnosedTimeStr = content.get(8);
            diseaseName = content.get(9);
            reportIssuingTime = content.get(10);
            harmName = content.get(11);
            vo.setHarmName(harmName);
            type = DiagnosedTypeEnum.diagnosed.getCode();
            diagnosedName = content.get(7);
            vo.setDiagnosedType(type);
            this.setOrgId(vo, diagnosedName, errors);
        } else {
            diagnosedTimeStr = content.get(7);
            diseaseName = content.get(8);
            reportIssuingTime = content.get(9);
            harmName = content.get(10);
            vo.setHarmName(harmName);
            type = DiagnosedTypeEnum.diagnosed.getCode();
            vo.setDiagnosedType(type);
        }
        vo.setCompanyName(companyName);
        vo.setEmployerName(employerName);
        vo.setContactWay(contactWay);
        vo.setReportCommitTime(new Date());
        vo.setReportStatus(DiagnosedReportStatusEnum.reported.getCode());
        this.setCid(vo, errors);
        this.setCheckWorkName(vo, checkWorkName, errors);
        this.setHarmYear(vo, harmYear, errors);
        this.setReportIssuingTime(vo, reportIssuingTime, errors);
        this.setDiagnosedTime(vo, diagnosedTimeStr, errors);
        this.setDiseaseName(vo, diseaseName, errors);
        this.seHarmName(vo, errors);
        if (errors.isEmpty()) {
            this.setStaffId(vo, notExistStaffList);
        }
        vo.setUpdateDate(now);
        vo.setUserId(userId);
        return errors;
    }

    private boolean ifRightHarmName(String harm) {
        String[] split = harm.split("\\(");
        if (split.length >= 2) {
            String split1 = split[0];
            String split2 = split[1];
            if ((split1.equals("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20") || split1.equals("\u5176\u4ed6\u7c89\u5c18") || split1.equals("\u5176\u4ed6\u7269\u7406\u56e0\u7d20") || split1.equals("\u5176\u4ed6\u751f\u7269\u56e0\u7d20") || split1.equals("\u5176\u4ed6\u653e\u5c04\u6027\u56e0\u7d20")) && split2.substring(split2.length() - 1).equals(")")) {
                return true;
            }
        }
        return false;
    }

    private void seHarmName(PhcThirdOccupationalDiseaserVo vo, List<String> errors) {
        String importHarmName = vo.getHarmName();
        if (StringUtils.isEmpty((CharSequence)importHarmName)) {
            errors.add("\u5371\u5bb3\u56e0\u7d20\u672a\u586b\u5199!");
            return;
        }
        List harms = StringUtils.multiSplit2((String)vo.getHarmName());
        ArrayList finalHarmName = new ArrayList();
        ArrayList finalHarmId = new ArrayList();
        harms.forEach(h -> {
            HarmFactor harmFactor = this.getHarm(h = StringUtils.toDBC((String)h), null);
            if (harmFactor != null) {
                finalHarmName.add(harmFactor.getNameCh());
                finalHarmId.add(String.valueOf(harmFactor.getId()));
            } else if (this.getHarm((String)h, vo.getCid()) == null) {
                if (this.ifRightHarmName((String)h)) {
                    String ids = this.harmFactorService.getHarmIdsByNames(h);
                    if (StringUtil.isEmpty((String)ids)) {
                        String type = h.substring(h.indexOf("\u4ed6") + 1, h.indexOf("("));
                        HarmFactor factor = new HarmFactor();
                        factor.setNameCh(h);
                        factor.setType(type);
                        factor.setBelongGbz188(Integer.valueOf(0));
                        factor.setBelongGbz22007(Integer.valueOf(1));
                        if (vo.getEmployerId() != null) {
                            factor.setCid(vo.getEmployerId());
                        } else {
                            factor.setCid(vo.getCid() == null ? null : vo.getCid());
                        }
                        this.harmFactorService.addCustomHarm(factor, null);
                        finalHarmName.add(h);
                        finalHarmId.add(this.harmFactorService.getHarmIdsByNames(h));
                    } else {
                        finalHarmName.add(h);
                        finalHarmId.add(ids);
                    }
                } else {
                    errors.add("(" + h + ")\u4e3a\u4e0d\u5b58\u5728\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20,\u6dfb\u52a0\u7cfb\u7edf\u9009\u9879\u4e2d\u4e0d\u5b58\u5728\u7684\u56e0\u7d20\uff0c\u8bf7\u6309\u4ee5\u4e0b\u683c\u5f0f\u586b\u5199\uff1a\u5176\u4ed6\u5316\u5b66\u56e0\u7d20(\u5177\u4f53\u6210\u5206)\uff0c\u5176\u4ed6\u7c89\u5c18(\u5177\u4f53\u6210\u5206)\uff0c\u5176\u4ed6\u7269\u7406\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)\uff0c\u5176\u4ed6\u751f\u7269\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)\uff0c\u5176\u4ed6\u653e\u5c04\u6027\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)\u3002\u5982\u679c\u786e\u8ba4\u8f93\u5165\u683c\u5f0f\u6b63\u786e\u8bf7\u68c0\u67e5\u4e24\u4e2a\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u4e4b\u95f4\u662f\u5426\u662f\u4f7f\u7528\u4e2d\u6587\u9017\u53f7\u5206\u9694\u3002");
                }
            } else {
                HarmFactor harmFactors = this.getHarm((String)h, vo.getCid());
                finalHarmName.add(harmFactors.getNameCh());
                finalHarmId.add(String.valueOf(harmFactors.getId()));
            }
        });
        vo.setHarmName(String.join((CharSequence)",", finalHarmName));
        vo.setHarmId(String.join((CharSequence)",", finalHarmId));
    }

    private HarmFactor getHarm(String h, Long cid) {
        List<HarmFactor> harmFactors = this.harmMap.get(h);
        if (harmFactors == null) {
            return null;
        }
        for (HarmFactor f : harmFactors) {
            if (f.getCid() == null) {
                return f;
            }
            if (cid == null || cid.longValue() != f.getCid().longValue()) continue;
            return f;
        }
        return null;
    }

    private void setOrgId(PhcThirdOccupationalDiseaserVo vo, String diagnosedName, List<String> errors) {
        if (StringUtils.isEmpty((CharSequence)diagnosedName)) {
            errors.add(DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        Long orgId = null;
        orgId = vo.getDiagnosedType().byteValue() == DiagnosedTypeEnum.diagnosed.getCode().byteValue() ? this.thirdOrgMap1.get(diagnosedName) : this.thirdOrgMap2.get(diagnosedName);
        if (orgId == null) {
            errors.add("\u673a\u6784\u201c" + diagnosedName + "\u201d\u5728" + DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u673a\u6784\u4e2d\u4e0d\u5b58\u5728\uff01");
            return;
        }
        vo.setDiagnosedName(diagnosedName);
        vo.setDiagnosedId(orgId);
    }

    private void setDiseaseName(PhcThirdOccupationalDiseaserVo vo, String diseaseName, List<String> errors) {
        if (StringUtils.isEmpty((CharSequence)diseaseName)) {
            errors.add("\u804c\u4e1a\u75c5\u540d\u79f0\u672a\u586b\u5199\uff01");
        } else {
            List list = StringUtils.multiSplit((String)diseaseName);
            ArrayList finalList = new ArrayList();
            list.forEach(l -> {
                Integer dId = this.allDiseaseNameIdMap.get(l);
                if (dId != null) {
                    finalList.add(l);
                }
            });
            if (finalList.isEmpty()) {
                errors.add("\u804c\u4e1a\u75c5\u540d\u79f0\u201c" + diseaseName + "\u201d\u90fd\u4e0d\u5b58\u5728\uff01");
            } else {
                vo.setDiseaseName(String.join((CharSequence)",", finalList));
            }
        }
    }

    private void setDiagnosedTime(PhcThirdOccupationalDiseaserVo vo, String diagnosedTimeStr, List<String> errors) {
        if (StringUtils.isEmpty((CharSequence)diagnosedTimeStr)) {
            errors.add(DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + (vo.getDiagnosedType() == 1 ? "\u8bca\u65ad" : "\u9274\u5b9a") + "\u65f6\u95f4\u672a\u586b\u5199\uff01");
        } else {
            int index = diagnosedTimeStr.indexOf("~");
            if (index > 0) {
                Date diagnosedDate = DateUtils.parseDate((Object)diagnosedTimeStr.substring(0, index));
                Date diagnosedEndDate = DateUtils.parseDate((Object)diagnosedTimeStr.substring(index + 1, diagnosedTimeStr.length()));
                if (diagnosedDate == null || diagnosedEndDate == null) {
                    errors.add("\u8bf7\u6309\u65f6\u95f4\u683c\u5f0f\u586b\u5199" + DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u65f6\u95f4\uff01");
                } else {
                    vo.setDiagnosedTime(diagnosedDate);
                    vo.setDiagnosedEndTime(diagnosedEndDate);
                }
            } else {
                Date diagnosedDate = DateUtils.parseDate((Object)diagnosedTimeStr);
                if (diagnosedDate == null) {
                    errors.add("\u8bf7\u6309\u65f6\u95f4\u683c\u5f0f\u586b\u5199" + DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u65f6\u95f4\uff01");
                } else {
                    vo.setDiagnosedTime(diagnosedDate);
                    vo.setDiagnosedEndTime(diagnosedDate);
                }
            }
        }
    }

    private void setReportIssuingTime(PhcThirdOccupationalDiseaserVo vo, String reportIssuingTime, List<String> errors) {
        if (StringUtils.isEmpty((CharSequence)reportIssuingTime)) {
            errors.add(DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u62a5\u544a\u51fa\u5177\u65f6\u95f4\u672a\u586b\u5199\uff01");
        } else {
            Date time = DateUtils.parseDate((Object)reportIssuingTime);
            if (time == null) {
                errors.add("\u8bf7\u6309\u65f6\u95f4\u683c\u5f0f\u586b\u5199" + DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u62a5\u544a\u51fa\u5177\u65f6\u95f4\uff01");
            } else {
                vo.setReportIssuingTime(time);
            }
        }
    }

    private void setCheckWorkName(PhcThirdOccupationalDiseaserVo vo, String checkWorkName, List<String> errors) {
        if (StringUtils.isEmpty((CharSequence)checkWorkName)) {
            errors.add(DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u5c97\u4f4d/\u5de5\u79cd\u672a\u586b\u5199\uff01");
        } else {
            vo.setCheckWorkName(checkWorkName);
        }
    }

    private void setHarmYear(PhcThirdOccupationalDiseaserVo vo, String harmYear, List<String> errors) {
        if (StringUtils.isEmpty((CharSequence)harmYear)) {
            errors.add(DiagnosedTypeEnum.getName((Byte)vo.getDiagnosedType()) + "\u63a5\u5bb3\u5e74\u9f84\u672a\u586b\u5199\uff01");
        } else {
            vo.setHarmYear(harmYear);
        }
    }

    private void setCid(PhcThirdOccupationalDiseaserVo vo, List<String> errors) {
        if (StringUtils.isEmpty((CharSequence)vo.getCompanyName())) {
            errors.add("\u6240\u5728\u5355\u4f4d\u672a\u586b\u5199\uff01");
        } else {
            Long idByName = this.allCompanyMap.get(vo.getCompanyName());
            if (idByName != null) {
                CompanySuperviseModel superviseModel = this.provideBySuperviseService.getCompanyInfoById(idByName);
                if (superviseModel.getCompanyType() == 2) {
                    if (StringUtils.isEmpty((CharSequence)vo.getEmployerName())) {
                        errors.add("\u6240\u9009\u5355\u4f4d\u4e3a\u5916\u5305\u5355\u4f4d\uff0c\u8bf7\u586b\u5199\u5b9e\u9645\u7528\u5de5\u5355\u4f4d!");
                    } else {
                        Long employerId = this.allCompanyMap.get(vo.getEmployerName());
                        CompanySuperviseModel empCompanyInfoById = this.provideBySuperviseService.getCompanyInfoById(employerId);
                        if (employerId != null) {
                            if (empCompanyInfoById.getCompanyType() == 1) {
                                vo.setEmployerId(employerId);
                                vo.setCompanyAreaId(empCompanyInfoById.getAreaDetailId());
                                vo.setCid(idByName);
                                vo.setWorkPlace(StringUtils.isEmpty((CharSequence)empCompanyInfoById.getWorkAddress()) ? null : superviseModel.getWorkAddress());
                            } else {
                                errors.add("\u586b\u5199\u7684\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u4e3a\u5916\u5305\u5355\u4f4d\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5b9e\u9645\u7528\u5de5\u5355\u4f4d!");
                            }
                        } else {
                            errors.add("\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!");
                        }
                    }
                } else if (!StringUtils.isEmpty((CharSequence)vo.getEmployerName())) {
                    errors.add("\u6240\u5728\u5355\u4f4d\u4e3a\u975e\u5916\u5305\u5355\u4f4d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!");
                } else {
                    vo.setCid(idByName);
                    vo.setCompanyAreaId(superviseModel.getAreaDetailId());
                    vo.setWorkPlace(StringUtils.isEmpty((CharSequence)superviseModel.getWorkAddress()) ? null : superviseModel.getWorkAddress());
                }
            } else {
                errors.add("\u6240\u5728\u5355\u4f4d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
            }
        }
    }

    private void setStaffId(PhcThirdOccupationalDiseaserVo vo, List<StaffBasicVo> notExistStaffList) {
        String idCard = vo.getIdCard();
        String staffName = vo.getStaffName();
        Long cid = vo.getCid();
        if (StringUtils.isEmpty((CharSequence)idCard) || StringUtils.isEmpty((CharSequence)staffName) || cid == null) {
            return;
        }
        StaffBasicVo existStaff = this.getExistStaff(idCard, cid);
        if (existStaff == null) {
            this.createStaff(vo, notExistStaffList);
        } else {
            vo.setStaffId(existStaff.getStaffId());
            if (!staffName.equals(existStaff.getStaffName())) {
                vo.setExistStaffName(existStaff.getStaffName());
                this.isUpdateStaffNameByConver(vo);
                if (vo.getCoverStaff() == 1) {
                    vo.setCheckWorkName(this.staffInfoService.getStaffCurrentWorkNameByStaffId(vo.getStaffId()));
                }
                this.updateStaffName(vo);
            }
        }
    }

    private void updateStaffName(PhcThirdOccupationalDiseaserVo vo) {
        Integer coverStaff = vo.getCoverStaff();
        if (coverStaff != 2) {
            return;
        }
        List<StaffBasicVo> staffInfos = this.staffIdCardMap.get(vo.getIdCard() + "_" + vo.getCid());
        if (staffInfos == null || staffInfos.size() == 0) {
            return;
        }
        for (StaffBasicVo v : staffInfos) {
            v.setStaffName(vo.getStaffName());
        }
    }

    private StaffBasicVo getExistStaff(String idCard, Long cid) {
        List<StaffBasicVo> staffInfos = this.staffIdCardMap.get(idCard + "_" + cid);
        if (staffInfos == null || staffInfos.size() == 0) {
            return null;
        }
        StaffBasicVo vo = null;
        for (StaffBasicVo v : staffInfos) {
            if (v.getIsValid() == null || !v.getIsValid().booleanValue()) continue;
            vo = v;
            break;
        }
        vo = vo == null ? staffInfos.get(0) : vo;
        return vo;
    }

    private void createStaff(PhcThirdOccupationalDiseaserVo vo, List<StaffBasicVo> notExistStaffList) {
        StaffBasicVo notExistStaff = new StaffBasicVo();
        notExistStaff.setNew(true);
        notExistStaff.setStaffName(vo.getStaffName());
        notExistStaff.setIdCard(vo.getIdCard());
        notExistStaff.setStaffId(Long.valueOf(this.idworker.nextId()));
        notExistStaff.setStaffBasicInfoId(Long.valueOf(this.idworker.nextId()));
        notExistStaff.setCid(vo.getCid());
        if (IDCardUtil.isIDCard((String)vo.getIdCard())) {
            notExistStaff.setGender(IDCardUtil.getGender((String)vo.getIdCard()));
            notExistStaff.setBirthday(IDCardUtil.getBirthday((String)vo.getIdCard()));
        }
        notExistStaffList.add(notExistStaff);
        this.addStaffIdCardMap(vo.getIdCard() + "_" + vo.getCid(), notExistStaff);
        vo.setStaffId(notExistStaff.getStaffId());
    }

    private void addBatch(List<PhcThirdOccupationalDiseaserVo> addBatchList, String companyName) {
        if (addBatchList.isEmpty()) {
            return;
        }
        this.dao.addDiseaserBatch(addBatchList);
        this.dao.addDiseaserDetailBatch(addBatchList);
        addBatchList.forEach(x -> {
            if (x.getAddFrom() == 3 && x.getReportStatus() == 2) {
                this.workOperateLogService.report(x.getDetailId(), WorkOperateLogEnum.phc.getTypeVal(), x.getUserId(), x.getCreateByName(), companyName);
            }
        });
    }

    @Transactional(readOnly=false)
    public void setStaffInfoByQuery(PhcThirdOccupationalDiseaserVo vo) {
        this.isUpdateStaffNameByConver(vo);
        StaffBasicVo staffInfo = this.staffInfoService.getOrAddStaffInfoByQuery(vo.getCid(), vo.getStaffName(), vo.getIdCard(), vo.getCheckWorkName(), vo.getHarmId(), null);
        vo.setStaffId(staffInfo == null ? null : staffInfo.getStaffId());
    }

    private void isUpdateStaffNameByConver(PhcThirdOccupationalDiseaserVo vo) {
        Long cid = vo.getCid();
        String idCard = vo.getIdCard();
        Integer coverStaff = vo.getCoverStaff();
        if (coverStaff == 1) {
            vo.setStaffName(vo.getExistStaffName());
        } else if (coverStaff == 2 && vo.getStaffId() != null) {
            this.staffInfoService.updateRealNameByStaffId(vo.getStaffName(), vo.getStaffId());
        }
    }
}

