/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalPersonCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalPersonInfo;
import cn.smarthse.modules.health.enums.check.CheckSourceEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.supervise.dao.check.SupervisePhcPhysicalCheckMapper;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountInfo;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountInfoBloc;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountParam;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountParamBloc;
import cn.smarthse.modules.health.supervise.entity.check.CheckParam;
import cn.smarthse.modules.health.supervise.entity.check.CompanyCountInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcCompanyDieaserInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcCompanySdInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcDieaserReportInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcPhysicalQueryCheck;
import cn.smarthse.modules.health.supervise.entity.check.PhcPhysicalQueryCheckInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcPhysicalQueryCheckInfoResult;
import cn.smarthse.modules.health.supervise.entity.check.PhcYearCheckInfo;
import cn.smarthse.modules.health.supervise.entity.check.SupervisePhcPhysicalCheckCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.ReportCheckListInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.ReportCheckListParam;
import cn.smarthse.modules.health.supervise.entity.check.project.ThirdOrgCheckCount;
import cn.smarthse.modules.health.supervise.entity.company.CompanyCollectModel;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.HarmFactorDeclareCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckThirdOrg;
import cn.smarthse.modules.health.supervise.entity.warning.CompanyHarms;
import cn.smarthse.modules.health.supervise.enums.CheckReportStateEnum;
import cn.smarthse.modules.health.supervise.enums.ExamResultEnum;
import cn.smarthse.modules.health.supervise.enums.company.CompanyCollectGroupByEnum;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.ISuperviseHarmFactorDeclareService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckPlanCompService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckThirdOrgService;
import cn.smarthse.modules.health.supervise.service.staff.ISuperviseStaffInfoService;
import cn.smarthse.modules.health.supervise.vo.company.CompanyAreaParamVo;
import cn.smarthse.modules.health.supervise.vo.company.CompanySearchVo;
import cn.smarthse.modules.health.supervise.vo.evaluate.EvaluateMaxTimeByOrgIdVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.util.common.JsonUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SupervisePhcPhysicalCheckServiceImpl
implements ISupervisePhcPhysicalCheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SupervisePhcPhysicalCheckMapper dao;
    @Autowired
    ISuperviseStaffInfoService staffService;
    @Autowired
    ISuperviseHarmFactorDeclareService declareService;
    @Autowired
    IHcCheckPlanCompService compService;
    @Autowired
    IHcCheckThirdOrgService hcCheckThirdOrgService;
    @Autowired
    ISuperviseCheckThirdOrganizationService superviseCheckThirdOrganizationService;
    @DubboReference
    IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    private Byte getLevel(Long areaId) {
        Byte areaLevel = null;
        if (areaId == null) {
            return areaLevel;
        }
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(areaId);
        if (areaModel != null) {
            areaLevel = areaModel.getLevel();
        }
        return areaLevel;
    }

    private boolean checkParam(CheckParam checkParam) {
        if (checkParam == null) {
            return false;
        }
        List cids = checkParam.getCids();
        return cids != null && cids.size() != 0;
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> alreadyCheckCompanies(CheckParam checkParam) {
        List<Object> companies = null;
        companies = this.checkParam(checkParam) ? this.dao.alreadyCheckCompanies(checkParam) : new ArrayList();
        return companies;
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> alreadyCheckCompanies() {
        List<SupervisePhcPhysicalCheckCompanyInfo> companies = this.dao.superviseAlreadyCheckCompanies(new CheckParam());
        return companies;
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> needCheckCompanies(CheckParam checkParam) {
        List<Object> list = null;
        list = this.checkParam(checkParam) ? this.dao.needCheckCompanies(checkParam) : new ArrayList();
        return list;
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> needCheckCompanies() {
        List<SupervisePhcPhysicalCheckCompanyInfo> list = this.dao.superviseNeedCheckCompanies(new CheckParam());
        return list;
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> willCheckCompanies(CheckParam checkParam) {
        List<Object> companies = null;
        companies = this.checkParam(checkParam) ? this.dao.willCheckCompanies(checkParam) : new ArrayList();
        return companies;
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> superviseWillCheckCompanies(CheckParam checkParam) {
        List<SupervisePhcPhysicalCheckCompanyInfo> companies = null;
        companies = this.dao.superviseWillCheckCompanies(checkParam);
        return companies;
    }

    public PhcYearCheckInfo doCountYearCheckInfo(PhcYearCheckInfo params) {
        if (params == null || params.getYear() == null) {
            return params;
        }
        Integer yearDiseasers = this.dao.countYearDiseasers(params);
        params.setDiagnoseDiseasers(yearDiseasers);
        List<PhcDieaserReportInfo> results = this.dao.countYearCheckInfo(params);
        if (results == null || results.size() == 0) {
            return params;
        }
        HashSet<Long> checkIds = new HashSet<Long>();
        HashSet<String> sos = new HashSet<String>();
        HashSet<String> oc = new HashSet<String>();
        HashSet<String> missing = new HashSet<String>();
        for (PhcDieaserReportInfo result : results) {
            Long checkId = result.getCheckId();
            checkIds.add(checkId);
            String idCard = result.getIdCard();
            if (StringUtils.isEmpty((CharSequence)idCard)) continue;
            String examResult = String.valueOf(result.getExamResult());
            if (ExamResultEnum.so.getCode().equals(examResult)) {
                sos.add(idCard);
                continue;
            }
            if (ExamResultEnum.oc.getCode().equals(examResult)) {
                oc.add(idCard);
                continue;
            }
            if (!ExamResultEnum.mis.getCode().equals(examResult)) continue;
            missing.add(idCard);
        }
        params.setSd(Integer.valueOf(sos.size()));
        List<String> beforeSOs = this.dao.countBeforeSO(params);
        if (beforeSOs != null && beforeSOs.size() > 0) {
            ArrayList idCardList = new ArrayList();
            beforeSOs.forEach(b -> idCardList.add(SpringEncryptUtils.decrypt((String)b)));
            sos.removeAll(idCardList);
        }
        params.setNewSd(Integer.valueOf(sos.size()));
        params.setCheckTimes(Integer.valueOf(checkIds.size()));
        params.setOc(Integer.valueOf(oc.size()));
        params.setMissing(Integer.valueOf(missing.size()));
        return params;
    }

    public PageInfo<PhcPhysicalQueryCheckInfo> queryCheckList(JqGridParam gparam, PhcPhysicalQueryCheck query) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalQueryCheckInfo> infoList = this.dao.queryCheck(query);
        if (query.getOutpackId() != null) {
            this.countCheck(infoList, query.getOutpackId(), true);
        } else {
            this.countCheck(infoList, query.getCid(), false);
        }
        return new PageInfo(infoList);
    }

    private void countCheck(List<PhcPhysicalQueryCheckInfo> infos, Long cid, boolean isOutpack) {
        if (infos == null || infos.size() == 0) {
            return;
        }
        ArrayList<Long> checkIds = new ArrayList<Long>();
        ArrayList<Byte> checkTypes = new ArrayList<Byte>();
        for (PhcPhysicalQueryCheckInfo info : infos) {
            if (!checkIds.contains(info.getCheckId())) {
                checkIds.add(info.getCheckId());
            }
            if (!checkTypes.contains(info.getCheckType())) {
                checkTypes.add(info.getCheckType());
            }
            info.setHospitalName(this.getThirdOrgName(info.getSource(), info.getHospital(), info.getHospitalName()));
        }
        PhcPhysicalQueryCheck resultQuery = new PhcPhysicalQueryCheck();
        resultQuery.setCheckIds(checkIds);
        resultQuery.setCheckTypes(checkTypes);
        if (isOutpack) {
            resultQuery.setOutpackId(cid);
        } else {
            resultQuery.setCid(cid);
        }
        List<PhcPhysicalQueryCheckInfoResult> infoResults = this.dao.queryCheckResult(resultQuery);
        HashMap<String, Set<Long>> checkTypeStaffsMap = new HashMap<String, Set<Long>>();
        HashMap<String, Set<Long>> checkTypeResultStaffsMap = new HashMap<String, Set<Long>>();
        HashMap<String, Set<Long>> checkTypeResultDiseaserStaffsMap = new HashMap<String, Set<Long>>();
        this.groupInfoResult(checkTypeStaffsMap, checkTypeResultStaffsMap, checkTypeResultDiseaserStaffsMap, infoResults);
        for (PhcPhysicalQueryCheckInfo info : infos) {
            this.countInfoResult(checkTypeStaffsMap, checkTypeResultStaffsMap, checkTypeResultDiseaserStaffsMap, info);
            this.confirmationInfo(info);
        }
    }

    private void confirmationInfo(PhcPhysicalQueryCheckInfo info) {
        List<CompanyCountInfo> confirmation = this.dao.getConfirmationByCheckId(info.getCheckId());
        if (confirmation != null) {
            for (CompanyCountInfo con : confirmation) {
                if ("0".equals(con.getGroupCode())) {
                    info.setNotviewed(con.getDiseaserCount());
                    continue;
                }
                if ("1".equals(con.getGroupCode())) {
                    info.setViewed(con.getDiseaserCount());
                    continue;
                }
                if (!"2".equals(con.getGroupCode())) continue;
                info.setSigned(con.getDiseaserCount());
            }
        }
    }

    private void groupInfoResult(Map<String, Set<Long>> checkTypeStaffsMap, Map<String, Set<Long>> checkTypeResultStaffsMap, Map<String, Set<Long>> checkTypeResultDiseaserStaffsMap, List<PhcPhysicalQueryCheckInfoResult> infoResults) {
        if (infoResults == null || infoResults.size() == 0) {
            return;
        }
        for (PhcPhysicalQueryCheckInfoResult result : infoResults) {
            Long checkId = result.getCheckId();
            Byte checkType = result.getCheckType();
            String checkTypeStaffsMapKey = checkId + "_" + checkType;
            String checkTypeResultStaffsMapKey = checkId + "_" + checkType + "_" + result.getExamResult();
            Set<Object> checkTypeStaffs = checkTypeStaffsMap.get(checkTypeStaffsMapKey) == null ? new HashSet() : checkTypeStaffsMap.get(checkTypeStaffsMapKey);
            checkTypeStaffs.add(result.getStaffId());
            checkTypeStaffsMap.put(checkTypeStaffsMapKey, checkTypeStaffs);
            Set<Object> checkTypeResultStaffs = checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey) == null ? new HashSet() : checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey);
            checkTypeResultStaffs.add(result.getStaffId());
            checkTypeResultStaffsMap.put(checkTypeResultStaffsMapKey, checkTypeResultStaffs);
            if (result.getIsDiseaser() == null || !result.getIsDiseaser().booleanValue()) continue;
            Set<Object> checkTypeDiseaserStaffs = checkTypeResultDiseaserStaffsMap.get(checkTypeStaffsMapKey) == null ? new HashSet() : checkTypeResultDiseaserStaffsMap.get(checkTypeStaffsMapKey);
            checkTypeDiseaserStaffs.add(result.getStaffId());
            checkTypeResultDiseaserStaffsMap.put(checkTypeStaffsMapKey, checkTypeDiseaserStaffs);
        }
    }

    private void countInfoResult(Map<String, Set<Long>> checkTypeStaffsMap, Map<String, Set<Long>> checkTypeResultStaffsMap, Map<String, Set<Long>> checkTypeResultDiseaserStaffsMap, PhcPhysicalQueryCheckInfo info) {
        Byte checkType;
        Long checkId = info.getCheckId();
        String checkTypeStaffsMapKey = checkId + "_" + (checkType = info.getCheckType());
        Set<Object> checkTypeStaffs = checkTypeStaffsMap.get(checkTypeStaffsMapKey) == null ? new HashSet() : checkTypeStaffsMap.get(checkTypeStaffsMapKey);
        int total = 0;
        for (ExamResultEnum examResult : ExamResultEnum.values()) {
            String exam = examResult.getCode();
            String checkTypeResultStaffsMapKey = checkId + "_" + checkType + "_" + exam;
            Set<Object> checkTypeResultStaffs = checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey) == null ? new HashSet() : checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey);
            total += checkTypeResultStaffs.size();
            if (ExamResultEnum.noraml.getCode().equals(exam)) {
                info.setNormal(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (ExamResultEnum.recheck.getCode().equals(exam)) {
                info.setRecheck(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (ExamResultEnum.so.getCode().equals(exam)) {
                info.setSd(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (ExamResultEnum.oc.getCode().equals(exam)) {
                info.setOc(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (ExamResultEnum.other.getCode().equals(exam)) {
                info.setOther(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (!ExamResultEnum.mis.getCode().equals(exam)) continue;
            info.setMissing(Integer.valueOf(checkTypeResultStaffs.size()));
        }
        String checkTypeDiseaserMapKey = checkId + "_" + checkType;
        Set<Object> checkTypeDiseaserStaffs = checkTypeResultDiseaserStaffsMap.get(checkTypeDiseaserMapKey) == null ? new HashSet() : checkTypeResultDiseaserStaffsMap.get(checkTypeDiseaserMapKey);
        info.setDiseaser(Integer.valueOf(checkTypeDiseaserStaffs.size()));
        info.setTotal(Integer.valueOf(checkTypeStaffs.size()));
        info.setCheckResultTotal(Integer.valueOf(total));
    }

    public PhcYearCheckInfo countYearCheckInfo(Integer year, Long cid) {
        PhcYearCheckInfo params = new PhcYearCheckInfo();
        params.setCid(cid);
        params.setYear(year);
        return this.doCountYearCheckInfo(params);
    }

    public PhcYearCheckInfo countOutPackYearCheckInfo(Integer year, Long cid) {
        PhcYearCheckInfo params = new PhcYearCheckInfo();
        params.setOutpackId(cid);
        params.setYear(year);
        return this.doCountYearCheckInfo(params);
    }

    public PhcYearCheckInfo countOutPackYearCheckInfo(PhcYearCheckInfo phcYearCheckInfo) {
        return this.doCountYearCheckInfo(phcYearCheckInfo);
    }

    public String countYearCheckInfoResult(Integer year, Long cid) {
        PhcYearCheckInfo params = new PhcYearCheckInfo();
        params.setCid(cid);
        params.setYear(year);
        PhcYearCheckInfo checkInfo = this.doCountYearCheckInfo(params);
        if (checkInfo == null || checkInfo.getCheckTimes() == 0) {
            return "\u672a\u8fdb\u884c\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\uff0c\u53d1\u73b0\u7591\u4f3c\u804c\u4e1a\u75c5<strong class=\"ft18 red\">0</strong>\u4eba\uff0c\u786e\u8bca\u804c\u4e1a\u75c5<strong class=\"ft18 red\">0</strong>\u4eba";
        }
        return "\u5df2\u8fdb\u884c\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5<strong class=\"ft18 red\">" + checkInfo.getCheckTimes() + "</strong>\u6b21\uff0c\u53d1\u73b0\u7591\u4f3c\u804c\u4e1a\u75c5<strong class=\"ft18 red\">" + checkInfo.getSd() + "</strong>\u4eba\uff0c\u786e\u8bca\u804c\u4e1a\u75c5<strong class=\"ft18 red\">" + checkInfo.getDiagnoseDiseasers() + "</strong>\u4eba";
    }

    public PageInfo<PhcPhysicalQueryCheckInfo> queryCheckPage(JqGridParam gparam, Long cid, Integer yearFlag) {
        PhcPhysicalQueryCheck query = new PhcPhysicalQueryCheck();
        query.setCid(cid);
        query.setYearFlag(yearFlag);
        return this.queryCheckList(gparam, query);
    }

    public PageInfo<PhcPhysicalQueryCheckInfo> queryCheckPage(JqGridParam gparam, Long cid, Integer yearFlag, Byte type) {
        PhcPhysicalQueryCheck query = new PhcPhysicalQueryCheck();
        query.setCid(cid);
        query.setYearFlag(yearFlag);
        ArrayList<Byte> types = new ArrayList<Byte>();
        types.add(type);
        query.setCheckTypes(types);
        return this.queryCheckList(gparam, query);
    }

    public PageInfo<PhcPhysicalQueryCheckInfo> queryOutpackCheckPage(JqGridParam gparam, Long cid) {
        PhcPhysicalQueryCheck query = new PhcPhysicalQueryCheck();
        List postDatas = gparam.getPostDatas();
        if (postDatas != null) {
            postDatas.forEach(item -> {
                String searchField = item.getSearchField();
                String searchValue = item.getSearchValue();
                if ("level".equals(searchField) && searchValue != null && !searchValue.isEmpty()) {
                    query.setLevel(Byte.valueOf(Byte.parseByte(searchValue)));
                }
                if ("areaId".equals(searchField) && searchValue != null && !searchValue.isEmpty()) {
                    query.setAreaId(Long.valueOf(Long.parseLong(searchValue)));
                }
            });
        }
        query.setOutpackId(cid);
        return this.queryCheckList(gparam, query);
    }

    public List<PhcPhysicalQueryCheckInfo> queryCheckList(Long cid) {
        PhcPhysicalQueryCheck query = new PhcPhysicalQueryCheck();
        query.setCid(cid);
        List<PhcPhysicalQueryCheckInfo> infoList = this.dao.queryCheck(query);
        this.countCheck(infoList, cid, false);
        return infoList;
    }

    public Integer getSuspectedCountByCompanyIds(List<Long> cids) {
        if (cids == null || cids.size() == 0) {
            return 0;
        }
        return this.dao.getSuspectedCountByCompanyIds(cids);
    }

    public Integer getSureCountByCompanyIds(List<Long> cids) {
        if (cids == null || cids.size() == 0) {
            return 0;
        }
        return this.dao.getSureCountByCompanyIds(cids);
    }

    public Integer getSuperviseStaffInfoCountByCids(List<Long> cids) {
        if (cids == null || cids.size() == 0) {
            return 0;
        }
        return this.staffService.getSuperviseStaffInfoCountByCids(cids);
    }

    public Integer getHcCheckPlanRegularCountByCids(List<Long> cids) {
        if (cids == null || cids.size() == 0) {
            return 0;
        }
        return this.compService.getHcCheckPlanRegularCountByCids(cids);
    }

    public HarmFactorDeclareCompanyInfo getHarmFactorDeclareCompanyInfo(List<Long> cids) {
        if (cids == null || cids.size() == 0) {
            return null;
        }
        return this.declareService.getHarmFactorDeclareCompanyInfo(cids);
    }

    public PageInfo<CheckCountInfo> companyCheckInfos(JqGridParam param, List<CompanyCountInfo> companies, CheckCountParam checkCountParam) {
        if (companies == null || companies.size() == 0) {
            return new PageInfo(null);
        }
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            checkCountParam.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CheckCountInfo> list = this.dao.companyCheckInfos(companies, checkCountParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public CheckCountInfo companyCheckInfoCount(List<CompanyCountInfo> companies, CheckCountParam checkCountParam) {
        CheckCountInfo countInfo = null;
        countInfo = companies == null || companies.size() == 0 ? new CheckCountInfo() : this.dao.companyCheckInfoCount(companies, checkCountParam);
        countInfo = countInfo == null ? new CheckCountInfo() : countInfo;
        countInfo.setName("\u5408\u8ba1\uff1a");
        return countInfo;
    }

    public List<CheckCountInfo> companyCheckInfoList(List<CompanyCountInfo> companies, CheckCountParam checkCountParam) {
        if (companies == null || companies.size() == 0) {
            return null;
        }
        List<CheckCountInfo> list = this.dao.companyCheckInfos(companies, checkCountParam);
        return list;
    }

    public PageInfo<CheckCountInfoBloc> companyCheckInfosBloc(JqGridParam param, CheckCountParamBloc checkCountParamBloc) {
        if (!this.checkBlocParam(checkCountParamBloc)) {
            return new PageInfo(null);
        }
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            checkCountParamBloc.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CheckCountInfoBloc> list = this.dao.companyCheckInfosBloc(checkCountParamBloc);
        PageInfo page = new PageInfo(list);
        return page;
    }

    private boolean checkBlocParam(CheckCountParamBloc checkCountParamBloc) {
        if (checkCountParamBloc == null) {
            return false;
        }
        List cids = checkCountParamBloc.getCids();
        if (cids == null || cids.size() == 0) {
            return false;
        }
        if (checkCountParamBloc.getYear() == null) {
            checkCountParamBloc.setYear(Integer.valueOf(DateUtils.getThisYear()));
        }
        return true;
    }

    public CheckCountInfoBloc companyCheckInfoCountBloc(CheckCountParamBloc checkCountParamBloc) {
        CheckCountInfoBloc countInfo = null;
        countInfo = !this.checkBlocParam(checkCountParamBloc) ? new CheckCountInfoBloc() : this.dao.companyCheckInfoCountBloc(checkCountParamBloc);
        countInfo = countInfo == null ? new CheckCountInfoBloc() : countInfo;
        countInfo.setName("\u5408\u8ba1\uff1a");
        return countInfo;
    }

    public List<CheckCountInfoBloc> companyCheckInfoListBloc(CheckCountParamBloc checkCountParamBloc) {
        if (!this.checkBlocParam(checkCountParamBloc)) {
            return new ArrayList<CheckCountInfoBloc>();
        }
        List<CheckCountInfoBloc> list = this.dao.companyCheckInfosBloc(checkCountParamBloc);
        return list;
    }

    public List<CompanyCollectModel> collectCompanyAllTypeGroup(CompanySearchVo companySearchVo, CompanyCollectGroupByEnum group, CompanyAreaParamVo areaParam) {
        return null;
    }

    public CheckCountInfo companyCheckInfoCount(CheckCountParam checkCountParam) {
        return this.dao.companyCheckInfoCount2(checkCountParam);
    }

    public PageInfo<CheckCountInfo> companyCheckInfos(JqGridParam param, CheckCountParam checkCountParam) {
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            if ("name".equals(param.getSidx())) {
                param.setSidx("groupCode");
            }
            checkCountParam.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CheckCountInfo> list = this.companyCheckInfoList(checkCountParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<CheckCountInfo> companyCheckInfoList(CheckCountParam checkCountParam) {
        Byte groupType = checkCountParam.getGroupType();
        List<CheckCountInfo> list = null;
        if (groupType == null || groupType == CompanyCollectGroupByEnum.AREA.getValue()) {
            list = this.dao.companyAreaCheckInfos(checkCountParam);
        } else if (groupType == CompanyCollectGroupByEnum.REGISTERTYPE.getValue()) {
            list = this.dao.companyRegisterCheckInfos(checkCountParam);
        } else if (groupType == CompanyCollectGroupByEnum.INDUSTRYCATEGORY.getValue()) {
            list = this.dao.companyIndustryCheckInfos(checkCountParam);
        } else if (groupType == CompanyCollectGroupByEnum.SCALE.getValue()) {
            list = this.dao.companyScaleCheckInfos(checkCountParam);
        } else if (groupType == CompanyCollectGroupByEnum.OCCUPATIONALRISKCLASSIFY.getValue()) {
            list = this.dao.companyOccCheckInfos(checkCountParam);
        }
        return list;
    }

    public PageInfo<PhcCompanyDieaserInfo> companyCheckSdInfos(JqGridParam param, Long cid, Integer examResult, boolean isOutpack, Integer yearFlag) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Byte level = 0;
        Long areaId = 0L;
        List postDatas = param.getPostDatas();
        if (postDatas != null) {
            for (ParamSeachFieldVO postData : postDatas) {
                String searchField = postData.getSearchField();
                String searchValue = postData.getSearchValue();
                if ("level".equals(searchField) && searchValue != null && !searchValue.isEmpty()) {
                    level = Byte.parseByte(searchValue);
                    continue;
                }
                if (!"areaId".equals(searchField) || searchValue == null || searchValue.isEmpty()) continue;
                areaId = Long.parseLong(searchValue);
            }
        }
        CheckParam checkParam = new CheckParam();
        checkParam.setLevel(level);
        checkParam.setAreaId(areaId);
        checkParam.setYearFlag(yearFlag);
        if (isOutpack) {
            checkParam.setOutpackId(cid);
        } else {
            checkParam.setCid(cid);
        }
        checkParam.setExamResult(examResult);
        List<PhcCompanyDieaserInfo> list = this.checkSdInfoList(checkParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<PhcCompanyDieaserInfo> checkSdInfos(JqGridParam param, CheckParam checkParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcCompanyDieaserInfo> list = this.checkSdInfoList(checkParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<PhcCompanyDieaserInfo> companyCheckSdInfoList(Long cid, Integer examResult, boolean isOutpack) {
        CheckParam param = new CheckParam();
        if (isOutpack) {
            param.setOutpackId(cid);
        } else {
            param.setCid(cid);
        }
        param.setExamResult(examResult);
        List<PhcCompanyDieaserInfo> list = this.checkSdInfoList(param);
        return list;
    }

    private List<PhcCompanyDieaserInfo> checkSdInfoList(CheckParam param) {
        param.setKeywordEncrypt(param.getKeyword());
        List<PhcCompanyDieaserInfo> list = this.dao.companyCheckSdInfoList(param);
        this.setCheckInfo(list, param.getExamResult());
        return list;
    }

    private void setCheckInfo(List<PhcCompanyDieaserInfo> list, Integer examResult) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (examResult == 4) {
            for (PhcCompanyDieaserInfo l : list) {
                l.setHarmFactorNames(this.superviseCheckThirdOrganizationService.getHarmNames(l.getHarmFactorIds()));
                l.setOccFactorNames(this.superviseCheckThirdOrganizationService.getHarmNames(l.getOccFactoryIds()));
                l.setHospitalName(this.getThirdOrgName(l.getSource(), l.getHospital(), l.getHospitalName()));
            }
        } else {
            for (PhcCompanyDieaserInfo l : list) {
                l.setHarmFactorNames(this.superviseCheckThirdOrganizationService.getHarmNames(l.getHarmFactorIds()));
                l.setHospitalName(this.getThirdOrgName(l.getSource(), l.getHospital(), l.getHospitalName()));
            }
        }
    }

    private String getThirdOrgName(Byte source, Long hospital, String hospitalName) {
        HcCheckThirdOrg org;
        if (source != null && source == CheckSourceEnum.third.getCode() && hospital != null && hospitalName == null && (org = this.hcCheckThirdOrgService.getThisByOrgId(hospital)) != null) {
            return org.getThirdOrgName();
        }
        return hospitalName;
    }

    public PageInfo<PhcCompanyDieaserInfo> companyCheckOdInfos(JqGridParam param, Long cid, Byte diagnosedType, Long areaId, Byte areaLevel) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcCompanyDieaserInfo> list = this.companyCheckOdInfoList(cid, diagnosedType, areaId, areaLevel);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<PhcCompanyDieaserInfo> companyCheckOdInfoList(Long cid, Byte diagnosedType, Long areaId, Byte areaLevel) {
        List<PhcCompanyDieaserInfo> list = this.dao.companyCheckOdInfoList(cid, diagnosedType, areaId, areaLevel);
        if (list == null || list.isEmpty()) {
            return list;
        }
        this.setCheckInfo(list, -1);
        return list;
    }

    public String getLastExamResultByStaffId(Long staffId) {
        if (staffId == null) {
            return null;
        }
        String examResult = this.dao.getLastExamResultByStaffId(staffId);
        return ExamResultEnum.getName((String)examResult);
    }

    public Integer getReportChecks(Long thirdOrgId, Long areaId) {
        Byte areaLevel;
        if (thirdOrgId == null) {
            return 0;
        }
        Integer year = DateUtils.getThisYear();
        List<ThirdOrgCheckCount> counts = this.dao.getReportChecks(thirdOrgId, year, areaId, areaLevel = this.getLevel(areaId));
        if (counts == null || counts.isEmpty()) {
            return 0;
        }
        ThirdOrgCheckCount count = counts.get(0);
        return count.getChecks();
    }

    public Map<Long, Integer> getOrgReportChecksMap(Integer year, Long areaId) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        Byte areaLevel = this.getLevel(areaId);
        List<ThirdOrgCheckCount> counts = this.dao.getReportChecks(null, year, areaId, areaLevel);
        if (counts == null || counts.isEmpty()) {
            return map;
        }
        for (ThirdOrgCheckCount c : counts) {
            map.put(c.getThirdOrgId(), c.getChecks());
        }
        return map;
    }

    public List<CompanyHarms> getCheckCompanyHarms(Long areaId, Byte areaLevel) {
        Date endTime = new Date();
        Date beginTime = DateUtils.getDistanceDate((Date)endTime, (int)1, (int)-1);
        return this.dao.getCheckCompanyHarms(areaId, areaLevel, beginTime, endTime);
    }

    public PageInfo<PhcPhysicalPersonInfo> getPersonCheckInfo(JqGridParam gparam, Long staffId) {
        return this.phcPhysicalCheckDataResultService.getPersonCheckInfo(gparam, staffId);
    }

    public PageInfo<PhcPhysicalPersonCheckInfo> getPersonAllCheckInfo(JqGridParam gparam, String idCard) {
        if (gparam == null || StringUtils.isEmpty((CharSequence)idCard)) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalPersonCheckInfo> checkInfos = this.dao.getPersonAllCheckInfo(SpringEncryptUtils.encrypt((String)idCard));
        PageInfo page = new PageInfo(checkInfos);
        return page;
    }

    public String getStaffNameByStaffId(Long id) {
        return this.staffInfoService.getStaffNameByStaffId(id);
    }

    public List<Long> reportCheckOrgIds(Long areaId, Byte ownLevel) {
        return this.dao.reportCheckOrgIds(areaId, ownLevel);
    }

    public List<Long> reportOdOrgIds(Long areaId, Byte ownLevel) {
        return this.dao.reportOdOrgIds(areaId, ownLevel);
    }

    public List<EvaluateMaxTimeByOrgIdVo> listOrgLastReportTime(List<Long> orgIds, Long areaId) {
        if (orgIds == null || orgIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.dao.listOrgLastReportTime(orgIds, areaId);
    }

    public PhcCompanySdInfo getSdInfo(Long id) {
        PhcCompanySdInfo info = this.dao.getSdInfo(id);
        info.setHarmFactorNames(this.superviseCheckThirdOrganizationService.getHarmNames(info.getHarmFactorIds()));
        info.setHospitalName(this.getThirdOrgName(info.getSource(), info.getHospital(), info.getHospitalName()));
        return info;
    }

    public PhcCompanySdInfo getOccInfo(Long id) {
        PhcCompanySdInfo info = this.dao.getOccInfo(id);
        info.setOccFactorNames(this.superviseCheckThirdOrganizationService.getHarmNames(info.getOccFactoryIds()));
        info.setHarmFactorNames(this.superviseCheckThirdOrganizationService.getHarmNames(info.getHarmFactorIds()));
        info.setHospitalName(this.getThirdOrgName(info.getSource(), info.getHospital(), info.getHospitalName()));
        return info;
    }

    public Map<Long, Integer> getReportCountMapByAreaIdAndOrgIdsOld(Long areaId, Byte arealevel, List<Long> orgIds) {
        List<String> list = this.dao.getReportCountMapByAreaIdAndOrgIds(areaId, arealevel, orgIds);
        if (list == null || list.size() == 0) {
            return null;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (String str : list) {
            String[] arr = str.split("-");
            map.put(Long.valueOf(arr[0]), Integer.valueOf(arr[1]));
        }
        return map;
    }

    public Map<Long, Integer> getReportCountMapByAreaIdAndOrgIds(Long areaId, Byte arealevel, List<Long> orgIds) {
        if (orgIds != null && orgIds.isEmpty()) {
            return null;
        }
        JqGridParam gparam = new JqGridParam();
        gparam.setPage(1);
        gparam.setRows(Integer.MAX_VALUE);
        ReportCheckListParam param = new ReportCheckListParam();
        param.setAreaLevel(arealevel);
        param.setAreaId(areaId);
        param.setOrgIds(orgIds);
        ArrayList<Byte> reportStates = new ArrayList<Byte>();
        reportStates.add(CheckReportStateEnum.feedback.getCode());
        reportStates.add(CheckReportStateEnum.reported.getCode());
        param.setReportStates(reportStates);
        PageInfo page = this.superviseCheckThirdOrganizationService.reportCheckPage(gparam, param);
        List list = page.getList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (ReportCheckListInfo info : list) {
            Integer num = (Integer)map.get(info.getHospital());
            if (num == null) {
                num = 1;
                map.put(info.getHospital(), num);
                continue;
            }
            map.put(info.getHospital(), num + 1);
        }
        this.logger.info("\u4f53\u68c0\u9879\u76ee\u7edf\u8ba1\u6570:" + JsonUtils.toJsonString(map));
        return map;
    }

    public Integer getReportProjCountByAreaId(Long areaId, Byte arealevel) {
        return this.dao.getReportProjCountByAreaId(areaId, arealevel);
    }
}

