/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.companyoutpack.OutpackRelationDto;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckThirdInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.vo.HudongSysStaffInfoVo;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.dao.check.SuperviseCheckThirdOrganizationMapper;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataResultInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDetailInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckFileInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckListInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckTypeCount;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckTypeInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.ImportDataParam;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckDataParam;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckListParam;
import cn.smarthse.modules.health.supervise.entity.check.project.ReportCheckListInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.ReportCheckListParam;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.entity.sys.SysFileThirdModel;
import cn.smarthse.modules.health.supervise.enums.CheckReportStateEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckAbnormalService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationImportService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.supervise.service.companyoutpack.ICompanyOutpackService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
@Transactional(readOnly=true)
public class SuperviseCheckThirdOrganizationServiceImpl
implements ISuperviseCheckThirdOrganizationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuperviseCheckThirdOrganizationServiceImpl.class);
    @Autowired
    protected IdWorker idworker;
    @Autowired
    SuperviseCheckThirdOrganizationMapper dao;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    IDiseaseThirdService diseaseThirdService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    ISuperviseCheckThirdOrganizationImportService superviseCheckThirdOrganizationImportService;
    @Autowired
    IWorkOperateLogService workOperateLogService;
    @Autowired
    ICompanyOutpackService companyOutpackService;
    @Autowired
    ISuperviseCheckAbnormalService superviseCheckAbnormalService;
    @DubboReference
    private ISysFileProvideService sysFileService;
    @DubboReference
    private IPhcPhysicalCheckService PhcPhysicalCheckService;
    @DubboReference
    private IPhcPhysicalCheckDataService phcPhysicalCheckDataService;
    @DubboReference
    private IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private ThreadPoolExecutor executor;
    @DubboReference
    IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;

    public CheckDetailInfo getCheckDetailById(Long checkId) {
        return this.getCheckDetailById(checkId, null);
    }

    public CheckDetailInfo getCheckDetailById(Long checkId, Long cid) {
        if (checkId == null) {
            return null;
        }
        CheckDetailInfo detail = this.dao.getBasicById(checkId);
        if (detail == null) {
            return detail;
        }
        this.setEmployers(detail);
        List<CheckTypeCount> checkTypeCounts = this.getCheckTypeCounts(checkId, cid);
        detail.setCheckTypeCounts(checkTypeCounts);
        if (checkTypeCounts == null || checkTypeCounts.isEmpty()) {
            return detail;
        }
        detail.setCheckTypeCount(checkTypeCounts.get(0));
        return detail;
    }

    private void setEmployers(CheckDetailInfo detail) {
        detail.setEmployers(this.dao.listEmployers(detail.getId()));
    }

    public List<CheckFileInfo> getFiles(String fileIds) {
        List ids = StringUtils.parseToLongList((String)fileIds);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<CheckFileInfo> files = new ArrayList<CheckFileInfo>();
        for (Long fileId : ids) {
            SysFileModel file = this.sysFileService.getFileById(fileId);
            if (file == null) continue;
            CheckFileInfo info = new CheckFileInfo();
            info.setId(file.getId());
            info.setCid(file.getCid());
            info.setFileUrl(file.getOssUrl());
            info.setFileName(file.getFileName());
            files.add(info);
        }
        return files;
    }

    public String getHarmNames(String harmIds) {
        List ids = StringUtils.parseToLongList((String)harmIds);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return this.harmFactorService.getHarmNames(harmIds);
    }

    private List<CheckTypeCount> getCheckTypeCountInfos(Long checkId) {
        ArrayList<CheckTypeCount> counts = new ArrayList<CheckTypeCount>();
        List<CheckTypeInfo> infos = this.dao.listCheckTypesByCheckId(checkId);
        if (infos == null || infos.isEmpty()) {
            return counts;
        }
        for (CheckTypeInfo info : infos) {
            String checkType = info.getCheckType();
            CheckTypeCount count = new CheckTypeCount();
            count.setCheckType(checkType);
            count.setCheckProjects(info.getCheckProjects());
            count.setCheckReportFileIds(info.getCheckReportFileIds());
            count.setReportFiles(this.getFiles(info.getCheckReportFileIds()));
            count.setOtherFileIds(info.getOtherFileIds());
            count.setOtherFiles(this.getFiles(info.getOtherFileIds()));
            count.setNeedChecks(info.getNeedChecks());
            count.setCheckTypeName(CheckTypeEnum.getThirdOrgName((String)checkType));
            counts.add(count);
        }
        return counts;
    }

    private List<CheckTypeCount> getCheckTypeCounts(Long checkId, Long cid) {
        ArrayList<CheckTypeCount> counts = new ArrayList<CheckTypeCount>();
        List<CheckTypeInfo> infos = this.dao.listCheckTypeInfoByCheckId(checkId, cid);
        if (infos == null || infos.isEmpty()) {
            return counts;
        }
        HashMap<String, CheckTypeCount> countMap = new HashMap<String, CheckTypeCount>();
        for (CheckTypeInfo checkTypeInfo : infos) {
            Byte gender;
            String checkType = checkTypeInfo.getCheckType();
            CheckTypeCount count = (CheckTypeCount)countMap.get(checkType);
            if (count == null) {
                count = new CheckTypeCount();
                count.setCheckType(checkType);
                count.setCheckProjects(checkTypeInfo.getCheckProjects());
                count.setCheckReportFileIds(checkTypeInfo.getCheckReportFileIds());
                count.setReportFiles(this.getFiles(checkTypeInfo.getCheckReportFileIds()));
                count.setOtherFileIds(checkTypeInfo.getOtherFileIds());
                count.setOtherFiles(this.getFiles(checkTypeInfo.getOtherFileIds()));
                count.setNeedChecks(checkTypeInfo.getNeedChecks());
                count.setCheckTypeName(CheckTypeEnum.getThirdOrgName((String)checkType));
            }
            count.setHarmIds((count.getHarmIds() == null ? "" : count.getHarmIds()) + (String)(checkTypeInfo.getHarmFactor() == null ? "" : "," + checkTypeInfo.getHarmFactor()));
            Long staffId = checkTypeInfo.getStaffId();
            String examResult = checkTypeInfo.getExamResult();
            if (staffId != null) {
                count.getCheckStaffIds().add(staffId);
            }
            if ((gender = IDCardUtil.getGender((String)checkTypeInfo.getIdCard())) != null && StaffGenderEnum.FEMALE.getValue().byteValue() == gender.byteValue()) {
                count.getWomenStaffIds().add(staffId);
            } else if (gender != null && gender.byteValue() == StaffGenderEnum.MALE.getValue().byteValue()) {
                count.getManStaffIds().add(staffId);
            }
            if (ExamResultEnum.so.getCode().equals(examResult)) {
                count.getSdStaffIds().add(staffId);
            } else if (ExamResultEnum.oc.getCode().equals(examResult)) {
                count.getOcStaffIds().add(staffId);
            } else if (ExamResultEnum.recheck.getCode().equals(examResult)) {
                count.getRecheckStaffIds().add(staffId);
            } else if (ExamResultEnum.mis.getCode().equals(examResult)) {
                count.getMissingStaffIds().add(staffId);
            }
            countMap.put(checkType, count);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            CheckTypeCount count = (CheckTypeCount)entry.getValue();
            count.setHarmNames(this.getHarmNames(count.getHarmIds()));
            counts.add(count);
        }
        return counts;
    }

    public PageInfo<CheckDataInfo> pageCheckData(JqGridParam gparam, PageCheckDataParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CheckDataInfo> infoList = this.listCheckData(param);
        return new PageInfo(infoList);
    }

    public List<CheckDataInfo> listCheckData(PageCheckDataParam param) {
        if (param == null || param.getCheckId() == null) {
            return new ArrayList<CheckDataInfo>();
        }
        List<CheckDataInfo> list = this.dao.listCheckData(param);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard())));
        }
        this.setDataInfos(list);
        return list;
    }

    private void setDataInfos(List<CheckDataInfo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (CheckDataInfo l : list) {
            if (StringUtils.isNotEmpty((String)l.getIdCard())) {
                l.setAge(Integer.valueOf(IDCardUtil.getAge((String)l.getIdCard())));
                l.setGenderName(IDCardUtil.getGenderName((String)l.getIdCard()));
            }
            l.setHarmNames(this.getHarmNames(l.getHarmIds()));
            l.setRessultName(ExamResultEnum.getName((String)l.getRessult()));
            l.setOccHarmNames(this.getHarmNames(l.getOccHarmIds()));
            if (!ExamResultEnum.oc.getCode().equals(l.getRessult()) || !StringUtils.isNotBlank((CharSequence)l.getOccHarmNames())) continue;
            l.setRessultName(l.getOccHarmNames() + "-" + l.getRessultName());
        }
    }

    public CheckDataResultInfo getCheckResultInfo(Long id) {
        CheckDataResultInfo resultInfo = this.dao.getCheckResultInfo(id);
        if (resultInfo != null) {
            resultInfo.setAge(resultInfo.getBirthday() == null ? null : Integer.valueOf(DateUtils.getAgeByYear((Date)resultInfo.getBirthday())));
            resultInfo.setGenderName(StaffGenderEnum.getName((Integer)resultInfo.getGender()));
            resultInfo.setHarmNames(this.getHarmNames(resultInfo.getHarmIds()));
            resultInfo.setRessultName(ExamResultEnum.getName((String)resultInfo.getRessult()));
            resultInfo.setHarms(this.harmFactorService.getHarmByIds(resultInfo.getHarmIds()));
            resultInfo.setOccHarms(this.harmFactorService.getHarmByIds(resultInfo.getOccHarmIds()));
            resultInfo.setOccHarmNames(this.getHarmNames(resultInfo.getOccHarmIds()));
            resultInfo.setCompanyFullAreaName(this.sysAreaService.getFullName(resultInfo.getCompanyAreaId(), ""));
            resultInfo.setIdCard(SpringEncryptUtils.decrypt((String)resultInfo.getIdCard()));
        }
        return resultInfo;
    }

    public PageInfo<CheckListInfo> thirdOrgPage(JqGridParam gparam, PageCheckListParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CheckListInfo> infoList = this.thirdOrgList(param);
        return new PageInfo(infoList);
    }

    public List<CheckListInfo> thirdOrgList(PageCheckListParam param) {
        List<CheckListInfo> list = this.dao.thirdOrgList(param);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        list.forEach(l -> {
            if (l.getCompanyType() != null && l.getCompanyType() == 2) {
                l.setEmployers(this.dao.listEmployers(l.getId()));
            }
        });
        return list;
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long updateBy) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        this.dao.deleteByIdList(idArray, updateBy);
        this.deleteOutpackRelation(idArray);
    }

    private void deleteOutpackRelation(List<Long> idArray) {
        idArray.forEach(id -> this.companyOutpackService.delOutpackRelation(id));
    }

    @Transactional(readOnly=false)
    public CheckDetailInfo info(CheckDetailInfo checkDetail, List<SysFileThirdModel> thirdFiles, String companyName) {
        if (checkDetail.getReportSate() != null && checkDetail.getReportSate() == CheckReportStateEnum.reported.getCode()) {
            checkDetail.setStatus(Byte.valueOf((byte)1));
        }
        if (checkDetail.getId() == null) {
            checkDetail.setId(Long.valueOf(this.idworker.nextId()));
            checkDetail.setNo(this.businessNoService.getBusinessNo(checkDetail.getCid(), BusinessNoTypeEnum.HEALTHCHECK.getCode()));
            checkDetail.setFromId(checkDetail.getId());
            checkDetail.setFromType(CoreWorkEnum.healthCheck.getValue());
            this.dao.addCheckDetail(checkDetail);
        } else {
            this.dao.updateCheckDetail(checkDetail);
        }
        if (checkDetail.getReportSate() != null && Objects.equals(checkDetail.getReportSate(), CheckReportStateEnum.reported.getCode())) {
            byte bussinessState = CheckReportStateEnum.getSysTipCode((Byte)checkDetail.getLastReportSate());
            this.sysCoreWorkModuleCorrelationService.uploadedCheckByOrgan(checkDetail.getId(), checkDetail.getWorkName(), Byte.valueOf(bussinessState), checkDetail.getCreateBy(), checkDetail.getCid());
            this.workOperateLogService.report(checkDetail.getId(), WorkOperateLogEnum.phc.getTypeVal(), checkDetail.getCreateBy(), checkDetail.getCreateByName(), companyName);
            this.addOutPackRealtion(checkDetail, bussinessState);
            this.addAbnormalReport(checkDetail);
        }
        this.addChildren(checkDetail, thirdFiles);
        if (checkDetail.getReportSate() != null && checkDetail.getReportSate() == CheckReportStateEnum.reported.getCode()) {
            CheckDetailInfo checkDetailById = this.getCheckDetailById(checkDetail.getId());
            checkDetail.setCheckTypeCounts(checkDetailById.getCheckTypeCounts());
        }
        CheckDetailInfo checkDetailInfo = this.phcPhysicalCheckV3221Service.saveInfo(checkDetail);
        return checkDetail;
    }

    private void addAbnormalReport(CheckDetailInfo checkDetail) {
        if (checkDetail.getIsRecheck() == null || !checkDetail.getIsRecheck().booleanValue()) {
            return;
        }
        this.superviseCheckAbnormalService.reportRecheckInfo(checkDetail.getId(), checkDetail.getHospital(), checkDetail.getCid(), new Date());
    }

    @Transactional(readOnly=false)
    public void addOutPackRealtion(CheckDetailInfo checkDetail, byte bussinessState) {
        if (StringUtils.isEmpty((CharSequence)checkDetail.getEmployerId())) {
            return;
        }
        List employerIds = StringUtils.parseToLongList((String)checkDetail.getEmployerId());
        employerIds.forEach(e -> {
            OutpackRelationDto outpackRelation = new OutpackRelationDto();
            outpackRelation.setBeLongCid(checkDetail.getCid());
            outpackRelation.setRealCid(e);
            outpackRelation.setWorkId(checkDetail.getId());
            this.companyOutpackService.updateOutpackRelation(outpackRelation, checkDetail.getCreateBy());
            this.sysCoreWorkModuleCorrelationService.uploadedCheckByOrgan(checkDetail.getId(), checkDetail.getWorkName(), Byte.valueOf(bussinessState), checkDetail.getCreateBy(), e);
        });
    }

    private void addChildren(CheckDetailInfo checkDetail, List<SysFileThirdModel> thirdFiles) {
        this.addCheckType(checkDetail);
        this.addThirdInfo(checkDetail);
    }

    private void addCheckType(CheckDetailInfo checkDetail) {
        Long checkId = checkDetail.getId();
        this.dao.deleteCheckTypeByCheckId(checkId);
        CheckTypeCount checkType = checkDetail.getCheckTypeCount();
        if (checkType == null) {
            return;
        }
        checkType.setCheckId(checkId);
        checkType.setId(Long.valueOf(this.idworker.nextId()));
        this.dao.addCheckType(checkType);
        this.dao.updateCheckDataType(checkId, checkType.getCheckType());
    }

    private void addThirdInfo(CheckDetailInfo checkDetail) {
        Long checkId = checkDetail.getId();
        PhcPhysicalCheckThirdInfo info = this.dao.getCheckThirdInfoByCheckId(checkId);
        this.dao.deleteCheckThirdInfoByCheckId(checkId);
        if (checkDetail.getReportSate() != null && checkDetail.getReportSate().equals(CheckReportStateEnum.reported.getCode())) {
            checkDetail.setReportTime(new Date());
            if (info != null && info.getReportTime() != null) {
                checkDetail.setReportTime(info.getReportTime());
            }
        }
        checkDetail.setThirdInfoId(Long.valueOf(this.idworker.nextId()));
        this.dao.addCheckThirdInfo(checkDetail);
    }

    @Transactional(readOnly=false)
    public void deleteCheckResultByIds(String ids) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        this.dao.deleteCheckResultByIds(idArray);
    }

    @Transactional(readOnly=false)
    public CheckDataResultInfo resultInfo(CheckDataResultInfo resultInfo) {
        this.setData(resultInfo);
        this.addResultInfo(resultInfo);
        this.phcPhysicalCheckV3221Service.saveResult(resultInfo);
        return resultInfo;
    }

    private void addResultInfo(CheckDataResultInfo resultInfo) {
        if (resultInfo.getDataId() != null) {
            this.dao.updateCheckData(resultInfo);
        } else {
            resultInfo.setDataId(Long.valueOf(this.idworker.nextId()));
            this.dao.insertCheckData(resultInfo);
        }
        if (resultInfo.getResultId() != null) {
            this.dao.updateCheckDataResult(resultInfo);
        } else {
            resultInfo.setResultId(Long.valueOf(this.idworker.nextId()));
            this.dao.insertCheckDataResult(resultInfo);
        }
    }

    private void setData(CheckDataResultInfo resultInfo) {
        resultInfo.setIdCardEncrypt(resultInfo.getIdCard());
        List<CheckDataResultInfo> existResults = this.dao.queryData(resultInfo);
        if (existResults == null || existResults.isEmpty()) {
            resultInfo.setStaffDataSource(Byte.valueOf((byte)2));
            this.setStaffInfo(resultInfo);
        } else {
            CheckDataResultInfo existResult = null;
            boolean hasOtherResult = false;
            for (CheckDataResultInfo r : existResults) {
                r.setIdCard(SpringEncryptUtils.decrypt((String)r.getIdCard()));
                if (ExamResultEnum.getGroup((String)r.getRessult()).equals(ExamResultEnum.getGroup((String)resultInfo.getRessult()))) {
                    existResult = r;
                    continue;
                }
                hasOtherResult = true;
            }
            if (existResult != null) {
                if (resultInfo.getDataId() == null) {
                    resultInfo.setResultId(existResult.getResultId());
                    resultInfo.setDataId(existResult.getDataId());
                } else {
                    if (!hasOtherResult) {
                        this.dao.deleteByDataId(existResult.getDataId());
                    }
                    this.deleteCheckResultByIds("" + existResult.getResultId());
                }
                this.setStaffInfo(resultInfo);
            } else {
                existResult = existResults.get(0);
                resultInfo.setDataId(existResult.getDataId());
                this.setStaffInfo(resultInfo);
            }
        }
    }

    private void setStaffInfo(CheckDataResultInfo resultInfo) {
        this.superviseCheckThirdOrganizationImportService.setStaffInfoByQuery(resultInfo);
    }

    public Integer getHcCheckNumByByAreaAndYear(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.dao.getHcCheckNumByByAreaAndYear(areaId, areaLevel, year, ownLevel);
    }

    public PageInfo<ReportCheckListInfo> reportCheckPage(JqGridParam gparam, ReportCheckListParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        this.setAreaLevel(param);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<ReportCheckListInfo> infoList = this.dao.reportCheckPage(param);
        if (CollectionUtils.isEmpty(infoList)) {
            return new PageInfo(infoList);
        }
        infoList.forEach(x -> {
            if (x.getCompanyType() == 2) {
                x.setEmployerName(this.dao.listEmployersByArea(x.getId(), param.getAreaId(), param.getAreaLevel()));
            }
        });
        return new PageInfo(infoList);
    }

    public List<ReportCheckListInfo> reportCheckList(ReportCheckListParam param) {
        this.setAreaLevel(param);
        return this.dao.reportCheckPage(param);
    }

    private void setAreaLevel(ReportCheckListParam param) {
        Long areaId = param.getAreaId();
        if (areaId == null) {
            return;
        }
        AreaModel area = this.sysAreaService.getAreaById(areaId);
        if (area != null) {
            param.setAreaLevel(area.getLevel());
        }
    }

    @Transactional(readOnly=false)
    public void deleteCheckResult(CheckDataResultInfo resultInfo) {
        Integer count = this.dao.otherResult(resultInfo.getDataId(), ExamResultEnum.getGroup((String)resultInfo.getRessult()));
        if (count == null || count == 0) {
            this.dao.deleteByDataId(resultInfo.getDataId());
        }
        this.deleteCheckResultByIds("" + resultInfo.getResultId());
        this.phcPhysicalCheckV3221Service.deleteByCardIds("" + resultInfo.getDataId());
        this.deleteByCheckResultGroup(resultInfo.getDataId(), resultInfo.getResultId(), ExamResultEnum.getGroup((String)resultInfo.getRessult()));
    }

    private void deleteByCheckResultGroup(Long dataId, Long resultId, String resultGroup) {
        Integer count = this.dao.otherResult(dataId, resultGroup);
        if (count == null || count == 0) {
            this.dao.deleteByDataId(dataId);
        }
        this.deleteCheckResultByIds("" + resultId);
    }

    @Transactional(readOnly=false)
    public void deleteMultiCheckData(String dataIds, String resultIds, String resultGroup) {
        List dataIdList = StringUtils.parseToLongList((String)dataIds);
        List resultIdList = StringUtils.parseToLongList((String)resultIds);
        if (dataIdList.isEmpty() || resultIdList.isEmpty()) {
            return;
        }
        for (int i = 0; i < dataIdList.size(); ++i) {
            this.deleteByCheckResultGroup((Long)dataIdList.get(i), (Long)resultIdList.get(i), resultGroup);
        }
        this.phcPhysicalCheckV3221Service.deleteByCardIds(dataIds);
    }

    @Transactional(readOnly=false)
    public List<String> importData(ImportDataParam param, List<List<String>> contents) {
        return this.superviseCheckThirdOrganizationImportService.importData(param, contents);
    }

    public Integer checkIdCard(CheckDataResultInfo resultInfo) {
        if (resultInfo == null || resultInfo.getCheckId() == null || resultInfo.getIdCard() == null) {
            return null;
        }
        resultInfo.setIdCardEncrypt(resultInfo.getIdCard());
        return this.dao.checkIdCard(resultInfo);
    }

    public Integer checkDataCount(Long checkId) {
        if (checkId == null) {
            return 0;
        }
        return this.dao.checkDataCount(checkId);
    }

    public ResponseData<StaffBasicVo> checkIdCardAndName(String idCard, String name, Long cid) {
        ResponseData res = new ResponseData();
        StaffBasicVo s = this.getNotSameStaff(idCard, name, cid);
        if (s != null) {
            res.setState(ResponseStateEnum.warning);
            res.setResult((Object)s);
        }
        return res;
    }

    public StaffBasicVo getNotSameStaff(String idCard, String name, Long cid) {
        List staffs = this.staffInfoService.getStaffInfoByIdCard(cid, idCard);
        if (staffs == null || staffs.isEmpty()) {
            return null;
        }
        StaffBasicVo s = (StaffBasicVo)staffs.get(0);
        if (!name.equals(s.getStaffName())) {
            String workName = s.getStaffId() != null ? this.staffInfoService.getStaffCurrentWorkNameByStaffId(s.getStaffId()) : "";
            s.setWorkName(workName);
            return s;
        }
        return null;
    }

    public int getCheckCountByNo(String no) {
        return this.dao.getCheckCountByNo(no);
    }

    public List<HudongSysStaffInfoVo> getAllStaffInfoListByCid(Long cid) {
        return this.PhcPhysicalCheckService.getAllStaffInfoListByCid(cid);
    }

    public ResponseData<List<StaffBasicVo>> importDataCheck(ImportDataParam param, List<List<String>> contents) {
        ResponseData data = new ResponseData();
        if (contents.isEmpty()) {
            return data;
        }
        ArrayList<StaffBasicVo> result = new ArrayList<StaffBasicVo>();
        CompanyBaseInfoModel wCompany = this.companyProvideByHSEService.getCompanyById(param.getCid());
        String wCompanyName = null;
        if (wCompany != null) {
            wCompanyName = wCompany.getName();
        }
        for (List<String> content : contents) {
            StaffBasicVo s;
            if (content == null || content.size() < 2) continue;
            String staffName = content.get(0);
            String idCard = content.get(1);
            if (StringUtils.isEmpty((CharSequence)staffName) || StringUtils.isEmpty((CharSequence)idCard)) continue;
            Long cid = param.getCid();
            if (param.getOutputFlg().booleanValue()) {
                CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getByName(content.get(2));
                if (companyBaseInfoModel == null || companyBaseInfoModel.getId() == null) continue;
                cid = companyBaseInfoModel.getId();
                wCompanyName = companyBaseInfoModel.getName();
            }
            if ((s = this.getNotSameStaff(idCard, staffName, cid)) == null) continue;
            s.setCompanyName(wCompanyName);
            result.add(s);
        }
        if (!result.isEmpty()) {
            data.setState(ResponseStateEnum.warning);
            data.setResult(result);
        }
        return data;
    }

    @Transactional(readOnly=false)
    public void backToThirdOrg(WorkOperateLog log) {
        if (log == null || log.getWorkId() == null) {
            return;
        }
        CheckDetailInfo detail = this.dao.getBasicById(log.getWorkId());
        if (detail == null) {
            return;
        }
        this.workOperateLogService.back(log.getWorkId(), log.getWorkModule(), log.getReason(), log.getCreateBy(), log.getOperater(), log.getCompanyName());
        this.dao.back(log.getWorkId(), log.getCreateBy());
        this.dao.updateThirdInfoState(log.getWorkId(), CheckReportStateEnum.feedback.getCode(), log.getCreateBy());
        this.dao.updateCheckCountInfoState(log.getWorkId(), CheckReportStateEnum.feedback.getCode());
        this.sysCoreWorkModuleCorrelationService.uploadedCheckByOrgan(log.getWorkId(), detail.getWorkName(), CheckReportStateEnum.reported.getSysTipCode(), log.getCreateBy(), detail.getCid());
    }

    @Transactional(readOnly=false)
    public HudongSysStaffInfoVo addHuadongStaffInfo(String realName, String idCard, Long loginStaffId, Long cid) {
        return this.staffInfoService.addHuadongStaffInfo(realName, null, idCard, loginStaffId, cid);
    }

    public PhcPhysicalCheckData getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(Long cid, Long checkId, Long staffId, Byte checkType) {
        return this.phcPhysicalCheckDataService.getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(cid, checkId, staffId, checkType);
    }

    @Transactional(readOnly=false)
    public PhcPhysicalCheckData addPhcPhysicalCheckData(PhcPhysicalCheckData ppcd, Long loginStaffId, Long cid) {
        return (PhcPhysicalCheckData)this.phcPhysicalCheckDataService.add((Object)ppcd, loginStaffId, cid);
    }

    @Transactional(readOnly=false)
    public void addPhcPhysicalCheck(PhcPhysicalCheck check) {
        this.dao.addPhcPhysicalCheck(check);
    }

    @Transactional(readOnly=false)
    public void addPhcPhysicalCheckThirdInfo(PhcPhysicalCheckThirdInfo thirdInfo) {
        this.dao.addPhcPhysicalCheckThirdInfo(thirdInfo);
    }

    @Transactional(readOnly=false)
    public void addPhcPhysicalCheckType(PhcPhysicalCheckType checkType) {
        this.dao.addPhcPhysicalCheckType(checkType);
    }

    @Transactional(readOnly=false)
    public void addPhcPhysicalCheckDataResult(PhcPhysicalCheckDataResult result) {
        this.dao.addPhcPhysicalCheckDataResult(result);
    }
}

