/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.supervise.dao.check.SuperviseCheckThirdOrganizationMapper;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataResultInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.ImportDataParam;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationImportService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.supervise.service.sys.ISysAreaService;
import cn.smarthse.snowflake.IdWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
@Transactional(readOnly=true)
public class SuperviseCheckThirdOrganizationImportServiceImpl
implements ISuperviseCheckThirdOrganizationImportService {
    @Autowired
    protected IdWorker idworker;
    @Autowired
    SuperviseCheckThirdOrganizationMapper dao;
    @Autowired
    ISysAreaService sysAreaService;
    @Autowired
    OssClientBean ossClientBean;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    IDiseaseThirdService diseaseThirdService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    ISuperviseCheckThirdOrganizationService superviseCheckThirdOrganizationService;
    @Autowired
    DataSourceTransactionManager txManager;
    private Map<String, Integer> addIndexMap;
    private Map<String, CheckDataResultInfo> importedResultMap;
    private Map<String, Long> harmMap;
    private Map<String, Set<String>> idCardMap;
    private Map<String, List<StaffBasicVo>> staffIdCardMap;
    private Map<String, Integer> allDiseaseNameIdMap;
    private Map<String, List<CheckDataResultInfo>> existAllResultMap;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;

    private void init(ImportDataParam param, List<List<String>> contents) {
        Long cid = param.getCid();
        Long checkId = param.getCheckId();
        Boolean outputFlg = param.getOutputFlg();
        this.addIndexMap = new HashMap<String, Integer>();
        this.importedResultMap = new HashMap<String, CheckDataResultInfo>();
        this.harmMap = new HashMap<String, Long>();
        this.idCardMap = this.getIdCardMap(contents, outputFlg);
        this.staffIdCardMap = new HashMap<String, List<StaffBasicVo>>();
        this.setStaffMap(cid, outputFlg);
        this.allDiseaseNameIdMap = this.diseaseThirdService.getAllSuspectDiseaseNameIdMap();
        this.existAllResultMap = this.getExistResultMap(checkId);
    }

    private Map<String, List<CheckDataResultInfo>> getExistResultMap(Long checkId) {
        HashMap<String, List<CheckDataResultInfo>> resultMap = new HashMap<String, List<CheckDataResultInfo>>();
        CheckDataResultInfo resultInfo = new CheckDataResultInfo();
        resultInfo.setCheckId(checkId);
        List<CheckDataResultInfo> existResults = this.dao.queryData(resultInfo);
        if (existResults == null || existResults.isEmpty()) {
            return resultMap;
        }
        for (CheckDataResultInfo r : existResults) {
            r.setIdCard(SpringEncryptUtils.decrypt((String)r.getIdCard()));
            String key = r.getIdCard() + "_" + r.getDataCid();
            ArrayList<CheckDataResultInfo> infos = (ArrayList<CheckDataResultInfo>)resultMap.get(key);
            if (infos == null) {
                infos = new ArrayList<CheckDataResultInfo>();
            }
            infos.add(r);
            resultMap.put(key, infos);
        }
        return resultMap;
    }

    private void setStaffMap(Long cid, Boolean outputFlg) {
        List staffInfos;
        if (outputFlg.booleanValue()) {
            cid = null;
        }
        if ((staffInfos = this.staffInfoService.getStaffInfoByIdCard(cid, null)) == null || staffInfos.size() == 0) {
            return;
        }
        for (StaffBasicVo v : staffInfos) {
            String idCard = v.getIdCard();
            this.addStaffIdCardMap(idCard, v);
        }
    }

    @Transactional
    public List<String> importData(ImportDataParam param, List<List<String>> contents) {
        ArrayList<String> checkResults = new ArrayList<String>();
        if (contents == null || contents.size() == 0) {
            checkResults.add("excel\u4e2d\u6ca1\u6709\u6570\u636e\u5bfc\u5165");
            return checkResults;
        }
        if (param == null || param.getCheckId() == null || param.getCheckType() == null) {
            checkResults.add("\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
            return checkResults;
        }
        this.init(param, contents);
        int len = contents.size();
        int subLen = 500;
        if (len > subLen) {
            int i;
            for (i = 0; i < (len - 1) / subLen; ++i) {
                List<List<String>> subList = contents.subList(i * subLen, (i + 1) * subLen);
                this.importBatch(subList, checkResults, param);
            }
            List<List<String>> lastList = contents.subList(i * subLen, len);
            this.importBatch(lastList, checkResults, param);
        } else {
            this.importBatch(contents, checkResults, param);
        }
        if (checkResults.size() == 0) {
            checkResults.add("\u5bfc\u5165\u6210\u529f");
        }
        return checkResults;
    }

    private void importBatch(List<List<String>> subList, List<String> checkResults, ImportDataParam param) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            ArrayList<StaffBasicVo> notExistStaffList = new ArrayList<StaffBasicVo>();
            HashMap<String, StaffBasicVo> notExistStaffMap = new HashMap<String, StaffBasicVo>();
            ArrayList<CheckDataResultInfo> checkDataBatch = new ArrayList<CheckDataResultInfo>();
            ArrayList<CheckDataResultInfo> checkDataResultBatch = new ArrayList<CheckDataResultInfo>();
            for (List<String> content : subList) {
                String importResult = this.addData(content, param, notExistStaffList, notExistStaffMap, checkDataBatch, checkDataResultBatch);
                if (!StringUtils.isNotEmpty((String)importResult)) continue;
                checkResults.add(importResult);
            }
            this.addNotExistStaffs(notExistStaffList);
            this.addCheckInfos(checkDataBatch, checkDataResultBatch);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u5206\u6279\u6b21\u5bfc\u5165\u4f53\u68c0\u4fe1\u606f\u51fa\u9519\u3011", (Throwable)e);
        }
    }

    private void addCheckInfos(List<CheckDataResultInfo> checkDataBatch, List<CheckDataResultInfo> checkDataResultBatch) {
        if (checkDataBatch != null && !checkDataBatch.isEmpty()) {
            this.dao.insertCheckDataBatch(checkDataBatch);
        }
        if (checkDataResultBatch != null && !checkDataResultBatch.isEmpty()) {
            this.dao.insertCheckDataResultBatch(checkDataResultBatch);
            this.phcPhysicalCheckV3221Service.insertCheckDataBatch(checkDataResultBatch);
        }
    }

    private void addNotExistStaffs(List<StaffBasicVo> notExistStaffList) {
        this.staffInfoService.addNotExistStaffs(notExistStaffList);
    }

    private Map<String, Set<String>> getIdCardMap(List<List<String>> contents, Boolean outputFlg) {
        HashMap<String, Set<String>> idCardMap = new HashMap<String, Set<String>>();
        for (List<String> content : contents) {
            String staffName = content.get(0);
            String idCard = content.get(1);
            if (StringUtils.isEmpty((CharSequence)staffName) || StringUtils.isEmpty((CharSequence)idCard)) continue;
            String key = this.getIdCardMapKey(idCard, content.get(2).trim(), outputFlg);
            HashSet<String> staffNameSet = (HashSet<String>)idCardMap.get(key);
            if (staffNameSet == null) {
                staffNameSet = new HashSet<String>();
            }
            staffNameSet.add(staffName);
            idCardMap.put(key, staffNameSet);
        }
        return idCardMap;
    }

    private String getIdCardMapKey(String idCard, String companyName, Boolean outputFlg) {
        if (outputFlg.booleanValue()) {
            return idCard.trim() + "_" + companyName.trim();
        }
        return idCard.trim();
    }

    private String addData(List<String> content, ImportDataParam param, List<StaffBasicVo> notExistStaffList, Map<String, StaffBasicVo> notExistStaffMap, List<CheckDataResultInfo> checkDataBatch, List<CheckDataResultInfo> checkDataResultBatch) {
        String result = "";
        if (content == null || content.size() < 9) {
            return result;
        }
        CheckDataResultInfo resultInfo = new CheckDataResultInfo();
        result = this.convertToResult(resultInfo, content, param, notExistStaffList, notExistStaffMap);
        this.logger.info("resultInfo:::{}", (Object)resultInfo.getRessult());
        if (StringUtils.isEmpty((CharSequence)result)) {
            String sheetName = content.get(content.size() - 1);
            String importedResultKey = resultInfo.getIdCard() + "_" + sheetName;
            if (param.getOutputFlg().booleanValue()) {
                importedResultKey = resultInfo.getIdCard() + "_" + resultInfo.getCid() + "_" + sheetName;
            }
            this.setData(resultInfo);
            this.addResultInfo(resultInfo, checkDataBatch, checkDataResultBatch);
        }
        return result;
    }

    private String convertToResult(CheckDataResultInfo resultInfo, List<String> content, ImportDataParam param, List<StaffBasicVo> notExistStaffList, Map<String, StaffBasicVo> notExistStaffMap) {
        String workName;
        Set<String> staffNameSet;
        resultInfo.setCheckId(param.getCheckId());
        resultInfo.setCid(param.getCid());
        resultInfo.setCheckType(param.getCheckType());
        resultInfo.setCoverStaff(param.getCoverStaff());
        Object errorMsg = "";
        String sheetName = content.get(content.size() - 1);
        int outputIndex = param.getOutputFlg() != false ? 1 : 0;
        Integer index = this.addIndexMap.get(sheetName) == null ? 2 : this.addIndexMap.get(sheetName);
        this.addIndexMap.put(sheetName, index + 1);
        String staffName = content.get(0).trim();
        if (StringUtils.isEmpty((CharSequence)staffName)) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201c\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u59d3\u540d\u201c\u4e0d\u80fd\u4e3a\u7a7a!";
            return errorMsg;
        }
        resultInfo.setStaffName(staffName);
        String idCard = content.get(1).trim();
        if (StringUtils.isEmpty((CharSequence)idCard)) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u8eab\u4efd\u8bc1\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
            return errorMsg;
        }
        if (!IDCardUtil.isIDCard((String)idCard)) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u8eab\u4efd\u8bc1\u53f7\u201d:" + idCard + "\u4e0d\u5408\u6cd5!";
            return errorMsg;
        }
        String staffNameSetKey = this.getIdCardMapKey(idCard, content.get(2).trim(), param.getOutputFlg());
        if (param.getOutputFlg().booleanValue()) {
            String companyName = content.get(2).trim();
            if (StringUtils.isEmpty((CharSequence)companyName)) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
            CompanyBaseInfoModel company = this.companyProvideByHSEService.getByName(companyName);
            if (company == null || company.getId() == null) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u201d\u4e0d\u5b58\u5728\u7cfb\u7edf\u4e2d!";
                return errorMsg;
            }
            this.logger.info("[checkImportCompanyType:]" + companyName + ":" + company.getCompanyType() + ".");
            if (company.getCompanyType() != null && company.getCompanyType() == 2) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\uff1a" + companyName + "\u201d\u4e3a\u5916\u5305\u5355\u4f4d\uff0c\u8bf7\u586b\u5199\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u540d\u79f0!";
                return errorMsg;
            }
            resultInfo.setCid(company.getId());
            resultInfo.setCompanyAreaId(company.getAreaId());
            resultInfo.setCompanyAddress(company.getWorkAddress());
        }
        if ((staffNameSet = this.idCardMap.get(staffNameSetKey)) != null && staffNameSet.size() > 1) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u8eab\u4efd\u8bc1\u53f7\u201d\u5728\u4e0a\u4f20\u7684excel\u4e2d\u91cd\u590d\u4e14\u59d3\u540d\u4e0d\u4e00\u81f4!";
            return errorMsg;
        }
        resultInfo.setIdCard(idCard);
        StaffBasicVo existStaff = this.getExistStaff(idCard, resultInfo.getCid());
        if (existStaff == null) {
            existStaff = notExistStaffMap.get(idCard);
            if (existStaff != null) {
                resultInfo.setStaffId(existStaff.getStaffId());
            } else {
                StaffBasicVo notExistStaff = new StaffBasicVo();
                notExistStaff.setNew(true);
                notExistStaff.setStaffName(staffName);
                notExistStaff.setIdCard(idCard);
                notExistStaff.setStaffId(Long.valueOf(this.idworker.nextId()));
                notExistStaff.setStaffBasicInfoId(Long.valueOf(this.idworker.nextId()));
                notExistStaff.setCid(resultInfo.getCid());
                notExistStaff.setWorkName(content.get(3 + outputIndex).trim());
                resultInfo.setStaffId(notExistStaff.getStaffId());
                String harms = content.get(4 + outputIndex).trim();
                if (harms != null) {
                    String harm = StringUtils.replace((String)harms, (String)"\uff0c", (String)",");
                    notExistStaff.setHarms(harm);
                }
                if (IDCardUtil.isIDCard((String)idCard)) {
                    notExistStaff.setGender(IDCardUtil.getGender((String)idCard));
                    notExistStaff.setBirthday(IDCardUtil.getBirthday((String)idCard));
                }
                notExistStaffList.add(notExistStaff);
                notExistStaffMap.put(idCard, notExistStaff);
            }
        } else {
            resultInfo.setExistStaffName(existStaff.getStaffName());
            resultInfo.setStaffId(existStaff.getStaffId());
            this.updateStaffName(resultInfo);
        }
        String harmYear = content.get(2 + outputIndex).trim();
        if (StringUtils.isEmpty((CharSequence)harmYear)) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u63a5\u5bb3\u5de5\u9f84\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
            return errorMsg;
        }
        String[] arr = harmYear.split("\u5e74");
        resultInfo.setHarmYear(arr[0] + "\u5e74");
        if (arr.length > 1) {
            resultInfo.setHarmMonth(arr[1]);
        }
        if (StringUtils.isEmpty((CharSequence)(workName = content.get(3 + outputIndex).trim()))) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5de5\u79cd\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
            return errorMsg;
        }
        resultInfo.setWorkName(workName);
        String harmNames = content.get(4 + outputIndex).trim();
        if (StringUtils.isEmpty((CharSequence)harmNames)) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
            return errorMsg;
        }
        HashSet<String> harmIds = new HashSet<String>();
        String harmErrorMsg = this.getHarmIds(harmNames, harmIds, sheetName, index, param.getCid(), param.getUserId(), "\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20");
        if (StringUtils.isNotBlank((CharSequence)harmErrorMsg)) {
            return harmErrorMsg;
        }
        String harmIdStr = String.join((CharSequence)",", harmIds);
        resultInfo.setHarmNames(harmNames);
        resultInfo.setHarmIds(harmIdStr);
        resultInfo.setAbnormal(content.get(6 + outputIndex).trim());
        String resultName = "";
        if ("\u7f3a\u5fc5\u68c0\u9879".equals(sheetName)) {
            resultName = sheetName;
            resultInfo.setRessult(ExamResultEnum.mis.getCode());
            resultInfo.setMissingItems(content.get(5 + outputIndex).trim());
            if (StringUtils.isEmpty((CharSequence)resultInfo.getMissingItems())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u7f3a\u68c0\u9879\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
            resultInfo.setCheckAdvice(content.get(7 + outputIndex).trim());
            resultInfo.setMedicalAdvice(content.get(8 + outputIndex).trim());
            if (StringUtils.isEmpty((CharSequence)resultInfo.getCheckAdvice())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5904\u7406\u610f\u89c1\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
        } else {
            resultName = content.get(5 + outputIndex).trim();
        }
        this.logger.info("resultName::::::{}", (Object)resultName);
        if (StringUtils.isEmpty((CharSequence)resultName)) {
            errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u7ed3\u8bba\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
            return errorMsg;
        }
        if ("\u76ee\u524d\u672a\u89c1\u5f02\u5e38".equals(resultName) || "\u5176\u4ed6\u75be\u75c5\u6216\u5f02\u5e38".equals(resultName)) {
            if ("\u76ee\u524d\u672a\u89c1\u5f02\u5e38".equals(resultName)) {
                resultInfo.setRessult(ExamResultEnum.noraml.getCode());
            } else if ("\u5176\u4ed6\u75be\u75c5\u6216\u5f02\u5e38".equals(resultName)) {
                resultInfo.setRessult(ExamResultEnum.other.getCode());
            }
            resultInfo.setMedicalAdvice(content.get(7 + outputIndex).trim());
        } else if ("\u590d\u67e5".equals(resultName)) {
            resultInfo.setRessult(ExamResultEnum.recheck.getCode());
            resultInfo.setCheckAdvice(content.get(7 + outputIndex).trim());
            resultInfo.setMedicalAdvice(content.get(8 + outputIndex).trim());
            if (StringUtils.isEmpty((CharSequence)resultInfo.getAbnormal())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5f02\u5e38\u6307\u6807\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
            if (StringUtils.isEmpty((CharSequence)resultInfo.getCheckAdvice())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5904\u7406\u610f\u89c1\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
            if (StringUtils.isEmpty((CharSequence)resultInfo.getMedicalAdvice())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u533b\u5b66\u5efa\u8bae\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
        } else if ("\u7591\u4f3c\u804c\u4e1a\u75c5".equals(resultName) || "\u804c\u4e1a\u7981\u5fcc\u8bc1".equals(resultName)) {
            if ("\u7591\u4f3c\u804c\u4e1a\u75c5".equals(resultName)) {
                resultInfo.setHarmDesc(content.get(10 + outputIndex).trim());
                if (!StringUtils.isNotEmpty((String)resultInfo.getHarmDesc())) {
                    errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u7591\u4f3c\u804c\u4e1a\u75c5\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                    return errorMsg;
                }
                Integer diseaseId = this.allDiseaseNameIdMap.get(resultInfo.getHarmDesc());
                resultInfo.setHarmDescId(diseaseId);
                resultInfo.setRessult(ExamResultEnum.so.getCode());
            } else {
                String occHarms = content.get(9 + outputIndex).trim();
                if (StringUtils.isEmpty((CharSequence)occHarms)) {
                    errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u7ed3\u8bba\u4e3a\u201c\u804c\u4e1a\u7981\u5fcc\u8bc1\u201d\u7684\u201c\u804c\u4e1a\u7981\u5fcc\u7684\u5371\u5bb3\u56e0\u7d20\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                    return errorMsg;
                }
                HashSet<String> occHarmIds = new HashSet<String>();
                String harmErrorMsg2 = this.getHarmIds(occHarms, occHarmIds, sheetName, index, param.getCid(), param.getUserId(), "\u5371\u5bb3\u56e0\u7d20");
                if (StringUtils.isNotBlank((CharSequence)harmErrorMsg2)) {
                    return harmErrorMsg2;
                }
                String occHarmIdStr = String.join((CharSequence)",", occHarmIds);
                resultInfo.setOccHarmIds(occHarmIdStr);
                resultInfo.setRessult(ExamResultEnum.oc.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)resultInfo.getRessult())) {
                if (sheetName.indexOf("\u7591\u4f3c") >= 0 || sheetName.indexOf("\u804c\u4e1a\u7981\u5fcc") >= 0) {
                    errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u7ed3\u8bba\u201d\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u201c\u7ed3\u8bba\u201d\u7684\u5185\u5bb9\u8bf7\u4ece\u6a21\u677f\u4e2d\u7684\u4e0b\u62c9\u9009\u9879\u4e2d\u9009\u62e9!";
                    return errorMsg;
                }
                if (sheetName.indexOf("\u590d\u67e5") >= 0) {
                    errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u7ed3\u8bba\u201d\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u201c\u7ed3\u8bba\u201d\u7684\u5185\u5bb9\u8bf7\u4ece\u6a21\u677f\u4e2d\u7684\u4e0b\u62c9\u9009\u9879\u4e2d\u9009\u62e9!";
                    return errorMsg;
                }
                if (sheetName.indexOf("\u5176\u4ed6\u4eba\u5458\u540d\u5355") >= 0) {
                    errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u7ed3\u8bba\u201d\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u201c\u7ed3\u8bba\u201d\u7684\u5185\u5bb9\u8bf7\u4ece\u6a21\u677f\u4e2d\u7684\u4e0b\u62c9\u9009\u9879\u4e2d\u9009\u62e9!";
                    return errorMsg;
                }
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u7ed3\u8bba\u201d\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u201c\u7ed3\u8bba\u201d\u7684\u5185\u5bb9\u8bf7\u4ece\u6a21\u677f\u4e2d\u7684\u4e0b\u62c9\u9009\u9879\u4e2d\u9009\u62e9!";
                return errorMsg;
            }
            resultInfo.setCheckAdvice(content.get(7 + outputIndex).trim());
            resultInfo.setMedicalAdvice(content.get(8 + outputIndex).trim());
            if (StringUtils.isEmpty((CharSequence)resultInfo.getAbnormal())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5f02\u5e38\u6307\u6807\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
            if (StringUtils.isEmpty((CharSequence)resultInfo.getCheckAdvice())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u5904\u7406\u610f\u89c1\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
            if (StringUtils.isEmpty((CharSequence)resultInfo.getMedicalAdvice())) {
                errorMsg = "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c\u533b\u5b66\u5efa\u8bae\u201d\u4e0d\u80fd\u4e3a\u7a7a!";
                return errorMsg;
            }
        }
        return errorMsg;
    }

    private void updateStaffName(CheckDataResultInfo resultInfo) {
        List<StaffBasicVo> staffInfos = this.staffIdCardMap.get(resultInfo.getIdCard() + "_" + resultInfo.getCid());
        if (staffInfos == null || staffInfos.size() == 0) {
            return;
        }
        Object vo = null;
        for (StaffBasicVo v : staffInfos) {
            v.setStaffName(resultInfo.getStaffName());
        }
    }

    private List<String> multiSplit(String str) {
        Object[] harmStrArr;
        ArrayList<String> arr = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)str) && ArrayUtils.isNotEmpty((Object[])(harmStrArr = StringUtils.splitByWholeSeparator((String)(str = str.replaceAll("\uff0c", "\uff1b")), (String)"\uff1b")))) {
            return Arrays.asList(harmStrArr);
        }
        return arr;
    }

    private String getHarmIds(String harmNames, Set<String> harmIds, String sheetName, int index, Long cid, Long creator, String title) {
        List<String> arr = this.multiSplit(harmNames);
        for (String harmName : arr) {
            if (StringUtils.isBlank((CharSequence)harmName)) continue;
            Long harmId = this.harmMap.get(harmName = StringUtils.toDBC((String)harmName));
            if (harmId != null) {
                harmIds.add("" + harmId);
                continue;
            }
            HarmFactor harmFactor = this.harmFactorService.getOccupationalRiskFactorsAutoCompleteByBlendName(null, harmName, cid);
            if (harmFactor != null && harmFactor.getId() != null) {
                if (harmFactor.getBelongGbz188() == null || harmFactor.getBelongGbz188() != 1) {
                    harmFactor.setBelongGbz188(Integer.valueOf(1));
                    this.harmFactorService.updateById(harmFactor, creator);
                    this.harmMap.put(harmName, harmFactor.getId());
                    harmIds.add("" + harmFactor.getId());
                    continue;
                }
                this.harmMap.put(harmName, harmFactor.getId());
                harmIds.add("" + harmFactor.getId());
                continue;
            }
            if (!this.isCustomHarm(harmName)) {
                return "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c" + title + "\u201d\uff1a\u201c" + harmName + "\u201d\u4e0d\u5728\u7cfb\u7edf\u9009\u9879\u4e2d\uff0c\u8bf7\u6309\u4ee5\u4e0b\u683c\u5f0f\u586b\u5199\uff1a\u5176\u4ed6\u5316\u5b66\u56e0\u7d20(\u5177\u4f53\u6210\u5206)\uff0c\u5176\u4ed6\u7c89\u5c18(\u5177\u4f53\u6210\u5206)\uff0c\u5176\u4ed6\u7269\u7406\u56e0\u7d20(\u5177\u4f53\u540d\u79f0\uff09\uff0c\u5176\u4ed6\u751f\u7269\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)\uff0c\u5176\u4ed6\u653e\u5c04\u6027\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)\uff0c\u5176\u4ed6\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)";
            }
            String customHarmName = this.getCustomHarmName(harmName);
            if (customHarmName.equals("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20") || customHarmName.equals("\u5176\u4ed6\u7c89\u5c18") || customHarmName.equals("\u5176\u4ed6\u7269\u7406\u56e0\u7d20") || customHarmName.equals("\u5176\u4ed6\u751f\u7269\u56e0\u7d20") || customHarmName.equals("\u5176\u4ed6\u653e\u5c04\u6027\u56e0\u7d20") || customHarmName.equals("\u5176\u4ed6\u56e0\u7d20")) {
                return "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c" + title + "\u201d\uff1a\u201c" + harmName + "\u201d\u4e0d\u5728\u7cfb\u7edf\u9009\u9879\u4e2d\uff0c\u8bf7\u6309\u4ee5\u4e0b\u683c\u5f0f\u586b\u5199\uff1a\u5176\u4ed6\u5316\u5b66\u56e0\u7d20(\u5177\u4f53\u6210\u5206)\uff0c\u5176\u4ed6\u7c89\u5c18(\u5177\u4f53\u6210\u5206)\uff0c\u5176\u4ed6\u7269\u7406\u56e0\u7d20(\u5177\u4f53\u540d\u79f0\uff09\uff0c\u5176\u4ed6\u751f\u7269\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)\uff0c\u5176\u4ed6\u653e\u5c04\u6027\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)\uff0c\u5176\u4ed6\u56e0\u7d20(\u5177\u4f53\u540d\u79f0)";
            }
            HarmFactor customHarmFactor = this.harmFactorService.getOccupationalRiskFactorsAutoCompleteByNameCh(null, customHarmName, cid);
            if (customHarmFactor != null && customHarmFactor.getId() != null && customHarmFactor.getIsValid() != null && customHarmFactor.getIsValid().booleanValue()) {
                return "\u5de5\u4f5c\u7c3f\uff1a\u201c" + sheetName + "\u201d\u4e2d\u7b2c" + index + "\u884c\u7684\u201c" + title + "\u201d\uff1a\u201c" + harmName + "\u201d\u4e0e\u7cfb\u7edf\u4e2d\u7684\u5371\u5bb3\u56e0\u7d20\uff1a\u201c" + customHarmFactor.getBlendName() + "\u201d\u91cd\u590d!";
            }
            String harmType = this.getHarmTypeByCustomType(harmName);
            HarmFactor newHarm = this.harmFactorService.addByNameAndType(harmName, harmType, cid, creator);
            this.harmMap.put(harmName, newHarm.getId());
            harmIds.add("" + newHarm.getId());
        }
        return null;
    }

    private String getHarmTypeByCustomType(String type) {
        if (type.startsWith("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20")) {
            return "\u5316\u5b66\u56e0\u7d20";
        }
        if (type.startsWith("\u5176\u4ed6\u7269\u7406\u56e0\u7d20")) {
            return "\u7269\u7406\u56e0\u7d20";
        }
        if (type.startsWith("\u5176\u4ed6\u653e\u5c04\u6027\u56e0\u7d20")) {
            return "\u653e\u5c04\u56e0\u7d20";
        }
        if (type.startsWith("\u5176\u4ed6\u751f\u7269\u56e0\u7d20")) {
            return "\u751f\u7269\u56e0\u7d20";
        }
        if (type.startsWith("\u5176\u4ed6\u7c89\u5c18")) {
            return "\u7c89\u5c18";
        }
        return "\u5176\u4ed6\u56e0\u7d20";
    }

    private boolean isCustomHarm(String customHarmName) {
        if (!customHarmName.contains("(") || !customHarmName.contains(")")) {
            return false;
        }
        return customHarmName.startsWith("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20") || customHarmName.startsWith("\u5176\u4ed6\u7c89\u5c18") || customHarmName.startsWith("\u5176\u4ed6\u7269\u7406\u56e0\u7d20") || customHarmName.startsWith("\u5176\u4ed6\u751f\u7269\u56e0\u7d20") || customHarmName.startsWith("\u5176\u4ed6\u653e\u5c04\u6027\u56e0\u7d20") || customHarmName.startsWith("\u5176\u4ed6\u56e0\u7d20");
    }

    private String getCustomHarmName(String customHarmName) {
        String[] harmInfos = customHarmName.split("\\(");
        Object newHarmName = "";
        for (int i = 1; i < harmInfos.length; ++i) {
            newHarmName = (String)newHarmName + harmInfos[i];
            if (i >= harmInfos.length - 1) continue;
            newHarmName = (String)newHarmName + "(";
        }
        return ((String)newHarmName).substring(0, ((String)newHarmName).length() - 1);
    }

    private StaffBasicVo getExistStaff(String idCard, Long cid) {
        String key = idCard + "_" + cid;
        List staffInfos = this.staffIdCardMap.get(key);
        if (staffInfos == null || staffInfos.size() == 0) {
            staffInfos = this.staffInfoService.getStaffInfoByIdCard(cid, idCard);
            if (staffInfos != null && staffInfos.size() > 0) {
                return (StaffBasicVo)staffInfos.get(0);
            }
            return null;
        }
        return staffInfos.get(0);
    }

    private void setData(CheckDataResultInfo resultInfo) {
        List<CheckDataResultInfo> existResults = this.existAllResultMap.get(resultInfo.getIdCard() + "_" + resultInfo.getCid());
        if (existResults == null || existResults.isEmpty()) {
            this.setStaffInfo(resultInfo);
        } else {
            CheckDataResultInfo existResult = null;
            boolean hasOtherResult = false;
            for (CheckDataResultInfo r : existResults) {
                if (ExamResultEnum.getGroup((String)r.getRessult()).equals(ExamResultEnum.getGroup((String)resultInfo.getRessult()))) {
                    existResult = r;
                    continue;
                }
                hasOtherResult = true;
            }
            if (existResult != null) {
                if (resultInfo.getDataId() == null) {
                    resultInfo.setResultId(existResult.getResultId());
                    resultInfo.setDataId(existResult.getDataId());
                } else {
                    if (!hasOtherResult) {
                        this.dao.deleteByDataId(existResult.getDataId());
                    }
                    this.superviseCheckThirdOrganizationService.deleteCheckResultByIds("" + existResult.getResultId());
                }
                this.setStaffInfo(resultInfo);
            } else {
                existResult = existResults.get(0);
                resultInfo.setDataId(existResult.getDataId());
                this.setStaffInfo(resultInfo);
            }
        }
    }

    private void setStaffInfo(CheckDataResultInfo resultInfo) {
        String idCard = resultInfo.getIdCard();
        if ("\u7591\u4f3c\u804c\u4e1a\u75c5".equalsIgnoreCase(resultInfo.getAbnormal())) {
            resultInfo.setRessult("3");
        } else if ("\u804c\u4e1a\u7981\u5fcc\u8bc1".equalsIgnoreCase(resultInfo.getAbnormal())) {
            resultInfo.setRessult("4");
        } else if (resultInfo.getAbnormal().contains("\u590d\u67e5")) {
            resultInfo.setRessult("2");
        } else if (resultInfo.getAbnormal().contains("\u5176\u4ed6")) {
            resultInfo.setRessult("5");
        } else if (resultInfo.getAbnormal().contains("\u6b63\u5e38")) {
            resultInfo.setRessult("1");
        }
        StaffBasicVo staffInfo = this.getExistStaff(idCard, resultInfo.getCid());
        this.setStaffInfo(resultInfo, staffInfo);
    }

    private void setStaffInfo(CheckDataResultInfo resultInfo, StaffBasicVo staffInfo) {
        if (staffInfo != null) {
            resultInfo.setStaffId(staffInfo.getStaffId());
            resultInfo.setStaffDeptId(staffInfo.getDeptId());
            resultInfo.setStaffDeptName(staffInfo.getDeptName());
            resultInfo.setWorkNo(staffInfo.getWorkNo());
            resultInfo.setRealName(staffInfo.getStaffName());
        }
    }

    public void setStaffInfoByQuery(CheckDataResultInfo resultInfo) {
        Long cid = resultInfo.getCid();
        String idCard = resultInfo.getIdCard();
        Integer coverStaff = resultInfo.getCoverStaff();
        if (coverStaff == 1) {
            resultInfo.setStaffName(resultInfo.getExistStaffName());
        } else if (coverStaff == 2) {
            this.staffInfoService.updateStaffNameByIdCardAndCid(cid, idCard, resultInfo.getStaffName());
        }
        StaffBasicVo staffInfo = this.staffInfoService.getOrAddStaffInfoByQuery(resultInfo.getCid(), resultInfo.getStaffName(), resultInfo.getIdCard(), resultInfo.getWorkName(), resultInfo.getHarmIds(), null);
        this.setStaffInfo(resultInfo, staffInfo);
    }

    private void addStaffIdCardMap(String idCard, StaffBasicVo staffInfo) {
        String key = idCard + "_" + staffInfo.getCid();
        List<StaffBasicVo> staffInfos = this.staffIdCardMap.get(key);
        if (staffInfos == null) {
            staffInfos = new ArrayList<StaffBasicVo>();
        }
        staffInfos.add(staffInfo);
        this.staffIdCardMap.put(key, staffInfos);
    }

    private void addResultInfo(CheckDataResultInfo resultInfo, List<CheckDataResultInfo> checkDataBatch, List<CheckDataResultInfo> checkDataResultBatch) {
        if (resultInfo.getDataId() != null) {
            this.dao.updateCheckData(resultInfo);
        } else {
            resultInfo.setDataId(Long.valueOf(this.idworker.nextId()));
            checkDataBatch.add(resultInfo);
        }
        if (resultInfo.getResultId() != null) {
            this.dao.updateCheckDataResult(resultInfo);
        } else {
            resultInfo.setResultId(Long.valueOf(this.idworker.nextId()));
            checkDataResultBatch.add(resultInfo);
        }
    }
}

