/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserVo;
import cn.smarthse.modules.health.supervise.dao.check.SuperviseCheckThirdHomeMapper;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountInfo;
import cn.smarthse.modules.health.supervise.entity.check.CheckParam;
import cn.smarthse.modules.health.supervise.entity.check.CompanyCountInfo;
import cn.smarthse.modules.health.supervise.entity.check.SupervisePhcPhysicalCheckCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.check.homePage.DiseaserIncrease;
import cn.smarthse.modules.health.supervise.entity.check.homePage.DiseaserIncreaseParam;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdHomeService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.supervise.service.sys.ISysAreaService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
@Transactional(readOnly=true)
public class SuperviseCheckThirdHomeServiceImpl
implements ISuperviseCheckThirdHomeService {
    @Autowired
    SuperviseCheckThirdHomeMapper dao;
    @Autowired
    ISysAreaService sysAreaService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    IDiseaseThirdService diseaseThirdService;
    @Autowired
    ISupervisePhcPhysicalOdService supervisePhcPhysicalOdService;

    public String checkRate(Integer year, Long areaId, Byte areaLevel, Byte ownLevel) {
        Integer checkedCount = this.dao.checkedCount(null, null, year, areaId, areaLevel, null, ownLevel);
        Integer allCount = this.dao.allCount(areaId, areaLevel);
        return NumberUtil.rateProcessing((int)checkedCount, (int)allCount);
    }

    private static String txfloat(int a, int b, String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format((double)a / (double)b);
    }

    public Integer diseasers(Integer year, Long areaId, Byte areaLevel, Byte ownLevel) {
        Integer counts = this.dao.diseasers(year, areaId, areaLevel, ownLevel);
        return counts == null ? 0 : counts;
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> willExpirateCompanies(CheckParam param) {
        return this.dao.willExpirateCompanies(param);
    }

    public List<SupervisePhcPhysicalCheckCompanyInfo> expiratedCompanies(Long areaId, Byte areaLevel) {
        return this.dao.expiratedCompanies(areaId, areaLevel);
    }

    public Integer willExpirateCompanyCount(CheckParam param) {
        List<SupervisePhcPhysicalCheckCompanyInfo> list = this.willExpirateCompanies(param);
        return list == null ? 0 : list.size();
    }

    public Integer expiratedCompanyCount(Long areaId, Byte areaLevel) {
        List<SupervisePhcPhysicalCheckCompanyInfo> list = this.expiratedCompanies(areaId, areaLevel);
        return list == null ? 0 : list.size();
    }

    public List<DiseaserIncrease> listDiseaserIncreases(DiseaserIncreaseParam param) {
        List<Long> cids = this.getIncreaseCids(param);
        List<DiseaserIncrease> result = this.listDiseaserIncreaseInfos(cids);
        return result;
    }

    private List<DiseaserIncrease> listDiseaserIncreaseInfos(List<Long> cids) {
        if (cids == null || cids.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DiseaserIncreaseParam param = new DiseaserIncreaseParam();
        param.setCids(cids);
        return this.dao.listDiseaserIncreases(param);
    }

    private List<Long> getIncreaseCids(DiseaserIncreaseParam param) {
        Long areaId = param.getAreaId();
        Integer warningYear = param.getWarningYear();
        Integer year = DateUtils.getThisYear();
        param.setYear(year);
        List<DiseaserIncrease> diseasers = this.dao.listDiseaserIncreases(param);
        if (diseasers == null || diseasers.isEmpty() || warningYear == null || warningYear <= 0) {
            return Collections.EMPTY_LIST;
        }
        Map<Long, DiseaserIncrease> map = this.convert(diseasers);
        for (int i = 1; i < warningYear; ++i) {
            param.setYear(Integer.valueOf(year - i));
            List<DiseaserIncrease> otherYearDiseasers = this.dao.listDiseaserIncreases(param);
            if (otherYearDiseasers == null || otherYearDiseasers.isEmpty()) continue;
            for (DiseaserIncrease d : otherYearDiseasers) {
                Long cid = d.getCid();
                DiseaserIncrease thisYearDiseaserIncrease = map.get(cid);
                if (thisYearDiseaserIncrease == null) continue;
                thisYearDiseaserIncrease.setIncreaseTimes(Integer.valueOf(thisYearDiseaserIncrease.getIncreaseTimes() + 1));
            }
        }
        List<Long> cids = this.getByWarningYear(map, warningYear);
        return cids;
    }

    private List<Long> getByWarningYear(Map<Long, DiseaserIncrease> map, Integer warningYear) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Map.Entry<Long, DiseaserIncrease> m : map.entrySet()) {
            Integer increaseTimes;
            Long cid = m.getKey();
            DiseaserIncrease d = m.getValue();
            if (cid == null || d == null || (increaseTimes = d.getIncreaseTimes()) == null || increaseTimes < warningYear) continue;
            result.add(cid);
        }
        return result;
    }

    private Map<Long, DiseaserIncrease> convert(List<DiseaserIncrease> diseasers) {
        HashMap<Long, DiseaserIncrease> map = new HashMap<Long, DiseaserIncrease>();
        for (DiseaserIncrease d : diseasers) {
            d.setIncreaseTimes(Integer.valueOf(1));
            map.put(d.getCid(), d);
        }
        return map;
    }

    public PageInfo<DiseaserIncrease> pageDiseaserIncreases(JqGridParam gparam, DiseaserIncreaseParam param) {
        List<Long> cids = this.getIncreaseCids(param);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<DiseaserIncrease> result = this.listDiseaserIncreaseInfos(cids);
        return new PageInfo(result);
    }

    public String checkRateByDate(Date beginTime, Date endTime, Long areaId, Byte areaLevel, Byte ownLevel) {
        Integer checkedCount = this.dao.checkedCount(beginTime, endTime, null, areaId, areaLevel, null, ownLevel);
        Integer allCount = this.dao.allCount(areaId, areaLevel);
        return NumberUtil.rateProcessing((int)checkedCount, (int)allCount);
    }

    public Integer checkComNumByDate(Date beginTime, Date endTime, Long areaId, Byte areaLevel, Byte ownLevel) {
        Integer checkedCount = this.dao.checkedCount(beginTime, endTime, null, areaId, areaLevel, null, ownLevel);
        return checkedCount == null ? 0 : checkedCount;
    }

    public Integer checkStaffCountByDate(Date beginTime, Date endTime, Long areaId, Byte areaLevel) {
        return this.dao.checkStaffCountByDate(beginTime, endTime, areaId, areaLevel);
    }

    public List<DiseaserIncrease> listDiseaserIncreasesByNum(DiseaserIncreaseParam param) {
        return this.dao.listDiseaserIncreasesByNum(param);
    }

    public DiseaserIncrease countDiseaserIncreasesByNum(DiseaserIncreaseParam param) {
        return this.dao.countDiseaserIncreasesByNum(param);
    }

    public PageInfo<DiseaserIncrease> pageDiseaserIncreasesByNum(JqGridParam gparam, DiseaserIncreaseParam param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<DiseaserIncrease> result = this.listDiseaserIncreasesByNum(param);
        return new PageInfo(result);
    }

    public Integer checkComNumByIndustry(Date beginTime, Date endTime, Long areaId, Byte areaLevel, String industries, Byte ownLevel) {
        Integer checkedCount = this.dao.checkedCount(beginTime, endTime, null, areaId, areaLevel, industries, ownLevel);
        return checkedCount == null ? 0 : checkedCount;
    }

    public List<CompanyCountInfo> countSDByArea(Long areaId, Byte areaLevel) {
        List<CompanyCountInfo> returnList = this.getHomeAreaCountInitList();
        List<CompanyCountInfo> resultList = this.dao.countSDByArea(areaId, areaLevel);
        if (CollectionUtils.isEmpty(resultList)) {
            return returnList;
        }
        int total = resultList.stream().mapToInt(c -> c.getDiseaserCount()).sum();
        this.setReturnList(returnList, resultList, total);
        return returnList;
    }

    private void setReturnList(List<CompanyCountInfo> returnList, List<CompanyCountInfo> resultList, int total) {
        int other = total;
        int size = resultList.size();
        int len = size < 3 ? size : 3;
        for (int i = 0; i < len; ++i) {
            CompanyCountInfo r = resultList.get(i);
            int count = r.getDiseaserCount();
            r.setGroupCode(NumberUtil.rateProcessing((int)count, (int)total));
            returnList.set(i, r);
            other -= count;
        }
        if (other > 0) {
            CompanyCountInfo o = new CompanyCountInfo();
            o.setGroupName("\u5176\u4ed6");
            o.setGroupCode(NumberUtil.rateProcessing((int)other, (int)total));
            o.setDiseaserCount(Integer.valueOf(other));
            returnList.set(len, o);
        }
    }

    public List<CompanyCountInfo> countOCByArea(Long areaId, Byte areaLevel) {
        List<CompanyCountInfo> returnList = this.getHomeAreaCountInitList();
        List<CompanyCountInfo> resultList = this.dao.countOCByArea(areaId, areaLevel);
        if (CollectionUtils.isEmpty(resultList)) {
            return returnList;
        }
        int total = 0;
        ArrayList<CompanyCountInfo> finalResultList = new ArrayList<CompanyCountInfo>();
        total = this.splitOCByHarms(finalResultList, resultList);
        this.setReturnList(returnList, finalResultList, total);
        return returnList;
    }

    public List<CompanyCountInfo> countODByArea(Long areaId, Byte areaLevel) {
        List<CompanyCountInfo> returnList = this.getHomeAreaCountInitList();
        List<PhcThirdOccupationalDiseaserVo> odList = this.getODList(areaId, areaLevel);
        if (CollectionUtils.isEmpty(odList)) {
            return returnList;
        }
        int total = 0;
        ArrayList<CompanyCountInfo> finalResultList = new ArrayList<CompanyCountInfo>();
        total = this.splitByODName(finalResultList, odList);
        this.setReturnList(returnList, finalResultList, total);
        return returnList;
    }

    private int splitByODName(List<CompanyCountInfo> finalResultList, List<PhcThirdOccupationalDiseaserVo> odList) {
        int total = 0;
        Map<String, Set<String>> harmStaffIds = this.splitODName(odList);
        for (Map.Entry<String, Set<String>> entry : harmStaffIds.entrySet()) {
            CompanyCountInfo info = new CompanyCountInfo();
            String mapKey = entry.getKey();
            int size = entry.getValue().size();
            info.setGroupName(mapKey);
            info.setDiseaserCount(Integer.valueOf(size));
            total += size;
            finalResultList.add(info);
        }
        this.sortCountList(finalResultList);
        return total;
    }

    private void sortCountList(List<CompanyCountInfo> finalResultList) {
        Collections.sort(finalResultList, new Comparator<CompanyCountInfo>(){

            @Override
            public int compare(CompanyCountInfo arg0, CompanyCountInfo arg1) {
                return arg1.getDiseaserCount().compareTo(arg0.getDiseaserCount());
            }
        });
    }

    private Map<String, Set<String>> splitODName(List<PhcThirdOccupationalDiseaserVo> resultList) {
        HashMap<String, Set<String>> odStaffIdMap = new HashMap<String, Set<String>>();
        for (PhcThirdOccupationalDiseaserVo r : resultList) {
            String odNames = r.getDiseaseName();
            String staffId = String.valueOf(r.getStaffId());
            if (StringUtils.isEmpty((CharSequence)odNames)) {
                this.countByStaffId(null, staffId, odStaffIdMap);
                continue;
            }
            List odNameList = StringUtils.parseToStringList((String)odNames, (String)",");
            odNameList.forEach(h -> this.countByStaffId((String)h, staffId, (Map<String, Set<String>>)odStaffIdMap));
        }
        return odStaffIdMap;
    }

    private List<PhcThirdOccupationalDiseaserVo> getODList(Long areaId, Byte areaLevel) {
        PhcThirdOccupationalDiseaserParamVo checkParam = new PhcThirdOccupationalDiseaserParamVo();
        checkParam.setAreaLevel(areaLevel);
        checkParam.setAreaId(areaId);
        return this.supervisePhcPhysicalOdService.checkOdInfoList(checkParam);
    }

    private List<CompanyCountInfo> getHomeAreaCountInitList() {
        ArrayList returnList = new ArrayList(){
            {
                this.add(new CompanyCountInfo());
                this.add(new CompanyCountInfo());
                this.add(new CompanyCountInfo());
                this.add(new CompanyCountInfo());
            }
        };
        return returnList;
    }

    private int splitOCByHarms(List<CompanyCountInfo> finalResultList, List<CompanyCountInfo> resultList) {
        int total = 0;
        Map allIdAndNameMap = this.harmFactorService.getAllIdAndNameMap();
        Map<String, Set<String>> harmStaffIds = this.splitOccIds(resultList);
        for (Map.Entry<String, Set<String>> entry : harmStaffIds.entrySet()) {
            CompanyCountInfo info = new CompanyCountInfo();
            String mapKey = entry.getKey();
            String groupName = (String)allIdAndNameMap.get(mapKey);
            int size = entry.getValue().size();
            info.setGroupName(groupName);
            info.setDiseaserCount(Integer.valueOf(size));
            total += size;
            finalResultList.add(info);
        }
        this.sortCountList(finalResultList);
        return total;
    }

    private Map<String, Set<String>> splitOccIds(List<CompanyCountInfo> resultList) {
        HashMap<String, Set<String>> harmStaffIds = new HashMap<String, Set<String>>();
        for (CompanyCountInfo r : resultList) {
            String harmIds = r.getGroupName();
            String staffId = r.getGroupCode();
            if (StringUtils.isEmpty((CharSequence)harmIds)) {
                this.countByStaffId(null, staffId, harmStaffIds);
                continue;
            }
            List harmIdList = StringUtils.parseToStringList((String)harmIds, (String)"");
            harmIdList.forEach(h -> this.countByStaffId((String)h, staffId, (Map<String, Set<String>>)harmStaffIds));
        }
        return harmStaffIds;
    }

    private void countByStaffId(String key, String staffId, Map<String, Set<String>> staffIdMap) {
        HashSet<String> staffIds = staffIdMap.get(key);
        staffIds = staffIds == null ? new HashSet<String>() : staffIds;
        staffIds.add(staffId);
        staffIdMap.put(key, staffIds);
    }

    public Integer countCompanyByHarms(String harmIds, Long areaId, Byte areaLevel) {
        return this.dao.countCompanyByHarms(harmIds, areaId, areaLevel);
    }

    public List<CheckCountInfo> countCompanyByScale(Long areaId, Byte areaLevel) {
        return this.dao.countCompanyByScale(areaId, areaLevel);
    }
}

