/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckFile;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckDataVO;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckQuery;
import cn.smarthse.modules.health.supervise.dao.check.SuperviseCheckSmarthseMapper;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckFileInfo;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckSmarthseService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SuperviseCheckSmarthseServiceImpl
implements ISuperviseCheckSmarthseService {
    @Autowired
    SuperviseCheckSmarthseMapper dao;
    @Autowired
    ISuperviseCheckThirdOrganizationService thirdOrganizationService;
    @Autowired
    OssClientBean ossClientBean;

    public PhcPhysicalCheck getDetailById(Long id) {
        if (id == null) {
            return new PhcPhysicalCheck();
        }
        PhcPhysicalCheck data = this.dao.getDetailById(id);
        if (data == null || data.getId() == null) {
            return data;
        }
        data.setManagerName(SpringEncryptUtils.decrypt((String)data.getManagerName()));
        this.setFiles(data);
        this.setCheckFiles(data);
        return data;
    }

    private void setCheckFiles(PhcPhysicalCheck data) {
        List checkTypes = data.getCheckTypes();
        if (checkTypes == null || checkTypes.size() == 0) {
            return;
        }
        for (PhcPhysicalCheckType checkType : checkTypes) {
            List files = this.thirdOrganizationService.getFiles(checkType.getCheckReportFileIds());
            checkType.setCheckReportFiles(this.convertToSysFile(files));
        }
    }

    private List<SysFileModel> convertToSysFile(List<CheckFileInfo> files) {
        ArrayList<SysFileModel> sysFiles = new ArrayList<SysFileModel>();
        if (files == null || files.isEmpty()) {
            return sysFiles;
        }
        for (CheckFileInfo f : files) {
            SysFileModel sysFile = new SysFileModel();
            sysFile.setFileName(f.getFileName());
            sysFile.setFullPath(f.getFileUrl());
            sysFiles.add(sysFile);
        }
        return sysFiles;
    }

    private void setFiles(PhcPhysicalCheck data) {
        List<PhcPhysicalCheckFile> allFiles = this.dao.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (PhcPhysicalCheckFile file : allFiles) {
            String url = this.ossClientBean.getUrl(file.getFileUrl());
            file.setFileUrl(url);
            if (file.getFileType() == null) continue;
            switch (file.getFileType()) {
                case 1: {
                    data.getReportFiles().add(file);
                    break;
                }
            }
        }
    }

    public PageInfo<PhcPhysicalCheckDataVO> getList(JqGridParam gparam, PhcPhysicalCheckQuery param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param == null || param.getCheckId() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalCheckDataVO> list = this.dao.listDatas(param);
        return new PageInfo(list);
    }
}

