/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.enums.check.SuperviseDealStatusEnum;
import cn.smarthse.modules.health.pojo.ComOccReform;
import cn.smarthse.modules.health.pojo.ComOccReformDealCount;
import cn.smarthse.modules.health.pojo.ComOccReformDealCountParam;
import cn.smarthse.modules.health.pojo.YearOccReformDealCount;
import cn.smarthse.modules.health.supervise.dao.check.SuperviseCheckAbnormalMapper;
import cn.smarthse.modules.health.supervise.entity.check.homePage.Abnormal;
import cn.smarthse.modules.health.supervise.entity.check.homePage.AbnormalDealInfo;
import cn.smarthse.modules.health.supervise.entity.check.homePage.AbnormalParam;
import cn.smarthse.modules.health.supervise.entity.check.homePage.DiseaserIncrease;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.model.AbnormalOrgComResult;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckAbnormalService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdStaffSearchVo;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdStaffVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
@Transactional(readOnly=true)
public class SuperviseCheckAbnormalServiceImpl
implements ISuperviseCheckAbnormalService {
    @Autowired
    SuperviseCheckAbnormalMapper dao;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    IDiseaseThirdService diseaseThirdService;
    @Autowired
    ISupervisePhcPhysicalOdService supervisePhcPhysicalOdService;
    @Autowired
    ISuperviseCheckThirdOrganizationService superviseCheckThirdOrganizationService;
    @Autowired
    IWorkOperateLogService workOperateLogService;

    public Integer checkResult2Num(Long areaId, Byte areaLevel) {
        AbnormalParam param = new AbnormalParam();
        param.setAreaId(areaId);
        param.setAreaLevel(areaLevel);
        param.setExamResult(ExamResultEnum.recheck.getCode());
        param.setSuperviseListType(Byte.valueOf((byte)1));
        List<Abnormal> list = this.checkResultList(param);
        return list == null ? 0 : list.size();
    }

    public Integer checkResult3Num(Long areaId, Byte areaLevel) {
        AbnormalParam param = new AbnormalParam();
        param.setAreaId(areaId);
        param.setAreaLevel(areaLevel);
        param.setExamResult(ExamResultEnum.so.getCode());
        param.setSuperviseListType(Byte.valueOf((byte)1));
        List<Abnormal> list = this.checkResultList(param);
        return list == null ? 0 : list.size();
    }

    public Integer checkResult4Num(Long areaId, Byte areaLevel) {
        AbnormalParam param = new AbnormalParam();
        param.setAreaId(areaId);
        param.setAreaLevel(areaLevel);
        param.setExamResult(ExamResultEnum.oc.getCode());
        param.setSuperviseListType(Byte.valueOf((byte)1));
        List<Abnormal> list = this.checkResultList(param);
        return list == null ? 0 : list.size();
    }

    public List<AbnormalOrgComResult> checkResult2Undeal(Long areaId, Byte areaLevel, int day) {
        return this.dao.checkResultUndeal(areaId, areaLevel, ExamResultEnum.recheck.getCode(), day);
    }

    public List<AbnormalOrgComResult> checkResult3Undeal(Long areaId, Byte areaLevel, int day) {
        return this.dao.checkResultUndeal(areaId, areaLevel, ExamResultEnum.so.getCode(), day);
    }

    public List<AbnormalOrgComResult> checkResult4Undeal(Long areaId, Byte areaLevel, int day) {
        return this.dao.checkResultUndeal(areaId, areaLevel, ExamResultEnum.oc.getCode(), day);
    }

    public List<AbnormalOrgComResult> checkResultUnreport(Long areaId, Byte areaLevel, int day) {
        return this.dao.checkResultUnreport(areaId, areaLevel, day, null);
    }

    public List<AbnormalOrgComResult> checkResult2Unreport(Long areaId, Byte areaLevel, int day) {
        return this.dao.checkResultUnreport(areaId, areaLevel, day, ExamResultEnum.recheck.getCode());
    }

    public List<AbnormalOrgComResult> checkResult3Unreport(Long areaId, Byte areaLevel, int day) {
        return this.dao.checkResultUnreport(areaId, areaLevel, day, ExamResultEnum.so.getCode());
    }

    public List<Abnormal> checkResultList(AbnormalParam param) {
        List<Abnormal> list = this.dao.checkResultList(param);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        list.forEach(l -> l.setOccNames(this.superviseCheckThirdOrganizationService.getHarmNames(l.getOccIds())));
        return list;
    }

    public List<Abnormal> checkResultListV3_1_1(AbnormalParam param) {
        List<Abnormal> list = this.dao.checkResultListV3_1_1(param);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        list.forEach(l -> l.setOccNames(this.superviseCheckThirdOrganizationService.getHarmNames(l.getOccIds())));
        return list;
    }

    public PageInfo<Abnormal> checkResultPage(JqGridParam jparam, AbnormalParam param) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<Abnormal> result = this.checkResultList(param);
        return new PageInfo(result);
    }

    public PageInfo<Abnormal> checkResultPageV3_1_1(JqGridParam jparam, AbnormalParam param) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<Abnormal> result = this.checkResultListV3_1_1(param);
        return new PageInfo(result);
    }

    public AbnormalDealInfo getDealInfo(Long id) {
        AbnormalDealInfo info = this.dao.getDealInfo(id);
        info.setFiles(this.superviseCheckThirdOrganizationService.getFiles(info.getExchangeReportIds()));
        return info;
    }

    @Transactional(readOnly=false)
    public void ignore(Long id, Long userId, String userName, String companyName) {
        this.dao.setIgnoreFlag(id, true, userId);
        this.workOperateLogService.ignore(id, WorkOperateLogEnum.phc.getTypeVal(), userId, userName, companyName);
    }

    @Transactional(readOnly=false)
    public void retip(Long id, Long userId, String userName, String companyName) {
        this.dao.setIgnoreFlag(id, false, userId);
        this.workOperateLogService.retip(id, WorkOperateLogEnum.phc.getTypeVal(), userId, userName, companyName);
    }

    @Transactional(readOnly=false)
    public void pass(Long id, Long userId, String userName, String companyName) {
        this.setSuperviseStatus(id, SuperviseDealStatusEnum.pass.getCode(), null, userId);
        this.workOperateLogService.pass(id, WorkOperateLogEnum.phc.getTypeVal(), userId, userName, companyName);
    }

    @Transactional(readOnly=false)
    public void reback(Long id, String reason, Long userId, String userName, String companyName) {
        this.setSuperviseStatus(id, SuperviseDealStatusEnum.reback.getCode(), null, userId);
        this.workOperateLogService.back(id, WorkOperateLogEnum.phc.getTypeVal(), reason, userId, userName, companyName);
    }

    private void setSuperviseStatus(Long id, Byte superviseStatus, Byte dealStatus, Long userId) {
        if (id == null) {
            return;
        }
        this.dao.setSuperviseStatus(id, superviseStatus, dealStatus, userId);
    }

    @Transactional(readOnly=false)
    public void reportDiagnosedInfo(Long reportId, Long thirdOrgId, Long staffId, Long cid, String odNames, Date reportTime) {
        List odNameList = StringUtils.parseToStringList((String)odNames, (String)",");
        this.dao.reportDiagnosedInfo(reportId, thirdOrgId, staffId, cid, odNameList, reportTime);
    }

    @Transactional(readOnly=false)
    public void reportRecheckInfo(Long reportId, Long thirdOrgId, Long cid, Date reportTime) {
        this.dao.reportRecheckInfo(reportId, thirdOrgId, cid, reportTime);
    }

    public PageInfo<ComOccReformDealCount> queryComOccReformDealCount(ComOccReformDealCountParam param) {
        List<ComOccReform> list = this.queryReformDealCom(param);
        List<ComOccReformDealCount> rList = this.parseToComOccReformDealCount(list);
        rList = this.filterByThreshold(rList, param);
        if (param.getSortType() != null) {
            if (param.getSortType() == 1) {
                rList.sort(Comparator.comparing(ComOccReformDealCount::getZybNoDealCount).reversed());
            } else if (param.getSortType() == 2) {
                rList.sort(Comparator.comparing(ComOccReformDealCount::getYszybNoDealCount).reversed());
            } else if (param.getSortType() == 3) {
                rList.sort(Comparator.comparing(ComOccReformDealCount::getJjzNoDealCount).reversed());
            } else {
                rList.sort(Comparator.comparing(ComOccReformDealCount::getReportTime));
            }
        }
        return PageUtil.getPageInfo(rList, (int)param.getPage(), (int)param.getRows());
    }

    public PageInfo<ComOccReformDealCount> queryComOccReformDealCountV314(ComOccReformDealCountParam param) {
        List<ComOccReform> list = this.queryReformDealCom(param);
        List<ComOccReformDealCount> rList = this.parseToComOccReformDealCount(list);
        rList = this.filterByThresholdV314(rList, param);
        return PageUtil.getPageInfo(rList, (int)param.getPage(), (int)param.getRows());
    }

    private List<ComOccReformDealCount> filterByThresholdV314(List<ComOccReformDealCount> list, ComOccReformDealCountParam param) {
        return list.stream().filter(item -> item.getFcTotalCount() >= param.getFcTthreshold() || item.getZybTotalCount() >= param.getZybTthreshold() || item.getYszybTotalCount() >= param.getYszybTthreshold() || item.getJjzTotalCount() >= param.getJjzTthreshold()).collect(Collectors.toList());
    }

    private List<ComOccReform> queryReformDealCom(ComOccReformDealCountParam param) {
        List<ComOccReform> list = new LinkedList<ComOccReform>();
        List<ComOccReform> diseaserList = this.dao.diseaserReformList(param);
        List<ComOccReform> checkResulstList = this.dao.checkResultReformList(param);
        list.addAll(diseaserList);
        list.addAll(checkResulstList);
        if (param.getBeginTime() != null || param.getEndTime() != null || param.getBeginReportTime() != null || param.getEndReportTime() != null) {
            list = this.filterByTime(list, param);
        }
        return list;
    }

    public PageInfo<YearOccReformDealCount> queryYearOccReformDealCount(ComOccReformDealCountParam param) {
        List<ComOccReform> list = this.queryReformDealCom(param);
        List<YearOccReformDealCount> rList = this.parseToYearOccReformDealCount(list);
        return PageUtil.getPageInfo(rList, (int)param.getPage(), (int)param.getRows());
    }

    public DiseaserIncrease occComCount(ComOccReformDealCountParam param) {
        param.setPage(Integer.valueOf(1));
        param.setRows(Integer.valueOf(Integer.MAX_VALUE));
        List list = this.queryComOccReformDealCount(param).getList();
        DiseaserIncrease increase = new DiseaserIncrease();
        increase.setCompanise(Integer.valueOf(list.size()));
        for (ComOccReformDealCount count : list) {
            increase.setDiseasers(Integer.valueOf(increase.getDiseasers() + count.getZybTotalCount()));
            increase.setDiseasersNoDeal(Integer.valueOf(increase.getDiseasersNoDeal() + count.getZybNoDealCount()));
            increase.setSds(Integer.valueOf(increase.getSds() + count.getYszybTotalCount()));
            increase.setSdsNoDeal(Integer.valueOf(increase.getSdsNoDeal() + count.getYszybNoDealCount()));
            increase.setRechecks(Integer.valueOf(increase.getRechecks() + count.getFcTotalCount()));
            increase.setRechecksNoDeal(Integer.valueOf(increase.getRechecksNoDeal() + count.getFcNoDealCount()));
            increase.setOcs(Integer.valueOf(increase.getOcs() + count.getJjzTotalCount()));
            increase.setOcsNoDeal(Integer.valueOf(increase.getOcsNoDeal() + count.getJjzNoDealCount()));
        }
        return increase;
    }

    @Transactional(readOnly=false)
    public void updateDiseaerSuperviseStatus(Long diseaerId, Integer superviseStatus) {
        this.dao.updateDiseaerSuperviseStatus(diseaerId, superviseStatus);
    }

    @Transactional(readOnly=false)
    public void updateResultSuperviseStatus(Long resultId, Integer superviseStatus) {
        this.dao.updateResultSuperviseStatus(resultId, superviseStatus);
    }

    public PageInfo<ThirdStaffVo> pageStaffVoBySearch(JqGridParam jParam, ThirdStaffSearchVo searchVo) {
        if (searchVo.getAbnormal() == null) {
            List<ThirdStaffVo> list = this.queryAll(searchVo);
            PageInfo pageInfo = PageUtil.getPageInfo(list, (int)jParam.getPage(), (int)jParam.getRows());
            this.setHarmFactor(pageInfo.getList());
            return pageInfo;
        }
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<ThirdStaffVo> list = null;
        searchVo.setSearchKeyEncrypt(searchVo.getSearchKey());
        list = searchVo.getAbnormal().equals(1) ? this.dao.listStaffVoBySearchAll1(searchVo) : this.dao.listStaffVoBySearchAll2(searchVo);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
                l.setRealName(SpringEncryptUtils.decrypt((String)l.getRealName()));
            });
        }
        this.setHarmFactor(list);
        return new PageInfo(list);
    }

    private List<ThirdStaffVo> queryAll(ThirdStaffSearchVo searchVo) {
        searchVo.setSearchKeyEncrypt(searchVo.getSearchKey());
        List<ThirdStaffVo> list = this.dao.listStaffVoBySearchAll1(searchVo);
        List<ThirdStaffVo> list2 = this.dao.listStaffVoBySearchAll2(searchVo);
        list.addAll(list2);
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
                l.setRealName(SpringEncryptUtils.decrypt((String)l.getRealName()));
            });
        }
        return list;
    }

    private void setHarmFactor(List<ThirdStaffVo> list) {
        Map allIdAndNameMap = this.harmFactorService.getAllIdAndNameMap();
        for (ThirdStaffVo vo : list) {
            vo.setHarmNames(this.getHarmNamesByIds(vo.getHarmIds(), allIdAndNameMap));
            vo.setOccHarmNames(this.getHarmNamesByIds(vo.getOccHarmIds(), allIdAndNameMap));
            vo.setCheckHarmNames(this.getHarmNamesByIds(vo.getCheckHarmIds(), allIdAndNameMap));
        }
    }

    private String getHarmNamesByIds(String checkHarmIds, Map<String, String> allIdAndNameMap) {
        if (checkHarmIds == null || checkHarmIds.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : checkHarmIds.split(",")) {
            String factorName = allIdAndNameMap.get(s);
            if (factorName == null || factorName.isEmpty()) continue;
            sb.append(factorName);
            sb.append(",");
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1);
    }

    private List<ComOccReform> filterByTime(List<ComOccReform> list, ComOccReformDealCountParam param) {
        return list.stream().filter(item -> {
            Date checkTime = item.getCheckTime();
            Date reportTime = item.getReportTime();
            boolean b1 = true;
            boolean b2 = true;
            boolean b3 = true;
            boolean b4 = true;
            if (param.getBeginTime() != null) {
                boolean bl = b1 = checkTime != null && checkTime.compareTo(param.getBeginTime()) > 0;
            }
            if (param.getEndTime() != null) {
                boolean bl = b2 = checkTime != null && checkTime.compareTo(param.getEndTime()) < 0;
            }
            if (param.getBeginReportTime() != null) {
                boolean bl = b3 = reportTime != null && reportTime.compareTo(param.getBeginReportTime()) > 0;
            }
            if (param.getEndReportTime() != null) {
                b4 = reportTime != null && reportTime.compareTo(param.getEndReportTime()) < 0;
            }
            return b1 && b2 && b3 && b4;
        }).collect(Collectors.toList());
    }

    private List<ComOccReformDealCount> filterByThreshold(List<ComOccReformDealCount> list, ComOccReformDealCountParam param) {
        return list.stream().filter(item -> item.getFcTotalCount() >= param.getFcTthreshold() || item.getZybTotalCount() >= param.getZybTthreshold() || item.getYszybTotalCount() >= param.getYszybTthreshold() || item.getJjzTotalCount() >= param.getJjzTthreshold()).filter(item -> item.getFcNoDealCount() + item.getZybNoDealCount() + item.getYszybNoDealCount() + item.getJjzNoDealCount() > 0).collect(Collectors.toList());
    }

    private List<ComOccReformDealCount> parseToComOccReformDealCount(List<ComOccReform> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Long, ComOccReformDealCount> map = new HashMap<Long, ComOccReformDealCount>();
        for (ComOccReform reform : list) {
            Long cid = reform.getCid();
            ComOccReformDealCount count = (ComOccReformDealCount)map.get(cid);
            if (count == null) {
                count = new ComOccReformDealCount();
                count.setCid(cid);
                count.setComName(reform.getComName());
                count.setReportTime(reform.getReportTime());
                map.put(cid, count);
            }
            this.countReformCount(reform, count);
        }
        return new LinkedList<ComOccReformDealCount>(map.values());
    }

    private List<YearOccReformDealCount> parseToYearOccReformDealCount(List<ComOccReform> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Integer, YearOccReformDealCount> map = new HashMap<Integer, YearOccReformDealCount>();
        for (ComOccReform reform : list) {
            Date checkTime = reform.getCheckTime();
            if (checkTime == null) continue;
            Integer year = DateUtils.getYear((Date)checkTime);
            YearOccReformDealCount count = (YearOccReformDealCount)map.get(year);
            if (count == null) {
                count = new YearOccReformDealCount();
                count.setYear(year);
                map.put(year, count);
            }
            this.countYearReformCount(reform, count);
        }
        return new LinkedList<YearOccReformDealCount>(map.values());
    }

    private void countReformCount(ComOccReform reform, ComOccReformDealCount count) {
        if (reform.getGenerationSource().equals(4)) {
            count.setJjzTotalCount(Integer.valueOf(count.getJjzTotalCount() + 1));
            if (reform.getSuperviseStatus() != null && reform.getSuperviseStatus().equals(0)) {
                count.setJjzNoDealCount(Integer.valueOf(count.getJjzNoDealCount() + 1));
            }
            return;
        }
        if (reform.getGenerationSource().equals(3)) {
            count.setYszybTotalCount(Integer.valueOf(count.getYszybTotalCount() + 1));
            if (reform.getSuperviseStatus() != null && reform.getSuperviseStatus().equals(0)) {
                count.setYszybNoDealCount(Integer.valueOf(count.getYszybNoDealCount() + 1));
            }
            return;
        }
        if (reform.getGenerationSource().equals(2)) {
            count.setFcTotalCount(Integer.valueOf(count.getFcTotalCount() + 1));
            if (reform.getSuperviseStatus() != null && reform.getSuperviseStatus().equals(0)) {
                count.setFcNoDealCount(Integer.valueOf(count.getFcNoDealCount() + 1));
            }
            return;
        }
        if (reform.getGenerationSource().equals(5)) {
            count.setZybTotalCount(Integer.valueOf(count.getZybTotalCount() + 1));
            if (reform.getSuperviseStatus() != null && reform.getSuperviseStatus().equals(0)) {
                count.setZybNoDealCount(Integer.valueOf(count.getZybNoDealCount() + 1));
            }
        }
    }

    private void countYearReformCount(ComOccReform reform, YearOccReformDealCount count) {
        if (reform.getGenerationSource().equals(4)) {
            if (reform.getSuperviseStatus() != null && !reform.getSuperviseStatus().equals(0)) {
                count.setJjzDealCount(Integer.valueOf(count.getJjzDealCount() + 1));
            }
            return;
        }
        if (reform.getGenerationSource().equals(3)) {
            if (reform.getSuperviseStatus() != null && !reform.getSuperviseStatus().equals(0)) {
                count.setYszybDealCount(Integer.valueOf(count.getYszybDealCount() + 1));
            }
            return;
        }
        if (reform.getGenerationSource().equals(2)) {
            if (reform.getSuperviseStatus() != null && !reform.getSuperviseStatus().equals(0)) {
                count.setFcDealCount(Integer.valueOf(count.getFcDealCount() + 1));
            }
            return;
        }
        if (reform.getGenerationSource().equals(5) && reform.getSuperviseStatus() != null && !reform.getSuperviseStatus().equals(0)) {
            count.setZybDealCount(Integer.valueOf(count.getZybDealCount() + 1));
        }
    }
}

