/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.dao.check.StatisticsPhysicalCheckMapper;
import cn.smarthse.modules.health.supervise.entity.StatisticsPhysicalCheck;
import cn.smarthse.modules.health.supervise.model.check.HomeCheckModel;
import cn.smarthse.modules.health.supervise.model.check.StatisticsFromModel;
import cn.smarthse.modules.health.supervise.service.check.IStatisticsPhysicalCheckService;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
@Transactional
public class StatisticsPhysicalCheckServiceImpl
extends BaseServiceImpl<StatisticsPhysicalCheckMapper, StatisticsPhysicalCheck>
implements IStatisticsPhysicalCheckService {
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaProvideService;
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @Autowired
    protected IdWorker idworker;

    public void statisticsCheckInfo(Long cid) {
        this.logger.error("====== \u5f00\u59cb\u7edf\u8ba1\u4f53\u68c0\u4fe1\u606f cid={} ======", (Object)cid);
        List<StatisticsPhysicalCheck> list = ((StatisticsPhysicalCheckMapper)this.dao).statisticsCheckInfo(cid);
        if (list == null || list.isEmpty()) {
            this.logger.info("\u6ca1\u6709\u6570\u636e\u9700\u8981\u7edf\u8ba1\uff0c\u76f4\u63a5\u7ed3\u675f");
            return;
        }
        this.logger.error("\u67e5\u8be2\u5230\u5f85\u7edf\u8ba1\u6570\u636e {} \u6761", (Object)list.size());
        int pageSize = 2000;
        int maxRetries = 3;
        long startTs = System.currentTimeMillis();
        try {
            ((StatisticsPhysicalCheckMapper)this.dao).delAll();
            this.logger.info("\u5df2\u6e05\u7a7a\u5386\u53f2\u6570\u636e");
            int total = list.size();
            int pages = (total + 2000 - 1) / 2000;
            for (int i = 0; i < pages; ++i) {
                int from = i * 2000;
                int to = Math.min((i + 1) * 2000, total);
                ArrayList<StatisticsPhysicalCheck> batch = new ArrayList<StatisticsPhysicalCheck>(list.subList(from, to));
                batch.forEach(p -> p.setId(Long.valueOf(this.idworker.nextId())));
                DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
                txDef.setPropagationBehavior(0);
                TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)txDef);
                try {
                    int attempt = 0;
                    while (true) {
                        ++attempt;
                        try {
                            ((StatisticsPhysicalCheckMapper)this.dao).saveBatch(batch);
                            this.logger.info("\u6279\u6b21 {}/{} \u63d2\u5165\u6210\u529f\uff08size={}\uff0cattempt={}\uff09", new Object[]{i + 1, pages, batch.size(), attempt});
                            break;
                        }
                        catch (CannotAcquireLockException e) {
                            if (attempt >= 3) {
                                this.logger.error("\u6279\u6b21 {}/{} \u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570 {}\uff0c\u629b\u51fa\u5f02\u5e38", new Object[]{i + 1, pages, 3});
                                throw e;
                            }
                            long waitMs = 1000L * (1L << attempt - 1);
                            this.logger.warn("\u6279\u6b21 {}/{} \u63d2\u5165\u88ab\u9501\uff0c\u91cd\u8bd5 {}/{}\uff0c\u7b49\u5f85 {} ms", new Object[]{i + 1, pages, attempt, 3, waitMs});
                            try {
                                Thread.sleep(waitMs);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                throw new RuntimeException("\u91cd\u8bd5\u7b49\u5f85\u88ab\u4e2d\u65ad", ie);
                            }
                        }
                    }
                    this.transactionManager.commit(status);
                    continue;
                }
                catch (RuntimeException e) {
                    this.transactionManager.rollback(status);
                    this.logger.error("\u6279\u6b21 {}/{} \u51fa\u9519\uff0c\u5df2\u56de\u6eda", new Object[]{i + 1, pages, e});
                    throw e;
                }
            }
            long elapsed = System.currentTimeMillis() - startTs;
            this.logger.error("====== \u7edf\u8ba1\u4f53\u68c0\u4fe1\u606f\u5b8c\u6210\uff0c\u603b\u5904\u7406\u6761\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{} ms ======", (Object)list.size(), (Object)elapsed);
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1\u4f53\u68c0\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public LayUiResponseResult<StatisticsFromModel> listPage(SearchParam searchParam) {
        PageHelper.startPage((int)searchParam.getPageNum(), (int)searchParam.getPageSize());
        PageInfo pageInfo = new PageInfo(this.listData(searchParam));
        return new LayUiResponseResult(pageInfo);
    }

    public List<StatisticsFromModel> listData(SearchParam searchParam) {
        if (searchParam.getAreaId() != null) {
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(searchParam.getAreaId());
            searchParam.setLevel(areaModel.getLevel());
            if (areaModel.getLevel() == 4) {
                return Collections.emptyList();
            }
        }
        return ((StatisticsPhysicalCheckMapper)this.dao).listData(searchParam);
    }

    public StatisticsFromModel headData(SearchParam searchParam) {
        if (searchParam.getAreaId() != null) {
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(searchParam.getAreaId());
            searchParam.setLevel(areaModel.getLevel());
        }
        return ((StatisticsPhysicalCheckMapper)this.dao).headData(searchParam);
    }

    public HomeCheckModel getData15(HomeIndexSearchVo searchVo) {
        return ((StatisticsPhysicalCheckMapper)this.dao).getData15(searchVo);
    }
}

