/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.certificate;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.supervise.dao.certificate.CertificateCompanyMapper;
import cn.smarthse.modules.health.supervise.dao.certificate.CertificateFilesMapper;
import cn.smarthse.modules.health.supervise.dao.certificate.SuperviseCertificateMapper;
import cn.smarthse.modules.health.supervise.entity.certificate.CertificateCompany;
import cn.smarthse.modules.health.supervise.entity.certificate.CertificateFiles;
import cn.smarthse.modules.health.supervise.entity.certificate.CertificateInfo;
import cn.smarthse.modules.health.supervise.enums.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.supervise.service.certificate.ISuperviseCertificateService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SuperviseCertificateServiceImpl
implements ISuperviseCertificateService {
    @Autowired
    SuperviseCertificateMapper dao;
    @Autowired
    CertificateCompanyMapper certificateCompanyMapper;
    @Autowired
    CertificateFilesMapper certificateFilesMapper;
    @Autowired
    OssClientBean ossClientBean;
    @DubboReference
    IStaffInfoService staffInfoService;

    public PageInfo<CertificateInfo> getPreviousCertificateInfo(JqGridParam param) {
        if (param.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CertificateInfo> list = this.dao.getCertificateInfoByCid(param.getCid());
        for (CertificateInfo cert : list) {
            if (cert.getValidityDate() == null) {
                // empty if block
            }
            if (cert.getStaffType().equals(OccHeaStaffTypeEnum.MAIN.getCode())) {
                cert.setStaffTypeName(OccHeaStaffTypeEnum.MAIN.getName());
            } else {
                cert.setStaffTypeName(OccHeaStaffTypeEnum.OccHeaMan.getName());
            }
            cert.setHaveCertificate("\u662f");
            if (cert.getValidityDate() != null) {
                SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
                String datastr = time.format(cert.getValidityDate());
                cert.setDataStr(datastr);
                continue;
            }
            cert.setDataStr("-");
        }
        return new PageInfo(list);
    }

    public List<CertificateInfo> getPreviousCertificateInfoList(Long cid) {
        if (cid == null) {
            return null;
        }
        List<CertificateInfo> list = this.dao.getCertificateInfoByCid(cid);
        if (list != null && list.size() > 0) {
            Boolean haveMainCert = true;
            Boolean haveHseCert = true;
            for (CertificateInfo cert : list) {
                String datastr;
                SimpleDateFormat time;
                StaffBasicVo cstaff;
                if (cert.getValidityDate() == null) {
                    // empty if block
                }
                if (cert.getStaffType().equals(OccHeaStaffTypeEnum.MAIN.getCode())) {
                    haveMainCert = false;
                    cert.setStaffTypeName(OccHeaStaffTypeEnum.MAIN.getName());
                } else {
                    haveHseCert = false;
                    cert.setStaffTypeName(OccHeaStaffTypeEnum.OccHeaMan.getName());
                }
                if (cert.getStaffId() != null && (cstaff = this.staffInfoService.getStaffBasicVoFromOrgById(cert.getStaffId())) != null) {
                    cert.setStaffName(cstaff.getStaffName());
                }
                cert.setHaveCertificate("\u662f");
                if (cert.getValidityDate() != null) {
                    time = new SimpleDateFormat("yyyy-MM-dd");
                    datastr = time.format(cert.getValidityDate());
                    cert.setDataStr(datastr);
                } else {
                    cert.setDataStr("-");
                }
                if (cert.getCertCreateDate() != null) {
                    time = new SimpleDateFormat("yyyy-MM-dd");
                    datastr = time.format(cert.getCertCreateDate());
                    cert.setCertCreateDateStr(datastr);
                    continue;
                }
                cert.setDataStr("-");
            }
            if (haveMainCert.booleanValue()) {
                list.add(0, this.getNullCertificateInfo(OccHeaStaffTypeEnum.MAIN.getName()));
            }
            if (haveHseCert.booleanValue()) {
                list.add(this.getNullCertificateInfo(OccHeaStaffTypeEnum.OccHeaMan.getName()));
            }
        } else {
            list.add(this.getNullCertificateInfo(OccHeaStaffTypeEnum.MAIN.getName()));
            list.add(this.getNullCertificateInfo(OccHeaStaffTypeEnum.OccHeaMan.getName()));
        }
        return list;
    }

    private CertificateInfo getNullCertificateInfo(String certName) {
        CertificateInfo info = new CertificateInfo();
        info.setStaffTypeName(certName);
        info.setHaveCertificate("\u5426");
        info.setDataStr("-");
        info.setStaffName("-");
        return info;
    }

    public List<CertificateFiles> getBusinessLicenseByCid(Long cid) {
        CertificateCompany record = new CertificateCompany();
        record.setCid(cid);
        record.setName("\u8425\u4e1a\u6267\u7167");
        record.setIsValid(Boolean.valueOf(true));
        List list = this.certificateCompanyMapper.select(record);
        CertificateCompany info = new CertificateCompany();
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                info = (CertificateCompany)list.get(0);
            } else {
                info = (CertificateCompany)list.get(0);
                if (info.getValidityDate() == null) {
                    CertificateFiles file = new CertificateFiles();
                    file.setCerId(info.getId());
                    List files = this.certificateFilesMapper.select(file);
                    if (files != null && files.size() > 0) {
                        this.getAliUrl(files);
                    }
                    info.setFiles(files);
                    return files;
                }
                for (CertificateCompany cert : list) {
                    if (cert.getValidityDate() == null) {
                        info = cert;
                        break;
                    }
                    if (!cert.getValidityDate().after(info.getValidityDate())) continue;
                    info = cert;
                }
            }
            CertificateFiles file = new CertificateFiles();
            file.setCerId(info.getId());
            List files = this.certificateFilesMapper.select(file);
            if (files != null && files.size() > 0) {
                this.getAliUrl(files);
            }
            info.setFiles(files);
            return files;
        }
        return null;
    }

    private void getAliUrl(List<CertificateFiles> files) {
        for (CertificateFiles file : files) {
            String url = this.ossClientBean.getUrl(file.getFileUrl());
            file.setFileUrl(url);
        }
    }

    public int getEffectiveCertByCidAndYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<CertificateInfo> list = this.dao.getEffectiveCertByCidAndYear(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public int getExpireCertByCidAndYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<CertificateInfo> list = this.dao.getExpireCertByCidAndYear(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public Boolean haveEffectiveCertByStaffid(Long staffId) {
        if (staffId == null) {
            return false;
        }
        List<CertificateInfo> certList = this.dao.getEffectiveCertByStaffId(staffId);
        if (certList != null && certList.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean haveMainEffectiveCertByCid(Long cid) {
        if (cid == null) {
            return false;
        }
        List<CertificateInfo> certList = this.dao.getMainEffectiveCertByCid(cid);
        if (certList != null && certList.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean haveHseManageEffectiveCertByCid(Long cid) {
        if (cid == null) {
            return false;
        }
        List<CertificateInfo> certList = this.dao.getHaveEffectiveHseCertListBycid(cid);
        if (certList != null && certList.size() > 0) {
            return true;
        }
        return false;
    }

    public int getEffectiveCertByCidThisYear(Long cid, Integer year) {
        if (cid == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<CertificateInfo> list = this.dao.getEffectiveCertByCidThisYear(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public int getExpireCertByCidThisYear(Long cid, Integer year) {
        if (cid == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<CertificateInfo> list = this.dao.getExpireCertByCidThisYear(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public List<CertificateInfo> getHaveEffectiveHseCertListBycid(Long cid) {
        List<CertificateInfo> list = this.dao.getHaveEffectiveHseCertListBycid(cid);
        return list;
    }

    public int getgetHaveEffectiveHseCertNumBycid(Long cid) {
        List<CertificateInfo> list = this.dao.getHaveEffectiveHseCertListBycid(cid);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }
}

