/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.camera;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.camera.StaffCheckInfo;
import cn.smarthse.modules.health.entity.base.device.CameraRecord;
import cn.smarthse.modules.health.pojo.CameraRecordStaff;
import cn.smarthse.modules.health.supervise.dao.camera.CameraMapper;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.AlarmCondition;
import cn.smarthse.modules.health.supervise.service.camera.ICameraService;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.AlarmCaseData;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class CameraService
extends BaseServiceImpl<CameraMapper, CameraRecord>
implements ICameraService {
    public List<AlarmCaseData> alarmCaseDataList(Date start, Date end) {
        Long startTime = start.getTime() / 1000L;
        Long endTime = end.getTime() / 1000L;
        List<CameraRecordStaff> staffs = ((CameraMapper)this.dao).queryRecordStaff(startTime, endTime);
        Map<Long, List<StaffCheckInfo>> checkInfoMap = this.staffIdToCheckInfos();
        Set<Long> diseases = this.diseases();
        LinkedList<AlarmCaseData> rList = new LinkedList<AlarmCaseData>();
        for (CameraRecordStaff staff : staffs) {
            List<StaffCheckInfo> infos;
            if (staff.getInstallationId() != null && staff.getWorkId() != null && !staff.getInstallationId().equals(staff.getWorkId())) {
                this.alarm(rList, staff, AlarmCondition.NON_POST_ENTER);
            }
            if (diseases.contains(staff.getStaffId())) {
                this.alarm(rList, staff, AlarmCondition.OCCUPATIONAL_DISEASE_PERSONNEL_ENTER);
            }
            if ((infos = checkInfoMap.get(staff.getStaffId())) == null) continue;
            boolean haveCheckType1 = false;
            boolean haveCheckType2 = false;
            for (StaffCheckInfo info : infos) {
                Integer examResult;
                if (info.getCheckType() != null && info.getCheckType().equals(1)) {
                    haveCheckType1 = true;
                }
                if (info.getCheckType() != null && info.getCheckType().equals(2)) {
                    haveCheckType2 = true;
                }
                if ((examResult = info.getExamResult()) == null) continue;
                if (examResult.equals(4)) {
                    this.alarm(rList, staff, AlarmCondition.OCCUPATIONAL_CONTRAINDICATIONS_ENTER);
                }
                if (!examResult.equals(3)) continue;
                this.alarm(rList, staff, AlarmCondition.SUSPECTED_OCCUPATIONAL_DISEASE_PERSONNEL_ENTER);
            }
            if (!haveCheckType1) {
                this.alarm(rList, staff, AlarmCondition.NO_PRE_JOB_PHYSICAL_EXAMINATION_ENTER);
            }
            if (haveCheckType2) continue;
            this.alarm(rList, staff, AlarmCondition.PERSONNEL_WITHOUT_ON_THE_JOB_PHYSICAL_EXAMINATION_ENTER);
        }
        return rList;
    }

    private Map<Long, List<StaffCheckInfo>> staffIdToCheckInfos() {
        HashMap<Long, List<StaffCheckInfo>> map = new HashMap<Long, List<StaffCheckInfo>>();
        List<StaffCheckInfo> staffCheckInfos = ((CameraMapper)this.dao).queryStaffCheckInfos();
        for (StaffCheckInfo staffCheckInfo : staffCheckInfos) {
            List list = map.computeIfAbsent(staffCheckInfo.getStaffId(), k -> new LinkedList());
            list.add(staffCheckInfo);
        }
        return map;
    }

    private Set<Long> diseases() {
        return new HashSet<Long>(((CameraMapper)this.dao).diseaseStaffIds());
    }

    private void alarm(List<AlarmCaseData> rList, CameraRecordStaff staff, AlarmCondition condition) {
        AlarmCaseData data = this.createAlarmCaseData(staff);
        data.setAlarmCase(condition.getCode());
        rList.add(data);
    }

    private AlarmCaseData createAlarmCaseData(CameraRecordStaff staff) {
        AlarmCaseData data = new AlarmCaseData();
        data.setDeviceId(staff.getDeviceId());
        data.setAlarmTime(new Date(staff.getDatetime() * 1000L));
        data.setDataId(staff.getCameraRecordId());
        return data;
    }
}

