/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.util;

import cn.hutool.core.convert.Convert;
import cn.smarthse.modules.health.sms.entity.SmsSendInfoRecord;
import cn.smarthse.modules.health.sms.enums.SmsSendFieldEnum;
import cn.smarthse.modules.health.sms.service.ISmsSendInfoRecordService;
import cn.smarthse.modules.health.sms.util.FieldConfig;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FieldChangeRecorder<T, P> {
    @Autowired
    private ISmsSendInfoRecordService smsSendInfoRecordService;

    public void recordFieldChanges(Long entityId, T before, P after, Long operatorId, Long regionId, Byte recordType, List<FieldConfig<T, P>> fieldConfigs, String applySystem) {
        if (entityId == null || before == null || after == null || fieldConfigs == null) {
            return;
        }
        for (FieldConfig<T, P> config : fieldConfigs) {
            Object afterValue;
            Object beforeValue = config.getFieldGetter().apply(before);
            if (Objects.equals(beforeValue, afterValue = config.getParamGetter().apply(after)) || !config.isRecordable()) continue;
            Arrays.stream(applySystem.split(",")).forEach(system -> this.createChangeRecord(entityId, beforeValue, afterValue, operatorId, regionId, recordType, config.getFieldEnum(), Convert.toByte((Object)system)));
        }
    }

    private void createChangeRecord(Long businessId, Object fromValue, Object toValue, Long operatorId, Long regionId, Byte recordType, SmsSendFieldEnum fieldEnum, Byte applySystem) {
        SmsSendInfoRecord record = new SmsSendInfoRecord();
        record.setId(Long.valueOf(IdWorker.getId()));
        record.setRegionId(regionId);
        record.setApplySystem(applySystem);
        record.setType(recordType);
        record.setField(fieldEnum.getKey());
        record.setBusinessId(businessId);
        record.setOldValue(Convert.toStr((Object)fromValue));
        record.setNewValue(Convert.toStr((Object)toValue));
        record.setCreateBy(operatorId);
        record.setCreateDate(LocalDateTime.now());
        this.smsSendInfoRecordService.add((Object)record);
    }
}

