/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.sms.dao.SmsSendManageMapper;
import cn.smarthse.modules.health.sms.dao.SmsSendTemplateMapper;
import cn.smarthse.modules.health.sms.entity.SmsSendManage;
import cn.smarthse.modules.health.sms.entity.SmsSendTemplate;
import cn.smarthse.modules.health.sms.enums.SmsSendApplySystemEnum;
import cn.smarthse.modules.health.sms.enums.SmsSendFieldEnum;
import cn.smarthse.modules.health.sms.enums.SmsSendTemplateTypeEnum;
import cn.smarthse.modules.health.sms.enums.SmsSendTypeEnum;
import cn.smarthse.modules.health.sms.param.SmsSendTemplateParam;
import cn.smarthse.modules.health.sms.service.ISmsSendTemplateService;
import cn.smarthse.modules.health.sms.util.FieldChangeRecorder;
import cn.smarthse.modules.health.sms.util.FieldConfig;
import cn.smarthse.modules.health.sms.vo.SmsSendManageTemplateVo;
import cn.smarthse.modules.health.sms.vo.SmsSendTemplateVo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class SmsSendTemplateServiceImpl
extends BaseServiceImpl<SmsSendTemplateMapper, SmsSendTemplate>
implements ISmsSendTemplateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsSendTemplateServiceImpl.class);
    @Autowired
    private SmsSendManageMapper smsSendManageMapper;
    @Autowired
    private FieldChangeRecorder<SmsSendTemplate, SmsSendTemplateParam> fieldChangeRecorder;
    @Autowired
    private RedisClient redisClient;
    private static final String SMS_SEND_TEMPLATE_REDIS_KEY = "smsSendTemplate_redisKey";
    private static final Long SMS_SEND_TEMPLATE_REDIS_TIME = 7200L;
    private final List<FieldConfig<SmsSendTemplate, SmsSendTemplateParam>> fieldConfigs = Arrays.asList(new FieldConfig.Builder().fieldGetter(SmsSendTemplate::getApplySystem).paramGetter(SmsSendTemplateParam::getApplySystem).fieldEnum(SmsSendFieldEnum.T_SYSTEM).recordable(Boolean.TRUE).build(), new FieldConfig.Builder().fieldGetter(SmsSendTemplate::getType).paramGetter(SmsSendTemplateParam::getType).fieldEnum(SmsSendFieldEnum.T_TYPE).recordable(Boolean.TRUE).build(), new FieldConfig.Builder().fieldGetter(SmsSendTemplate::getTemplate).paramGetter(SmsSendTemplateParam::getTemplate).fieldEnum(SmsSendFieldEnum.T_TEMPLATE).recordable(Boolean.TRUE).build(), new FieldConfig.Builder().fieldGetter(SmsSendTemplate::getIsValid).paramGetter(SmsSendTemplateParam::getIsValid).fieldEnum(SmsSendFieldEnum.T_IS_VALID).recordable(Boolean.TRUE).build());

    public SmsSendManageTemplateVo getTemplate() {
        Example example = new Example(SmsSendTemplate.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andLike("applySystem", String.valueOf(SmsSendApplySystemEnum.YCQ.getKey()));
        List smsSendTemplates = ((SmsSendTemplateMapper)this.dao).selectByExample(example);
        SmsSendManageTemplateVo smsSendManageTemplateVo = new SmsSendManageTemplateVo();
        smsSendManageTemplateVo.setTemplateVos(smsSendTemplates);
        Example example1 = new Example(SmsSendManage.class);
        example1.createCriteria().andEqualTo("isValid", (Object)1).andLike("applySystem", String.valueOf(SmsSendApplySystemEnum.YCQ.getKey()));
        SmsSendManage smsSendManage = (SmsSendManage)this.smsSendManageMapper.selectOneByExample(example1);
        smsSendManageTemplateVo.setSmsSendManage(smsSendManage);
        return smsSendManageTemplateVo;
    }

    public List<SmsSendTemplateVo> getSmsSendTemplateListByParam(SmsSendTemplateParam param) {
        if (param == null) {
            return Collections.emptyList();
        }
        List<SmsSendTemplateVo> templateList = ((SmsSendTemplateMapper)this.dao).selectSmsSendTemplateListByParam(param);
        this.postSetCommaSeparateEnumName(templateList);
        this.postSetFixedTemplateType(param, templateList);
        return templateList;
    }

    public void saveSmsSendTemplate(SmsSendTemplateParam param) {
        if (param == null) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        Long templateId = param.getId();
        String applySystem = param.getApplySystem();
        if (templateId == null) {
            SmsSendTemplate smsTemplate = new SmsSendTemplate();
            BeanUtils.copyProperties((Object)param, (Object)smsTemplate);
            smsTemplate.setId(Long.valueOf(IdWorker.getId()));
            smsTemplate.setCreateDate(now);
            smsTemplate.setUpdateDate(now);
            if (smsTemplate.getIsValid() == null) {
                smsTemplate.setIsValid(Boolean.TRUE);
            }
            ((SmsSendTemplateMapper)this.dao).insert(smsTemplate);
        } else {
            SmsSendTemplate smsTemplate = (SmsSendTemplate)((SmsSendTemplateMapper)this.dao).selectByPrimaryKey(templateId);
            if (smsTemplate == null) {
                throw new ServiceException("\u77ed\u4fe1\u6a21\u677f\u4e0d\u5b58\u5728\uff1a" + templateId);
            }
            SmsSendTemplate beforeSmsTemplate = new SmsSendTemplate();
            BeanUtils.copyProperties((Object)smsTemplate, (Object)beforeSmsTemplate);
            smsTemplate.setApplySystem(param.getApplySystem());
            smsTemplate.setType(param.getType());
            smsTemplate.setTemplate(param.getTemplate());
            smsTemplate.setIsValid(param.getIsValid());
            ((SmsSendTemplateMapper)this.dao).updateByPrimaryKey(smsTemplate);
            this.fieldChangeRecorder.recordFieldChanges(smsTemplate.getId(), beforeSmsTemplate, param, param.getUpdateBy(), param.getRegionId(), (byte)2, this.fieldConfigs, applySystem);
        }
    }

    public void deleteSmsTemplate(Long id) {
        if (id == null) {
            return;
        }
        ((SmsSendTemplateMapper)this.dao).deleteByPrimaryKey(id);
    }

    public List<SmsSendTemplate> getAllSmsSendTemplateList() {
        List templateList;
        boolean hasKey = this.redisClient.hasKey(SMS_SEND_TEMPLATE_REDIS_KEY);
        if (hasKey) {
            templateList = (List)this.redisClient.get(SMS_SEND_TEMPLATE_REDIS_KEY);
        } else {
            Example example = new Example(SmsSendTemplate.class);
            example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE);
            templateList = this.getListByExample(example);
            this.redisClient.set(SMS_SEND_TEMPLATE_REDIS_KEY, templateList, SMS_SEND_TEMPLATE_REDIS_TIME.longValue());
        }
        return templateList;
    }

    public void postSetCommaSeparateEnumName(List<SmsSendTemplateVo> templateList) {
        if (CollUtil.isEmpty(templateList)) {
            return;
        }
        templateList.forEach(t -> {
            t.setTypeName(SmsSendTemplateServiceImpl.getEnumValues(t.getType(), SmsSendTypeEnum::getValue));
            t.setApplySystemName(SmsSendTemplateServiceImpl.getEnumValues(t.getApplySystem(), SmsSendApplySystemEnum::getValue));
        });
    }

    private void postSetFixedTemplateType(SmsSendTemplateParam param, List<SmsSendTemplateVo> templateList) {
        if (CollUtil.isEmpty(templateList)) {
            return;
        }
        String applySystem = param.getApplySystem();
        SmsSendApplySystemEnum applySystemEnum = SmsSendApplySystemEnum.getEnum((Byte)Convert.toByte((Object)applySystem));
        if (applySystemEnum != SmsSendApplySystemEnum.ZLWQ) {
            return;
        }
        for (SmsSendTemplateVo template : templateList) {
            Long templateId = template.getId();
            SmsSendTemplateTypeEnum templateTypeEnum = null;
            if (templateId != null) {
                switch (templateId.intValue()) {
                    case 31824: {
                        templateTypeEnum = SmsSendTemplateTypeEnum.FIRST;
                        break;
                    }
                    case 31825: {
                        templateTypeEnum = SmsSendTemplateTypeEnum.YELLOW;
                        break;
                    }
                    case 31826: {
                        templateTypeEnum = SmsSendTemplateTypeEnum.RED;
                        break;
                    }
                    case 31827: {
                        templateTypeEnum = SmsSendTemplateTypeEnum.GENERAL;
                        break;
                    }
                }
            }
            if (templateTypeEnum == null) continue;
            template.setTemplateType(templateTypeEnum.getKey());
            template.setTemplateTypeName(templateTypeEnum.getValue());
        }
    }

    public static String getEnumValues(String keyStr, Function<Byte, String> valueFunc) {
        if (CharSequenceUtil.isBlank((CharSequence)keyStr)) {
            return "";
        }
        return Arrays.stream(keyStr.split(",")).map(String::trim).map(k -> {
            try {
                return Byte.valueOf(k);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).map(valueFunc).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(","));
    }
}

