/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.sms.dao.SmsSendMapper;
import cn.smarthse.modules.health.sms.entity.SmsSend;
import cn.smarthse.modules.health.sms.enums.SmsSendStatusEnum;
import cn.smarthse.modules.health.sms.enums.SmsSendTypeEnum;
import cn.smarthse.modules.health.sms.param.SmsSendParam;
import cn.smarthse.modules.health.sms.service.ISmsSendService;
import cn.smarthse.modules.health.sms.vo.SmsSendVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class SmsSendServiceImpl
extends BaseServiceImpl<SmsSendMapper, SmsSend>
implements ISmsSendService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsSendServiceImpl.class);
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public SmsSend getByid(Long sendId) {
        Example example = new Example(SmsSend.class);
        example.createCriteria().andEqualTo("id", (Object)sendId).andEqualTo("isValid", (Object)1);
        return (SmsSend)((SmsSendMapper)this.dao).selectOneByExample(example);
    }

    public PageInfo<SmsSendVo> getSmsSendListByParam(JqGridParam pageParam, SmsSendParam param) {
        this.preSetRegionInfo(param);
        this.preSetTimeScopeFilterInfo(param);
        this.preSetKeywordInfo(param);
        Page smsPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<SmsSendVo> smsList = ((SmsSendMapper)this.dao).selectSmsSendListByParam(param);
        this.postSetSmsSendTypeName(smsList);
        this.postSetSmsSendStatusName(smsList);
        return new PageInfo((List)smsPage);
    }

    public SmsSendVo getSmsSendById(Long id) {
        if (id == null) {
            return null;
        }
        SmsSendVo smsSend = ((SmsSendMapper)this.dao).selectSmsSendById(id);
        if (smsSend == null) {
            return null;
        }
        if (smsSend.getType() != null) {
            smsSend.setTypeName(SmsSendTypeEnum.getValue((Byte)smsSend.getType()));
        }
        if (smsSend.getStatus() != null) {
            smsSend.setStatusName(SmsSendStatusEnum.getValue((Byte)smsSend.getStatus()));
        }
        return smsSend;
    }

    public void smsSendYearNumTableRefresh() {
        ((SmsSendMapper)this.dao).truncateSmsSendYearNumTable();
        ((SmsSendMapper)this.dao).insertSmsSendYearNumTable();
    }

    private void preSetRegionInfo(SmsSendParam param) {
        if (param == null || param.getRegionId() == null) {
            return;
        }
        AreaModel region = this.sysAreaProvideService.getAreaById(param.getRegionId());
        if (region == null || region.getId() == null) {
            return;
        }
        param.setRegionLevel(region.getLevel());
    }

    private void preSetTimeScopeFilterInfo(SmsSendParam param) {
        if (param != null) {
            if (param.getFromDate() != null) {
                param.setFromTime(param.getFromDate().atTime(0, 0, 0));
            }
            if (param.getToDate() != null) {
                param.setToTime(param.getToDate().atTime(23, 59, 59));
            }
        }
    }

    private void preSetKeywordInfo(SmsSendParam param) {
        String keyword = param.getKeyword();
        if (CharSequenceUtil.isNotBlank((CharSequence)keyword)) {
            List<Long> sendIdList = ((SmsSendMapper)this.dao).getSendIdListByKeyword(keyword);
            param.setSendIdList(sendIdList);
        }
    }

    private void postSetSmsSendTypeName(List<SmsSendVo> smsList) {
        if (CollUtil.isEmpty(smsList)) {
            return;
        }
        smsList.forEach(s -> s.setTypeName(SmsSendTypeEnum.getValue((Byte)s.getType())));
    }

    private void postSetSmsSendStatusName(List<SmsSendVo> smsList) {
        if (CollUtil.isEmpty(smsList)) {
            return;
        }
        smsList.forEach(s -> s.setStatusName(SmsSendStatusEnum.getValue((Byte)s.getStatus())));
    }
}

