/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.service;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.sms.dao.SmsSendManageMapper;
import cn.smarthse.modules.health.sms.entity.SmsSendManage;
import cn.smarthse.modules.health.sms.enums.SmsSendFieldEnum;
import cn.smarthse.modules.health.sms.param.SmsSendManageParam;
import cn.smarthse.modules.health.sms.service.ISmsSendInfoRecordService;
import cn.smarthse.modules.health.sms.service.ISmsSendManageService;
import cn.smarthse.modules.health.sms.util.FieldChangeRecorder;
import cn.smarthse.modules.health.sms.util.FieldConfig;
import cn.smarthse.modules.health.sms.vo.SmsSendManageVo;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class SmsSendManageServiceImpl
extends BaseServiceImpl<SmsSendManageMapper, SmsSendManage>
implements ISmsSendManageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsSendManageServiceImpl.class);
    @DubboReference(check=false)
    private ISmsSendInfoRecordService smsSendInfoRecordService;
    @Autowired
    private FieldChangeRecorder<SmsSendManage, SmsSendManageParam> fieldChangeRecorder;
    private final List<FieldConfig<SmsSendManage, SmsSendManageParam>> fieldConfigs = Arrays.asList(new FieldConfig.Builder().fieldGetter(SmsSendManage::getMaxNum).paramGetter(SmsSendManageParam::getMaxNum).fieldEnum(SmsSendFieldEnum.M_MAX_NUM).recordable(Boolean.TRUE).build(), new FieldConfig.Builder().fieldGetter(SmsSendManage::getToUserType).paramGetter(SmsSendManageParam::getToUserType).fieldEnum(SmsSendFieldEnum.M_TO_USER_TYPE).recordable(Boolean.TRUE).build());

    public SmsSendManage getManage(Byte systemWide) {
        Example example = new Example(SmsSendManage.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("applySystem", (Object)systemWide);
        return (SmsSendManage)((SmsSendManageMapper)this.dao).selectOneByExample(example);
    }

    public int updateManag(String type) {
        return ((SmsSendManageMapper)this.dao).updateManag(type);
    }

    public SmsSendManageVo getSmsSendManageByParam(SmsSendManageParam param) {
        if (param == null) {
            return null;
        }
        return ((SmsSendManageMapper)this.dao).selectSmsSendManageByParam(param);
    }

    public void saveSmsSendManage(SmsSendManageParam param) {
        if (param == null || param.getId() == null) {
            return;
        }
        Long manageId = param.getId();
        Byte applySystem = param.getApplySystem();
        SmsSendManage smsManage = (SmsSendManage)((SmsSendManageMapper)this.dao).selectByPrimaryKey(manageId);
        if (smsManage == null) {
            throw new ServiceException("\u77ed\u4fe1\u53c2\u6570\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + manageId);
        }
        SmsSendManage beforeSmsManage = new SmsSendManage();
        BeanUtils.copyProperties((Object)smsManage, (Object)beforeSmsManage);
        Optional.ofNullable(param.getMaxNum()).ifPresent(arg_0 -> ((SmsSendManage)smsManage).setMaxNum(arg_0));
        Optional.ofNullable(param.getToUserType()).filter(CharSequenceUtil::isNotBlank).ifPresent(arg_0 -> ((SmsSendManage)smsManage).setToUserType(arg_0));
        Optional.ofNullable(param.getApplySystem()).ifPresent(arg_0 -> ((SmsSendManage)smsManage).setApplySystem(arg_0));
        ((SmsSendManageMapper)this.dao).updateByPrimaryKey(smsManage);
        this.fieldChangeRecorder.recordFieldChanges(manageId, beforeSmsManage, param, param.getUpdateBy(), param.getRegionId(), (byte)1, this.fieldConfigs, Convert.toStr((Object)applySystem));
    }
}

