/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.sms.dao.SmsSendInfoRecordMapper;
import cn.smarthse.modules.health.sms.entity.SmsSendInfoRecord;
import cn.smarthse.modules.health.sms.enums.SmsSendFieldEnum;
import cn.smarthse.modules.health.sms.enums.SmsSendTypeEnum;
import cn.smarthse.modules.health.sms.param.SmsSendInfoRecordParam;
import cn.smarthse.modules.health.sms.service.ISmsSendInfoRecordService;
import cn.smarthse.modules.health.sms.vo.SmsSendInfoRecordVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class SmsSendInfoRecordServiceImpl
extends BaseServiceImpl<SmsSendInfoRecordMapper, SmsSendInfoRecord>
implements ISmsSendInfoRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsSendInfoRecordServiceImpl.class);

    public PageInfo<SmsSendInfoRecordVo> getSmsSendInfoRecordListByParam(JqGridParam pageParam, SmsSendInfoRecordParam param) {
        Page smsRecordPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<SmsSendInfoRecordVo> smsRecordList = ((SmsSendInfoRecordMapper)this.dao).selectSmsSendInfoRecordListByParam(param);
        this.postSetChangeFieldShowValue(smsRecordList);
        return new PageInfo((List)smsRecordPage);
    }

    private void postSetChangeFieldShowValue(List<SmsSendInfoRecordVo> smsRecordList) {
        if (CollUtil.isEmpty(smsRecordList)) {
            return;
        }
        for (SmsSendInfoRecordVo smsRecord : smsRecordList) {
            SmsSendFieldEnum fieldEnum = SmsSendFieldEnum.getEnum((Byte)smsRecord.getField());
            if (fieldEnum == null) continue;
            switch (fieldEnum) {
                case M_MAX_NUM: {
                    break;
                }
                case M_TO_USER_TYPE: {
                    smsRecord.setOldValue(this.convertToUserType(smsRecord.getOldValue()));
                    smsRecord.setNewValue(this.convertToUserType(smsRecord.getNewValue()));
                    break;
                }
                case T_TYPE: {
                    smsRecord.setOldValue(this.convertSmsSendType(smsRecord.getOldValue()));
                    smsRecord.setNewValue(this.convertSmsSendType(smsRecord.getNewValue()));
                    break;
                }
                case T_TEMPLATE: {
                    break;
                }
                case T_IS_VALID: {
                    smsRecord.setOldValue(this.convertIsValid(smsRecord.getOldValue()));
                    smsRecord.setNewValue(this.convertIsValid(smsRecord.getNewValue()));
                    break;
                }
                case T_SYSTEM: {
                    break;
                }
            }
        }
    }

    private String convertToUserType(String str) {
        return str == null ? "" : Arrays.stream(str.split(",")).map(String::trim).map(type -> switch (type) {
            case "1" -> "\u4f01\u4e1a\u8d1f\u8d23\u4eba";
            case "2" -> "\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458";
            default -> "";
        }).collect(Collectors.joining(","));
    }

    private String convertSmsSendType(String str) {
        return str == null ? "" : Arrays.stream(str.split(",")).map(String::trim).map(Convert::toByte).map(type -> switch (SmsSendTypeEnum.getEnum((Byte)type)) {
            default -> throw new IncompatibleClassChangeError();
            case SmsSendTypeEnum.RISK_RESOLUTION_REMIND -> SmsSendTypeEnum.RISK_RESOLUTION_REMIND.getValue();
            case SmsSendTypeEnum.CLASS_SELF_CHECK_REMIND -> SmsSendTypeEnum.CLASS_SELF_CHECK_REMIND.getValue();
        }).collect(Collectors.joining(","));
    }

    private String convertIsValid(String isValidStr) {
        Boolean isValid = Convert.toBool((Object)isValidStr);
        if (Boolean.TRUE.equals(isValid)) {
            return "\u542f\u7528";
        }
        return "\u7981\u7528";
    }
}

