/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.supervise.CompanyNoteSearchParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.sms.dao.SmsSendDetailMapper;
import cn.smarthse.modules.health.sms.entity.SmsSendDetail;
import cn.smarthse.modules.health.sms.entity.SmsSendTemplate;
import cn.smarthse.modules.health.sms.enums.SmsSendDetailStatusEnum;
import cn.smarthse.modules.health.sms.enums.SmsSendRuleEnum;
import cn.smarthse.modules.health.sms.param.SmsSendDetailParam;
import cn.smarthse.modules.health.sms.service.ISmsSendDetailService;
import cn.smarthse.modules.health.sms.service.ISmsSendTemplateService;
import cn.smarthse.modules.health.sms.vo.SmsSendDetailTabVo;
import cn.smarthse.modules.health.sms.vo.SmsSendDetailVo;
import cn.smarthse.modules.health.vo.note.ChooseCompanyParam;
import cn.smarthse.modules.health.vo.note.ChooseCompanyVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class SmsSendDetailServiceImpl
extends BaseServiceImpl<SmsSendDetailMapper, SmsSendDetail>
implements ISmsSendDetailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsSendDetailServiceImpl.class);
    @DubboReference
    private IReformItemBasicCommandService itemBasicCommandService;
    @DubboReference
    private ISmsSendTemplateService smsSendTemplateService;

    public SmsSendDetail getByCidAndSendId(Long cid, Long id) {
        Example example = new Example(SmsSendDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("cid", (Object)cid).andEqualTo("sendId", (Object)id);
        return (SmsSendDetail)((SmsSendDetailMapper)this.dao).selectOneByExample(example);
    }

    public SmsSendDetailTabVo getSmsSendDetailTabInfo(SmsSendDetailParam param) {
        if (param == null || param.getSendId() == null) {
            throw new ServiceException("\u77ed\u4fe1\u53d1\u9001\u7ba1\u7406\u4e3b\u952eid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        return ((SmsSendDetailMapper)this.dao).selectSmsSendDetailTabInfo(param);
    }

    public PageInfo<SmsSendDetailVo> getSmsSendDetailListByParam(JqGridParam pageParam, SmsSendDetailParam param) {
        if (param == null || param.getSendId() == null) {
            throw new ServiceException("\u77ed\u4fe1\u53d1\u9001\u7ba1\u7406\u4e3b\u952eid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Page smsDetailPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<SmsSendDetailVo> smsDetailList = ((SmsSendDetailMapper)this.dao).selectSmsSendDetailListByParam(param);
        this.postSetSmsSendDetailStatusName(smsDetailList);
        this.postSetSmsSendDetailWarningStatusName(smsDetailList);
        this.postSetSmsSendDetailContent(smsDetailList);
        return new PageInfo((List)smsDetailPage);
    }

    private void postSetSmsSendDetailStatusName(List<SmsSendDetailVo> smsDetailList) {
        if (CollUtil.isEmpty(smsDetailList)) {
            return;
        }
        smsDetailList.forEach(s -> s.setStatusName(SmsSendDetailStatusEnum.getValue((Byte)s.getStatus())));
    }

    private void postSetSmsSendDetailWarningStatusName(List<SmsSendDetailVo> smsDetailList) {
        if (CollUtil.isEmpty(smsDetailList)) {
            return;
        }
        smsDetailList.forEach(s -> s.setSendRuleName(SmsSendRuleEnum.getValue((Byte)s.getSendRule())));
    }

    private void postSetSmsSendDetailContent(List<SmsSendDetailVo> smsDetailList) {
        if (CollUtil.isEmpty(smsDetailList)) {
            return;
        }
        List templateList = this.smsSendTemplateService.getAllSmsSendTemplateList();
        Map<Long, SmsSendTemplate> templateMap = templateList.stream().collect(Collectors.toMap(SmsSendTemplate::getId, t -> t, (v1, v2) -> v2));
        for (SmsSendDetailVo detail : smsDetailList) {
            SmsSendRuleEnum ruleEnum = SmsSendRuleEnum.getEnum((Byte)detail.getSendRule());
            if (ruleEnum == null) continue;
            Long templateId = switch (ruleEnum) {
                default -> throw new IncompatibleClassChangeError();
                case SmsSendRuleEnum.GENERAL_TEMPLATE -> 31827L;
                case SmsSendRuleEnum.YELLOW_TEMPLATE -> 31826L;
                case SmsSendRuleEnum.READ_TEMPLATE -> 31825L;
            };
            SmsSendTemplate template = templateMap.get(templateId);
            detail.setSendContent(template != null ? template.getTemplate() : null);
        }
    }

    public int updateHasChoose(Long id) {
        return ((SmsSendDetailMapper)this.dao).updateHasChoose(id);
    }

    @Transactional
    public void addPushCompany(ChooseCompanyParam param, Long loginUserId) {
        List cidList = param.getCidList();
        if (cidList.isEmpty()) {
            throw new HealthException("\u4f01\u4e1a\u5217\u8868\u4e3a\u7a7a");
        }
        Long sendId = param.getSendId();
        if (sendId == null) {
            throw new HealthException("\u672a\u627e\u5230\u4e3b\u8868id");
        }
        for (Long cid : cidList) {
            SmsSendDetail smsSendDetail = new SmsSendDetail();
            smsSendDetail.setId(Long.valueOf(this.idworker.nextId()));
            smsSendDetail.setCid(cid);
            smsSendDetail.setSendId(sendId);
            smsSendDetail.setSuccessCount(Integer.valueOf(0));
            Boolean has = this.itemBasicCommandService.getHashRisk(cid, LocalDateTime.now().getYear());
            smsSendDetail.setHasRisk(Boolean.valueOf(has != null && has != false));
            smsSendDetail.setStatus(Byte.valueOf((byte)1));
            smsSendDetail.setCreateBy(loginUserId);
            smsSendDetail.setUpdateBy(loginUserId);
            smsSendDetail.setIsValid(Boolean.valueOf(true));
            smsSendDetail.setCreateDate(LocalDateTime.now());
            smsSendDetail.setUpdateDate(LocalDateTime.now());
            smsSendDetail.setHasChoose(Boolean.valueOf(true));
            ((SmsSendDetailMapper)this.dao).insert(smsSendDetail);
        }
    }

    public PageInfo<ChooseCompanyVo> selectPage(JqGridParam param, CompanyNoteSearchParam searchParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ChooseCompanyVo> companyRiskListVos = ((SmsSendDetailMapper)this.dao).selectChooseCompany(param, searchParam);
        PageInfo page = new PageInfo(companyRiskListVos);
        return page;
    }

    @Transactional
    public void deleteChooseCompany(ChooseCompanyParam param) {
        List ids = param.getIds();
        if (ids.isEmpty()) {
            throw new HealthException("\u4f01\u4e1a\u5217\u8868\u4e3a\u7a7a");
        }
        String idStr = ids.stream().map(String::valueOf).collect(Collectors.joining(","));
        ((SmsSendDetailMapper)this.dao).deleteByIds(idStr);
        this.logger.info("\u9009\u4e2d\u4f01\u4e1a\u79fb\u9664\u5b8c\u6210");
    }

    public int getCountByUnifiedSocialCcOrName(String name, Long sendId) {
        return ((SmsSendDetailMapper)this.dao).selectCountByName(name, sendId);
    }

    public int getListByWorkAndCid(Long cid, Long sendId) {
        return ((SmsSendDetailMapper)this.dao).selectCountByCid(cid, sendId);
    }

    public int getCountByUnifiedSocialCc(String unifiedSocialCc, Long sendId) {
        return ((SmsSendDetailMapper)this.dao).selectCountBySocialCc(unifiedSocialCc, sendId);
    }

    @Transactional
    public int insertBatch(List<SmsSendDetail> list) {
        return ((SmsSendDetailMapper)this.dao).insertBatch(list);
    }

    @Transactional
    public void updateSmsSendStatus(String phone, Boolean success, String name, Long loginUserId, SmsSendDetail sendDetail) {
        if (sendDetail == null) {
            log.error("\u77ed\u4fe1\u8be6\u60c5\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
            return;
        }
        if (success.booleanValue()) {
            Integer successCount = sendDetail.getSuccessCount();
            sendDetail.setSuccessCount(Integer.valueOf(successCount == null ? 1 : successCount + 1));
            sendDetail.setStatus(SmsSendDetailStatusEnum.SEND_SUCCESS.getKey());
            sendDetail.setToUserName(name);
            sendDetail.setToUserPhone(phone);
        } else {
            sendDetail.setStatus(SmsSendDetailStatusEnum.SEND_FAIL.getKey());
            sendDetail.setFailCount(Integer.valueOf(sendDetail.getFailCount() == null ? 1 : sendDetail.getFailCount() + 1));
        }
        sendDetail.setUpdateBy(loginUserId);
        ((SmsSendDetailMapper)this.dao).updateByPrimaryKey(sendDetail);
    }
}

