/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.service;

import cn.smarthse.modules.datacentre.model.SendMessageVo;
import cn.smarthse.modules.health.sms.entity.SmsSend;
import cn.smarthse.modules.health.sms.enums.SmsSendStatusEnum;
import cn.smarthse.modules.health.sms.service.AsyncSmsSender;
import cn.smarthse.modules.health.sms.service.INoteService;
import cn.smarthse.modules.health.sms.service.ISmsSendDetailService;
import cn.smarthse.modules.health.sms.service.ISmsSendManageService;
import cn.smarthse.modules.health.sms.service.ISmsSendService;
import cn.smarthse.modules.health.sms.service.ISmsSendTemplateService;
import cn.smarthse.modules.health.sms.vo.SmsSendParamVo;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class INoteServiceImpl
implements INoteService {
    private static final Logger log = LoggerFactory.getLogger(INoteServiceImpl.class);
    @Autowired
    private AsyncSmsSender asyncSmsSender;
    @DubboReference(check=false)
    private ISmsSendService smsSendService;
    @DubboReference(check=false)
    private ISmsSendDetailService smsSendDetailService;
    @DubboReference(check=false)
    private ISmsSendManageService smsSendManageService;
    @DubboReference(check=false)
    private ISmsSendTemplateService smsSendTemplateService;

    @Transactional(rollbackFor={Exception.class})
    public void processAndSendMessages(SendMessageVo vo) {
        List companies = vo.getCompanies();
        if (companies.isEmpty()) {
            return;
        }
        try {
            String addContent = null;
            if (!(vo.getUnit().isEmpty() && vo.getPhone().isEmpty() && vo.getName().isEmpty())) {
                addContent = this.buildContactInfo(vo.getUnit(), vo.getName(), vo.getPhone());
            }
            Long sendId = vo.getSendId();
            Long templateId = vo.getTemplateId();
            if (sendId == null || templateId == null) {
                throw new HealthException("\u53c2\u6570\u9519\u8bef,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String toUserType = vo.getToUserType();
            if (toUserType == null) {
                throw new HealthException("\u77ed\u4fe1\u63a5\u6536\u4eba\u5458\u53c2\u6570\u672a\u627e\u5230");
            }
            SmsSend send = this.smsSendService.getByid(sendId);
            send.setStatus(SmsSendStatusEnum.SENDING.getKey());
            if (send.getTemplateId() == null) {
                send.setTemplateId(vo.getTemplateId());
            }
            this.smsSendService.update((Object)send);
            this.asyncSmsSender.asyncSendSmsYcq(send, addContent, vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u77ed\u4fe1\u53d1\u9001\u53d1\u751f\u5f02\u5e38");
            throw new HealthException("\u77ed\u4fe1\u53d1\u9001\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
    }

    public void sendNoteSu(SmsSendParamVo smsSendParamVo) {
        if (!this.isWorkingHours(LocalDateTime.now())) {
            throw new HealthException("\u5f53\u524d\u65f6\u95f4\u672a\u5728\u5de5\u4f5c\u65e59:00-12:00\uff1b13:00-18:00\uff0c\u8bf7\u5728\u5de5\u4f5c\u65e59:00-12:00\uff1b13:00-18:00\u53d1\u9001\u77ed\u4fe1");
        }
        this.asyncSmsSender.asyncSendSmsSu(smsSendParamVo);
    }

    public String buildContactInfo(String unit, String name, String phone) {
        String front = "\u82e5\u6709\u7591\u95ee\u8bf7\u54a8\u8be2:";
        StringBuilder sb = new StringBuilder(front);
        if (unit != null && !unit.trim().isEmpty()) {
            sb.append(" ").append(unit);
        }
        if (name != null && !name.trim().isEmpty()) {
            sb.append(" ").append(name);
        }
        if (phone != null && !phone.trim().isEmpty()) {
            sb.append(" ").append(phone);
        }
        return sb.toString();
    }

    public boolean isWorkingHours(LocalDateTime dateTime) {
        boolean isWeekday;
        if (dateTime == null) {
            return false;
        }
        DayOfWeek day = dateTime.getDayOfWeek();
        LocalTime time = dateTime.toLocalTime();
        boolean bl = isWeekday = day.getValue() >= 1 && day.getValue() <= 5;
        if (!isWeekday) {
            return false;
        }
        LocalTime morningStart = LocalTime.of(9, 0);
        LocalTime morningEnd = LocalTime.of(12, 0);
        LocalTime afternoonStart = LocalTime.of(13, 0);
        LocalTime afternoonEnd = LocalTime.of(18, 0);
        boolean inMorning = !time.isBefore(morningStart) && time.isBefore(morningEnd);
        boolean inAfternoon = !time.isBefore(afternoonStart) && time.isBefore(afternoonEnd);
        return inMorning || inAfternoon;
    }

    @Generated
    public INoteServiceImpl() {
    }
}

