/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.sms.service;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.SendMessageVo;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.health.sms.entity.SmsSend;
import cn.smarthse.modules.health.sms.entity.SmsSendDetail;
import cn.smarthse.modules.health.sms.entity.SmsSendTemplate;
import cn.smarthse.modules.health.sms.enums.SmsSendDetailStatusEnum;
import cn.smarthse.modules.health.sms.enums.SmsSendStatusEnum;
import cn.smarthse.modules.health.sms.service.INoteService;
import cn.smarthse.modules.health.sms.service.ISmsSendDetailService;
import cn.smarthse.modules.health.sms.service.ISmsSendService;
import cn.smarthse.modules.health.sms.service.ISmsSendTemplateService;
import cn.smarthse.modules.health.sms.vo.SmsSendParamVo;
import cn.smarthse.modules.health.vo.note.CompanyRiskListVo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.annotation.Resource;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AsyncSmsSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncSmsSender.class);
    private static final ExecutorService SMS_EXECUTOR = Executors.newFixedThreadPool(4);
    private static final int BATCH_SIZE = 1000;
    @DubboReference
    private ISMSProviderWelinkService smsProvider;
    @DubboReference(check=false)
    private ISmsSendService smsSendService;
    @DubboReference(check=false)
    private ISmsSendDetailService smsSendDetailService;
    @DubboReference(check=false)
    private ISmsSendTemplateService smsSendTemplateService;
    @DubboReference
    private INoteService noteService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Resource(name="commonThreadPoolExecutor")
    private ThreadPoolExecutor threadPoolExecutor;

    public void asyncSendSmsYcq(SmsSend send, String addContent, SendMessageVo vo) {
        CompletableFuture.runAsync(() -> {
            try {
                SmsSendTemplate template = (SmsSendTemplate)this.smsSendTemplateService.getById(vo.getTemplateId());
                String message = template.getTemplate() + (addContent != null ? addContent : "");
                CountDownLatch countDownLatch = new CountDownLatch(vo.getCompanies().size());
                String toUserType = vo.getToUserType();
                Iterator iterator = vo.getCompanies().iterator();
                while (iterator.hasNext()) {
                    Company curCompany;
                    Company company = curCompany = (Company)iterator.next();
                    SMS_EXECUTOR.submit(() -> {
                        try {
                            SmsSendDetail sendDetail = this.smsSendDetailService.getByCidAndSendId(company.getId(), send.getId());
                            String successTel = null;
                            String successName = null;
                            if (toUserType.equals("1")) {
                                successTel = company.getMainLeaderTel();
                                successName = company.getMainLeaderName();
                                this.smsProvider.singleSendSms(company.getMainLeaderTel(), message, sendDetail.getId());
                            } else if (toUserType.equals("2")) {
                                successTel = company.getOccManagerTel();
                                successName = company.getOccManagerName();
                                this.smsProvider.singleSendSms(company.getOccManagerTel(), message, sendDetail.getId());
                            } else {
                                throw new HealthException("\u6682\u65f6\u53ea\u652f\u6301\u53d1\u9001\u4e00\u4eba");
                            }
                            Byte messageStatus = this.smsProvider.getMessageStatus(sendDetail.getId());
                            this.smsSendDetailService.updateSmsSendStatus(successTel, Boolean.valueOf(messageStatus != null && messageStatus == 1), successName, vo.getLoginUserId(), sendDetail);
                        }
                        catch (Exception e) {
                            log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25,sendId={}", (Object)send.getId());
                            log.error(e.getMessage());
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    });
                }
                long timeoutMinutes = Math.max(10L, (long)vo.getCompanies().size() / 1000L);
                boolean completed = countDownLatch.await(timeoutMinutes, TimeUnit.MINUTES);
                send.setStatus(SmsSendStatusEnum.SENT.getKey());
                send.setCompanyNum(Integer.valueOf(vo.getCompanies().size()));
                this.smsSendService.update((Object)send);
            }
            catch (Exception e) {
                log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25,sendId={}", (Object)send.getId());
                log.error(e.getMessage());
            }
        }, this.threadPoolExecutor);
    }

    public void asyncSendSmsSu(SmsSendParamVo smsSendParamVo) {
        CompletableFuture.runAsync(() -> {
            try {
                SmsSendTemplate template = (SmsSendTemplate)this.smsSendTemplateService.getById(smsSendParamVo.getTemplateId());
                String message = template.getTemplate();
                List companies = smsSendParamVo.getCompanies();
                SmsSend send = this.smsSendService.getByid(smsSendParamVo.getSendId());
                if (send == null) {
                    throw new HealthException("\u672a\u627e\u5230\u4e3b\u8868\uff0c\u77ed\u4fe1\u53d1\u9001\u7ed3\u675f");
                }
                List<SmsSendDetail> collect = companies.stream().map(e -> {
                    SmsSendDetail smsSendDetail = new SmsSendDetail();
                    smsSendDetail.setSendId(send.getId());
                    smsSendDetail.setId(Long.valueOf(IdWorker.getId()));
                    smsSendDetail.setCid(e.getCid());
                    smsSendDetail.setStatus(SmsSendDetailStatusEnum.DRAFT.getKey());
                    smsSendDetail.setSendRule(smsSendParamVo.getSendRule());
                    return smsSendDetail;
                }).toList();
                this.transactionTemplate.execute(status -> {
                    for (int i = 0; i < collect.size(); i += 1000) {
                        int end = Math.min(i + 1000, collect.size());
                        List batch = collect.subList(i, end);
                        this.smsSendDetailService.insertBatch(batch);
                    }
                    return null;
                });
                CountDownLatch latch = new CountDownLatch(companies.size());
                Iterator iterator = companies.iterator();
                while (iterator.hasNext()) {
                    CompanyRiskListVo companyVo;
                    CompanyRiskListVo company = companyVo = (CompanyRiskListVo)iterator.next();
                    SMS_EXECUTOR.submit(() -> {
                        try {
                            boolean sentSuccessfully = false;
                            String successPhone = null;
                            String successName = null;
                            LinkedHashMap<String, String> contacts = new LinkedHashMap<String, String>();
                            contacts.put(company.getMainLeaderName(), company.getMainLeaderTel());
                            contacts.put(company.getOccManagerName(), company.getOccManagerTel());
                            contacts.put(company.getBindName(), company.getBindTel());
                            SmsSendDetail sendDetail = this.smsSendDetailService.getByCidAndSendId(company.getCid(), send.getId());
                            if (sendDetail == null || sendDetail.getId() == null) {
                                log.error("\u4e3a\u67e5\u8be2\u5230\u77ed\u4fe1\u660e\u7ec6\uff0c\u4f01\u4e1aid={}\uff0c\u77ed\u4fe1\u4e3b\u8868id={}", (Object)company.getCid(), (Object)send.getId());
                                return;
                            }
                            for (Map.Entry contact : contacts.entrySet()) {
                                String name = (String)contact.getKey();
                                String phone = (String)contact.getValue();
                                if (phone == null) continue;
                                this.smsProvider.singleSendSms(phone, message, sendDetail.getId());
                                Byte messageStatus = this.smsProvider.getMessageStatus(sendDetail.getId());
                                if (messageStatus == null || messageStatus != 1) continue;
                                successName = name;
                                successPhone = phone;
                                sentSuccessfully = true;
                                break;
                            }
                            this.smsSendDetailService.updateSmsSendStatus(successPhone, Boolean.valueOf(sentSuccessfully), successName, smsSendParamVo.getLoginId(), sendDetail);
                            log.info("\u77ed\u4fe1\u53d1\u9001\u5b8c\u6210\uff0c\u662f\u5426\u6210\u529f\uff1a{} ,\u4f01\u4e1aid{}", (Object)sentSuccessfully, (Object)company.getCid());
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                long timeoutMinutes = Math.max(10L, (long)companies.size() / 1000L);
                boolean completed = latch.await(timeoutMinutes, TimeUnit.MINUTES);
                if (!completed) {
                    log.warn("\u77ed\u4fe1\u53d1\u9001\u672a\u5b8c\u6210");
                } else {
                    log.info("\u6240\u6709\u77ed\u4fe1\u53d1\u9001\u4efb\u52a1\u5df2\u63d0\u4ea4\u5e76\u5b8c\u6210\u56de\u8c03\uff0csendId:{}", (Object)send.getId());
                }
                send.setStatus(SmsSendStatusEnum.SENT.getKey());
                send.setCompanyNum(Integer.valueOf(companies.size()));
                this.smsSendService.update((Object)send);
            }
            catch (Exception e2) {
                log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25 ", (Throwable)e2);
            }
        }, this.threadPoolExecutor);
    }
}

