/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.onlineMonitoring.service.impl.warning;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.onlineMonitoring.entity.warning.MoreAlarmConfig;
import cn.smarthse.modules.health.onlineMonitoring.mapper.warning.MoreAlarmConfigMapper;
import cn.smarthse.modules.health.onlineMonitoring.service.warning.IMoreAlarmConfigService;
import cn.smarthse.modules.platform.model.AreaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class MoreAlarmConfigServiceImpl
extends BaseServiceImpl<MoreAlarmConfigMapper, MoreAlarmConfig>
implements IMoreAlarmConfigService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;

    @Transactional(readOnly=false)
    public List<MoreAlarmConfig> getConfigByAreaId(Long areaId) {
        Example example = new Example(MoreAlarmConfig.class);
        example.createCriteria().andEqualTo("areaId", (Object)areaId).andEqualTo("isValid", (Object)true);
        List listByExample = this.getListByExample(example);
        if (listByExample.isEmpty()) {
            for (int i = 0; i < 8; ++i) {
                this.createConfig(i + 1, areaId);
            }
        }
        return this.getListByExample(example);
    }

    @Transactional(readOnly=false)
    public void createConfig(int arr, Long areaId) {
        ((MoreAlarmConfigMapper)this.dao).createConfig(arr, areaId);
    }

    @Transactional(readOnly=false)
    public void saveConfig(Long areaId, List<MoreAlarmConfig> configList) {
        Example example = new Example(MoreAlarmConfig.class);
        example.createCriteria().andEqualTo("areaId", (Object)areaId);
        ((MoreAlarmConfigMapper)this.dao).setStatus(0, areaId);
        List configs = ((MoreAlarmConfigMapper)this.dao).selectByExample(example);
        for (MoreAlarmConfig config : configs) {
            for (MoreAlarmConfig moreAlarmConfig : configList) {
                if (config.getAlarmCondition() != moreAlarmConfig.getAlarmCondition()) continue;
                moreAlarmConfig.setId(config.getId());
                moreAlarmConfig.setStatus(Integer.valueOf(1));
                this.update(moreAlarmConfig);
            }
        }
    }

    @Transactional(readOnly=false)
    public List<MoreAlarmConfig> getConfig(Integer status) {
        Example example = new Example(MoreAlarmConfig.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)0);
        List listByExample = this.getListByExample(example);
        if (listByExample.isEmpty()) {
            for (int i = 0; i < 8; ++i) {
                this.createConfig(i + 1, 0L);
            }
        }
        List<Object> list = this.getListByExample(example);
        if (status != null) {
            list = list.stream().filter(item -> item.getStatus() == status).collect(Collectors.toList());
        }
        return list;
    }

    public Map<Integer, MoreAlarmConfig> getConfigMapByAreaId(Long areaId) {
        Long configAreaIdByOrgAreaId = this.getConfigAreaIdByOrgAreaId(areaId);
        Example example = new Example(MoreAlarmConfig.class);
        example.createCriteria().andEqualTo("areaId", (Object)configAreaIdByOrgAreaId).andEqualTo("isValid", (Object)true);
        List alarmConfigList = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(alarmConfigList)) {
            Map<Integer, MoreAlarmConfig> alarmConfigMap = alarmConfigList.stream().collect(Collectors.toMap(MoreAlarmConfig::getAlarmCondition, v -> v, (v1, v2) -> v1));
            return alarmConfigMap;
        }
        return Collections.emptyMap();
    }

    public Long getConfigAreaIdByOrgAreaId(Long areaIdTemp) {
        HashSet<Long> allGradeSetAreaIdSet;
        ArrayList<Long> areaids = new ArrayList<Long>();
        areaids.add(0L);
        AreaModel areaModel = this.areaProvideService.getAreaById(areaIdTemp);
        if (areaModel != null) {
            if (areaModel.getLevel().intValue() == 1) {
                areaids.add(areaModel.getProvinceId());
            } else if (areaModel.getLevel().intValue() == 2) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
            } else if (areaModel.getLevel().intValue() == 3) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
                areaids.add(areaModel.getAreaId());
            } else if (areaModel.getLevel().intValue() == 4) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
                areaids.add(areaModel.getAreaId());
                areaids.add(areaModel.getStreetId());
            }
        }
        Collections.reverse(areaids);
        List<Long> allGradeSetAreaIdList = this.getAllConfigAreaId();
        if (CollectionUtils.isNotEmpty(allGradeSetAreaIdList) && CollectionUtils.isNotEmpty(allGradeSetAreaIdSet = new HashSet<Long>(allGradeSetAreaIdList))) {
            for (Long areaid : areaids) {
                if (!allGradeSetAreaIdSet.contains(areaid)) continue;
                return areaid;
            }
        }
        return -1L;
    }

    public List<Long> getAllConfigAreaId() {
        return ((MoreAlarmConfigMapper)this.dao).getAllConfigAreaId();
    }
}

