/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.onlineMonitoring.service.impl.reform;

import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.modules.health.bx.entity.BxFxhj;
import cn.smarthse.modules.health.bx.entity.BxRiskReport;
import cn.smarthse.modules.health.bx.service.IBxFxhjService;
import cn.smarthse.modules.health.bx.service.IBxRiskReportService;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.onlineMonitoring.service.impl.reform.OnlineDeviceUtil;
import cn.smarthse.modules.health.onlineMonitoring.service.reform.IOnlineReformService;
import cn.smarthse.modules.health.onlineMonitoring.vo.reform.ReformDeviceVo;
import cn.smarthse.modules.health.onlineMonitoring.vo.reform.ReformFile;
import cn.smarthse.modules.health.onlineMonitoring.vo.reform.ReportRectVo;
import cn.smarthse.modules.health.onlineMonitoring.vo.reform.ReportRiskParam;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class OnlineReformServiceImpl
implements IOnlineReformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnlineReformServiceImpl.class);
    @DubboReference
    private IReformItemAcceptanceRecordService acceptanceRecordService;
    @DubboReference
    IBusinessNoService businessNoService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @Autowired
    OnlineDeviceUtil onlineDeviceUtil;
    @Autowired
    IOnlineDeviceService onlineDeviceService;
    @DubboReference
    IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    IBxFxhjService bxFxhjService;
    @DubboReference
    IBxRiskReportService riskReportService;

    public void reportRectificationData(ReformDeviceVo vo, Long cid) {
        ReformItemBasic basic = new ReformItemBasic();
        try {
            this.setBasicInfo(vo, cid, basic);
            basic = (ReformItemBasic)this.reformItemBasicService.add((Object)basic);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ReformItemAcceptanceRecord acce = new ReformItemAcceptanceRecord();
        acce.setReformItemId(basic.getId());
        acce.setStatus(Byte.valueOf((byte)0));
        acce.setCid(cid);
        acce.setUpdateDate(new Date());
        acce.setCreateDate(new Date());
        this.acceptanceRecordService.add((Object)acce);
    }

    public void reportRectPlanData(ReportRectVo vo) {
        ReformItemAcceptanceRecord acce = this.getReformItemAcceptanceRecord(Long.parseLong(vo.getReportId()));
        this.setAcceInfo(vo, acce);
        this.acceptanceRecordService.update((Object)acce);
        ReformItemBasic basic = new ReformItemBasic();
        basic.setId(acce.getReformItemId());
        basic.setStatus(Byte.valueOf((byte)2));
        this.reformItemBasicService.update((Object)basic);
    }

    public boolean isFinish(long reportId) {
        ReformItemAcceptanceRecord acce = this.getReformItemAcceptanceRecord(reportId);
        return acce.getStatus().equals(StatusEnum.complete.getValue());
    }

    public Boolean deviceIdCidIsMatching(Long cid, String deviceId) {
        if (cid == null || deviceId == null) {
            return false;
        }
        OnlineDevice device = this.onlineDeviceService.getByDeviceIdAndCid(cid, deviceId);
        return Objects.nonNull(device);
    }

    @Transactional
    public void reportRisk(ReportRiskParam param) {
        BxRiskReport bxRiskReport = new BxRiskReport();
        BeanUtils.copyProperties((Object)param, (Object)bxRiskReport);
        bxRiskReport.setDeviceId(Long.valueOf(Long.parseLong(param.getDeviceId())));
        bxRiskReport.setFactorId(Long.valueOf(Long.parseLong(param.getFactorId())));
        try {
            if (param.getViewRecord().contains(".mp4")) {
                String viewRecordId = this.onlineDeviceUtil.uplod2Oss(param.getViewRecord(), String.valueOf(UUID.randomUUID()) + ".mp4");
                bxRiskReport.setViewRecordId(Long.valueOf(Long.parseLong(viewRecordId)));
            }
            String backGroundId = this.onlineDeviceUtil.uplod2Oss(param.getBackgroud(), String.valueOf(UUID.randomUUID()) + ".jpg");
            bxRiskReport.setBackgroudId(Long.valueOf(Long.parseLong(backGroundId)));
        }
        catch (Exception e) {
            log.error("\u5728\u7ebf\u76d1\u6d4b\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u3002\u3002\u3002\u3002{}", (Object)e.getMessage());
        }
        bxRiskReport = this.riskReportService.saveOne(bxRiskReport);
        ReformAddParam addParam = new ReformAddParam().setCid(bxRiskReport.getCid()).setFindTime(bxRiskReport.getFindTime()).setName(bxRiskReport.getDescribe()).setReformItemSource(ReformSourceLiteEnum.ZXJCJK.getValue()).setReformItemSourceId(bxRiskReport.getId()).setGenerationSource(ReformGenerationSourceEnum.JCCBZG.getValue()).setReformItemSourceType(bxRiskReport.getRiskType()).setDescription(bxRiskReport.getDescribe()).setDataSource(Byte.valueOf((byte)10));
        this.reformItemBasicNewService.generateReform(Collections.singletonList(addParam));
        BxFxhj bxFxhj = new BxFxhj();
        bxFxhj.setCid(param.getCid());
        bxFxhj.setFindTime(param.getFindTime());
        bxFxhj.setReformItemSource(Integer.valueOf(ReformSourceLiteEnum.ZXJCJK.getValue().intValue()));
        bxFxhj.setRiskName(bxRiskReport.getDescribe());
        bxFxhj.setRiskDesc(bxRiskReport.getDescribe());
        bxFxhj.setRiskType(Integer.valueOf(89));
        bxFxhj.setStatus(Integer.valueOf(0));
        bxFxhj.setId(bxRiskReport.getId());
        this.bxFxhjService.saveOne(bxFxhj);
    }

    private ReformItemAcceptanceRecord getReformItemAcceptanceRecord(Long reportId) {
        List list = this.reformItemBasicService.getReformListBySourceId(reportId);
        ReformItemBasic reformItemBasic = (ReformItemBasic)list.get(0);
        List listByReformItemId = this.acceptanceRecordService.getListByReformItemId(reformItemBasic.getId());
        return (ReformItemAcceptanceRecord)listByReformItemId.get(0);
    }

    private void setAcceInfo(ReportRectVo vo, ReformItemAcceptanceRecord acce) {
        String ids;
        acce.setReformDirectorName(vo.getRecPerson());
        acce.setReformCollaboratorName(vo.getRecCooperationPerson());
        acce.setRequireFinishTime(vo.getRecperiod());
        acce.setActualFinishTime(vo.getAcceptTime());
        acce.setReformSolution(vo.getRecProgramme());
        acce.setReformMeasure(vo.getRecProgramme());
        acce.setAcceptanceDirectorName(vo.getAcceptPerson());
        acce.setAcceptanceCollaboratorName(vo.getAcceptCooperationPerson());
        acce.setAcceptanceDate(vo.getAcceptTime());
        acce.setAcceptanceResult(vo.getResult());
        acce.setAcceptanceResultExplain(vo.getAcceptDesc());
        if (1 == vo.getResult()) {
            acce.setStatus(StatusEnum.complete.getValue());
        } else {
            acce.setStatus(StatusEnum.draff.getValue());
        }
        if (vo.getRecProgrammeFile() != null && vo.getRecProgrammeFile().size() > 0) {
            ids = this.getFile(vo.getRecProgrammeFile());
            acce.setReformProgrammeFiles(ids);
        }
        if (vo.getAcceptFile() != null && vo.getAcceptFile().size() > 0) {
            ids = this.getFile(vo.getAcceptFile());
            acce.setAcceptanceFiles(ids);
        }
        if (vo.getRecResultFile() != null && vo.getRecResultFile().size() > 0) {
            ids = this.getFile(vo.getRecResultFile());
            acce.setReformFinishedFiles(ids);
        }
        if (vo.getRecInfoFile() != null && vo.getRecInfoFile().size() > 0) {
            ids = this.getFile(vo.getRecInfoFile());
            acce.setReformNotification(ids);
        }
    }

    private void setBasicInfo(ReformDeviceVo vo, Long cid, ReformItemBasic basic) throws MalformedURLException {
        basic.setCid(cid);
        String businessNo = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HIDDEN_DANGER_REFORM.getCode());
        basic.setReformItemSn(businessNo);
        basic.setName(vo.getName());
        basic.setFinderName(vo.getFindPerson());
        basic.setFindTime(vo.getFindTime());
        basic.setReformItemSource(ReformSourceLiteEnum.ZXJCJK.getValue());
        basic.setReformItemSourceId(vo.getReportId());
        basic.setReformItemPositionName(vo.getFindAdress());
        basic.setReformItemLevel(Byte.valueOf(vo.getReformGrade().byteValue()));
        basic.setDescription(vo.getDescrible());
        basic.setAcceptanceObject(Byte.valueOf((byte)2));
        basic.setStatus(StatusEnum.approving.getValue());
        basic.setBusinessStatus(StatusEnum.none.getValue());
        basic.setGenerationSource(ReformGenerationSourceEnum.JCCBZG.getValue());
        basic.setIsAutoGeneration(Boolean.valueOf(true));
        basic.setCreateDate(new Date());
        basic.setUpdateDate(new Date());
        if (vo.getReformFile() != null && vo.getReformFile().size() > 0) {
            String ids = this.getFile(vo.getReformFile());
            basic.setReformItemFiles(ids);
        }
    }

    private String getFile(List<ReformFile> reformFile) {
        List collect = reformFile.stream().map(item -> {
            String id = null;
            try {
                id = this.onlineDeviceUtil.uplod2Oss(item.getFileUrl(), item.getFileName());
                log.info("{}\u6587\u4ef6\u4e0a\u4f20\u6210\u529f", (Object)item.getFileName());
            }
            catch (Exception e) {
                log.error("{}\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Object)item.getFileName());
            }
            return id;
        }).collect(Collectors.toList());
        Object ids = "";
        if (!collect.isEmpty()) {
            for (String s : collect) {
                ids = (String)ids + s + ",";
            }
        }
        return ids;
    }
}

