/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.onlineMonitoring.service.impl.device;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.bx.entity.BxReformAccept;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyRiskCompletion;
import cn.smarthse.modules.health.enums.hccheckplan.OccTypeEnum;
import cn.smarthse.modules.health.enums.reform.AcceptanceResultEnum;
import cn.smarthse.modules.health.enums.reform.ReformAcceptanceRecordStatusEnum;
import cn.smarthse.modules.health.onlineMonitoring.entity.device.OnlineMonitorDeviceFactor;
import cn.smarthse.modules.health.onlineMonitoring.entity.device.OnlineMonitorWarning;
import cn.smarthse.modules.health.onlineMonitoring.mapper.device.OnlineMonitorWarningMapper;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorWarningService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.dao.occriskfactor.OccupationalRiskFactorsMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringBigDataCountVo;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.DataTypeEnum;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.DeviceTypeEnum;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.RiskwarringTypeEnum;
import cn.smarthse.modules.health.supervise.model.OnlineDeviceParam;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.MonitorCompanyVo;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.MonitorDataVo;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.WarnCaptureVo;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineDeviceAiwarningCollectModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineMonitoringDeviceModel;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.modules.health.supervise.service.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.syncdata.OnlineRealDataAlarmServiceImpl;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.MonitoringSearchVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineMonitoringSearchVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceBindVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.CompanyGradeVoV314;
import cn.smarthse.modules.health.vo.base.company.gradev3.GradeSearchV314;
import cn.smarthse.modules.health.vo.riskResolve.RiskResolveResInfoVo;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Component
public class OnlineMonitorWarningServiceImpl
extends BaseServiceImpl<OnlineMonitorWarningMapper, OnlineMonitorWarning>
implements IOnlineMonitorWarningService {
    private final IKeyFactoryService keyFactoryService;
    @DubboReference
    private ICompanyRiskCompletionService riskCompletionService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @Lazy
    @Autowired
    private IOnlineDeviceService onlineDeviceService;
    private final IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @DubboReference
    private IFactorLimitValueService factorLimitValueService;
    private final IOnlineMonitorDeviceFactorService onlineMonitorDeviceFactorService;
    private final OccupationalRiskFactorsMapper riskFactorsMapper;
    private final OssClientBean ossBean;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final OnlineRealDataAlarmServiceImpl dataAlarmService;
    @Autowired
    private RedisClient redisClient;
    private static final Integer QUERY_LIMIT = 60;
    private static final Integer QUERY_HOUR = 2;
    private static final String ONLINE_MONITOR_TIME_POINT = "OnlineMonitorTimePoint";
    private Cache<Long, List<OnlineMonitorWarning>> alarmSettingCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).maximumSize(Integer.MAX_VALUE).build();

    public List<OnlineMonitorWarning> getCacheOnlineMonitorWarning(Long deviceId) {
        List onlineMonitorWarnings = (List)this.alarmSettingCache.get((Object)deviceId, key -> {
            Example e = new Example(OnlineMonitorWarning.class);
            e.createCriteria().andEqualTo("deviceId", (Object)deviceId).andEqualTo("isValid", (Object)true);
            List monitorWarningList = this.getListByExample(e);
            return monitorWarningList;
        });
        return onlineMonitorWarnings;
    }

    @Transactional(readOnly=false)
    public void assertAndInsert(String ids, Integer deviceType) {
        String[] split = ids.split(",");
        ArrayList<OnlineMonitorWarning> list = new ArrayList<OnlineMonitorWarning>();
        ArrayList<String> factorIds = new ArrayList<String>(Arrays.asList(split));
        Map map = this.factorLimitValueService.queryLimitValues(factorIds);
        for (String factorId : factorIds) {
            if (!this.getByFactorId(Long.parseLong(factorId)).isEmpty()) continue;
            OccupationalRiskFactors factors = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(Long.valueOf(Long.parseLong(factorId)));
            OnlineMonitorWarning warning = new OnlineMonitorWarning();
            warning.setDeviceType(deviceType);
            this.setWarningInfo(list, factorId, factors, warning);
            if (deviceType == 1) {
                Set strings = ((Map)map.get(factorId)).keySet();
                if (strings.contains("twa_total") && strings.contains("twa_respirabel")) {
                    warning.setFactorName(factors.getNameCh() + "-\u603b\u5c18");
                    warning.setDataType(DataTypeEnum.TOTAL_DUST.getCode());
                    this.setAramData(map, factorId, warning, DataTypeEnum.TOTAL_DUST.getCode());
                    this.add(warning);
                    list.add(warning);
                    warning.setFactorName(factors.getNameCh() + "-\u547c\u5c18");
                    this.setAramData(map, factorId, warning, DataTypeEnum.EXHALE_DUST.getCode());
                    warning.setDataType(DataTypeEnum.EXHALE_DUST.getCode());
                    this.add(warning);
                    list.add(warning);
                    continue;
                }
                if (strings.contains("twa_total")) {
                    this.setWarningInfo(list, factorId, factors, warning);
                    warning.setFactorName(factors.getNameCh() + "-\u603b\u5c18");
                    warning.setDataType(DataTypeEnum.TOTAL_DUST.getCode());
                    this.setAramData(map, factorId, warning, DataTypeEnum.TOTAL_DUST.getCode());
                    this.add(warning);
                    list.add(warning);
                    continue;
                }
                this.setWarningInfo(list, factorId, factors, warning);
                warning.setFactorName(factors.getNameCh() + "-\u547c\u5c18");
                this.setAramData(map, factorId, warning, DataTypeEnum.EXHALE_DUST.getCode());
                warning.setDataType(DataTypeEnum.EXHALE_DUST.getCode());
                this.add(warning);
                list.add(warning);
                continue;
            }
            if (deviceType == 3) {
                warning.setDataType(DataTypeEnum.NOISE_INTENSITY.getCode());
                warning.setAlarmVdata("85");
                this.add(warning);
                continue;
            }
            if (deviceType == 4) {
                warning.setDataType(DataTypeEnum.TEMPERATURE.getCode());
                warning.setAlarmVdata("35");
                this.add(warning);
                continue;
            }
            if (deviceType == 2) {
                warning.setDataType(DataTypeEnum.CHEMICAL_POISON.getCode());
                this.setAramData(map, factorId, warning, null);
                this.add(warning);
                list.add(warning);
                continue;
            }
            this.add(warning);
            list.add(warning);
        }
    }

    private void setWarningInfo(List<OnlineMonitorWarning> list, String factorId, OccupationalRiskFactors factors, OnlineMonitorWarning warning) {
        warning.setFactorId(Long.valueOf(Long.parseLong(factorId)));
        warning.setFactorName(factors.getNameCh());
        if (list.size() == 0) {
            list = this.list(null);
        }
        warning.setSort(Integer.valueOf(list.size() + 1));
        warning.setIsTop(Integer.valueOf(0));
        if (CollectionUtils.isEmpty(list)) {
            warning.setStandard(Integer.valueOf(1));
        } else {
            warning.setStandard(Integer.valueOf(list.get(0).getStandard() == null ? 1 : list.get(0).getStandard()));
        }
        warning.setCreateDate(new Date());
    }

    private void setAramData(Map<String, Map<String, String>> map, String factorId, OnlineMonitorWarning warning, Integer dataType) {
        Map<String, String> thisMap = map.get(factorId);
        Set<String> strings = thisMap.keySet();
        String suffix = "";
        if (dataType != null) {
            switch (dataType) {
                case 1002: {
                    suffix = "_total";
                    break;
                }
                case 1003: {
                    suffix = "_respirabel";
                    break;
                }
                default: {
                    suffix = "";
                }
            }
        }
        if (strings.contains("stel" + suffix)) {
            String stel = thisMap.get("stel" + suffix);
            if (stel != null) {
                double stelVal = Double.parseDouble(stel);
                warning.setEarlyWarning("" + stelVal / 2.0);
                warning.setAlarmVdata("" + stelVal);
            }
            warning.setHighWarning(null);
        } else if (strings.contains("mac" + suffix)) {
            String mac = thisMap.get("mac" + suffix);
            if (mac != null) {
                double macVal = Double.parseDouble(mac);
                warning.setEarlyWarning("" + macVal / 2.0);
                warning.setAlarmVdata("" + macVal);
            }
            warning.setHighWarning(null);
        } else {
            String twa = thisMap.get("twa" + suffix);
            if (twa != null) {
                double twaVal = Double.parseDouble(twa);
                warning.setEarlyWarning("" + twaVal * 2.5);
                warning.setAlarmVdata("" + twaVal * 5.0);
            }
            warning.setHighWarning(null);
        }
    }

    public List<OnlineMonitorWarning> getByFactorId(Long factorId) {
        Example example = new Example(OnlineMonitorWarning.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("factorId", (Object)factorId);
        List<OnlineMonitorWarning> listByExample = this.getListByExample(example);
        return listByExample;
    }

    public List<OnlineMonitorWarning> getByFactorIdDataType(Long factorId, Integer dataType) {
        Example example = new Example(OnlineMonitorWarning.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("factorId", (Object)factorId);
        if (dataType != null) {
            criteria.andEqualTo("dataType", (Object)dataType);
        }
        List<OnlineMonitorWarning> listByExample = this.getListByExample(example);
        return listByExample;
    }

    public List<OnlineMonitorWarning> list(String keyword) {
        return ((OnlineMonitorWarningMapper)this.dao).list(keyword);
    }

    @Transactional(readOnly=false)
    public void top(Long id) {
        ((OnlineMonitorWarningMapper)this.dao).top(id);
    }

    @Transactional(readOnly=false)
    public void upOrDown(Long id, Integer type) {
        List<OnlineMonitorWarning> list = this.list(null);
        if (type == 2) {
            Collections.reverse(list);
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getId().equals(id)) continue;
            OnlineMonitorWarning now = list.get(i);
            OnlineMonitorWarning next = list.get(i + 1);
            Integer sort = now.getSort();
            now.setSort(next.getSort());
            next.setSort(sort);
            this.update(now);
            this.update(next);
        }
    }

    @Transactional(readOnly=false)
    public void batchEditStandard(Integer standard) {
        ((OnlineMonitorWarningMapper)this.dao).batchEditStandard(standard);
        this.onlineMonitorDeviceFactorService.clearCache();
    }

    public List<OnlineDeviceAiwarningCollectModel> getSmartWarnInfo(HomeIndexSearchVo searchVo) {
        List<OnlineDeviceAiwarningCollectModel> warnList = ((OnlineMonitorWarningMapper)this.dao).collectAiwarning(searchVo);
        if (warnList == null || warnList.isEmpty()) {
            return Collections.emptyList();
        }
        IntStream.of(1, 2, 3).forEach(code -> {
            if (warnList.stream().noneMatch(w -> Objects.equals(w.getCode(), code))) {
                OnlineDeviceAiwarningCollectModel o = new OnlineDeviceAiwarningCollectModel();
                o.setCode(Integer.valueOf(code));
                String codeName = "";
                if (code == 1) {
                    codeName = "\u9632\u5c18\u53e3\u7f69\u4e0d\u89c4\u8303";
                }
                if (code == 2) {
                    codeName = "\u8033\u7f69\u4e0d\u89c4\u8303";
                }
                if (code == 3) {
                    codeName = "\u9632\u6bd2\u9762\u5177\u4e0d\u89c4\u8303";
                }
                o.setName(codeName);
                o.setNum(Long.valueOf(0L));
                warnList.add(o);
            }
        });
        warnList.forEach(warn -> warn.setDesc(RiskwarringTypeEnum.getNameByCode((Integer)warn.getCode())));
        return Arrays.asList(warnList.get(1), warnList.get(0), warnList.get(2));
    }

    public List<WarnCaptureVo> getWarnPhotoInfo(HomeIndexSearchVo searchVo) {
        List<WarnCaptureVo> warnCaptureList = ((OnlineMonitorWarningMapper)this.dao).getWarnCaptureInfoByParam(searchVo);
        if (warnCaptureList == null || warnCaptureList.isEmpty()) {
            return Collections.emptyList();
        }
        this.processHazardFactorUnit(warnCaptureList);
        this.processBxCaptureImg(warnCaptureList, null);
        return OnlineMonitorWarningServiceImpl.limitWarnCaptureList(warnCaptureList, 2);
    }

    public MonitorCompanyVo getMonitorDetails(Long cid) {
        if (cid == null) {
            return null;
        }
        Long areaId = 330000000000L;
        Byte areaLevel = 1;
        Integer belongType = 1;
        JqGridParam param = new JqGridParam();
        param.setPage(1);
        param.setRows(100);
        int completionRiskNum = 8;
        MonitorCompanyVo resultVo = new MonitorCompanyVo();
        Company company = ((OnlineMonitorWarningMapper)this.dao).getCompanyInfoByCid(cid);
        if (company == null) {
            return null;
        }
        String cname = company.getName();
        String ucc = company.getUnifiedSocialCc();
        String address = company.getRegisterAddress();
        String contact = company.getMainLeaderName();
        String contactPhone = company.getMainLeaderTel();
        resultVo.setCid(cid);
        resultVo.setCname(cname);
        resultVo.setCAddress(address);
        resultVo.setContact(StringUtils.isBlank((String)contact) ? "-" : contact);
        resultVo.setContactPhone(StringUtils.isBlank((String)contactPhone) ? "-" : contactPhone);
        CountDownLatch latch = new CountDownLatch(5);
        this.threadPoolExecutor.execute(() -> {
            try {
                GradeSearchV314 gradeSearch = new GradeSearchV314();
                gradeSearch.setGradeYear(Integer.valueOf(DateUtils.getGradeYear()));
                gradeSearch.setAreaId(areaId);
                gradeSearch.setAreaLevel(areaLevel);
                gradeSearch.setOrgAreaId(areaId);
                gradeSearch.setOrgAreaLevel(areaLevel);
                gradeSearch.setCalcBelongType(belongType);
                gradeSearch.setDataRange(Byte.valueOf((byte)1));
                gradeSearch.setCompanyName(cname);
                gradeSearch.setGradeSource("2,1");
                List<CompanyGradeVoV314> gradeList = ((OnlineMonitorWarningMapper)this.dao).queryCompanyDatabaseGrade(cid);
                if (gradeList != null && !gradeList.isEmpty()) {
                    CompanyGradeVoV314 grade = gradeList.get(0);
                    Integer gradeCode = grade.getGrade();
                    String gradeName = grade.getGradeName();
                    resultVo.setIndustryCategory(Long.valueOf(gradeCode.intValue()));
                    resultVo.setIndustryCategoryName(gradeName);
                }
            }
            finally {
                latch.countDown();
            }
        });
        this.threadPoolExecutor.execute(() -> {
            try {
                List<BxReformAccept> bxRiskList;
                String riskResolutionSituation = null;
                String residualRiskNum = null;
                CompanyRiskCompletion riskSearch = new CompanyRiskCompletion();
                riskSearch.setId(cid);
                riskSearch.setSearchAreaId(areaId);
                riskSearch.setSearchAreaLevel(areaLevel);
                riskSearch.setBelongType(belongType);
                riskSearch.setKeyWord(cname);
                PageInfo riskPage = this.riskCompletionService.getPageCompanyRiskCompletionBySearchModel(param, riskSearch);
                List riskList = riskPage.getList();
                int riskNum = 0;
                if (riskList != null && !riskList.isEmpty()) {
                    CompanyRiskCompletion risk = (CompanyRiskCompletion)riskList.get(0);
                    if (risk.getDeclare().booleanValue()) {
                        ++riskNum;
                    }
                    if (risk.getPhysicalExamination().booleanValue()) {
                        ++riskNum;
                    }
                    if (risk.getCheck().booleanValue()) {
                        ++riskNum;
                    }
                    if (risk.getTraining().booleanValue()) {
                        ++riskNum;
                    }
                    if (risk.getThreeSimultaneous().booleanValue()) {
                        ++riskNum;
                    }
                    if (risk.getProtectEquip().booleanValue()) {
                        ++riskNum;
                    }
                    if (risk.getWarnSignManage().booleanValue()) {
                        ++riskNum;
                    }
                    if (risk.getHealthManageFiles().booleanValue()) {
                        ++riskNum;
                    }
                }
                if ((bxRiskList = ((OnlineMonitorWarningMapper)this.dao).getCompanyBxRiskList(cid)) != null && !bxRiskList.isEmpty()) {
                    long bxNum = bxRiskList.stream().filter(r -> r.getAcceptanceDate() != null && r.getAcceptanceResult().intValue() == AcceptanceResultEnum.complete.getValue().intValue() && (r.getStatus().intValue() == ReformAcceptanceRecordStatusEnum.WXZG.getValue().intValue() || r.getStatus().intValue() == ReformAcceptanceRecordStatusEnum.WC.getValue().intValue())).count();
                    long resolveNum = (long)riskNum + bxNum;
                    long nowRiskNum = (long)(completionRiskNum - riskNum + bxRiskList.size()) - bxNum;
                    int totalNum = bxRiskList.size() + completionRiskNum;
                    riskResolutionSituation = String.valueOf(new BigDecimal(resolveNum).divide(new BigDecimal(totalNum), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100))) + "%";
                    residualRiskNum = String.valueOf(nowRiskNum);
                } else {
                    riskResolutionSituation = String.valueOf(new BigDecimal(riskNum).divide(new BigDecimal(completionRiskNum), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100))) + "%";
                    residualRiskNum = String.valueOf(completionRiskNum - riskNum);
                }
                resultVo.setRiskResolutionStatus(riskResolutionSituation);
                resultVo.setResidualRiskNum(residualRiskNum);
            }
            finally {
                latch.countDown();
            }
        });
        this.threadPoolExecutor.execute(() -> {
            try {
                RiskResolveResSearch searchVo = new RiskResolveResSearch();
                searchVo.setPage(Integer.valueOf(param.getPage()));
                searchVo.setRows(Integer.valueOf(param.getRows()));
                searchVo.setAreaId(areaId);
                searchVo.setAreaLevel(areaLevel);
                searchVo.setSearchType(Integer.valueOf(0));
                searchVo.setKeyWord(ucc);
                PageInfo resultPage = this.reformItemBasicService.getReformRiskResolveResList(searchVo);
                List resultPageList = resultPage.getList();
                if (resultPageList != null && !resultPageList.isEmpty()) {
                    resultPageList = ((List)Optional.of(resultPageList).orElse(new ArrayList())).stream().filter(v -> v != null && v.getFindTime() != null).sorted(Comparator.comparing(RiskResolveResInfoVo::getFindTime)).collect(Collectors.toList());
                    RiskResolveResInfoVo first = (RiskResolveResInfoVo)resultPageList.get(0);
                    Byte warningStatus = first.getWarningStatus();
                    resultVo.setWarningStatus(warningStatus);
                    resultVo.setWarningStatusName(resultVo.getWarnTypeName(resultVo.getWarningStatus()));
                }
            }
            finally {
                latch.countDown();
            }
        });
        this.threadPoolExecutor.execute(() -> {
            try {
                Set<String> companyBxYsZybSet;
                Set<String> companyBxZybSet;
                Set<String> idcardSet;
                HashSet<String> zybIdcardSet = new HashSet<String>();
                HashSet<String> ysZybIdcardSet = new HashSet<String>();
                if (StringUtils.isNotBlank((String)ucc) && (idcardSet = ((OnlineMonitorWarningMapper)this.dao).getCompanyJkzxYsZybList(ucc)) != null) {
                    ysZybIdcardSet.addAll(idcardSet);
                }
                if ((companyBxZybSet = ((OnlineMonitorWarningMapper)this.dao).getCompanyBxZybSet(ucc)) != null && !companyBxZybSet.isEmpty()) {
                    zybIdcardSet.addAll(companyBxZybSet);
                }
                if ((companyBxYsZybSet = ((OnlineMonitorWarningMapper)this.dao).getCompanyBxYsZybSet(ucc)) != null && !companyBxYsZybSet.isEmpty()) {
                    ysZybIdcardSet.addAll(companyBxYsZybSet);
                }
                resultVo.setZybNum(Integer.valueOf(zybIdcardSet.size()));
                resultVo.setYszybNum(Integer.valueOf(ysZybIdcardSet.size()));
            }
            finally {
                latch.countDown();
            }
        });
        this.threadPoolExecutor.execute(() -> {
            try {
                MonitoringSearchVo monitoringSearchVo = new MonitoringSearchVo();
                monitoringSearchVo.setAreaId(areaId);
                monitoringSearchVo.setAreaLevel(areaLevel);
                monitoringSearchVo.setCid(cid);
                monitoringSearchVo.setKeyword(cname);
                PageInfo monitorPage = this.onlineDeviceService.getOnlineMonitoringDeviceList(param, monitoringSearchVo);
                List monitorList = monitorPage.getList();
                this.showByGroup(resultVo, monitorList);
                List deviceBindVos = this.onlineDeviceService.getDevicesByCid(cid);
                this.showByCameraId(resultVo, deviceBindVos, monitorList);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return resultVo;
    }

    public void putTimePoint(String timePoint) {
        if (StringUtils.isBlank((String)timePoint)) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u65f6\u95f4\u70b9\uff01");
        }
        this.redisClient.set(ONLINE_MONITOR_TIME_POINT, (Object)timePoint);
    }

    private void processHazardFactorUnit(List<WarnCaptureVo> warnCaptureList) {
        List factorIdList = warnCaptureList.stream().map(WarnCaptureVo::getFactorId).collect(Collectors.toList());
        String factorIds = CharSequenceUtil.join((CharSequence)",", factorIdList);
        List riskFactorList = StringUtils.isBlank((String)factorIds) ? Collections.emptyList() : this.riskFactorsMapper.selectByIds(factorIds);
        if (CollUtil.isNotEmpty(riskFactorList)) {
            Map riskFactorMap = riskFactorList.stream().collect(Collectors.toMap(OccupationalRiskFactors::getId, Function.identity(), (v1, v2) -> v2));
            block4: for (WarnCaptureVo warnCapture : warnCaptureList) {
                OccTypeEnum typeEnum;
                Long factorId = warnCapture.getFactorId();
                OccupationalRiskFactors riskFactor = (OccupationalRiskFactors)riskFactorMap.get(factorId);
                String typeName = riskFactor.getType();
                if (StringUtils.isNotBlank((String)typeName) && (typeEnum = OccTypeEnum.getThisEnumByName((String)typeName)) != null) {
                    switch (typeEnum) {
                        case DUSTTYPE: 
                        case CHEMICALTYPE: {
                            warnCapture.setMonitorUnit("mg/m^3");
                            continue block4;
                        }
                        case PHYSICALTYPE: {
                            warnCapture.setMonitorUnit("dB(A)");
                            continue block4;
                        }
                    }
                    warnCapture.setMonitorUnit("-");
                    continue;
                }
                warnCapture.setMonitorUnit("-");
            }
        }
    }

    private void processCaptureImg(List<WarnCaptureVo> warnCaptureList, MonitorDataVo vo) {
        for (WarnCaptureVo warn : warnCaptureList) {
            String warnCapture = warn.getWarnCapture();
            this.convertFileById(vo, warn, warnCapture, Boolean.TRUE);
        }
    }

    private void processBxCaptureImg(List<WarnCaptureVo> warnCaptureList, MonitorDataVo vo) {
        for (WarnCaptureVo warn : warnCaptureList) {
            this.convertFileById(vo, warn, Convert.toStr((Object)warn.getBackgroundId()), Boolean.TRUE);
        }
    }

    private void processBxCaptureMv(List<WarnCaptureVo> warnCaptureList, MonitorDataVo vo) {
        for (WarnCaptureVo warn : warnCaptureList) {
            this.convertFileById(vo, warn, Convert.toStr((Object)warn.getViewRecordId()), Boolean.FALSE);
        }
    }

    private void convertFileById(MonitorDataVo vo, WarnCaptureVo warn, String fileIds, Boolean isImg) {
        if (StringUtils.isNotBlank((String)fileIds)) {
            List<Long> fileIdList = Arrays.stream(fileIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            List fileModelList = fileIdList.isEmpty() ? Collections.emptyList() : ((OnlineMonitorWarningMapper)this.dao).selectFileInfoBatch(fileIdList);
            Map<Long, String> nameUrlMap = fileModelList.stream().collect(Collectors.toMap(SysFileModel::getId, img -> img.getFileName() + "," + this.ossBean.getUrl(img.getOssUrl()), (a, b) -> b));
            List fileBeanList = fileIdList.stream().map(i -> {
                String nameUrl = (String)nameUrlMap.get(i);
                if (StringUtils.isNotBlank((String)nameUrl)) {
                    SysFileModel file = new SysFileModel();
                    file.setId(i);
                    file.setFileName(((String)nameUrlMap.get(i)).split(",")[0]);
                    file.setOssUrl(((String)nameUrlMap.get(i)).split(",")[1]);
                    return file;
                }
                return null;
            }).collect(Collectors.toList());
            Predicate<SysFileModel> filterPredicate = isImg != false ? file -> file.getFileName().endsWith(".jpg") || file.getFileName().endsWith(".png") : file -> file.getFileName().endsWith(".mp4") || file.getFileName().endsWith(".mkv");
            fileBeanList = fileBeanList.stream().filter(Objects::nonNull).filter(filterPredicate).collect(Collectors.toList());
            List fileUrlList = fileBeanList.stream().map(SysFileModel::getOssUrl).collect(Collectors.toList());
            if (isImg.booleanValue()) {
                warn.setWarnCapture(fileIds);
                warn.setWarnCaptureUrlList(fileUrlList);
                warn.setWarnCaptureBeanList(fileBeanList);
            } else {
                warn.setWarnVideoCapture(fileIds);
                warn.setWarnVideoCaptureUrlList(fileUrlList);
                warn.setWarnVideoCaptureBeanList(fileBeanList);
            }
            if (vo != null && isImg.booleanValue()) {
                vo.setWarnCapture(fileIds);
                vo.setWarnCaptureUrlList(fileUrlList);
                vo.setWarnCaptureBeanList(fileBeanList);
            }
            if (this.redisClient.hasKey(ONLINE_MONITOR_TIME_POINT)) {
                warn.setTimePoint((String)this.redisClient.get(ONLINE_MONITOR_TIME_POINT));
            }
        }
    }

    private static List<WarnCaptureVo> limitWarnCaptureList(List<WarnCaptureVo> warnCaptureList, Integer limit) {
        return warnCaptureList.stream().filter(warn -> StringUtils.isNotBlank((String)warn.getFindTime())).sorted((w1, w2) -> w2.getFindTime().compareTo(w1.getFindTime())).limit(limit.intValue()).collect(Collectors.toList());
    }

    private void showByGroup(MonitorCompanyVo resultVo, List<OnlineMonitoringDeviceModel> monitorList) {
        if (monitorList != null && !monitorList.isEmpty()) {
            Map<String, List<OnlineMonitoringDeviceModel>> deviceTypeMap = monitorList.stream().collect(Collectors.groupingBy(v -> v.getId() + "_" + v.getType()));
            ArrayList<MonitorDataVo> monitorDataList = new ArrayList<MonitorDataVo>();
            for (Map.Entry<String, List<OnlineMonitoringDeviceModel>> deviceTypeEnrty : deviceTypeMap.entrySet()) {
                String deviceType = deviceTypeEnrty.getKey();
                List<OnlineMonitoringDeviceModel> modelList = deviceTypeEnrty.getValue();
                String[] split = deviceType.split("_");
                Long id = Long.valueOf(split[0]);
                String type = split[1];
                MonitorDataVo vo = new MonitorDataVo();
                boolean isJk = Objects.equals(String.valueOf(DeviceTypeEnum.JK.getValue()), type);
                if (isJk) {
                    OnlineDeviceParam deviceParam = new OnlineDeviceParam();
                    deviceParam.setId(id);
                    OnlineDevice info = this.onlineDeviceService.getDeviceInfoByParam(deviceParam);
                    if (info != null) {
                        vo.setLiveAddress(this.concatLive(info));
                    }
                }
                String totalDustStr = "/";
                String breathDustStr = "/";
                String fcMonitorObject = "";
                String noiseStr = "/";
                String toxicStr = "/";
                for (OnlineMonitoringDeviceModel model : modelList) {
                    vo.setConstructionUnitName(model.getConstructionUnitName());
                    boolean totalDust = Objects.equals(model.getDataType(), DataTypeEnum.TOTAL_DUST.getCode().toString());
                    boolean exhaleDust = Objects.equals(model.getDataType(), DataTypeEnum.EXHALE_DUST.getCode().toString());
                    boolean noise = Objects.equals(model.getDataType(), DataTypeEnum.NOISE_INTENSITY.getCode().toString());
                    boolean toxic = Objects.equals(model.getDataType(), DataTypeEnum.CHEMICAL_POISON.getCode().toString());
                    if (totalDust) {
                        totalDustStr = model.getEarlyWarning() == null ? "/" : model.getEarlyWarning();
                        fcMonitorObject = model.getFactorName().replace("-\u603b\u5c18", "");
                        this.fillDistribution(vo, model, DataTypeEnum.TOTAL_DUST);
                    }
                    if (exhaleDust) {
                        breathDustStr = model.getEarlyWarning() == null ? "/" : model.getEarlyWarning();
                        fcMonitorObject = model.getFactorName().replace("-\u547c\u5c18", "");
                        this.fillDistribution(vo, model, DataTypeEnum.EXHALE_DUST);
                    }
                    if (noise) {
                        noiseStr = model.getEarlyWarning() == null ? "/" : model.getEarlyWarning();
                        this.fillDistribution(vo, model, DataTypeEnum.NOISE_INTENSITY);
                    }
                    if (toxic) {
                        toxicStr = model.getEarlyWarning() == null ? "/" : model.getEarlyWarning();
                        this.fillDistribution(vo, model, DataTypeEnum.CHEMICAL_POISON);
                    }
                    if (vo.getTotalDistribution() != null && !vo.getTotalDistribution().isEmpty() || vo.getBreathDistribution() != null && !vo.getBreathDistribution().isEmpty()) continue;
                    this.fillDistribution(vo, model, null);
                }
                if (OnlineMonitorWarningServiceImpl.isNumeric(totalDustStr)) {
                    double numericValue = Double.parseDouble(totalDustStr);
                    String formattedValue = String.format("%.2f", numericValue);
                    vo.setTotalDust(formattedValue);
                } else {
                    vo.setTotalDust(totalDustStr);
                }
                if (OnlineMonitorWarningServiceImpl.isNumeric(breathDustStr)) {
                    double numericValue = Double.parseDouble(breathDustStr);
                    String formattedValue = String.format("%.2f", numericValue);
                    vo.setBreathDust(formattedValue);
                } else {
                    vo.setBreathDust(breathDustStr);
                }
                if (OnlineMonitorWarningServiceImpl.isNumeric(noiseStr)) {
                    double numericValue = Double.parseDouble(noiseStr);
                    String formattedValue = String.format("%.2f", numericValue);
                    vo.setNoise(formattedValue);
                } else {
                    vo.setNoise(noiseStr);
                }
                if (OnlineMonitorWarningServiceImpl.isNumeric(toxicStr)) {
                    double numericValue = Double.parseDouble(toxicStr);
                    String formattedValue = String.format("%.2f", numericValue);
                    vo.setToxic(formattedValue);
                } else {
                    vo.setToxic(toxicStr);
                }
                vo.setDeviceId(id);
                vo.setFactorId(modelList.get(0).getFactorId());
                vo.setDeviceName(modelList.get(0).getDeviceName());
                vo.setDeviceStatus(Integer.valueOf(modelList.get(0).getStatus().byteValue()));
                vo.setDeviceStatusName(vo.getDeviceStatusName(vo.getDeviceStatus()));
                vo.setDeviceType(Integer.valueOf(type));
                vo.setDeviceTypeName(vo.getDeviceTypeName(vo.getDeviceType()));
                boolean isFc = Objects.equals(String.valueOf(DeviceTypeEnum.FC.getValue()), type);
                boolean isDw = Objects.equals(String.valueOf(DeviceTypeEnum.HXDW.getValue()), type);
                boolean isZs = Objects.equals(String.valueOf(DeviceTypeEnum.CS.getValue()), type);
                vo.setMonitorObject(isFc ? fcMonitorObject : modelList.get(0).getFactorName());
                OnlineDeviceParam onlineDeviceParam = new OnlineDeviceParam();
                onlineDeviceParam.setId(vo.getDeviceId());
                onlineDeviceParam.setFactorId(vo.getFactorId());
                onlineDeviceParam.setDataType(Convert.toInt((Object)modelList.get(0).getDataType()));
                OnlineMonitorDeviceFactor deviceFactor = this.onlineMonitorDeviceFactorService.getWarnInfoByParam(onlineDeviceParam);
                if (deviceFactor != null) {
                    Integer dataType = deviceFactor.getDataType();
                    String overLimit = this.dataAlarmService.getOverLimitByFactorId(vo.getFactorId(), dataType);
                    vo.setAlarmData(overLimit);
                }
                vo.setInstallPosition(modelList.get(0).getPosition());
                if (isJk || isFc || isDw || isZs) {
                    OnlineDevice deviceParam = new OnlineDevice();
                    deviceParam.setType(String.valueOf(DeviceTypeEnum.FC.getValue()));
                    HomeIndexSearchVo searchVo = new HomeIndexSearchVo();
                    searchVo.setCid(resultVo.getCid());
                    List<WarnCaptureVo> warnCaptureList = ((OnlineMonitorWarningMapper)this.dao).getWarnCaptureInfoByParam(searchVo);
                    this.processHazardFactorUnit(warnCaptureList);
                    this.processBxCaptureImg(warnCaptureList, vo);
                    this.processBxCaptureMv(warnCaptureList, vo);
                    vo.setWarnCaptureList(warnCaptureList);
                }
                if (this.redisClient.hasKey(ONLINE_MONITOR_TIME_POINT)) {
                    vo.setTimePoint((String)this.redisClient.get(ONLINE_MONITOR_TIME_POINT));
                }
                monitorDataList.add(vo);
            }
            resultVo.setMonitorDataVoList(monitorDataList);
        }
    }

    private void showByCameraId(MonitorCompanyVo resultVo, List<OnlineDeviceBindVo> deviceBindVos, List<OnlineMonitoringDeviceModel> monitorList) {
        List deviceIds = monitorList.stream().filter(e -> !"3".equals(e.getType())).map(OnlineMonitoringDeviceModel::getId).distinct().collect(Collectors.toList());
        List<Long> cameraIds = monitorList.stream().filter(e -> "3".equals(e.getType())).map(OnlineMonitoringDeviceModel::getId).distinct().collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deviceBindVos)) {
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deviceIds)) {
                for (OnlineDeviceBindVo deviceBindVo : deviceBindVos) {
                    List longs = cn.smarthse.common.util.StringUtils.parseToLongList((String)deviceBindVo.getDeviceIds(), (String)",");
                    deviceIds.removeAll(longs);
                }
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deviceIds)) {
                deviceBindVos.forEach(e -> e.setDeviceIds(e.getDeviceIds() + "," + cn.smarthse.common.util.StringUtils.join((Iterable)deviceIds, (String)",")));
            }
            List bindCameraIds = deviceBindVos.stream().map(e -> Long.valueOf(e.getCameraId())).collect(Collectors.toList());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cameraIds)) {
                cameraIds.removeAll(bindCameraIds);
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cameraIds)) {
                for (Long cameraId : cameraIds) {
                    OnlineDeviceBindVo bindVo = new OnlineDeviceBindVo();
                    bindVo.setCameraId(String.valueOf(cameraId));
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deviceIds)) {
                        bindVo.setDeviceIds(cn.smarthse.common.util.StringUtils.join(deviceIds, (String)","));
                    }
                    deviceBindVos.add(bindVo);
                }
            }
        } else if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cameraIds)) {
            cameraIds.forEach(e -> {
                OnlineDeviceBindVo bindVo = new OnlineDeviceBindVo();
                bindVo.setCameraId(String.valueOf(e));
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)deviceIds)) {
                    bindVo.setDeviceIds(cn.smarthse.common.util.StringUtils.join((Iterable)deviceIds, (String)","));
                }
                deviceBindVos.add(bindVo);
            });
        }
        resultVo.setDeviceBindVoList(deviceBindVos);
    }

    private void fillDistribution(MonitorDataVo vo, OnlineMonitoringDeviceModel model, DataTypeEnum dataTypeEnum) {
        List distribution;
        OnlineMonitoringSearchVo bigDataParam = new OnlineMonitoringSearchVo();
        bigDataParam.setDeviceId(model.getId());
        bigDataParam.setFactorId(model.getFactorId());
        bigDataParam.setQueryLimit(QUERY_LIMIT);
        if (dataTypeEnum != null) {
            bigDataParam.setDataType(dataTypeEnum.getCode());
        }
        if ((distribution = this.onlineDeviceService.getDeviceBigMoreDateCountV317(bigDataParam)) != null && !distribution.isEmpty()) {
            Integer sum = distribution.stream().map(OnlineMonitoringBigDataCountVo::getNum).reduce(Integer::sum).orElse(-1);
            for (OnlineMonitoringBigDataCountVo o : distribution) {
                Integer num = o.getNum();
                String percent = String.valueOf(new BigDecimal(String.valueOf(num)).multiply(new BigDecimal("100")).divide(new BigDecimal(String.valueOf(sum)), 2, RoundingMode.HALF_UP));
                o.setRate(percent);
            }
            if (Objects.equals(dataTypeEnum, DataTypeEnum.TOTAL_DUST)) {
                vo.setTotalDistribution(distribution);
            }
            if (Objects.equals(dataTypeEnum, DataTypeEnum.EXHALE_DUST)) {
                vo.setBreathDistribution(distribution);
            }
            if (Objects.equals(dataTypeEnum, DataTypeEnum.NOISE_INTENSITY)) {
                vo.setNoiseDistribution(distribution);
            }
            if (Objects.equals(dataTypeEnum, DataTypeEnum.CHEMICAL_POISON)) {
                vo.setToxicDistribution(distribution);
            }
            if (dataTypeEnum == null) {
                vo.setTotalDistribution(distribution);
                vo.setBreathDistribution(distribution);
                vo.setNoiseDistribution(distribution);
                vo.setToxicDistribution(distribution);
            }
        }
    }

    private String concatLive(OnlineDevice device) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataStr = sdf.format(new Date());
        String signCheck = MD5Utils.getMD5String((String)("appId=" + device.getAppId() + "&appSecret=" + device.getAppSecret() + "&deviceNo=" + device.getDeviceNo() + "&online=1&requestTime=" + dataStr));
        String liveAdreess = device.getVideoAddress() + "?appId=" + device.getAppId() + "&sign=" + signCheck + "&deviceNo=" + device.getDeviceNo() + "&online=1&requestTime=" + dataStr;
        return liveAdreess;
    }

    private static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Generated
    public OnlineMonitorWarningServiceImpl(IKeyFactoryService keyFactoryService, IOccupationalRiskFactorsService occupationalRiskFactorsService, IOnlineMonitorDeviceFactorService onlineMonitorDeviceFactorService, OccupationalRiskFactorsMapper riskFactorsMapper, OssClientBean ossBean, ThreadPoolExecutor threadPoolExecutor, OnlineRealDataAlarmServiceImpl dataAlarmService) {
        this.keyFactoryService = keyFactoryService;
        this.occupationalRiskFactorsService = occupationalRiskFactorsService;
        this.onlineMonitorDeviceFactorService = onlineMonitorDeviceFactorService;
        this.riskFactorsMapper = riskFactorsMapper;
        this.ossBean = ossBean;
        this.threadPoolExecutor = threadPoolExecutor;
        this.dataAlarmService = dataAlarmService;
    }
}

