/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.onlineMonitoring.service.impl.device;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.onlineMonitoring.entity.device.OnlineMonitorDeviceFactor;
import cn.smarthse.modules.health.onlineMonitoring.entity.device.OnlineMonitorWarning;
import cn.smarthse.modules.health.onlineMonitoring.mapper.device.OnlineMonitorDeviceFactorMapper;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorWarningService;
import cn.smarthse.modules.health.supervise.model.OnlineDeviceParam;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineDeviceAlarmSettingModel;
import cn.smarthse.util.common.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class OnlineMonitorDeviceFactorServiceImpl
extends BaseServiceImpl<OnlineMonitorDeviceFactorMapper, OnlineMonitorDeviceFactor>
implements IOnlineMonitorDeviceFactorService {
    protected Logger logger = LoggerFactory.getLogger((String)"onlinemonitorlogger");
    @Autowired
    @Lazy
    private IOnlineMonitorWarningService onlineMonitorWarningService;
    @Autowired
    private RedisClient redisClient;
    public static final String DEVICE_FACTOR_CACHENAME = "device_factor_cachename";
    private Cache<Long, List<OnlineDeviceAlarmSettingModel>> alarmSettingCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).maximumSize(Integer.MAX_VALUE).build();

    @Transactional(readOnly=false)
    public void delByDeviceId(Long deviceId) {
        if (deviceId != null) {
            Example e = new Example(OnlineMonitorDeviceFactor.class);
            e.createCriteria().andEqualTo("deviceId", (Object)deviceId);
            ((OnlineMonitorDeviceFactorMapper)this.dao).deleteByExample(e);
        }
        this.redisClient.del(new String[]{"device_factor_cachename:" + deviceId});
    }

    public List<OnlineMonitorDeviceFactor> getByDeviceId(Long deviceId) {
        if (deviceId != null) {
            Example e = new Example(OnlineMonitorDeviceFactor.class);
            e.createCriteria().andEqualTo("deviceId", (Object)deviceId);
            List<OnlineMonitorDeviceFactor> listByExample = this.getListByExample(e);
            return listByExample;
        }
        return null;
    }

    public Set<Long> getFactorMapByDeviceId(Long deviceId) {
        if (deviceId == null) {
            return null;
        }
        Set result = (Set)this.redisClient.get(DEVICE_FACTOR_CACHENAME, deviceId.toString(), 86400L, () -> {
            List<OnlineMonitorDeviceFactor> byDeviceId = this.getByDeviceId(deviceId);
            if (CollectionUtils.isNotEmpty(byDeviceId)) {
                Set factorIdSet = byDeviceId.stream().map(OnlineMonitorDeviceFactor::getFactorId).collect(Collectors.toSet());
                return factorIdSet;
            }
            return null;
        });
        return result;
    }

    public List<OnlineDeviceAlarmSettingModel> getWarnInfoByDeviceId(Long deviceId) {
        List warningList = (List)this.alarmSettingCache.get((Object)deviceId, key -> {
            List<OnlineMonitorDeviceFactor> factorList = this.getByDeviceId(deviceId);
            if (factorList.isEmpty()) {
                return null;
            }
            ArrayList<OnlineDeviceAlarmSettingModel> list = new ArrayList<OnlineDeviceAlarmSettingModel>();
            for (OnlineMonitorDeviceFactor deviceFactor : factorList) {
                OnlineDeviceAlarmSettingModel model = new OnlineDeviceAlarmSettingModel();
                model.setFactorId(deviceFactor.getFactorId());
                if (StringUtils.isNotBlank((CharSequence)deviceFactor.getAlarmVdata()) && StringUtils.isNotBlank((CharSequence)deviceFactor.getEarlyWarning()) && deviceFactor.getDataType() != null) {
                    model.setAlarmVdata(deviceFactor.getAlarmVdata());
                    model.setEarlyWarning(deviceFactor.getEarlyWarning());
                    model.setStandard(deviceFactor.getStandard());
                    model.setDataType(deviceFactor.getDataType());
                    list.add(model);
                    continue;
                }
                List byFactorId = this.onlineMonitorWarningService.getByFactorIdDataType(deviceFactor.getFactorId(), deviceFactor.getDataType());
                if (!CollectionUtils.isNotEmpty((Collection)byFactorId)) continue;
                if (byFactorId.size() > 1) {
                    this.logger.warn("=========================\u914d\u7f6e\u6709\u95ee\u9898\uff0c \u540cfactorId\uff1a{} dataType\uff1a{} \u542b\u591a\u6761\u914d\u7f6e\u6570\u636e", (Object)deviceFactor.getFactorId(), (Object)deviceFactor.getDataType());
                }
                OnlineMonitorWarning warning = (OnlineMonitorWarning)byFactorId.get(0);
                model.setAlarmVdata(warning.getAlarmVdata());
                model.setEarlyWarning(warning.getEarlyWarning());
                model.setHighWarning(warning.getHighWarning());
                model.setStandard(warning.getStandard());
                model.setDataType(warning.getDataType());
                list.add(model);
            }
            return list;
        });
        return warningList;
    }

    public OnlineMonitorDeviceFactor getWarnInfoByDeviceIdAndFactorId(Long id, Long factorId) {
        Example e = new Example(OnlineMonitorDeviceFactor.class);
        e.createCriteria().andEqualTo("deviceId", (Object)id).andEqualTo("factorId", (Object)factorId);
        return (OnlineMonitorDeviceFactor)this.getOneByExample(e);
    }

    public void clearCache() {
        this.logger.warn("========================\u8bbe\u5907all\u8bbe\u7f6e\u7f13\u5b58\u6570\u636e\u88ab\u6e05\u7a7a========================");
        this.alarmSettingCache.invalidateAll();
    }

    public void clearCacheByDeviceId(Long deviceId) {
        this.logger.warn("========================\u8bbe\u5907\uff1a{}\u8bbe\u7f6e\u7f13\u5b58\u6570\u636e\u88ab\u6e05\u7a7a========================", (Object)deviceId);
        this.alarmSettingCache.invalidate((Object)deviceId);
        this.redisClient.del(new String[]{DEVICE_FACTOR_CACHENAME + deviceId.toString()});
    }

    public OnlineMonitorDeviceFactor getWarnInfoByParam(OnlineDeviceParam param) {
        Example e = new Example(OnlineMonitorDeviceFactor.class);
        e.createCriteria().andEqualTo("deviceId", (Object)param.getId()).andEqualTo("factorId", (Object)param.getFactorId()).andEqualTo("dataType", (Object)param.getDataType());
        return (OnlineMonitorDeviceFactor)this.getOneByExample(e);
    }
}

