/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.task;

import cn.smarthse.common.util.Convert;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.compliance.service.home.IHomeComplianceService;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceBasicVo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceAreaScoreMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceAreaScore;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceScoreChangeRecord;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceScoreChangeRecordV2;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceAccordingTypeEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceAreaScoreService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyExitItemService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemdataService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceGuideConstructionService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreChangeRecordService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreChangeRecordV2Service;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreRefreshService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Component
public class NewComplianceTask {
    Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    INewComplianceScoreRefreshService scoreRefreshService;
    @Autowired
    cn.smarthse.snowflake.IdWorker idWorker;
    @Autowired
    INewComplianceCompanyExitItemService exitItemService;
    @Autowired
    INewComplianceCompanyInfoService companyInfoService;
    @Autowired
    INewComplianceCompanyItemdataService itemdataService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    INewComplianceAreaScoreService complianceAreaScoreService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService areaProvideService;
    @Autowired
    INewComplianceScoreChangeRecordService oldRecordService;
    @Autowired
    INewComplianceScoreChangeRecordV2Service recordV2Service;
    @Autowired
    INewComplianceGuideConstructionService guideConstructionService;
    @DubboReference
    private IHomeComplianceService homeComplianceService;
    private static final List<String> EXCLUDED_AREAS = Arrays.asList("\u5f00\u53d1\u533a", "\u5b81\u6ce2\u676d\u5dde\u6e7e\u65b0\u533a", "\u897f\u6e56\u897f\u6eaa\u7ba1\u59d4\u4f1a");

    @XxlJob(value="NewComplianceTask-PhysicalCheckCacheDelTask")
    public void PhysicalCheckCacheDelTask() {
        this.logger.info("\u5220\u9664\u5408\u89c4\u4f01\u4e1a\u7b2c\u4e94\u9879\u7f13\u5b58\u5f00\u59cb");
        Set keys = this.redisTemplate.keys((Object)"PhysicalCheckScoreCalcHandle:*");
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
        this.logger.info("\u5220\u9664\u5408\u89c4\u4f01\u4e1a\u7b2c\u4e94\u9879\u7f13\u5b58\u7ed3\u675f");
    }

    @XxlJob(value="NewComplianceTask-newComplianceDayScoreChangeRecord")
    public void newComplianceDayScoreChangeRecord(List<Long> cidList) {
        this.scoreRefreshService.newComplianceDayScoreChangeRecord(cidList);
    }

    @XxlJob(value="NewComplianceTask-handHisDayScoreChangeRecord")
    @Transactional(readOnly=false)
    public <T> void handHisDayScoreChangeRecord() {
        List allComplianceCids = this.companyInfoService.getAllComplianceCids(null);
        if (CollectionUtils.isEmpty((Collection)allComplianceCids)) {
            return;
        }
        Set newComplianceIdSet = allComplianceCids.stream().map(NewComplianceCompanyInfo::getId).collect(Collectors.toSet());
        for (Long newComplianceId : newComplianceIdSet) {
            List oldRecordList = this.oldRecordService.listNewComplianceScoreChangeRecordById(newComplianceId);
            int size = oldRecordList.size();
            ArrayList<NewComplianceScoreChangeRecordV2> recordV2List = new ArrayList<NewComplianceScoreChangeRecordV2>();
            for (int i = 0; i < size; ++i) {
                NewComplianceScoreChangeRecord curr = (NewComplianceScoreChangeRecord)oldRecordList.get(i);
                if (i < size - 1) {
                    NewComplianceScoreChangeRecord pre = (NewComplianceScoreChangeRecord)oldRecordList.get(i + 1);
                    curr.setPreComplianceScore(pre.getComplianceScore());
                }
                NewComplianceScoreChangeRecordV2 recordV2 = new NewComplianceScoreChangeRecordV2();
                BeanUtils.copyProperties((Object)curr, (Object)recordV2);
                recordV2.setId(Long.valueOf(this.idWorker.nextId()));
                recordV2.setIsValid(Boolean.valueOf(true));
                recordV2.setComplianceAccordingType(NewComplianceAccordingTypeEnum.COMPLIANCE.getKey());
                recordV2List.add(recordV2);
            }
            XxlJobHelper.log((String)"\u5904\u7406\u4f01\u4e1aid:[{}], \u53d8\u66f4\u8bb0\u5f55\u6570\uff1a[{}]", (Object[])new Object[]{newComplianceId, recordV2List.size()});
            this.recordV2Service.insertComplianceScoreChangeBatch(recordV2List);
        }
    }

    @XxlJob(value="NewComplianceTask-loadExitTimeTask")
    public void loadExitTimeTask(List<Long> cidList) {
        long start = System.currentTimeMillis();
        this.logger.info("\u52a0\u8f7d\u7cfb\u7edf\u9000\u51fa\u9879\u6570\u636e\u4efb\u52a1\u5f00\u59cb");
        this.exitItemService.syncExitItem(cidList);
        this.logger.info("\u52a0\u8f7d\u7cfb\u7edf\u9000\u51fa\u9879\u6570\u636e\u4efb\u52a1\u7ed3\u675f,\u8017\u65f6\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="NewComplianceTask-loadNumCommitTask")
    public void loadNumCommitTask() {
        List allComplianceCids = this.companyInfoService.getAllComplianceCids(Arrays.asList(NewComplianceInfoStatusEnum.COMPLIANT.getKey(), NewComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey()));
        if (CollectionUtils.isEmpty((Collection)allComplianceCids)) {
            return;
        }
        List allComplianceIdList = allComplianceCids.stream().map(NewComplianceCompanyInfo::getId).distinct().collect(Collectors.toList());
        List cids = allComplianceCids.stream().map(NewComplianceCompanyInfo::getCid).distinct().collect(Collectors.toList());
        XxlJobHelper.log((String)"\u9700\u5237\u65b0\u5408\u89c4\u4f01\u4e1a\u6570\uff1a{}", (Object[])new Object[]{allComplianceIdList.size()});
        Example example = new Example(NewComplianceCompanyItemdata.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("itemcodeId", (Object)11303L).andIn("complianceId", allComplianceIdList).andIn("fieldName", Arrays.asList("localNumCommit", "outNumCommit"));
        List oldData = this.itemdataService.getListByExample(example);
        ArrayList<NewComplianceCompanyItemdata> newData = new ArrayList<NewComplianceCompanyItemdata>();
        List workNums = this.staffInfoService.getStaffInfoWorkNum(cids, null);
        Map<Long, StaffInfo> staffMap = workNums.stream().collect(Collectors.toMap(StaffInfo::getCid, v -> v));
        for (NewComplianceCompanyInfo info : allComplianceCids) {
            NewComplianceCompanyItemdata data1331 = new NewComplianceCompanyItemdata();
            NewComplianceCompanyItemdata data1332 = new NewComplianceCompanyItemdata();
            StaffInfo workNum = staffMap.get(info.getCid());
            data1331.setComplianceId(info.getId());
            data1331.setItemcodeId(Long.valueOf(11303L));
            data1331.setFieldName("localNumCommit");
            data1331.setResultData(workNum != null ? Convert.toStr((Object)workNum.getLocalWorkNum()) : "0");
            newData.add(data1331);
            data1332.setComplianceId(info.getId());
            data1332.setItemcodeId(Long.valueOf(11303L));
            data1332.setFieldName("outNumCommit");
            data1332.setResultData(workNum != null ? Convert.toStr((Object)workNum.getOutWorkNum()) : "0");
            newData.add(data1332);
        }
        this.itemdataService.saveDataItemData(newData, oldData);
    }

    @XxlJob(value="NewComplianceTask-countScoreByArea")
    @Transactional
    public void countScoreByArea() {
        this.complianceAreaScoreService.deleteAllComplianceAreaScores();
        List areaScoreList = this.complianceAreaScoreService.countAreaScoreByArea();
        List cityScoreList = this.complianceAreaScoreService.countCityScoreByArea();
        NewComplianceAreaScore provinceScore = this.complianceAreaScoreService.getProvinceScore();
        List streetScore = this.complianceAreaScoreService.getStreetScore();
        provinceScore.setIsValid(Boolean.valueOf(true));
        provinceScore.setId(Long.valueOf(IdWorker.getId()));
        provinceScore.setUpdateDate(new Date());
        List lastAreaScoreList = this.complianceAreaScoreService.countLastAreaScoreByArea();
        List lastCityScoreList = this.complianceAreaScoreService.countLastCityScoreByArea();
        List lastStreetScoreList = this.complianceAreaScoreService.countLastStreetScoreByArea();
        Map<Long, NewComplianceAreaScore> lastAreaMap = Optional.ofNullable(lastAreaScoreList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).collect(Collectors.toMap(NewComplianceAreaScore::getAreaId, e -> e, (a, b) -> a));
        Map<Long, NewComplianceAreaScore> lastCityMap = Optional.ofNullable(lastCityScoreList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).collect(Collectors.toMap(NewComplianceAreaScore::getAreaId, e -> e, (a, b) -> a));
        Map<Long, NewComplianceAreaScore> lastStreetMap = Optional.ofNullable(lastStreetScoreList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).collect(Collectors.toMap(NewComplianceAreaScore::getAreaId, e -> e, (a, b) -> a));
        HomeComplianceBasicVo provinceAvgVo = this.homeComplianceService.getProvinceAvgVo();
        BigDecimal provinceAvg = provinceAvgVo.getProvinceAvg();
        Long provinceAvgCount = provinceAvgVo.getProvinceAvgCount();
        BigDecimal finalProvinceAvg = provinceAvg;
        Long finalProvinceAvgCount = provinceAvgCount;
        List<NewComplianceAreaScore> normalizedAreas = Optional.ofNullable(areaScoreList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).filter(a -> EXCLUDED_AREAS.stream().noneMatch(area -> a.getAreaName().contains((CharSequence)area))).peek(a -> {
            a.setIsValid(Boolean.valueOf(true));
            a.setId(Long.valueOf(IdWorker.getId()));
            a.setUpdateDate(new Date());
        }).map(a -> {
            BigDecimal score = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
            BigDecimal currentRate = BigDecimal.ZERO;
            Integer complianceCount = Optional.ofNullable(a.getComplianceCount()).orElse(0);
            Integer companyNum = Optional.ofNullable(a.getCompanyNum()).orElse(0);
            NewComplianceAreaScore last = (NewComplianceAreaScore)lastAreaMap.get(a.getAreaId());
            if (complianceCount == 0 || companyNum == 0) {
                score = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
            } else {
                currentRate = this.calcRate(complianceCount, companyNum);
                Integer lastCount = 0;
                BigDecimal lastRate = BigDecimal.ZERO;
                if (last != null) {
                    lastCount = Optional.ofNullable(last.getComplianceCount()).orElse(0);
                    lastRate = this.calcRate(last.getComplianceCount(), last.getCompanyNum());
                }
                boolean higherThanProvince = (long)complianceCount.intValue() >= finalProvinceAvgCount || currentRate.compareTo(finalProvinceAvg) > 0;
                boolean higherThanLastYear = complianceCount > lastCount || currentRate.compareTo(lastRate) > 0;
                score = higherThanProvince || higherThanLastYear ? BigDecimal.ONE.setScale(1, RoundingMode.HALF_UP) : new BigDecimal("0.5").setScale(1, RoundingMode.HALF_UP);
            }
            if (last != null) {
                a.setComplianceCount2024(last.getComplianceCount());
                BigDecimal rate2024 = this.calcRate(last.getComplianceCount(), last.getCompanyNum());
                a.setComplianceProportion2024(rate2024.stripTrailingZeros().toPlainString() + "%");
            } else {
                a.setComplianceCount2024(Integer.valueOf(0));
                a.setComplianceProportion2024("0.00%");
            }
            a.setScore(score);
            return a;
        }).toList();
        List<NewComplianceAreaScore> normalizedCities = Optional.ofNullable(cityScoreList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).peek(c -> {
            c.setIsValid(Boolean.valueOf(true));
            c.setId(Long.valueOf(IdWorker.getId()));
            c.setUpdateDate(new Date());
        }).map(c -> {
            List<NewComplianceAreaScore> subAreas = normalizedAreas.stream().filter(a -> a.getCityId() != null && a.getCityId().equals(c.getCityId())).toList();
            long halfCount = subAreas.stream().filter(a -> a.getScore() != null && a.getScore().compareTo(new BigDecimal("0.5")) == 0).count();
            long zeroCount = subAreas.stream().filter(a -> a.getScore() != null && a.getScore().compareTo(BigDecimal.ZERO) == 0).count();
            long zeroComplianceCount = subAreas.stream().filter(a -> Optional.ofNullable(a.getComplianceCount()).orElse(0) == 0).count();
            c.setZeroComplianceCount(Integer.valueOf((int)zeroComplianceCount));
            long belowOrNotImprovedCount = subAreas.stream().filter(a -> {
                BigDecimal currentRate = this.calcRate(a.getComplianceCount(), a.getCompanyNum());
                NewComplianceAreaScore last = (NewComplianceAreaScore)lastAreaMap.get(a.getAreaId());
                BigDecimal lastRate = BigDecimal.ZERO;
                if (last != null) {
                    lastRate = this.calcRate(last.getComplianceCount(), last.getCompanyNum());
                }
                boolean belowProvince = currentRate.compareTo(finalProvinceAvg) < 0;
                boolean notImproved = currentRate.compareTo(lastRate) <= 0;
                return belowProvince || notImproved;
            }).count();
            c.setBelowOrNotImprovedCount(Integer.valueOf((int)belowOrNotImprovedCount));
            BigDecimal cityScore = BigDecimal.ONE.subtract(BigDecimal.valueOf(halfCount).multiply(new BigDecimal("0.2"))).subtract(BigDecimal.valueOf(zeroCount).multiply(new BigDecimal("0.4")));
            if (cityScore.compareTo(BigDecimal.ZERO) < 0) {
                cityScore = BigDecimal.ZERO;
            }
            cityScore = cityScore.setScale(1, RoundingMode.HALF_UP);
            c.setScore(cityScore);
            NewComplianceAreaScore lastCity = (NewComplianceAreaScore)lastCityMap.get(c.getAreaId());
            if (lastCity != null) {
                c.setComplianceCount2024(lastCity.getComplianceCount());
                BigDecimal lastCityRate = this.calcRate(lastCity.getComplianceCount(), lastCity.getCompanyNum());
                c.setComplianceProportion2024(lastCityRate.stripTrailingZeros().toPlainString() + "%");
            }
            return c;
        }).toList();
        List<NewComplianceAreaScore> normalizedStreets = Optional.ofNullable(streetScore).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).peek(s -> {
            s.setId(Long.valueOf(IdWorker.getId()));
            s.setIsValid(Boolean.valueOf(true));
            s.setUpdateDate(new Date());
            NewComplianceAreaScore last = (NewComplianceAreaScore)lastStreetMap.get(s.getAreaId());
            if (last != null) {
                s.setComplianceCount2024(last.getComplianceCount());
                BigDecimal lastCityRate = this.calcRate(last.getComplianceCount(), last.getCompanyNum());
                s.setComplianceProportion2024(lastCityRate.stripTrailingZeros().toPlainString() + "%");
            }
        }).toList();
        ArrayList<NewComplianceAreaScore> finalScoreList = new ArrayList<NewComplianceAreaScore>();
        finalScoreList.add(provinceScore);
        finalScoreList.addAll(normalizedCities);
        finalScoreList.addAll(normalizedAreas);
        finalScoreList.addAll(normalizedStreets);
        this.complianceAreaScoreService.batchUpdateOrInsert(finalScoreList, NewComplianceAreaScoreMapper.class, (item, mapper) -> mapper.insert(item));
    }

    private BigDecimal calcRate(Integer complianceCount, Integer companyNum) {
        if (companyNum == null || companyNum == 0 || complianceCount == null) {
            return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        }
        BigDecimal rate = BigDecimal.valueOf(complianceCount.intValue()).divide(BigDecimal.valueOf(companyNum.intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
        return rate.setScale(2, RoundingMode.HALF_UP);
    }

    @XxlJob(value="NewComplianceTask-countGuide")
    @Transactional
    public void countGuide() {
        this.guideConstructionService.countGuide();
    }
}

