/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.task;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.health.newcompliance.entity.NewCompliancePrepareSms;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoLabelEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewCompliancePprepareSmsEnum;
import cn.smarthse.modules.health.newcompliance.service.INewCompliancePrepareSmsService;
import cn.smarthse.modules.health.newcompliance.vo.NewCompliancePrepareSmsVo;
import com.google.gson.Gson;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewComplianceSendSmsTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceSendSmsTask.class);
    @Autowired
    private INewCompliancePrepareSmsService prepareSmsService;
    @DubboReference
    private ISMSProvideMasService smsProvideMasService;
    private final Gson gson = new Gson();

    @XxlJob(value="NewComplianceSendSmsTask-sendSms")
    public void checkPrepareSms() {
        List list = this.prepareSmsService.getNeedSendComplianceList();
        if (list == null || list.isEmpty()) {
            XxlJobHelper.log((String)"\u65e0\u9700\u8981\u53d1\u9001\u77ed\u4fe1\u7684\u5408\u89c4\u4f01\u4e1a", (Object[])new Object[0]);
            return;
        }
        XxlJobHelper.log((String)"\u53d1\u751f\u53d8\u66f4\u7684\u5408\u89c4\u4f01\u4e1a\u6570\uff1a{}", (Object[])new Object[]{list.size()});
        ArrayList<NewCompliancePrepareSms> prepareSmsList = new ArrayList<NewCompliancePrepareSms>();
        block4: for (NewCompliancePrepareSmsVo v : list) {
            NewCompliancePrepareSms sms2 = new NewCompliancePrepareSms();
            sms2.setId(v.getId());
            sms2.setComplianceId(v.getComplianceId());
            Byte status = v.getStatus();
            switch (status) {
                case 5: {
                    Byte smsResult = this.sendSms(v, String.format("\u60a8\u6240\u5728\u7684\u4f01\u4e1a\u201c%s\u201d\u5408\u89c4\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5b58\u5728\u9000\u51fa\u9879\u201d\uff0c\u8bf7\u53ca\u65f6\u767b\u9646\u201c\u6d59\u91cc\u536b\u4f01\u201d\u5bf9\"\u9000\u51fa\u9879\"\u5185\u5bb9\u8fdb\u884c\u6838\u5b9e\uff0c\u82e5\u6709\u7591\u95ee\u53ef\u5728\u7ebf\u7533\u8bc9\u3002", v.getCompanyName()));
                    sms2.setSendStatus(smsResult);
                    prepareSmsList.add(sms2);
                    continue block4;
                }
                case 3: {
                    List labelList = CommonUtil.str2IntegerList((String)v.getLabels(), (String)",");
                    if (labelList == null) {
                        labelList = Collections.emptyList();
                    }
                    Byte smsResult = labelList.contains(NewComplianceInfoLabelEnum.EXITITEMS.getKey()) ? this.sendSms(v, String.format("\u60a8\u6240\u5728\u7684\u4f01\u4e1a\u201c%s\u201d\u5408\u89c4\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5408\u89c4\u8bc4\u4f30\u4e2d\u2014\u9000\u51fa\u9879\u672a\u6838\u5b9e\u201d\uff0c\u8bf7\u7b49\u5f85\u5c5e\u5730\u76d1\u7ba1\u90e8\u95e8\u901a\u8fc7\u201c\u6d59\u91cc\u536b\u4f01\u201d\u6838\u5b9e\u9000\u51fa\u9879\u5185\u5bb9\u3002", v.getCompanyName())) : (v.getReformRemainDate() != null ? this.sendSms(v, String.format("\u60a8\u6240\u5728\u4f01\u4e1a\u201c%s\u201d\u5408\u89c4\u6307\u6570\u53d8\u66f4\u4e3a\uff1a%s \u5206\uff0c\u5f53\u524d\u5408\u89c4\u72b6\u6001\u4e3a\u201c\u5408\u89c4\u8bc4\u4f30\u4e2d\u2014\u5bb9\u671f\u6574\u6539\u4e2d\u201d\uff0c\u8bf7\u53ca\u65f6\u767b\u9646\u201c\u6d59\u91cc\u536b\u4f01\u201d\u67e5\u770b\u8be6\u7ec6\u6263\u5206\u9879\u8fdb\u884c\u6574\u6539\u3002", v.getCompanyName(), v.getComplianceScore())) : (labelList.contains(NewComplianceInfoLabelEnum.PROMISEDATACLASH.getKey()) ? this.sendSms(v, String.format("\u60a8\u6240\u5728\u7684\u4f01\u4e1a\u201c%s\u201d\u5408\u89c4\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5408\u89c4\u8bc4\u4f30\u4e2d\u2014\u627f\u8bfa\u5185\u5bb9\u51b2\u7a81\u201d\uff0c\u8bf7\u53ca\u65f6\u767b\u9646\u201c\u6d59\u91cc\u536b\u4f01\u201d\u5e76\u5b8c\u5584\u51b2\u7a81\u9879\u5185\u5bb9\u3002", v.getCompanyName())) : (labelList.contains(NewComplianceInfoLabelEnum.OBJECTION.getKey()) ? this.sendSms(v, String.format("\u5c5e\u5730\u76d1\u7ba1\u90e8\u95e8\u5bf9\u60a8\u6240\u5728\u201c%s\u201d\u4f01\u4e1a\u7684\u5408\u89c4\u627f\u8bfa\u5185\u5bb9\u63d0\u51fa\u5f02\u8bae\uff0c\u8bf7\u53ca\u65f6\u767b\u9646\u201c\u6d59\u91cc\u536b\u4f01\u201d\u5bf9\u5f02\u8bae\u5185\u5bb9\u8fdb\u884c\u5b8c\u5584\u3002", v.getCompanyName())) : NewCompliancePprepareSmsEnum.NOT_REQUIRED.getKey())));
                    sms2.setSendStatus(smsResult);
                    prepareSmsList.add(sms2);
                    continue block4;
                }
            }
            sms2.setSendStatus(NewCompliancePprepareSmsEnum.NOT_REQUIRED.getKey());
            prepareSmsList.add(sms2);
        }
        this.prepareSmsService.batchUpdateSendStatus(prepareSmsList);
        long successCount = prepareSmsList.stream().filter(sms -> NewCompliancePprepareSmsEnum.SENT_SUCCESS.getKey().equals(sms.getSendStatus())).count();
        long failureCount = prepareSmsList.stream().filter(sms -> NewCompliancePprepareSmsEnum.SENT_FAILURE.getKey().equals(sms.getSendStatus())).count();
        XxlJobHelper.log((String)"\u77ed\u4fe1\u5904\u7406\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u6761\u8bb0\u5f55\uff0c\u5176\u4e2d\u53d1\u9001\u6210\u529f\uff1a{} \u6761\uff0c\u53d1\u9001\u5931\u8d25\uff1a{} \u6761", (Object[])new Object[]{prepareSmsList.size(), successCount, failureCount});
    }

    private Byte sendSms(NewCompliancePrepareSmsVo vo, String text) {
        if (vo == null || vo.getOccManagerTel() == null || vo.getOccManagerTel().isEmpty()) {
            log.warn("\u4f01\u4e1a: {} \u7f3a\u5c11\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)(vo != null ? vo.getCompanyName() : "\u672a\u77e5\u4f01\u4e1a"));
            return NewCompliancePprepareSmsEnum.NOT_REQUIRED.getKey();
        }
        try {
            Thread.sleep(3000L);
            String smsResult = this.smsProvideMasService.sendSms(vo.getOccManagerTel(), text);
            Response responseData = (Response)this.gson.fromJson(smsResult, Response.class);
            if (responseData != null && responseData.isSuccess()) {
                return NewCompliancePprepareSmsEnum.SENT_SUCCESS.getKey();
            }
            log.warn("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c: {}", (Object)smsResult);
            return NewCompliancePprepareSmsEnum.SENT_FAILURE.getKey();
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0c\u4f01\u4e1a: {}\uff0c\u539f\u56e0: {}", new Object[]{vo.getCompanyName(), e.getMessage(), e});
            return NewCompliancePprepareSmsEnum.SENT_FAILURE.getKey();
        }
    }

    static class Response {
        private String rspcod;
        private Boolean success;

        Response() {
        }

        public String getRspcod() {
            return this.rspcod;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

