/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.task;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemcode;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreRefreshService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewComplianceScoreRefreshTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceScoreRefreshTask.class);
    @Autowired
    INewComplianceScoreRefreshService scoreRefreshService;
    @Autowired
    INewBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    INewComplianceCompanyInfoService companyInfoService;
    @Autowired
    INewComplianceCompanyItemcodeService itemcodeService;

    @XxlJob(value="NewComplianceScoreRefreshTask-businessDataUpdateRefresh")
    public void businessDataUpdateRefresh(List<Long> cidList, String itemCodeId) {
        this.businessDataUpdateRefreshService.exeBussinessDataUpdateTask();
    }

    @XxlJob(value="NewComplianceScoreRefreshTask-refreshAllCompliance")
    public void refreshAllCompliance() {
        List allComplianceCids = this.companyInfoService.listComplianceIndusStatus(null, Arrays.asList(NewComplianceInfoStatusEnum.COMPLIANT.getKey(), NewComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey()));
        if (CollectionUtils.isEmpty((Collection)allComplianceCids)) {
            return;
        }
        this.companyInfoService.updateComplianceIndusInvalid(allComplianceCids);
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObject = JSON.parseObject((String)jobParam);
        String itemCodeParam = null;
        String versionParam = "";
        if (jsonObject != null) {
            if (jsonObject.containsKey((Object)"itemCode")) {
                itemCodeParam = jsonObject.getString("itemCode");
            }
            if (jsonObject.containsKey((Object)"v")) {
                versionParam = jsonObject.getString("v");
            }
        }
        List allComplianceCidList = allComplianceCids.stream().filter(f -> f.getComplianceIndusId() != null).map(NewComplianceCompanyInfo::getCid).distinct().collect(Collectors.toList());
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        Set<String> codeSet = allItemcode.stream().filter(f -> Objects.equals(f.getType(), 1)).map(NewComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        String[] itemCodes = codeSet.toArray(new String[codeSet.size()]);
        XxlJobHelper.log((String)"\u9700\u5237\u65b0\u5408\u89c4\u4f01\u4e1a\u6570\uff1a{}", (Object[])new Object[]{allComplianceCidList.size()});
        if ("v2".equals(versionParam)) {
            if (StringUtils.isNotBlank((CharSequence)itemCodeParam)) {
                XxlJobHelper.log((String)"\u5237\u65b0\u5355\u9879\u6570\u636e\uff0c itemCodeParam\uff1a{}", (Object[])new Object[]{itemCodeParam});
                this.scoreRefreshService.reloadRefDataV2(allComplianceCidList, null, new String[]{itemCodeParam});
            } else {
                this.scoreRefreshService.reloadRefDataV2(allComplianceCidList, null, itemCodes);
            }
        } else if (StringUtils.isNotBlank((CharSequence)itemCodeParam)) {
            XxlJobHelper.log((String)"\u5237\u65b0\u5355\u9879\u6570\u636e\uff0c itemCodeParam\uff1a{}", (Object[])new Object[]{itemCodeParam});
            this.scoreRefreshService.reloadRefData(allComplianceCidList, null, new String[]{itemCodeParam});
        } else {
            this.scoreRefreshService.reloadRefData(allComplianceCidList, null, itemCodes);
        }
    }

    @XxlJob(value="NewComplianceScoreRefreshTask-refreshOrgCode03ByGradeLastReport")
    public void refreshOrgCode03ByGradeLastReport() {
        List allComplianceCids = this.companyInfoService.getAllComplianceCids(Arrays.asList(NewComplianceInfoStatusEnum.COMPLIANT.getKey(), NewComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey()));
        if (CollectionUtils.isEmpty((Collection)allComplianceCids)) {
            return;
        }
        List allComplianceCidList = allComplianceCids.stream().map(NewComplianceCompanyInfo::getCid).distinct().collect(Collectors.toList());
        this.scoreRefreshService.reloadRefData(allComplianceCidList, null, new String[]{"03"});
    }
}

