/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceBasicVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceGuideVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceHeadlineVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceIndustryDisVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceIndustryVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceInfoVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceRemindVo;
import cn.smarthse.modules.health.newcompliance.dao.home.NewHomeComplianceMapper;
import cn.smarthse.modules.health.newcompliance.model.home.NewHomeComplianceModel;
import cn.smarthse.modules.health.newcompliance.service.home.INewHomeComplianceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional
public class NewHomeComplianceServiceImpl
implements INewHomeComplianceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewHomeComplianceServiceImpl.class);
    @Autowired
    private NewHomeComplianceMapper homeComplianceMapper;

    @Transactional(readOnly=true)
    public HomeComplianceBasicVo getBasicVo(NewHomeComplianceModel model) {
        HomeComplianceBasicVo vo = this.homeComplianceMapper.getBasicVo(model);
        return vo;
    }

    @Transactional(readOnly=true)
    public HomeComplianceHeadlineVo getHeadlineVo(NewHomeComplianceModel model) {
        return this.homeComplianceMapper.getHeadlineVo(model);
    }

    @Transactional(readOnly=true)
    public HomeComplianceRemindVo getRemindVo(NewHomeComplianceModel model) {
        return this.homeComplianceMapper.getRemindVo(model);
    }

    public List<HomeComplianceGuideVo> getGuideVoList(NewHomeComplianceModel model) {
        if (model.getAreaLevel() < 2) {
            return this.homeComplianceMapper.getGuideVoByProvince(model);
        }
        if (model.getAreaLevel() == 2) {
            return this.homeComplianceMapper.getGuideVoByCity(model);
        }
        return Collections.emptyList();
    }

    public HomeComplianceIndustryDisVo getIndustryDisVo(NewHomeComplianceModel model) {
        HomeComplianceIndustryDisVo vo = new HomeComplianceIndustryDisVo();
        List<HomeComplianceIndustryVo> list = this.homeComplianceMapper.getIndustryDisVo(model);
        if (list == null || list.isEmpty()) {
            vo.setCompliantCount(Integer.valueOf(0));
            vo.setIndustry(Collections.emptyList());
            return vo;
        }
        int compliantCount = list.stream().mapToInt(HomeComplianceIndustryVo::getCompliantCount).sum();
        vo.setCompliantCount(Integer.valueOf(compliantCount));
        ArrayList<HomeComplianceIndustryVo> industry = new ArrayList<HomeComplianceIndustryVo>();
        int size = list.size();
        if (size <= 5) {
            industry.addAll(list);
        } else {
            List<HomeComplianceIndustryVo> topFive = list.subList(0, 5);
            industry.addAll(topFive);
            int otherCompliantCount = list.subList(5, size).stream().mapToInt(HomeComplianceIndustryVo::getCompliantCount).sum();
            HomeComplianceIndustryVo other = new HomeComplianceIndustryVo();
            other.setImportantType(Integer.valueOf(0));
            other.setImportantTypeName("\u5176\u4ed6");
            other.setCompliantCount(Integer.valueOf(otherCompliantCount));
            industry.add(other);
        }
        vo.setIndustry(industry);
        return vo;
    }

    public boolean getHasThisLevel(Long cityId) {
        return this.homeComplianceMapper.getHasThisLevel(cityId);
    }

    public List<HomeComplianceInfoVo> getInfoVo(NewHomeComplianceModel model) {
        return this.homeComplianceMapper.getInfoVo(model);
    }
}

