/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.newcompliance.dao.NewCompliantChargePersonCertificateMapper;
import cn.smarthse.modules.health.newcompliance.entity.CompliantChargePersonCertificate;
import cn.smarthse.modules.health.newcompliance.model.NewCompliantChargePersonCertificateParam;
import cn.smarthse.modules.health.newcompliance.service.INewCompliantChargePersonCertificateService;
import cn.smarthse.modules.health.newcompliance.vo.NewCompliantChargePersonCertificateVo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewCompliantChargePersonCertificateServiceImpl
extends BaseServiceImpl<NewCompliantChargePersonCertificateMapper, CompliantChargePersonCertificate>
implements INewCompliantChargePersonCertificateService {
    @Transactional
    public List<NewCompliantChargePersonCertificateVo> loadChargePersonCertificateData(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        List<CertificateStaffDetail> newCertBatch = ((NewCompliantChargePersonCertificateMapper)this.dao).getCertificateStaffDetailList(cidList);
        Example selExample = new Example(CompliantChargePersonCertificate.class);
        selExample.createCriteria().andIn("cid", cidList).andEqualTo("isValid", (Object)Boolean.TRUE);
        List oldCertBatch = ((NewCompliantChargePersonCertificateMapper)this.dao).selectByExample(selExample);
        Map<Long, List<CertificateStaffDetail>> newCertMap = newCertBatch.stream().collect(Collectors.groupingBy(CertificateStaffDetail::getCid));
        Map<Long, List<CompliantChargePersonCertificate>> oldCertMap = oldCertBatch.stream().collect(Collectors.groupingBy(CompliantChargePersonCertificate::getCid));
        ArrayList needAdd = new ArrayList();
        ArrayList needDel = new ArrayList();
        for (Map.Entry<Long, List<CertificateStaffDetail>> newCertEntry : newCertMap.entrySet()) {
            Long cid = newCertEntry.getKey();
            List<CertificateStaffDetail> newCertList = newCertEntry.getValue();
            List newIdList = newCertList.stream().map(CertificateStaffDetail::getId).collect(Collectors.toList());
            List<CompliantChargePersonCertificate> oldCertList = oldCertMap.get(cid);
            if (CollUtil.isNotEmpty(oldCertList)) {
                List oldIdList = oldCertList.stream().map(CompliantChargePersonCertificate::getCertificateId).collect(Collectors.toList());
                List addIdList = newIdList.stream().filter(i -> !oldIdList.contains(i)).collect(Collectors.toList());
                List delIdList = oldIdList.stream().filter(i -> !newIdList.contains(i)).collect(Collectors.toList());
                needAdd.addAll(addIdList);
                needDel.addAll(delIdList);
                continue;
            }
            needAdd.addAll(newIdList);
        }
        List<CertificateStaffDetail> newCertList = newCertBatch.stream().filter(c -> needAdd.contains(c.getId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(newCertList)) {
            List<CompliantChargePersonCertificate> pcAddBatch = this.convertCertData(newCertList);
            ((NewCompliantChargePersonCertificateMapper)this.dao).insertList2(pcAddBatch);
        }
        if (CollUtil.isNotEmpty(needDel)) {
            Example delExample = new Example(CompliantChargePersonCertificate.class);
            delExample.createCriteria().andIn("certificateId", needDel);
            ((NewCompliantChargePersonCertificateMapper)this.dao).deleteByExample(delExample);
        }
        NewCompliantChargePersonCertificateParam certParam = new NewCompliantChargePersonCertificateParam();
        certParam.setCidList(cidList);
        return ((NewCompliantChargePersonCertificateMapper)this.dao).getSelectedCertPage(certParam);
    }

    public PageInfo<CertificateStaffDetail> getUnselectedCertPage(JqGridParam pageParam, CertificateStaffDetail certParam) {
        if (certParam == null || certParam.getCid() == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Page certPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        ((NewCompliantChargePersonCertificateMapper)this.dao).getUnselectedCertPage(certParam);
        return new PageInfo((List)certPage);
    }

    public PageInfo<NewCompliantChargePersonCertificateVo> getSelectedCertPage(JqGridParam pageParam, NewCompliantChargePersonCertificateParam certParam) {
        if (certParam == null || certParam.getCid() == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Page perCertPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<NewCompliantChargePersonCertificateVo> perCertList = ((NewCompliantChargePersonCertificateMapper)this.dao).getSelectedCertPage(certParam);
        for (NewCompliantChargePersonCertificateVo perCert : perCertList) {
            Integer dataSource = perCert.getDataSource();
            perCert.setDataSourceName(switch (dataSource) {
                case 1, 2, 4 -> "\u5176\u4ed6\u6765\u6e90";
                case 3 -> "\u6d59\u91cc\u536b\u4f01";
                case 5 -> "\u4e07\u8fbe\u4ed3-\u676d\u5dde\u57f9\u8bad";
                default -> null;
            });
            perCert.setPersonTypeName(StaffWorkPropertyEnum.getName((Byte)perCert.getPersonType()));
            perCert.setExpireName(perCert.getExpire() != false ? "\u5df2\u8d85\u671f" : "\u672a\u8d85\u671f");
        }
        return new PageInfo((List)perCertPage);
    }

    @Transactional
    public void selectOrDeselect(Long cid, Long certificateId) {
        if (certificateId == null) {
            return;
        }
        Example e = new Example(CompliantChargePersonCertificate.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("certificateId", (Object)certificateId);
        CompliantChargePersonCertificate cert = (CompliantChargePersonCertificate)((NewCompliantChargePersonCertificateMapper)this.dao).selectOneByExample(e);
        if (cert == null) {
            Date date = new Date();
            CompliantChargePersonCertificate c = new CompliantChargePersonCertificate();
            c.setId(Long.valueOf(IdWorker.getId()));
            c.setCid(cid);
            c.setCertificateId(certificateId);
            c.setIsValid(Boolean.TRUE);
            c.setCreateBy(cid);
            c.setCreateDate(date);
            c.setUpdatedBy(cid);
            c.setUpdateDate(date);
            ((NewCompliantChargePersonCertificateMapper)this.dao).insert(c);
        } else {
            ((NewCompliantChargePersonCertificateMapper)this.dao).deleteByExample(e);
        }
    }

    private List<CompliantChargePersonCertificate> convertCertData(List<CertificateStaffDetail> newCertList) {
        ArrayList<CompliantChargePersonCertificate> pcAddBatch = new ArrayList<CompliantChargePersonCertificate>();
        Date date = new Date();
        for (CertificateStaffDetail newCert : newCertList) {
            CompliantChargePersonCertificate pcAdd = new CompliantChargePersonCertificate();
            pcAdd.setId(Long.valueOf(IdWorker.getId()));
            pcAdd.setCid(newCert.getCid());
            pcAdd.setCertificateId(newCert.getId());
            pcAdd.setIsValid(Boolean.TRUE);
            pcAdd.setCreateDate(date);
            pcAdd.setUpdateDate(date);
            pcAddBatch.add(pcAdd);
        }
        return pcAddBatch;
    }
}

