/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceWorkerTrainRecordsMapper;
import cn.smarthse.modules.health.newcompliance.entity.ComplianceWorkerTrainRecords;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceStaffInfo;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceWorkerTrainRecordsParam;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceStaffInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceWorkerTrainRecordsService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceWorkerTrainRecordsVo;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class NewComplianceWorkerTrainRecordsServiceImpl
extends BaseServiceImpl<NewComplianceWorkerTrainRecordsMapper, ComplianceWorkerTrainRecords>
implements INewComplianceWorkerTrainRecordsService {
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private INewComplianceStaffInfoService complianceStaffInfoService;
    @Autowired
    private IWorkOperateLogService operateLogService;
    @Autowired
    protected IdWorker idworker;
    private static long dayMilliseconds = 86400000L;

    public PageInfo<NewComplianceWorkerTrainRecordsVo> pageList(NewComplianceWorkerTrainRecordsParam search, JqGridParam page) {
        Page trainPage = PageMethod.startPage((int)page.getPage(), (int)page.getRows());
        List<NewComplianceWorkerTrainRecordsVo> trainList = ((NewComplianceWorkerTrainRecordsMapper)this.dao).pageList(search);
        this.postSetTrainProofFile(trainList);
        return new PageInfo((List)trainPage);
    }

    public List<NewComplianceWorkerTrainRecordsVo> getTrainStaffListBatch(List<Long> cidList) {
        List<NewComplianceWorkerTrainRecordsVo> pageResult;
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        int pageSize = 500000;
        int offset = 0;
        ArrayList<NewComplianceWorkerTrainRecordsVo> result = new ArrayList<NewComplianceWorkerTrainRecordsVo>();
        while (!(pageResult = ((NewComplianceWorkerTrainRecordsMapper)this.dao).getTrainStaffListBatch(cidList, offset, pageSize)).isEmpty()) {
            result.addAll(pageResult);
            offset += pageSize;
        }
        return result;
    }

    public NewComplianceWorkerTrainRecordsVo getTrainInfo(Long id) {
        NewComplianceWorkerTrainRecordsVo recordsVo = ((NewComplianceWorkerTrainRecordsMapper)this.dao).getTrainInfo(id);
        List staffInfoList = this.complianceStaffInfoService.getStaffInfoList(id);
        recordsVo.setStaffInfoList(staffInfoList);
        if (StringUtils.isNotBlank((CharSequence)recordsVo.getFileId())) {
            SysFileModel file = this.sysFileProvideService.getFileById(Long.valueOf(recordsVo.getFileId()));
            recordsVo.setSysFileModel(file);
        }
        return recordsVo;
    }

    public PageInfo<NewComplianceWorkerTrainRecordsVo> getListByStaffId(Long staffId, JqGridParam page) {
        if (staffId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        List<NewComplianceWorkerTrainRecordsVo> trainRecords = ((NewComplianceWorkerTrainRecordsMapper)this.dao).getListByStaffId(staffId);
        return new PageInfo(trainRecords);
    }

    private void postSetTrainProofFile(List<NewComplianceWorkerTrainRecordsVo> trainList) {
        List fileIdList;
        if (CollUtil.isNotEmpty(trainList) && CollUtil.isNotEmpty(fileIdList = trainList.stream().map(NewComplianceWorkerTrainRecordsVo::getFileId).filter(CharSequenceUtil::isNotBlank).map(Convert::toLong).collect(Collectors.toList()))) {
            List fileList = this.sysFileProvideService.getListByIds(fileIdList);
            Map fileMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, Function.identity(), (v1, v2) -> v2));
            trainList.forEach(train -> {
                Long fileId = Convert.toLong((Object)train.getFileId());
                if (fileMap.containsKey(fileId)) {
                    train.setSysFileModel((SysFileModel)fileMap.get(fileId));
                }
            });
        }
    }

    @Transactional
    public Long updateTrain(NewComplianceWorkerTrainRecordsParam param, Integer changeState, Long loginStaffId, String loginStaffName) {
        BigDecimal max;
        if (param.getTrainHour() == null) {
            throw new ServiceException("\u57f9\u8bad\u8bfe\u65f6\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        BigDecimal trainHour = param.getTrainHour();
        if (trainHour.compareTo(max = Convert.toBigDecimal((Object)9.999999999E7)) > 0) {
            throw new ServiceException("\u57f9\u8bad\u8bfe\u65f6\u8d85\u8fc7\u6700\u5927\u503c[" + String.valueOf(max) + "]\uff01");
        }
        if (changeState == null) {
            throw new RuntimeException("\u63d0\u4ea4\u65b9\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5de5\u4f5c\u4eba\u5458");
        }
        if (changeState != 0) {
            if (param.getTrainBeginTime() == null || param.getTrainEndTime() == null) {
                throw new RuntimeException("\u57f9\u8bad\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long milliTime = param.getTrainEndTime().getTime() - param.getTrainBeginTime().getTime();
            if (milliTime / dayMilliseconds > 30L) {
                throw new RuntimeException("\u57f9\u8bad\u65f6\u95f4\u8303\u56f4\u6700\u591a\u4e0d\u8d85\u8fc730\u5929");
            }
        }
        ComplianceWorkerTrainRecords records = new ComplianceWorkerTrainRecords();
        BeanUtils.copyProperties((Object)param, (Object)records);
        if (CollectionUtils.isNotEmpty((Collection)param.getStaffInfoList())) {
            records.setTrainNumber(Integer.valueOf(param.getStaffInfoList().size()));
        }
        List newStaffInfoList = param.getStaffInfoList();
        this.setTrainId(newStaffInfoList, records.getId());
        Integer dbState = null;
        if (changeState == 0) {
            records.setStatus(Integer.valueOf(1));
        } else {
            records.setStatus(Integer.valueOf(2));
        }
        records.setUpdateDate(new Date());
        records.setUpdateBy(loginStaffId);
        if (records.getId() == null) {
            records.setId(Long.valueOf(this.idworker.nextId()));
            records.setCreateBy(loginStaffId);
            records.setCreateDate(new Date());
            ((NewComplianceWorkerTrainRecordsMapper)this.dao).insertSelective(records);
            this.setTrainId(newStaffInfoList, records.getId());
            this.complianceStaffInfoService.addStaffInfoList(newStaffInfoList, loginStaffId);
        } else {
            Example example = new Example(ComplianceWorkerTrainRecords.class);
            example.createCriteria().andEqualTo("id", (Object)records.getId()).andEqualTo("isValid", (Object)true);
            ComplianceWorkerTrainRecords dbRecord = (ComplianceWorkerTrainRecords)((NewComplianceWorkerTrainRecordsMapper)this.dao).selectOneByExample(example);
            if (dbRecord == null) {
                throw new RuntimeException("\u57f9\u8bad\u8bb0\u5f55\u7684id\u9519\u8bef\u3002");
            }
            dbState = dbRecord.getStatus();
            if (dbState == 2 && changeState == 0) {
                throw new RuntimeException("\u5df2\u7ecf\u63d0\u4ea4\u7684\u8bb0\u5f55\u4e0d\u80fd\u4fdd\u5b58\uff0c\u53ea\u80fd\u4fee\u6539");
            }
            ((NewComplianceWorkerTrainRecordsMapper)this.dao).updateByExampleSelective(records, example);
            List oldStaffInfoList = this.complianceStaffInfoService.getStaffInfoList(records.getId());
            List<Object> addList = new ArrayList();
            List<Object> deleteIdList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)newStaffInfoList) && CollectionUtils.isNotEmpty((Collection)oldStaffInfoList)) {
                addList.addAll(newStaffInfoList);
                List oldStaffIds = oldStaffInfoList.stream().map(NewComplianceStaffInfo::getStaffId).collect(Collectors.toList());
                List newStaffIds = newStaffInfoList.stream().map(NewComplianceStaffInfo::getStaffId).collect(Collectors.toList());
                addList = addList.stream().filter(e -> !oldStaffIds.contains(e.getStaffId())).collect(Collectors.toList());
                List deleteStaffIds = oldStaffIds.stream().filter(e -> !newStaffIds.contains(e)).collect(Collectors.toList());
                if (deleteStaffIds.size() > 0) {
                    deleteIdList = oldStaffInfoList.stream().filter(e -> deleteStaffIds.contains(e.getStaffId())).map(NewComplianceStaffInfo::getId).collect(Collectors.toList());
                }
            } else if (CollectionUtils.isEmpty((Collection)newStaffInfoList)) {
                deleteIdList = oldStaffInfoList.stream().map(NewComplianceStaffInfo::getId).collect(Collectors.toList());
            } else if (CollectionUtils.isEmpty((Collection)oldStaffInfoList)) {
                addList.addAll(newStaffInfoList);
            }
            this.complianceStaffInfoService.addStaffInfoList(addList, loginStaffId);
            this.complianceStaffInfoService.deleteStaffInfoList(deleteIdList, loginStaffId);
        }
        if (changeState != 0 && Objects.equals(dbState, 2)) {
            changeState = 2;
        }
        if (changeState == 1 || changeState == 2) {
            WorkOperateLogStatusEnum status = changeState == 1 ? WorkOperateLogStatusEnum.report : WorkOperateLogStatusEnum.back;
            this.operateLogService.addOperateLog(records.getCid(), WorkOperateLogEnum.workerTrain.getTypeVal(), records.getTrainName(), loginStaffId, loginStaffName, status, records.getId().toString());
        }
        return records.getId();
    }

    private void setTrainId(List<NewComplianceStaffInfo> staffInfoList, Long trainId) {
        if (CollectionUtils.isNotEmpty(staffInfoList) && trainId != null) {
            staffInfoList.forEach(e -> e.setStaffTrainId(trainId));
        }
    }

    @Transactional
    public String deleteByIds(String ids, Long loginStaffId, String loginStaffName) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            throw new RuntimeException("\u5220\u9664\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List idList = Arrays.stream(ids.split(",")).map(Long::valueOf).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList) && idList.size() > 1) {
            throw new RuntimeException("\u5220\u9664\u53c2\u6570ids\u5927\u4e8e1");
        }
        Long id = (Long)idList.get(0);
        ComplianceWorkerTrainRecords trainRecords = (ComplianceWorkerTrainRecords)this.getById(id);
        Example example = new Example(ComplianceWorkerTrainRecords.class);
        Example.Criteria criteria = example.createCriteria();
        ComplianceWorkerTrainRecords records = new ComplianceWorkerTrainRecords();
        criteria.andEqualTo("id", (Object)id);
        records.setIsValid(Boolean.valueOf(false));
        ((NewComplianceWorkerTrainRecordsMapper)this.dao).updateByExampleSelective(records, example);
        if (trainRecords.getStatus() == 2) {
            this.operateLogService.addOperateLog(trainRecords.getCid(), WorkOperateLogEnum.workerTrain.getTypeVal(), trainRecords.getTrainName(), loginStaffId, loginStaffName, WorkOperateLogStatusEnum.pass, trainRecords.getId().toString());
        }
        return ids;
    }

    @Transactional
    public void clearComplianceStaffTrainByCid(Long cid) {
        if (cid == null) {
            return;
        }
        ((NewComplianceWorkerTrainRecordsMapper)this.dao).clearComplianceStaffTrainByCid(cid);
    }
}

