/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceTryCompanyWorkMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceAssessmentInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceTryCompanyWork;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceAssessmentInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceTryCompanyWorkService;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewComplianceTryCompanyWorkServiceImpl
extends BaseServiceImpl<NewComplianceTryCompanyWorkMapper, NewComplianceTryCompanyWork>
implements INewComplianceTryCompanyWorkService {
    @Autowired
    private INewComplianceAssessmentInfoService complianceAssessmentInfoService;

    public List<NewComplianceTryCompanyWork> getTryCompanyRefInfo(Long workId) {
        NewComplianceTryCompanyWork param = new NewComplianceTryCompanyWork();
        param.setWorkId(workId);
        List<NewComplianceTryCompanyWork> tryCompanyRefInfo = ((NewComplianceTryCompanyWorkMapper)this.dao).getTryCompanyRefInfo(param);
        return tryCompanyRefInfo;
    }

    public Integer getListByWorkAndCid(Long cid, Long workId) {
        Example example = new Example(NewComplianceTryCompanyWork.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("cid", (Object)cid).andEqualTo("workId", (Object)workId);
        return ((NewComplianceTryCompanyWorkMapper)this.dao).selectCountByExample(example);
    }

    @Transactional(readOnly=false)
    public Integer batchUpdateCompanyWorkList(List<NewComplianceTryCompanyWork> companyWorkList) throws HealthException {
        if (CollectionUtils.isEmpty(companyWorkList)) {
            return null;
        }
        int i = this.batchUpdateOrInsert(companyWorkList, NewComplianceTryCompanyWorkMapper.class, (s, mapper) -> {
            s.setId(Long.valueOf(this.idworker.nextId()));
            return mapper.insertSelective(s);
        });
        Long workId = companyWorkList.get(0).getWorkId();
        if (ObjectUtil.isNull((Object)workId)) {
            throw new HealthException("\u672a\u6307\u5b9a\u5de5\u4f5c\u533a");
        }
        NewComplianceAssessmentInfo byId = (NewComplianceAssessmentInfo)this.complianceAssessmentInfoService.getById(workId);
        Example example = new Example(NewComplianceTryCompanyWork.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("workId", (Object)workId);
        Long countByExample = this.getCountByExample(example);
        byId.setCompanyNum(countByExample);
        this.complianceAssessmentInfoService.update((Object)byId);
        return i;
    }
}

