/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceStaffInfoMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceStaffInfo;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceStaffInfoService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceStaffInfoVo;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(rollbackFor={Exception.class})
public class NewComplianceStaffInfoServiceImpl
extends BaseServiceImpl<NewComplianceStaffInfoMapper, NewComplianceStaffInfo>
implements INewComplianceStaffInfoService {
    @Autowired
    protected IdWorker idworker;

    public List<NewComplianceStaffInfo> getStaffInfoList(Long trainId) {
        return ((NewComplianceStaffInfoMapper)this.dao).getStaffInfoList(trainId);
    }

    public void addStaffInfoList(List<NewComplianceStaffInfo> addList, Long userId) {
        if (CollectionUtils.isNotEmpty(addList)) {
            Date date = new Date();
            addList.forEach(e -> {
                e.setId(Long.valueOf(this.idworker.nextId()));
                e.setUpdateBy(userId);
                e.setUpdateDate(date);
            });
            this.batchUpdateOrInsert(addList, NewComplianceStaffInfoMapper.class, (e, mapper) -> mapper.insertSelective(e));
        }
    }

    public void deleteStaffInfoList(List<Long> deleteIdList, Long userId) {
        if (CollectionUtils.isNotEmpty(deleteIdList)) {
            Example example = new Example(NewComplianceStaffInfo.class);
            example.createCriteria().andIn("id", deleteIdList);
            NewComplianceStaffInfo staffInfo = new NewComplianceStaffInfo();
            staffInfo.setIsValid(Boolean.valueOf(false));
            staffInfo.setUpdateDate(new Date());
            staffInfo.setUpdateBy(userId);
            ((NewComplianceStaffInfoMapper)this.dao).updateByExampleSelective(staffInfo, example);
        }
    }

    public List<NewComplianceStaffInfoVo> queryCompletedWorkerTrainInfo(List<Long> staffIdList) {
        if (CollUtil.isEmpty(staffIdList)) {
            return Collections.emptyList();
        }
        return ((NewComplianceStaffInfoMapper)this.dao).queryCompletedWorkerTrainInfo(staffIdList);
    }
}

