/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceScoreChangeRecordV2Mapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceScoreChangeRecordV2;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreChangeRecordV2Service;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceScoreChangeRecordVoV2;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class NewComplianceScoreChangeRecordV2Impl
extends BaseServiceImpl<NewComplianceScoreChangeRecordV2Mapper, NewComplianceScoreChangeRecordV2>
implements INewComplianceScoreChangeRecordV2Service {
    @Transactional(readOnly=false)
    public void insertComplianceScoreChangeBatch(List<NewComplianceScoreChangeRecordV2> scoreList) {
        if (CollUtil.isEmpty(scoreList)) {
            return;
        }
        ((NewComplianceScoreChangeRecordV2Mapper)this.dao).insertList2(scoreList);
    }

    public List<NewComplianceScoreChangeRecordV2> queryLatestRecordsV2(List<Long> complianceIds) {
        if (CollectionUtil.isEmpty(complianceIds)) {
            return Collections.emptyList();
        }
        return ((NewComplianceScoreChangeRecordV2Mapper)this.dao).queryYesterdayRecordsV2(complianceIds);
    }

    public PageInfo<NewComplianceScoreChangeRecordVoV2> getComplianceScoreChangeRecord(JqGridParam pageParam, Long complianceId) {
        if (complianceId == null) {
            return null;
        }
        PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<NewComplianceScoreChangeRecordVoV2> complianceTryCompanyInfoVos = ((NewComplianceScoreChangeRecordV2Mapper)this.dao).getComplianceScoreChangeRecord(complianceId);
        this.calculateScoreChanges(complianceTryCompanyInfoVos);
        PageInfo data = new PageInfo(complianceTryCompanyInfoVos);
        return data;
    }

    public void calculateScoreChanges(List<NewComplianceScoreChangeRecordVoV2> recordList) {
        if (CollUtil.isEmpty(recordList)) {
            return;
        }
        for (NewComplianceScoreChangeRecordVoV2 r : recordList) {
            BigDecimal currentScore = r.getComplianceScore();
            Integer status = r.getStatus();
            if (!Objects.equals(status, NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey()) && !Objects.equals(status, NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) continue;
            String statusName = NewComplianceInfoStatusEnum.getValue((Integer)status);
            if (statusName.contains("-")) {
                statusName = statusName.substring(statusName.indexOf("-") + 1);
            }
            r.setComplianceScoreStr(statusName);
            r.setChangeScore("--");
        }
    }
}

