/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceGuideConstructionMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceGuideConstruction;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceGuideConstructioParam;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceGuideConstructionDto;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceGuideConstructionService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceGuideConstructionVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional
public class NewComplianceGuideConstructionServiceImpl
extends BaseServiceImpl<NewComplianceGuideConstructionMapper, NewComplianceGuideConstruction>
implements INewComplianceGuideConstructionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceGuideConstructionServiceImpl.class);
    @Autowired
    private ISysAreaProvideService areaProvideService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;

    public List<NewComplianceGuideConstruction> getDetailByAreaId(Long areaId, Boolean thisLevel, Boolean thisYear) {
        AreaModel area = this.areaProvideService.getAreaById(areaId);
        return ((NewComplianceGuideConstructionMapper)this.dao).getDetailByAreaId(areaId, area.getLevel(), thisLevel, thisYear);
    }

    public PageInfo<NewComplianceGuideConstructionVo> listData(JqGridParam param, NewComplianceGuideConstructioParam queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<Object> list = new ArrayList();
        list = queryParam.getAreaLevel() <= 1 && queryParam.getAreaShow() == false ? ((NewComplianceGuideConstructionMapper)this.dao).listDataByCity(queryParam) : ((NewComplianceGuideConstructionMapper)this.dao).listDataByArea(queryParam);
        return new PageInfo(list);
    }

    public NewComplianceGuideConstructionVo countByAreaId(NewComplianceGuideConstructioParam queryParam) {
        return ((NewComplianceGuideConstructionMapper)this.dao).countByArea(queryParam);
    }

    public void countGuide() {
        ((NewComplianceGuideConstructionMapper)this.dao).delete(new NewComplianceGuideConstruction());
        List<NewComplianceGuideConstructionDto> allImportantType = ((NewComplianceGuideConstructionMapper)this.dao).selectALLImportantType();
        ArrayList<String> allUnits = new ArrayList<String>();
        ArrayList<String> allIndustryIds = new ArrayList<String>();
        for (NewComplianceGuideConstructionDto dto2 : allImportantType) {
            if (dto2.getUnit() != null && !dto2.getUnit().isEmpty()) {
                allUnits.addAll(Arrays.asList(dto2.getUnit().split(",")));
            }
            if (dto2.getIndustryIds() == null || dto2.getIndustryIds().isEmpty()) continue;
            allIndustryIds.addAll(Arrays.asList(dto2.getIndustryIds().split(",")));
        }
        List<String> distinctUnits = allUnits.stream().distinct().collect(Collectors.toList());
        List<String> distinctIndustryIds = allIndustryIds.stream().distinct().collect(Collectors.toList());
        Map<String, Object> infoMap = this.buildUnitAndIndustryMap(distinctUnits, distinctIndustryIds);
        Map unitAreaMap = (Map)infoMap.get("unitAreaMap");
        Map industryMap = (Map)infoMap.get("industryMap");
        List<NewComplianceGuideConstructionDto> splitList = this.splitImportantType(allImportantType);
        this.fillUnitAndIndustryInfo(splitList, unitAreaMap, industryMap);
        List filteredList = splitList.stream().filter(dto -> dto.getAreaId() != null).collect(Collectors.toList());
        List<NewComplianceGuideConstruction> entityList = filteredList.stream().map(NewComplianceGuideConstructionServiceImpl::convertDtoToEntity).toList();
        this.batchUpdateOrInsert(entityList, NewComplianceGuideConstructionMapper.class, (item, mapper) -> mapper.insert(item));
    }

    public static NewComplianceGuideConstruction convertDtoToEntity(NewComplianceGuideConstructionDto dto) {
        if (dto == null) {
            return null;
        }
        NewComplianceGuideConstruction entity = new NewComplianceGuideConstruction();
        entity.setId(Long.valueOf(IdWorker.getId()));
        entity.setCategoryTypeId(dto.getCategoryTypeId());
        entity.setAreaId(dto.getAreaId());
        entity.setAreaLevel(dto.getAreaLevel());
        entity.setAreaName(dto.getAreaName());
        entity.setGuideName(dto.getGuideName());
        entity.setIsValid(Boolean.valueOf(true));
        entity.setIndustryCategory(dto.getIndustryCategory());
        entity.setIndustryIds(dto.getIndustryIds());
        entity.setUpdateDate(new Date());
        entity.setCreateDate(dto.getZdTime());
        return entity;
    }

    private void fillUnitAndIndustryInfo(List<NewComplianceGuideConstructionDto> list, Map<Long, NewComplianceGuideConstructionDto> unitAreaMap, Map<Long, IndustryModel> industryMap) {
        for (NewComplianceGuideConstructionDto dto : list) {
            if (dto.getUnit() != null) {
                try {
                    Long unitId = Long.valueOf(dto.getUnit());
                    NewComplianceGuideConstructionDto areaInfo = unitAreaMap.get(unitId);
                    if (areaInfo != null) {
                        dto.setAreaId(areaInfo.getAreaId());
                        dto.setAreaLevel(areaInfo.getAreaLevel());
                        dto.setAreaName(areaInfo.getAreaName());
                    }
                }
                catch (Exception unitId) {
                    // empty catch block
                }
            }
            if (dto.getIndustryIds() == null || dto.getIndustryIds().isEmpty()) continue;
            String[] ids = dto.getIndustryIds().split(",");
            ArrayList<String> names = new ArrayList<String>();
            for (String idStr : ids) {
                try {
                    Long id = Long.valueOf(idStr.trim());
                    IndustryModel model = industryMap.get(id);
                    if (model == null || model.getName() == null) continue;
                    names.add(model.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dto.setIndustryCategory(String.join((CharSequence)",", names));
        }
    }

    private List<NewComplianceGuideConstructionDto> splitImportantType(List<NewComplianceGuideConstructionDto> allImportantType) {
        ArrayList<NewComplianceGuideConstructionDto> splitList = new ArrayList<NewComplianceGuideConstructionDto>();
        for (NewComplianceGuideConstructionDto dto : allImportantType) {
            if (dto.getUnit() == null || dto.getUnit().trim().isEmpty()) {
                splitList.add(dto);
                continue;
            }
            String[] unitArr = dto.getUnit().split(",");
            if (unitArr.length == 1) {
                splitList.add(dto);
                continue;
            }
            for (String u : unitArr) {
                NewComplianceGuideConstructionDto copy = new NewComplianceGuideConstructionDto();
                copy.setId(dto.getId());
                copy.setCategoryTypeId(dto.getCategoryTypeId());
                copy.setGuideName(dto.getGuideName());
                copy.setZdTime(dto.getZdTime());
                copy.setSource(dto.getSource());
                copy.setIndustryIds(dto.getIndustryIds());
                copy.setIndustryCategory(dto.getIndustryCategory());
                copy.setGuideNum(dto.getGuideNum());
                copy.setUnit(u.trim());
                splitList.add(copy);
            }
        }
        return splitList;
    }

    private Map<String, Object> buildUnitAndIndustryMap(List<String> distinctUnits, List<String> distinctIndustryIds) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!distinctUnits.isEmpty()) {
            List<NewComplianceGuideConstructionDto> unitAreaList = ((NewComplianceGuideConstructionMapper)this.dao).selectUnitAreaInfo(distinctUnits);
            HashMap<Long, NewComplianceGuideConstructionDto> unitAreaMap = new HashMap<Long, NewComplianceGuideConstructionDto>();
            for (NewComplianceGuideConstructionDto dto : unitAreaList) {
                unitAreaMap.put(dto.getId(), dto);
            }
            resultMap.put("unitAreaMap", unitAreaMap);
        }
        if (!distinctIndustryIds.isEmpty()) {
            String ids = String.join((CharSequence)",", distinctIndustryIds);
            List industryList = this.industryProvideService.getIndustryByIds(ids);
            HashMap<Long, IndustryModel> industryMap = new HashMap<Long, IndustryModel>();
            for (IndustryModel model : industryList) {
                industryMap.put(model.getId(), model);
            }
            resultMap.put("industryMap", industryMap);
        }
        return resultMap;
    }
}

