/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.newcompliance.dao.NewcomplianceGhcollectMonthReportMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceGhcollectWeekReport;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceGhcollectMonthReportService;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualParam;
import cn.smarthse.util.common.StringUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewComplianceGhcollectMonthReportServiceImpl
extends BaseServiceImpl<NewcomplianceGhcollectMonthReportMapper, NewComplianceGhcollectWeekReport>
implements INewComplianceGhcollectMonthReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceGhcollectMonthReportServiceImpl.class);

    public List<NewComplianceGhcollectWeekReport> selectAll(Integer weekNum) {
        Example e = new Example(NewComplianceGhcollectWeekReport.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true);
        if (weekNum != null) {
            criteria.andEqualTo("weekNum", (Object)weekNum);
        }
        return this.getListByExample(e);
    }

    public List<NewComplianceGhcollectWeekReport> getHgCollectData(ComplianceVisualParam param) {
        List<NewComplianceGhcollectWeekReport> dataList = ((NewcomplianceGhcollectMonthReportMapper)this.dao).getHgCollectData(param);
        return dataList;
    }

    public String generateMapKey(NewComplianceGhcollectWeekReport report) {
        Long provinceId = Optional.ofNullable(report).map(NewComplianceGhcollectWeekReport::getProvinceId).orElse(0L);
        Long cityId = Optional.ofNullable(report).map(NewComplianceGhcollectWeekReport::getCityId).orElse(0L);
        Long areaId = Optional.ofNullable(report).map(NewComplianceGhcollectWeekReport::getAreaId).orElse(0L);
        Long streetId = Optional.ofNullable(report).map(NewComplianceGhcollectWeekReport::getStreetId).orElse(0L);
        Integer monthNum = Optional.ofNullable(report).map(NewComplianceGhcollectWeekReport::getWeekNum).orElse(0);
        return StringUtils.join((Object[])new Number[]{provinceId, cityId, areaId, streetId, monthNum});
    }

    @Transactional(readOnly=false)
    public void collectReport() {
        ImmutablePair weekNumber = DateUtil.getWeekNumber((LocalDate)LocalDate.now());
        List<NewComplianceGhcollectWeekReport> oldDataList = this.selectAll((Integer)weekNumber.getRight());
        List<NewComplianceGhcollectWeekReport> newDataList = ((NewcomplianceGhcollectMonthReportMapper)this.dao).collectReport();
        if (CollectionUtils.isEmpty(newDataList)) {
            return;
        }
        newDataList.forEach(i -> i.setWeekNum((Integer)weekNumber.getRight()));
        Map<Object, Object> okdMapKeyIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(oldDataList)) {
            okdMapKeyIdMap = oldDataList.stream().collect(Collectors.toMap(k -> this.generateMapKey((NewComplianceGhcollectWeekReport)k), NewComplianceGhcollectWeekReport::getId, (v1, v2) -> v1));
        }
        for (NewComplianceGhcollectWeekReport complianceGhcollectMonthReport : newDataList) {
            String mapKey = this.generateMapKey(complianceGhcollectMonthReport);
            complianceGhcollectMonthReport.setId((Long)okdMapKeyIdMap.get(mapKey));
        }
        List partition = ListUtil.partition(newDataList, (int)1000);
        for (List complianceGhcollectMonthReports : partition) {
            this.batchUpdateOrInsert(complianceGhcollectMonthReports, NewcomplianceGhcollectMonthReportMapper.class, (item, mapper) -> {
                if (item.getId() == null) {
                    item.setId(Long.valueOf(this.idworker.nextId()));
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    return mapper.insert(item);
                }
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
        }
    }
}

