/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.newcompliance.calcscore.NewCalcScoreBusService;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceApplyAppend;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyLabel;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyProcessRecord;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoLabelEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceObjectionStatusEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceProcessStatusEnum;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyObjectionApplyParam;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceApplyAppendService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyLabelService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyProcessRecordService;
import cn.smarthse.modules.health.newcompliance.service.INewCompliancePrepareSmsService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreRefreshService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyLabelVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyObjectionApplyVo;
import cn.smarthse.modules.health.newcompliance.vo.NewCompliantItemcodeTypeVo;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategoryType;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class NewComplianceCompanyObjectionApplyServiceImpl
extends BaseServiceImpl<NewComplianceCompanyObjectionApplyMapper, NewComplianceCompanyObjectionApply>
implements INewComplianceCompanyObjectionApplyService {
    @Autowired
    private NewComplianceCompanyInfoMapper infoMapper;
    @Autowired
    private INewComplianceCompanyLabelService labelService;
    @Autowired
    INewComplianceScoreRefreshService scoreRefreshService;
    @Autowired
    INewBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    NewCalcScoreBusService calcScoreBusService;
    @Autowired
    private INewComplianceCompanyProcessRecordService processRecordService;
    @Autowired
    private NewComplianceCompanyExitItemMapper exitItemMapper;
    @Autowired
    private INewComplianceApplyAppendService complianceApplyAppendService;
    @Autowired
    private IImportantIndustryCategoryService importantIndustryCategoryService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService regionService;
    @Autowired
    private INewCompliancePrepareSmsService prepareSmsService;
    private static final String COMPLIANCE_ITEM_TYPE = "03,06,09,11,12,13,14";
    private static final String APPLY_ITEM_TYPE = "00,01,04,05,07,08,10";
    private static final Map<String, String> APPLY_ITEM_MAP;

    public List<NewCompliantItemcodeTypeVo> getItemcodeTypeList() {
        return ((NewComplianceCompanyObjectionApplyMapper)this.dao).getItemcodeTypeList(COMPLIANCE_ITEM_TYPE);
    }

    public PageInfo<NewComplianceCompanyObjectionApplyVo> getObjectionPage(JqGridParam pageParam, NewComplianceCompanyObjectionApplyParam objectionParam) {
        this.preSetRegionInfo(objectionParam);
        ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
        typeParam.setMenuSet(Integer.valueOf(1));
        List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
        if (CollUtil.isNotEmpty((Collection)typeList)) {
            List industries = typeList.stream().map(ImportantIndustryCategoryType::getImportantType).map(String::valueOf).collect(Collectors.toList());
            objectionParam.setIndustries(industries);
        }
        Page objectionPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        objectionParam.setSelectItemcodeKey(COMPLIANCE_ITEM_TYPE);
        List<NewComplianceCompanyObjectionApplyVo> objectionList = ((NewComplianceCompanyObjectionApplyMapper)this.dao).getObjectionPage(objectionParam);
        objectionList.forEach(v -> v.setObjectionTypeName(NewComplianceObjectionStatusEnum.getValue((Integer)v.getObjectionType())));
        return new PageInfo((List)objectionPage);
    }

    public PageInfo<NewComplianceCompanyObjectionApplyVo> getApplyPage(JqGridParam pageParam, NewComplianceCompanyObjectionApplyParam applyParam) {
        this.preSetRegionInfo(applyParam);
        ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
        typeParam.setMenuSet(Integer.valueOf(1));
        List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
        if (CollUtil.isNotEmpty((Collection)typeList)) {
            List industries = typeList.stream().map(ImportantIndustryCategoryType::getImportantType).map(String::valueOf).collect(Collectors.toList());
            applyParam.setIndustries(industries);
        }
        Page applyPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        applyParam.setSelectItemcodeKey(APPLY_ITEM_TYPE);
        List<NewComplianceCompanyObjectionApplyVo> applyList = ((NewComplianceCompanyObjectionApplyMapper)this.dao).getApplyPage(applyParam);
        applyList.forEach(v -> v.setObjectionTypeName(NewComplianceProcessStatusEnum.getValue((Integer)v.getObjectionType())));
        applyList.forEach(v -> v.setTitle(APPLY_ITEM_MAP.get(v.getItemcodeKey())));
        return new PageInfo((List)applyPage);
    }

    public void preSetRegionInfo(NewComplianceCompanyObjectionApplyParam objectionApplyParam) {
        if (objectionApplyParam == null) {
            return;
        }
        Long regionId = objectionApplyParam.getRegionId();
        AreaModel region = this.regionService.getAreaById(regionId);
        if (region != null && region.getId() != null) {
            objectionApplyParam.setRegionLevel(region.getLevel());
        }
    }

    public List<NewComplianceCompanyObjectionApply> getUnprocessedByCidAndItemcodeId(Long cid, Long itemcodeId, Integer type) {
        Example example = new Example(NewComplianceCompanyObjectionApply.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("itemcodeId", (Object)itemcodeId).andEqualTo("status", (Object)1).andEqualTo("type", (Object)type).andEqualTo("isValid", (Object)true);
        return ((NewComplianceCompanyObjectionApplyMapper)this.dao).selectByExample(example);
    }

    public List<NewComplianceCompanyObjectionApply> listObjectionApply(Long complianceId, List<Long> itemcodeIdList, Integer type, List<Integer> status) {
        Example example = new Example(NewComplianceCompanyObjectionApply.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("complianceId", (Object)complianceId).andEqualTo("isValid", (Object)true);
        if (type != null) {
            criteria.andEqualTo("type", (Object)type);
        }
        if (CollectionUtil.isNotEmpty(status)) {
            criteria.andIn("status", status);
        }
        if (CollectionUtil.isNotEmpty(itemcodeIdList)) {
            criteria.andIn("itemcodeId", itemcodeIdList);
        }
        return ((NewComplianceCompanyObjectionApplyMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void raiseObjection(NewComplianceCompanyInfo info, NewComplianceCompanyObjectionApply moudel, Long userId) {
        Date now = new Date();
        moudel.setId(Long.valueOf(IdWorker.getId()));
        moudel.setCid(info.getCid());
        moudel.setUpdateDate(now);
        moudel.setCreateDate(now);
        moudel.setUpdatedBy(userId);
        moudel.setCreateBy(userId);
        moudel.setStatus(Integer.valueOf(1));
        moudel.setType(Integer.valueOf(1));
        moudel.setIsValid(Boolean.valueOf(true));
        ((NewComplianceCompanyObjectionApplyMapper)this.dao).insert(moudel);
        this.labelService.updateBypLabel(info.getId(), NewComplianceInfoLabelEnum.OBJECTION.getKey(), userId);
        if (info != null && info.getStatus() != NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey()) {
            info.setUpdateDate(now);
            info.setUpdateBy(userId);
            if (info.getStatus() == NewComplianceInfoStatusEnum.COMPLIANT.getKey()) {
                this.prepareSmsService.addPrepareSms(info.getId());
                info.setLastExitQualifyDate(new Date());
            }
            info.setStatus(NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
            this.infoMapper.updateByPrimaryKey(info);
            ArrayList<NewComplianceCompanyLabel> list = new ArrayList<NewComplianceCompanyLabel>();
            NewComplianceCompanyLabel label = new NewComplianceCompanyLabel();
            label.setComplianceId(info.getId());
            label.setLabel(NewComplianceInfoLabelEnum.OBJECTION.getKey());
            label.setCreateBy(userId);
            label.setCreateDate(now);
            label.setIsValid(Boolean.valueOf(true));
            list.add(label);
            this.labelService.updateClashLabel(list);
        }
    }

    @Transactional(readOnly=false)
    public void sendAppeal(NewComplianceCompanyObjectionApply moudel, Long userId) {
        NewComplianceCompanyInfo complianceCompanyInfo = this.infoMapper.getInfoById(moudel.getComplianceId());
        Date now = new Date();
        moudel.setId(Long.valueOf(IdWorker.getId()));
        moudel.setCid(complianceCompanyInfo.getCid());
        moudel.setUpdateDate(now);
        moudel.setCreateDate(now);
        moudel.setUpdatedBy(userId);
        moudel.setCreateBy(userId);
        moudel.setStatus(Integer.valueOf(1));
        moudel.setType(Integer.valueOf(2));
        moudel.setIsValid(Boolean.valueOf(true));
        ((NewComplianceCompanyObjectionApplyMapper)this.dao).insert(moudel);
        Map appendConditions = moudel.getAppendConditions();
        if (MapUtils.isNotEmpty((Map)appendConditions)) {
            List appendList = appendConditions.keySet().stream().map(key -> {
                NewComplianceApplyAppend append = new NewComplianceApplyAppend();
                append.setApplyId(moudel.getId());
                append.setKey(key);
                append.setValue((String)appendConditions.get(key));
                append.setId(Long.valueOf(IdWorker.getId()));
                append.setUpdateDate(now);
                append.setCreateDate(now);
                append.setUpdatedBy(userId);
                append.setCreateBy(userId);
                append.setIsValid(Boolean.valueOf(true));
                return append;
            }).collect(Collectors.toList());
            this.complianceApplyAppendService.saveBatch(appendList);
        }
        complianceCompanyInfo.setUpdateDate(now);
        complianceCompanyInfo.setUpdateBy(userId);
        if (NewComplianceInfoStatusEnum.COMPLIANT.getKey() == complianceCompanyInfo.getStatus()) {
            complianceCompanyInfo.setLastExitQualifyDate(now);
        }
        complianceCompanyInfo.setStatus(NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
        this.infoMapper.updateByPrimaryKey(complianceCompanyInfo);
        ArrayList<NewComplianceCompanyLabel> list = new ArrayList<NewComplianceCompanyLabel>();
        NewComplianceCompanyLabel label = new NewComplianceCompanyLabel();
        label.setComplianceId(complianceCompanyInfo.getId());
        label.setLabel(NewComplianceInfoLabelEnum.APPEAL.getKey());
        label.setCreateBy(userId);
        label.setCreateDate(now);
        label.setIsValid(Boolean.valueOf(true));
        list.add(label);
        this.labelService.updateClashLabel(list);
    }

    @Transactional(readOnly=false)
    public void withdrawAppeal(NewComplianceCompanyObjectionApply apply, Long userId) {
        apply.setStatus(Integer.valueOf(2));
        NewComplianceCompanyProcessRecord record = new NewComplianceCompanyProcessRecord();
        record.setStatus(NewComplianceProcessStatusEnum.CANCEL.getKey());
        record.setCreateBy(userId);
        record.setCreateDate(new Date());
        record.setObjectionApplyId(apply.getId());
        record.setId(Long.valueOf(this.idworker.nextId()));
        this.processRecordService.add((Object)record);
        this.changeStatusAfterAudit(apply, userId, NewComplianceInfoLabelEnum.APPEAL.getKey());
    }

    @Transactional(readOnly=false)
    public void changeStatusAfterAudit(NewComplianceCompanyObjectionApply objectionApply, Long userId, Integer label) {
        objectionApply.setUpdateDate(new Date());
        objectionApply.setUpdatedBy(userId);
        ((NewComplianceCompanyObjectionApplyMapper)this.dao).updateByPrimaryKey(objectionApply);
        this.labelService.updateBypLabel(objectionApply.getComplianceId(), label, userId);
        NewComplianceCompanyLabelVo labelVo = this.labelService.selectLabelByComplianceId(objectionApply.getComplianceId(), null);
        Boolean exitExist = this.exitItemMapper.whetherExitItemsExist(objectionApply.getComplianceId());
        if (exitExist.booleanValue()) {
            NewComplianceCompanyInfo info = this.infoMapper.getInfoById(objectionApply.getComplianceId());
            info.setStatus(NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey());
            info.setUpdateBy(userId);
            info.setUpdateDate(new Date());
            this.infoMapper.updateByPrimaryKey(info);
        } else if (!(labelVo == null || labelVo.getHasObjection().booleanValue() || labelVo.getHasAppeal().booleanValue() || labelVo.getHasExitItems().booleanValue() || labelVo.getPromiseDataClash().booleanValue())) {
            this.scoreRefreshService.syncRefresh(objectionApply.getCid(), null, new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14"});
        }
    }

    static {
        HashMap<String, String> applyMap = new HashMap<String, String>();
        applyMap.put("00", "\u30101.\u9000\u51fa\u9879\u3011");
        applyMap.put("01", "\u30102.\u804c\u4e1a\u536b\u751f\u5206\u7c7b\u548c\u98ce\u9669\u5316\u89e3\u3011 2.1\uff1a\u804c\u4e1a\u536b\u751f\u5206\u7c7b");
        applyMap.put("03", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.1\uff1a\u7ec4\u7ec7\u673a\u6784\u548c\u7ba1\u7406\u5236\u5ea6");
        applyMap.put("04", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.2\uff1a\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u201c\u4e09\u540c\u65f6\u201d");
        applyMap.put("05", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.3\uff1a\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5");
        applyMap.put("06", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.4\uff1a\u804c\u4e1a\u5065\u5eb7\u5f02\u5e38\u7ed3\u679c\u53ca\u65f6\u5904\u7f6e\u548c\u62a5\u544a");
        applyMap.put("07", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.5\uff1a\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u3001\u8bc4\u4ef7");
        applyMap.put("08", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.6\uff1a\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6d53\u5ea6\u6216\u5f3a\u5ea6");
        applyMap.put("10", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.8\uff1a\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5");
        APPLY_ITEM_MAP = applyMap;
    }
}

