/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyItemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyLabelMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyLabel;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoLabelEnum;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyLabelService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyLabelVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class NewComplianceCompanyLabelServiceImpl
extends BaseServiceImpl<NewComplianceCompanyLabelMapper, NewComplianceCompanyLabel>
implements INewComplianceCompanyLabelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceCompanyLabelServiceImpl.class);
    @Autowired
    private NewComplianceCompanyExitItemMapper exitItemMapper;
    @Autowired
    private NewComplianceCompanyObjectionApplyMapper objectionApplyMapper;
    @Autowired
    private NewComplianceCompanyItemMapper itemMapper;

    @Transactional
    public void updateBypLabel(Long complianceId, Integer label, Long userId) {
        if (complianceId == null || label == null) {
            return;
        }
        List<NewComplianceCompanyLabel> list = this.toComplianceCompanyLabelList(complianceId, label, userId);
        boolean shouldSave = false;
        boolean shouldDelete = false;
        NewComplianceInfoLabelEnum enumValue = null;
        for (NewComplianceInfoLabelEnum value : NewComplianceInfoLabelEnum.values()) {
            if (value.getKey() != label) continue;
            enumValue = value;
            break;
        }
        if (enumValue != null) {
            switch (enumValue) {
                case EXITITEMS: {
                    shouldSave = this.exitItemMapper.hasExitItems(complianceId);
                    break;
                }
                case OBJECTION: {
                    shouldSave = this.objectionApplyMapper.getUnprocessedBycomplianceId(complianceId, (byte)1);
                    break;
                }
                case APPEAL: {
                    shouldSave = this.objectionApplyMapper.getUnprocessedBycomplianceId(complianceId, (byte)2);
                    break;
                }
                case PROMISEDATACLASH: {
                    shouldSave = this.itemMapper.hasPromisedataclash(complianceId);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        boolean bl = shouldDelete = !shouldSave;
        if (shouldSave) {
            this.updateClashLabel(list);
        } else if (shouldDelete) {
            this.delLabels(list);
        }
    }

    private List<NewComplianceCompanyLabel> toComplianceCompanyLabelList(Long complianceId, Integer label, Long userId) {
        ArrayList<NewComplianceCompanyLabel> list = new ArrayList<NewComplianceCompanyLabel>();
        NewComplianceCompanyLabel companyLabel = new NewComplianceCompanyLabel();
        Date now = new Date();
        companyLabel.setComplianceId(complianceId);
        companyLabel.setLabel(label);
        companyLabel.setCreateBy(userId);
        companyLabel.setUpdateBy(userId);
        companyLabel.setCreateDate(now);
        companyLabel.setUpdateDate(now);
        companyLabel.setIsValid(Boolean.valueOf(true));
        list.add(companyLabel);
        return list;
    }

    public NewComplianceCompanyLabelVo selectLabelByComplianceId(Long complianceId, Integer label) {
        return ((NewComplianceCompanyLabelMapper)this.dao).selectLabelByComplianceId(complianceId, label);
    }

    @Transactional(readOnly=false)
    public void updateClashLabel(List<NewComplianceCompanyLabel> labels) {
        if (CollectionUtils.isEmpty(labels)) {
            return;
        }
        Set complianceIdSet = labels.stream().map(NewComplianceCompanyLabel::getComplianceId).collect(Collectors.toSet());
        Integer label = labels.get(0).getLabel();
        Example e = new Example(NewComplianceCompanyLabel.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true).andIn("complianceId", complianceIdSet).andEqualTo("label", (Object)label);
        e.selectProperties(new String[]{"id", "complianceId", "isValid"});
        List dbLabels = ((NewComplianceCompanyLabelMapper)this.dao).selectByExample(e);
        Map<Object, Object> dbDataMap = new HashMap();
        if (dbLabels != null && dbLabels.size() > 0) {
            dbDataMap = dbLabels.stream().collect(Collectors.toMap(k -> k.getComplianceId(), Function.identity(), (v1, v2) -> v1));
        }
        ArrayList<NewComplianceCompanyLabel> needUpdateList = new ArrayList<NewComplianceCompanyLabel>();
        for (NewComplianceCompanyLabel newLabel : labels) {
            if (dbDataMap.containsKey(newLabel.getComplianceId())) {
                NewComplianceCompanyLabel dbData = (NewComplianceCompanyLabel)dbDataMap.get(newLabel.getComplianceId());
                if (Objects.equals(dbData.getIsValid(), newLabel.getIsValid())) continue;
                newLabel.setId(dbData.getId());
                needUpdateList.add(newLabel);
                continue;
            }
            needUpdateList.add(newLabel);
        }
        if (CollectionUtils.isNotEmpty(needUpdateList)) {
            for (List complianceCompanyLabels : ListUtil.partition(needUpdateList, (int)1000)) {
                this.batchUpdateOrInsert(complianceCompanyLabels, NewComplianceCompanyLabelMapper.class, (item, mapper) -> {
                    if (item.getId() == null) {
                        if (Objects.equals(item.getIsValid(), false)) {
                            return 0;
                        }
                        item.setId(Long.valueOf(this.idworker.nextId()));
                        item.setCreateDate(new Date());
                        item.setIsValid(Boolean.valueOf(true));
                        return mapper.insert(item);
                    }
                    item.setUpdateDate(new Date());
                    return mapper.updateByPrimaryKeySelective(item);
                });
            }
        }
    }

    @Transactional
    public void delLabels(List<NewComplianceCompanyLabel> list) {
        ((NewComplianceCompanyLabelMapper)this.dao).delLabels(list);
    }
}

